/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.emulator.util;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.persist.PageDatum;
import ai.platon.pulsar.persist.metadata.OpenPageCategory;
import ai.platon.pulsar.persist.metadata.PageCategory;
import ai.platon.pulsar.protocol.browser.emulator.util.PageCategorySniffer;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lai/platon/pulsar/protocol/browser/emulator/util/ChainedPageCategorySniffer;", "Lai/platon/pulsar/protocol/browser/emulator/util/PageCategorySniffer;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "sniffers", "Ljava/util/concurrent/CopyOnWriteArrayList;", "addFirst", "", "sniffer", "addLast", "invoke", "Lai/platon/pulsar/persist/metadata/OpenPageCategory;", "pageDatum", "Lai/platon/pulsar/persist/PageDatum;", "remove", "pulsar-protocol"})
public final class ChainedPageCategorySniffer
implements PageCategorySniffer {
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final CopyOnWriteArrayList<PageCategorySniffer> sniffers;

    public ChainedPageCategorySniffer(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.sniffers = new CopyOnWriteArrayList();
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @Override
    @NotNull
    public OpenPageCategory invoke(@NotNull PageDatum pageDatum) {
        Intrinsics.checkNotNullParameter((Object)pageDatum, (String)"pageDatum");
        for (PageCategorySniffer sniffer : this.sniffers) {
            OpenPageCategory category = sniffer.invoke(pageDatum);
            if (category.toPageCategory() == PageCategory.UNKNOWN) continue;
            return category;
        }
        return new OpenPageCategory(PageCategory.UNKNOWN);
    }

    public final void addFirst(@NotNull PageCategorySniffer sniffer) {
        Intrinsics.checkNotNullParameter((Object)sniffer, (String)"sniffer");
        this.sniffers.add(0, sniffer);
    }

    public final void addLast(@NotNull PageCategorySniffer sniffer) {
        Intrinsics.checkNotNullParameter((Object)sniffer, (String)"sniffer");
        this.sniffers.add(sniffer);
    }

    public final void remove(@NotNull PageCategorySniffer sniffer) {
        Intrinsics.checkNotNullParameter((Object)sniffer, (String)"sniffer");
        this.sniffers.remove(sniffer);
    }
}

