/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Parameterized;
import ai.platon.pulsar.common.message.MiscMessageWriter;
import ai.platon.pulsar.persist.WebPage;
import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020\u001eJ\u0006\u0010!\u001a\u00020\u001eJ\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0011\u001a\n \f*\u0004\u0018\u00010\u00120\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0015\u001a\n \f*\u0004\u0018\u00010\u00160\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\u0019\u001a\n \f*\u0004\u0018\u00010\u00160\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0019\u0010\u001b\u001a\n \f*\u0004\u0018\u00010\u00160\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018\u00a8\u0006%"}, d2={"Lai/platon/pulsar/protocol/browser/BrowserFetchMetrics;", "Lai/platon/pulsar/common/config/Parameterized;", "Ljava/lang/AutoCloseable;", "messageWriter", "Lai/platon/pulsar/common/message/MiscMessageWriter;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/message/MiscMessageWriter;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "elapsedTime", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getElapsedTime", "()Ljava/time/Duration;", "metricRegistry", "Lcom/codahale/metrics/MetricRegistry;", "startTime", "Ljava/time/Instant;", "getStartTime", "()Ljava/time/Instant;", "totalFinishedPages0", "Lcom/codahale/metrics/Counter;", "getTotalFinishedPages0", "()Lcom/codahale/metrics/Counter;", "totalPages0", "getTotalPages0", "totalSuccessPages0", "getTotalSuccessPages0", "close", "", "trackAbort", "trackCanceled", "trackFailure", "trackSuccess", "page", "Lai/platon/pulsar/persist/WebPage;", "pulsar-protocol"})
public final class BrowserFetchMetrics
implements Parameterized,
AutoCloseable {
    @NotNull
    private final MiscMessageWriter messageWriter;
    private final MetricRegistry metricRegistry;
    private final Instant startTime;
    private final Counter totalPages0;
    private final Counter totalSuccessPages0;
    private final Counter totalFinishedPages0;
    @NotNull
    private final AtomicBoolean closed;

    public BrowserFetchMetrics(@NotNull MiscMessageWriter messageWriter, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)messageWriter, (String)"messageWriter");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.messageWriter = messageWriter;
        this.metricRegistry = SharedMetricRegistries.getOrCreate((String)"pulsar");
        this.startTime = Instant.now();
        String[] stringArray = new String[]{"totalPages"};
        this.totalPages0 = this.metricRegistry.counter(MetricRegistry.name(this.getClass(), (String[])stringArray));
        stringArray = new String[]{"totalSuccessPages"};
        this.totalSuccessPages0 = this.metricRegistry.counter(MetricRegistry.name(this.getClass(), (String[])stringArray));
        stringArray = new String[]{"totalFinishedPages"};
        this.totalFinishedPages0 = this.metricRegistry.counter(MetricRegistry.name(this.getClass(), (String[])stringArray));
        this.closed = new AtomicBoolean();
    }

    public final Instant getStartTime() {
        return this.startTime;
    }

    public final Duration getElapsedTime() {
        return Duration.between(this.startTime, Instant.now());
    }

    public final Counter getTotalPages0() {
        return this.totalPages0;
    }

    public final Counter getTotalSuccessPages0() {
        return this.totalSuccessPages0;
    }

    public final Counter getTotalFinishedPages0() {
        return this.totalFinishedPages0;
    }

    public final void trackSuccess(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.totalSuccessPages0.inc();
        this.totalFinishedPages0.inc();
    }

    public final void trackFailure() {
        this.totalFinishedPages0.inc();
    }

    public final void trackAbort() {
    }

    public final void trackCanceled() {
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            // empty if block
        }
    }
}

