/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver;

import ai.platon.pulsar.browser.driver.chrome.common.ChromeOptions;
import ai.platon.pulsar.browser.driver.chrome.common.LauncherOptions;
import ai.platon.pulsar.crawl.fetch.privacy.BrowserInstanceId;
import ai.platon.pulsar.protocol.browser.driver.NavigateEntry;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010/\u001a\u000200H&R\"\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0016\u001a\n \u000b*\u0004\u0018\u00010\u00170\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u00061"}, d2={"Lai/platon/pulsar/protocol/browser/driver/BrowserInstance;", "Ljava/lang/AutoCloseable;", "id", "Lai/platon/pulsar/crawl/fetch/privacy/BrowserInstanceId;", "launcherOptions", "Lai/platon/pulsar/browser/driver/chrome/common/LauncherOptions;", "launchOptions", "Lai/platon/pulsar/browser/driver/chrome/common/ChromeOptions;", "(Lai/platon/pulsar/crawl/fetch/privacy/BrowserInstanceId;Lai/platon/pulsar/browser/driver/chrome/common/LauncherOptions;Lai/platon/pulsar/browser/driver/chrome/common/ChromeOptions;)V", "activeTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "getActiveTime", "()Ljava/time/Instant;", "setActiveTime", "(Ljava/time/Instant;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getClosed", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "getId", "()Lai/platon/pulsar/crawl/fetch/privacy/BrowserInstanceId;", "idleTimeout", "Ljava/time/Duration;", "getIdleTimeout", "()Ljava/time/Duration;", "isGUI", "", "()Z", "isIdle", "getLaunchOptions", "()Lai/platon/pulsar/browser/driver/chrome/common/ChromeOptions;", "launched", "getLaunched", "getLauncherOptions", "()Lai/platon/pulsar/browser/driver/chrome/common/LauncherOptions;", "navigateHistory", "", "Lai/platon/pulsar/protocol/browser/driver/NavigateEntry;", "getNavigateHistory", "()Ljava/util/List;", "tabCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "getTabCount", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setTabCount", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "launch", "", "pulsar-protocol"})
public abstract class BrowserInstance
implements AutoCloseable {
    @NotNull
    private final BrowserInstanceId id;
    @NotNull
    private final LauncherOptions launcherOptions;
    @NotNull
    private final ChromeOptions launchOptions;
    @NotNull
    private AtomicInteger tabCount;
    @NotNull
    private final List<NavigateEntry> navigateHistory;
    private Instant activeTime;
    private final Duration idleTimeout;
    @NotNull
    private final AtomicBoolean launched;
    @NotNull
    private final AtomicBoolean closed;

    public BrowserInstance(@NotNull BrowserInstanceId id, @NotNull LauncherOptions launcherOptions, @NotNull ChromeOptions launchOptions) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)launcherOptions, (String)"launcherOptions");
        Intrinsics.checkNotNullParameter((Object)launchOptions, (String)"launchOptions");
        this.id = id;
        this.launcherOptions = launcherOptions;
        this.launchOptions = launchOptions;
        this.tabCount = new AtomicInteger();
        boolean bl = false;
        this.navigateHistory = new ArrayList();
        this.activeTime = Instant.now();
        this.idleTimeout = Duration.ofMinutes(10L);
        this.launched = new AtomicBoolean();
        this.closed = new AtomicBoolean();
    }

    @NotNull
    public final BrowserInstanceId getId() {
        return this.id;
    }

    @NotNull
    public final LauncherOptions getLauncherOptions() {
        return this.launcherOptions;
    }

    @NotNull
    public final ChromeOptions getLaunchOptions() {
        return this.launchOptions;
    }

    public final boolean isGUI() {
        return this.launcherOptions.getBrowserSettings().isGUI();
    }

    @NotNull
    public final AtomicInteger getTabCount() {
        return this.tabCount;
    }

    public final void setTabCount(@NotNull AtomicInteger atomicInteger) {
        Intrinsics.checkNotNullParameter((Object)atomicInteger, (String)"<set-?>");
        this.tabCount = atomicInteger;
    }

    @NotNull
    public final List<NavigateEntry> getNavigateHistory() {
        return this.navigateHistory;
    }

    public final Instant getActiveTime() {
        return this.activeTime;
    }

    public final void setActiveTime(Instant instant) {
        this.activeTime = instant;
    }

    public final Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    public final boolean isIdle() {
        return Duration.between(this.activeTime, Instant.now()).compareTo(this.idleTimeout) > 0;
    }

    @NotNull
    protected final AtomicBoolean getLaunched() {
        return this.launched;
    }

    @NotNull
    protected final AtomicBoolean getClosed() {
        return this.closed;
    }

    public abstract void launch();
}

