/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.config.AppConstants;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Parameterized;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.common.metrics.AppMetricRegistry;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.crawl.fetch.privacy.BrowserInstanceId;
import ai.platon.pulsar.protocol.browser.driver.WebDriverAdapter;
import ai.platon.pulsar.protocol.browser.driver.WebDriverFactory;
import ai.platon.pulsar.protocol.browser.driver.WebDriverSettings;
import ai.platon.pulsar.protocol.browser.emulator.WebDriverPoolException;
import ai.platon.pulsar.protocol.browser.emulator.WebDriverPoolExhaustedException;
import com.codahale.metrics.Counter;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u0087\u00012\u00020\u00012\u00020\u0002:\u0002\u0087\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020hJ\b\u0010i\u001a\u00020fH\u0002J\b\u0010j\u001a\u00020fH\u0016J\u0016\u0010k\u001a\u00020f2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020!0mH\u0002J\u0018\u0010n\u001a\u00020f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020hH\u0002J\u0010\u0010o\u001a\u00020f2\u0006\u0010p\u001a\u00020'H\u0002J\u001c\u0010q\u001a\u0004\u0018\u00010!2\u0012\u0010r\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u0002000sJ\u001a\u0010t\u001a\u00020f2\u0012\u0010u\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020f0sJ\u0010\u0010v\u001a\u00020w2\b\b\u0002\u0010x\u001a\u000200J\u0010\u0010y\u001a\u00020f2\u0006\u0010z\u001a\u00020!H\u0002J\u0010\u0010{\u001a\u00020f2\u0006\u0010z\u001a\u00020!H\u0002J\b\u0010|\u001a\u0004\u0018\u00010!J\u000e\u0010|\u001a\u00020!2\u0006\u0010\t\u001a\u00020hJ\u001e\u0010|\u001a\u00020!2\u0006\u0010\t\u001a\u00020h2\u0006\u0010}\u001a\u00020\r2\u0006\u0010~\u001a\u00020\u007fJ\u001e\u0010|\u001a\u00020!2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020h2\u0006\u0010}\u001a\u00020'J&\u0010|\u001a\u00020!2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020h2\u0006\u0010}\u001a\u00020\r2\u0006\u0010~\u001a\u00020\u007fJ-\u0010\u0080\u0001\u001a\u00020!2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010h2\u0006\u0010}\u001a\u00020\r2\u0006\u0010~\u001a\u00020\u007fH\u0002J\u000f\u0010\u0081\u0001\u001a\u00020f2\u0006\u0010z\u001a\u00020!J\u001c\u0010\u0082\u0001\u001a\u00020f2\u0006\u0010z\u001a\u00020!2\t\b\u0002\u0010\u0083\u0001\u001a\u000200H\u0002J\t\u0010\u0084\u0001\u001a\u000200H\u0002J\t\u0010\u0085\u0001\u001a\u00020wH\u0016J\u0011\u0010\u0086\u0001\u001a\u00020f2\u0006\u0010}\u001a\u00020'H\u0002R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 \u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0012R\u0019\u0010&\u001a\n (*\u0004\u0018\u00010'0'8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\"\u0010+\u001a\n (*\u0004\u0018\u00010'0'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010*\"\u0004\b-\u0010.R\u0011\u0010/\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b/\u00101R\u0011\u00102\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b2\u00101R\u001a\u00103\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00101\"\u0004\b4\u00105R\"\u00106\u001a\n (*\u0004\u0018\u00010707X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u000e\u0010<\u001a\u00020=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010>\u001a\n (*\u0004\u0018\u00010?0?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010@\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u0012R\u0016\u0010B\u001a\n (*\u0004\u0018\u00010C0CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010D\u001a\n (*\u0004\u0018\u00010C0CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010E\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u0012R\u0011\u0010G\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u0012R\u0011\u0010I\u001a\u00020J\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u0011\u0010M\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\bN\u0010\u0012R\u0011\u0010O\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\bP\u0010\u0012R\u0011\u0010Q\u001a\u00020J\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010LR\u0011\u0010S\u001a\u00020J\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010LR\u0011\u0010U\u001a\u00020J\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010LR\u0011\u0010W\u001a\u00020J\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010LR\u0011\u0010Y\u001a\u00020J\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010LR\u0017\u0010[\u001a\b\u0012\u0004\u0012\u00020!0\\\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010^R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010_\u001a\u00020`X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010a\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\bb\u00101R\u000e\u0010c\u001a\u00020dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0088\u0001"}, d2={"Lai/platon/pulsar/protocol/browser/driver/LoadingWebDriverPool;", "Lai/platon/pulsar/common/config/Parameterized;", "Ljava/lang/AutoCloseable;", "browserInstanceId", "Lai/platon/pulsar/crawl/fetch/privacy/BrowserInstanceId;", "priority", "", "driverFactory", "Lai/platon/pulsar/protocol/browser/driver/WebDriverFactory;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/crawl/fetch/privacy/BrowserInstanceId;ILai/platon/pulsar/protocol/browser/driver/WebDriverFactory;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "availableMemory", "", "getAvailableMemory", "()J", "capacity", "getCapacity", "()I", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "counterQuit", "Lcom/codahale/metrics/Counter;", "getCounterQuit", "()Lcom/codahale/metrics/Counter;", "counterRetired", "getCounterRetired", "driverSettings", "Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;", "getDriverSettings", "()Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;", "freeDrivers", "Ljava/util/concurrent/ArrayBlockingQueue;", "Lai/platon/pulsar/crawl/fetch/driver/WebDriver;", "getFreeDrivers", "()Ljava/util/concurrent/ArrayBlockingQueue;", "id", "getId", "idleTime", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getIdleTime", "()Ljava/time/Duration;", "idleTimeout", "getIdleTimeout", "setIdleTimeout", "(Ljava/time/Duration;)V", "isActive", "", "()Z", "isIdle", "isRetired", "setRetired", "(Z)V", "lastActiveTime", "Ljava/time/Instant;", "getLastActiveTime", "()Ljava/time/Instant;", "setLastActiveTime", "(Ljava/time/Instant;)V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "logger", "Lorg/slf4j/Logger;", "maxDismissWarnings", "getMaxDismissWarnings", "notBusy", "Ljava/util/concurrent/locks/Condition;", "notEmpty", "numActive", "getNumActive", "numAvailable", "getNumAvailable", "numDismissWarnings", "Ljava/util/concurrent/atomic/AtomicInteger;", "getNumDismissWarnings", "()Ljava/util/concurrent/atomic/AtomicInteger;", "numFree", "getNumFree", "numOnline", "getNumOnline", "numSuccess", "getNumSuccess", "numTasks", "getNumTasks", "numTimeout", "getNumTimeout", "numWaiting", "getNumWaiting", "numWorking", "getNumWorking", "onlineDrivers", "Ljava/util/concurrent/ConcurrentSkipListSet;", "getOnlineDrivers", "()Ljava/util/concurrent/ConcurrentSkipListSet;", "registry", "Lai/platon/pulsar/common/metrics/AppMetricRegistry;", "shouldRetire", "getShouldRetire", "systemInfo", "Loshi/SystemInfo;", "allocate", "", "volatileConfig", "Lai/platon/pulsar/common/config/VolatileConfig;", "checkState", "close", "closeAllDrivers", "drivers", "", "createDriverIfNecessary", "doClose", "timeToWait", "firstOrNull", "predicate", "Lkotlin/Function1;", "forEach", "action", "formatStatus", "", "verbose", "logDriverOnline", "driver", "offer", "poll", "timeout", "unit", "Ljava/util/concurrent/TimeUnit;", "poll0", "put", "retire", "external", "shouldCreateDriver", "toString", "waitUntilIdleOrTimeout", "Companion", "pulsar-protocol"})
public final class LoadingWebDriverPool
implements Parameterized,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BrowserInstanceId browserInstanceId;
    private final int priority;
    @NotNull
    private final WebDriverFactory driverFactory;
    @NotNull
    private final ImmutableConfig conf;
    private final Logger logger;
    private final int id;
    @NotNull
    private final ConcurrentSkipListSet<WebDriver> onlineDrivers;
    @NotNull
    private final ArrayBlockingQueue<WebDriver> freeDrivers;
    @NotNull
    private final ReentrantLock lock;
    private final Condition notBusy;
    private final Condition notEmpty;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final SystemInfo systemInfo;
    @NotNull
    private final AppMetricRegistry registry;
    @NotNull
    private final Counter counterRetired;
    @NotNull
    private final Counter counterQuit;
    private boolean isRetired;
    @NotNull
    private final AtomicInteger numWaiting;
    @NotNull
    private final AtomicInteger numWorking;
    @NotNull
    private final AtomicInteger numTasks;
    @NotNull
    private final AtomicInteger numSuccess;
    @NotNull
    private final AtomicInteger numTimeout;
    @NotNull
    private final AtomicInteger numDismissWarnings;
    private final int maxDismissWarnings;
    private Instant lastActiveTime;
    private Duration idleTimeout;
    private static Duration CLOSE_ALL_TIMEOUT = Duration.ofSeconds(60L);
    private static Duration POLLING_TIMEOUT = Duration.ofSeconds(60L);
    @NotNull
    private static final AtomicInteger instanceSequencer = new AtomicInteger();

    public LoadingWebDriverPool(@NotNull BrowserInstanceId browserInstanceId, int priority, @NotNull WebDriverFactory driverFactory, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)browserInstanceId, (String)"browserInstanceId");
        Intrinsics.checkNotNullParameter((Object)driverFactory, (String)"driverFactory");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.browserInstanceId = browserInstanceId;
        this.priority = priority;
        this.driverFactory = driverFactory;
        this.conf = conf;
        this.logger = LoggerFactory.getLogger(LoadingWebDriverPool.class);
        this.id = instanceSequencer.incrementAndGet();
        this.onlineDrivers = new ConcurrentSkipListSet();
        this.freeDrivers = new ArrayBlockingQueue(2 * this.getCapacity());
        this.lock = new ReentrantLock();
        this.notBusy = this.lock.newCondition();
        this.notEmpty = this.lock.newCondition();
        this.closed = new AtomicBoolean();
        this.systemInfo = new SystemInfo();
        this.registry = AppMetrics.Companion.getDefaultMetricRegistry();
        this.counterRetired = this.registry.counter((Object)this, "retired");
        this.counterQuit = this.registry.counter((Object)this, "quit");
        this.numWaiting = new AtomicInteger();
        this.numWorking = new AtomicInteger();
        this.numTasks = new AtomicInteger();
        this.numSuccess = new AtomicInteger();
        this.numTimeout = new AtomicInteger();
        this.numDismissWarnings = new AtomicInteger();
        this.maxDismissWarnings = 5;
        this.lastActiveTime = Instant.now();
        Duration duration = Duration.ofMinutes(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(10)");
        this.idleTimeout = this.conf.getDuration("browser.driver.pool.idle.timeout", duration);
    }

    public /* synthetic */ LoadingWebDriverPool(BrowserInstanceId browserInstanceId, int n, WebDriverFactory webDriverFactory, ImmutableConfig immutableConfig, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(browserInstanceId, n, webDriverFactory, immutableConfig);
    }

    public final int getId() {
        return this.id;
    }

    public final int getCapacity() {
        return this.conf.getInt("browser.max.active.tabs", AppContext.INSTANCE.getNCPU());
    }

    @NotNull
    public final ConcurrentSkipListSet<WebDriver> getOnlineDrivers() {
        return this.onlineDrivers;
    }

    @NotNull
    public final ArrayBlockingQueue<WebDriver> getFreeDrivers() {
        return this.freeDrivers;
    }

    private final WebDriverSettings getDriverSettings() {
        return this.driverFactory.getDriverSettings();
    }

    private final long getAvailableMemory() {
        return this.systemInfo.getHardware().getMemory().getAvailable();
    }

    @NotNull
    public final Counter getCounterRetired() {
        return this.counterRetired;
    }

    @NotNull
    public final Counter getCounterQuit() {
        return this.counterQuit;
    }

    public final boolean isRetired() {
        return this.isRetired;
    }

    public final void setRetired(boolean bl) {
        this.isRetired = bl;
    }

    public final boolean isActive() {
        return !this.isRetired && !this.closed.get();
    }

    @NotNull
    public final AtomicInteger getNumWaiting() {
        return this.numWaiting;
    }

    @NotNull
    public final AtomicInteger getNumWorking() {
        return this.numWorking;
    }

    @NotNull
    public final AtomicInteger getNumTasks() {
        return this.numTasks;
    }

    @NotNull
    public final AtomicInteger getNumSuccess() {
        return this.numSuccess;
    }

    @NotNull
    public final AtomicInteger getNumTimeout() {
        return this.numTimeout;
    }

    @NotNull
    public final AtomicInteger getNumDismissWarnings() {
        return this.numDismissWarnings;
    }

    public final int getMaxDismissWarnings() {
        return this.maxDismissWarnings;
    }

    public final boolean getShouldRetire() {
        return this.numDismissWarnings.get() > this.maxDismissWarnings;
    }

    public final int getNumFree() {
        return this.freeDrivers.size();
    }

    public final int getNumActive() {
        return this.numWorking.get() + this.getNumFree();
    }

    public final int getNumAvailable() {
        return this.getCapacity() - this.numWorking.get();
    }

    public final int getNumOnline() {
        return this.onlineDrivers.size();
    }

    public final Instant getLastActiveTime() {
        return this.lastActiveTime;
    }

    public final void setLastActiveTime(Instant instant) {
        this.lastActiveTime = instant;
    }

    public final Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    public final void setIdleTimeout(Duration duration) {
        this.idleTimeout = duration;
    }

    public final Duration getIdleTime() {
        return Duration.between(this.lastActiveTime, Instant.now());
    }

    public final boolean isIdle() {
        return this.numWorking.get() == 0 && this.getIdleTime().compareTo(this.idleTimeout) > 0;
    }

    public final void allocate(@NotNull VolatileConfig volatileConfig) {
        Intrinsics.checkNotNullParameter((Object)volatileConfig, (String)"volatileConfig");
        int n = this.getCapacity();
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            Throwable throwable;
            Object object;
            int it = n2;
            boolean bl2 = false;
            LoadingWebDriverPool loadingWebDriverPool = this;
            boolean bl3 = false;
            try {
                object = Result.Companion;
                LoadingWebDriverPool $this$allocate_u24lambda_u2d2_u24lambda_u2d0 = loadingWebDriverPool;
                boolean bl4 = false;
                $this$allocate_u24lambda_u2d2_u24lambda_u2d0.put($this$allocate_u24lambda_u2d2_u24lambda_u2d0.poll($this$allocate_u24lambda_u2d2_u24lambda_u2d0.priority, volatileConfig, POLLING_TIMEOUT.getSeconds(), TimeUnit.SECONDS));
                Unit unit = Unit.INSTANCE;
                boolean bl5 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable2) {
                Result.Companion companion = Result.Companion;
                boolean bl6 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            loadingWebDriverPool = object;
            bl3 = false;
            boolean bl7 = false;
            if (Result.exceptionOrNull-impl((Object)loadingWebDriverPool) == null) continue;
            boolean bl8 = false;
            boolean bl9 = false;
            Throwable throwable3 = throwable;
            boolean bl10 = false;
            Throwable it2 = throwable3;
            boolean bl11 = false;
            this.logger.warn("Unexpected exception", it2);
        }
    }

    @Nullable
    public final WebDriver poll() {
        this.numWaiting.incrementAndGet();
        WebDriver webDriver = this.freeDrivers.poll();
        boolean bl = false;
        boolean bl2 = false;
        WebDriver it = webDriver;
        boolean bl3 = false;
        this.getNumWaiting().decrementAndGet();
        return webDriver;
    }

    @NotNull
    public final WebDriver poll(@NotNull VolatileConfig conf) throws WebDriverPoolExhaustedException {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        return this.poll(0, conf, POLLING_TIMEOUT.getSeconds(), TimeUnit.SECONDS);
    }

    @NotNull
    public final WebDriver poll(@NotNull VolatileConfig conf, long timeout, @NotNull TimeUnit unit) throws WebDriverPoolExhaustedException {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.poll(0, conf, timeout, unit);
    }

    @NotNull
    public final WebDriver poll(int priority, @NotNull VolatileConfig conf, @NotNull Duration timeout) throws WebDriverPoolExhaustedException {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        return this.poll(0, conf, timeout.getSeconds(), TimeUnit.SECONDS);
    }

    @NotNull
    public final WebDriver poll(int priority, @NotNull VolatileConfig conf, long timeout, @NotNull TimeUnit unit) throws WebDriverPoolExhaustedException {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        WebDriver webDriver = this.poll0(priority, conf, timeout, unit);
        boolean bl = false;
        boolean bl2 = false;
        WebDriver it = webDriver;
        boolean bl3 = false;
        this.getNumWorking().incrementAndGet();
        this.setLastActiveTime(Instant.now());
        return webDriver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(@NotNull WebDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        if (this.numWorking.decrementAndGet() == 0) {
            Lock lock = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            lock.lock();
            try {
                boolean bl3 = false;
                this.notBusy.signalAll();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
        if ((double)this.getAvailableMemory() < AppConstants.BROWSER_TAB_REQUIRED_MEMORY && (double)this.getNumOnline() > 0.5 * (double)this.getCapacity()) {
            driver.retire();
        }
        if (this.getNumOnline() > this.getCapacity()) {
            driver.retire();
        }
        if (driver.isRetired()) {
            LoadingWebDriverPool.retire$default(this, driver, false, 2, null);
        } else {
            this.offer(driver);
        }
        this.lastActiveTime = Instant.now();
    }

    public final void forEach(@NotNull Function1<? super WebDriver, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Iterable $this$forEach$iv = this.onlineDrivers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            action.invoke(element$iv);
        }
    }

    @Nullable
    public final WebDriver firstOrNull(@NotNull Function1<? super WebDriver, Boolean> predicate) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Iterable $this$firstOrNull$iv = this.onlineDrivers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                if (!((Boolean)predicate.invoke(element$iv)).booleanValue()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                Duration duration = CLOSE_ALL_TIMEOUT;
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"CLOSE_ALL_TIMEOUT");
                this.doClose(duration);
            }
            catch (InterruptedException e) {
                this.logger.warn("Thread interrupted when closing | {}", (Object)this);
                Thread.currentThread().interrupt();
            }
        }
    }

    @NotNull
    public final String formatStatus(boolean verbose) {
        String string;
        boolean bl;
        Object[] objectArray;
        Object object;
        StringCompanionObject stringCompanionObject;
        LoadingWebDriverPool p = this;
        if (verbose) {
            stringCompanionObject = StringCompanionObject.INSTANCE;
            object = "online: %d, free: %d, waiting: %d, working: %d, active: %d";
            objectArray = new Object[]{p.getNumOnline(), p.getNumFree(), p.numWaiting.get(), p.numWorking.get(), p.getNumActive()};
            bl = false;
            String string2 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        } else {
            stringCompanionObject = StringCompanionObject.INSTANCE;
            object = "%d/%d/%d/%d/%d (online/free/waiting/working/active)";
            objectArray = new Object[]{p.getNumOnline(), p.getNumFree(), p.numWaiting.get(), p.numWorking.get(), p.getNumActive()};
            bl = false;
            String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        }
        String status = string;
        object = this.getIdleTime();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"idleTime");
        String time = DateTimesKt.readable((Duration)object);
        return this.isIdle() ? "[Idle] " + time + " | " + status : (this.isRetired ? "[Retired] " + time + " | " + status : status);
    }

    public static /* synthetic */ String formatStatus$default(LoadingWebDriverPool loadingWebDriverPool, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return loadingWebDriverPool.formatStatus(bl);
    }

    @NotNull
    public String toString() {
        return this.formatStatus(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final synchronized void offer(WebDriver driver) {
        void $this$offer_u24lambda_u2d6;
        Object object = driver;
        boolean bl = false;
        boolean bl2 = false;
        WebDriver webDriver = object;
        ArrayBlockingQueue<WebDriver> arrayBlockingQueue = this.freeDrivers;
        boolean bl3 = false;
        $this$offer_u24lambda_u2d6.free();
        Unit unit = Unit.INSTANCE;
        arrayBlockingQueue.offer((WebDriver)object);
        object = this.lock;
        bl = false;
        bl2 = false;
        object.lock();
        try {
            boolean bl4 = false;
            this.notEmpty.signalAll();
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            object.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void retire(WebDriver driver, boolean external) {
        boolean bl;
        Object object;
        Object object2;
        void $this$retire_u24lambda_u2d8;
        if (external && !this.isActive()) {
            return;
        }
        this.counterRetired.inc();
        WebDriver webDriver = driver;
        boolean bl2 = false;
        boolean bl3 = false;
        WebDriver webDriver2 = webDriver;
        ArrayBlockingQueue<WebDriver> arrayBlockingQueue = this.freeDrivers;
        boolean bl4 = false;
        $this$retire_u24lambda_u2d8.retire();
        Unit unit = Unit.INSTANCE;
        arrayBlockingQueue.remove(webDriver);
        webDriver = driver;
        bl2 = false;
        try {
            object2 = Result.Companion;
            WebDriver $this$retire_u24lambda_u2d10 = webDriver;
            boolean bl5 = false;
            $this$retire_u24lambda_u2d10.quit();
            object = Unit.INSTANCE;
            bl = false;
            boolean bl6 = false;
            Unit it = object;
            boolean bl7 = false;
            this.getCounterQuit().inc();
            webDriver2 = Unit.INSTANCE;
            boolean bl8 = false;
            object2 = Result.constructor-impl((Object)webDriver2);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl9 = false;
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        webDriver = object2;
        bl2 = false;
        boolean bl10 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)webDriver);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl11 = false;
            boolean bl12 = false;
            object = throwable2;
            bl = false;
            Object it = object;
            boolean bl13 = false;
            this.logger.warn("Unexpected exception quit " + driver, (Throwable)it);
        }
        this.onlineDrivers.remove(driver);
    }

    static /* synthetic */ void retire$default(LoadingWebDriverPool loadingWebDriverPool, WebDriver webDriver, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        loadingWebDriverPool.retire(webDriver, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final WebDriver poll0(int priority, VolatileConfig conf, long timeout, TimeUnit unit) throws WebDriverPoolException {
        WebDriver driver;
        WebDriver webDriver;
        if (conf != null) {
            this.createDriverIfNecessary(priority, conf);
        }
        this.numWaiting.incrementAndGet();
        try {
            webDriver = this.freeDrivers.poll(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WebDriverPoolException(e);
        }
        finally {
            this.numWaiting.decrementAndGet();
        }
        webDriver = driver = webDriver;
        if (webDriver == null) {
            throw new WebDriverPoolExhaustedException("Driver pool is exhausted (" + LoadingWebDriverPool.formatStatus$default(this, false, 1, null) + ")");
        }
        return webDriver;
    }

    static /* synthetic */ WebDriver poll0$default(LoadingWebDriverPool loadingWebDriverPool, int n, VolatileConfig volatileConfig, long l, TimeUnit timeUnit, int n2, Object object) throws WebDriverPoolException {
        if ((n2 & 2) != 0) {
            volatileConfig = null;
        }
        return loadingWebDriverPool.poll0(n, volatileConfig, l, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createDriverIfNecessary(int priority, VolatileConfig conf) {
        if (this.shouldCreateDriver()) {
            WebDriverFactory webDriverFactory = this.driverFactory;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (webDriverFactory) {
                boolean bl3 = false;
                if (this.shouldCreateDriver()) {
                    WebDriverAdapter driver = this.driverFactory.create(this.browserInstanceId, priority, conf);
                    Lock lock = this.lock;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    lock.lock();
                    try {
                        boolean bl6 = false;
                        this.getFreeDrivers().add((WebDriver)driver);
                        this.notEmpty.signalAll();
                        bl5 = this.getOnlineDrivers().add((WebDriver)driver);
                    }
                    finally {
                        lock.unlock();
                    }
                    this.logDriverOnline((WebDriver)driver);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private final boolean shouldCreateDriver() {
        return this.isActive() && (double)this.getAvailableMemory() > AppConstants.BROWSER_TAB_REQUIRED_MEMORY && this.onlineDrivers.size() < this.getCapacity();
    }

    private final void doClose(Duration timeToWait) {
        this.freeDrivers.clear();
        List list = CollectionsKt.toList((Iterable)this.onlineDrivers);
        boolean bl = false;
        boolean bl2 = false;
        List it = list;
        boolean bl3 = false;
        this.getOnlineDrivers().clear();
        List nonSynchronized = list;
        nonSynchronized.parallelStream().forEach(LoadingWebDriverPool::doClose$lambda-15);
        this.waitUntilIdleOrTimeout(timeToWait);
        this.closeAllDrivers(nonSynchronized);
        this.driverFactory.close();
    }

    private final void closeAllDrivers(List<? extends WebDriver> drivers) {
        AtomicInteger i = new AtomicInteger();
        int total = drivers.size();
        drivers.parallelStream().forEach(arg_0 -> LoadingWebDriverPool.closeAllDrivers$lambda-17(this, i, total, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void waitUntilIdleOrTimeout(Duration timeout) {
        Lock lock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            long ttl = timeout.getSeconds();
            int i = 0;
            try {
                while (this.isActive() && this.getNumWorking().get() > 0 && (long)(++i) < ttl) {
                    Logger logger;
                    this.notBusy.await(1L, TimeUnit.SECONDS);
                    Logger logger2 = this.logger;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Logger it = logger2;
                    boolean bl6 = false;
                    Object object = logger = i % 20 == 0 ? logger2 : null;
                    if (logger == null) continue;
                    logger.info("Round " + i + "/" + ttl + " waiting for idle | " + this);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void logDriverOnline(WebDriver driver) {
        if (this.logger.isTraceEnabled()) {
            WebDriverSettings driverSettings = this.driverFactory.getDriverSettings();
            Object[] objectArray = new Object[]{this.getNumOnline(), driver.getName(), driverSettings.getPageLoadStrategy(), this.getCapacity()};
            this.logger.trace("The {}th web driver is online, browser: {} pageLoadStrategy: {} capacity: {}", objectArray);
        }
    }

    private final void checkState() {
        if (!this.isActive()) {
            throw new WebDriverPoolException("Loading web driver pool is closed | " + this + " | " + this.browserInstanceId);
        }
    }

    private static final void doClose$lambda-15(WebDriver it) {
        it.cancel();
    }

    private static final void closeAllDrivers$lambda-17(LoadingWebDriverPool this$0, AtomicInteger $i, int $total, WebDriver driver) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$i, (String)"$i");
        driver.quit();
        Object[] objectArray = Unit.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        Object[] it = objectArray;
        boolean bl3 = false;
        this$0.getCounterQuit().inc();
        objectArray = new Object[]{$i.incrementAndGet(), $total, driver};
        this$0.logger.debug("Quit driver {}/{} | {}", objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\"\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lai/platon/pulsar/protocol/browser/driver/LoadingWebDriverPool$Companion;", "", "()V", "CLOSE_ALL_TIMEOUT", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getCLOSE_ALL_TIMEOUT", "()Ljava/time/Duration;", "setCLOSE_ALL_TIMEOUT", "(Ljava/time/Duration;)V", "POLLING_TIMEOUT", "getPOLLING_TIMEOUT", "setPOLLING_TIMEOUT", "instanceSequencer", "Ljava/util/concurrent/atomic/AtomicInteger;", "getInstanceSequencer", "()Ljava/util/concurrent/atomic/AtomicInteger;", "pulsar-protocol"})
    public static final class Companion {
        private Companion() {
        }

        public final Duration getCLOSE_ALL_TIMEOUT() {
            return CLOSE_ALL_TIMEOUT;
        }

        public final void setCLOSE_ALL_TIMEOUT(Duration duration) {
            CLOSE_ALL_TIMEOUT = duration;
        }

        public final Duration getPOLLING_TIMEOUT() {
            return POLLING_TIMEOUT;
        }

        public final void setPOLLING_TIMEOUT(Duration duration) {
            POLLING_TIMEOUT = duration;
        }

        @NotNull
        public final AtomicInteger getInstanceSequencer() {
            return instanceSequencer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

