/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver;

import ai.platon.pulsar.browser.common.BrowserSettings;
import ai.platon.pulsar.browser.driver.chrome.common.ChromeOptions;
import ai.platon.pulsar.browser.driver.chrome.common.LauncherOptions;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.crawl.fetch.driver.AbstractWebDriver;
import ai.platon.pulsar.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.crawl.fetch.privacy.BrowserInstanceId;
import ai.platon.pulsar.persist.metadata.BrowserType;
import ai.platon.pulsar.protocol.browser.DriverLaunchException;
import ai.platon.pulsar.protocol.browser.UnsupportedWebDriverException;
import ai.platon.pulsar.protocol.browser.driver.BrowserInstance;
import ai.platon.pulsar.protocol.browser.driver.BrowserInstanceManager;
import ai.platon.pulsar.protocol.browser.driver.WebDriverAdapter;
import ai.platon.pulsar.protocol.browser.driver.WebDriverSettings;
import ai.platon.pulsar.protocol.browser.driver.cdt.ChromeDevtoolsBrowserInstance;
import ai.platon.pulsar.protocol.browser.driver.cdt.ChromeDevtoolsDriver;
import ai.platon.pulsar.protocol.browser.driver.playwright.PlaywrightBrowserInstance;
import ai.platon.pulsar.protocol.browser.driver.playwright.PlaywrightDriver;
import ai.platon.pulsar.protocol.browser.driver.test.MockWebDriver;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ$\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001b2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$H\u0002J$\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00020\u001b2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$H\u0002J$\u0010)\u001a\u00020*2\u0006\u0010\"\u001a\u00020\u001b2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$H\u0002J$\u0010+\u001a\u00020,2\u0006\u0010\"\u001a\u00020\u001b2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$H\u0002J$\u0010-\u001a\u00020\u00172\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0.2\u0006\u0010/\u001a\u00020%H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00060"}, d2={"Lai/platon/pulsar/protocol/browser/driver/WebDriverFactory;", "Ljava/lang/AutoCloseable;", "driverSettings", "Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;", "browserInstanceManager", "Lai/platon/pulsar/protocol/browser/driver/BrowserInstanceManager;", "immutableConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;Lai/platon/pulsar/protocol/browser/driver/BrowserInstanceManager;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getBrowserInstanceManager", "()Lai/platon/pulsar/protocol/browser/driver/BrowserInstanceManager;", "getDriverSettings", "()Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;", "getImmutableConfig", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "numDrivers", "Ljava/util/concurrent/atomic/AtomicInteger;", "getNumDrivers", "()Ljava/util/concurrent/atomic/AtomicInteger;", "close", "", "create", "Lai/platon/pulsar/protocol/browser/driver/WebDriverAdapter;", "browserInstanceId", "Lai/platon/pulsar/crawl/fetch/privacy/BrowserInstanceId;", "priority", "", "conf", "Lai/platon/pulsar/common/config/VolatileConfig;", "createBrowserInstance", "Lai/platon/pulsar/protocol/browser/driver/BrowserInstance;", "instanceId", "capabilities", "", "", "", "createChromeDevtoolsDriver", "Lai/platon/pulsar/protocol/browser/driver/cdt/ChromeDevtoolsDriver;", "createMockChromeDevtoolsDriver", "Lai/platon/pulsar/protocol/browser/driver/test/MockWebDriver;", "createPlaywrightDriver", "Lai/platon/pulsar/protocol/browser/driver/playwright/PlaywrightDriver;", "setProxy", "", "proxyServer", "pulsar-protocol"})
public class WebDriverFactory
implements AutoCloseable {
    @NotNull
    private final WebDriverSettings driverSettings;
    @NotNull
    private final BrowserInstanceManager browserInstanceManager;
    @NotNull
    private final ImmutableConfig immutableConfig;
    private final Logger log;
    @NotNull
    private final AtomicInteger numDrivers;

    public WebDriverFactory(@NotNull WebDriverSettings driverSettings, @NotNull BrowserInstanceManager browserInstanceManager, @NotNull ImmutableConfig immutableConfig) {
        Intrinsics.checkNotNullParameter((Object)((Object)driverSettings), (String)"driverSettings");
        Intrinsics.checkNotNullParameter((Object)browserInstanceManager, (String)"browserInstanceManager");
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"immutableConfig");
        this.driverSettings = driverSettings;
        this.browserInstanceManager = browserInstanceManager;
        this.immutableConfig = immutableConfig;
        this.log = LoggerFactory.getLogger(WebDriverFactory.class);
        this.numDrivers = new AtomicInteger();
    }

    @NotNull
    public final WebDriverSettings getDriverSettings() {
        return this.driverSettings;
    }

    @NotNull
    public final BrowserInstanceManager getBrowserInstanceManager() {
        return this.browserInstanceManager;
    }

    @NotNull
    public final ImmutableConfig getImmutableConfig() {
        return this.immutableConfig;
    }

    @NotNull
    public final AtomicInteger getNumDrivers() {
        return this.numDrivers;
    }

    @NotNull
    public final synchronized WebDriverAdapter create(@NotNull BrowserInstanceId browserInstanceId, int priority, @NotNull VolatileConfig conf) throws DriverLaunchException {
        int n;
        Object object;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)browserInstanceId, (String)"browserInstanceId");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.log.debug("Creating web driver #{} | {}", (Object)this.numDrivers.incrementAndGet(), (Object)browserInstanceId);
        Map<String, Object> capabilities = this.driverSettings.createGeneralOptions();
        String string = browserInstanceId.getProxyServer();
        if (string != null) {
            String string2 = string;
            bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean $i$a$-let-WebDriverFactory$create$22 = false;
            this.setProxy(capabilities, it);
        }
        BrowserType browserType = browserInstanceId.getBrowserType();
        bl = false;
        try {
            AbstractWebDriver abstractWebDriver;
            object = Result.Companion;
            boolean bl3 = false;
            BrowserType $i$a$-let-WebDriverFactory$create$22 = browserType;
            n = WhenMappings.$EnumSwitchMapping$0[$i$a$-let-WebDriverFactory$create$22.ordinal()];
            switch (n) {
                case 1: {
                    abstractWebDriver = this.createChromeDevtoolsDriver(browserInstanceId, capabilities);
                    break;
                }
                case 2: {
                    abstractWebDriver = this.createPlaywrightDriver(browserInstanceId, capabilities);
                    break;
                }
                case 3: {
                    abstractWebDriver = this.createMockChromeDevtoolsDriver(browserInstanceId, capabilities);
                    break;
                }
                default: {
                    throw new UnsupportedWebDriverException("Unsupported WebDriver: " + browserType);
                }
            }
            AbstractWebDriver abstractWebDriver2 = abstractWebDriver;
            boolean $i$a$-let-WebDriverFactory$create$22 = false;
            object = Result.constructor-impl((Object)abstractWebDriver2);
        }
        catch (Throwable throwable) {
            Result.Companion $i$a$-let-WebDriverFactory$create$22 = Result.Companion;
            n = 0;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object2 = object;
        boolean bl4 = false;
        boolean bl5 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean $i$a$-let-WebDriverFactory$create$22 = false;
            n = 0;
            Throwable throwable3 = throwable2;
            boolean bl6 = false;
            Throwable it = throwable3;
            boolean bl7 = false;
            this.log.error("Failed to create web driver " + browserType, it);
        }
        bl4 = false;
        boolean bl8 = false;
        Throwable throwable4 = Result.exceptionOrNull-impl((Object)object2);
        if (throwable4 != null) {
            Throwable it = throwable4;
            boolean bl9 = false;
            throw new DriverLaunchException("Failed to create web driver | " + browserType);
        }
        AbstractWebDriver driver = (AbstractWebDriver)object2;
        return new WebDriverAdapter(browserInstanceId, (WebDriver)driver, priority);
    }

    @Override
    public void close() {
        this.browserInstanceManager.close();
    }

    private final BrowserInstance createBrowserInstance(BrowserInstanceId instanceId, Map<String, ? extends Object> capabilities) {
        LauncherOptions launcherOptions = new LauncherOptions((BrowserSettings)this.driverSettings, null, null, 6, null);
        if (this.driverSettings.isSupervised()) {
            launcherOptions.setSupervisorProcess(this.driverSettings.getSupervisorProcess());
            List list = launcherOptions.getSupervisorProcessArgs();
            Collection collection = this.driverSettings.getSupervisorProcessArgs();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"driverSettings.supervisorProcessArgs");
            list.addAll(collection);
        }
        ChromeOptions launchOptions = this.driverSettings.createChromeOptions(capabilities);
        return this.browserInstanceManager.launchIfAbsent(instanceId, launcherOptions, launchOptions);
    }

    private final ChromeDevtoolsDriver createChromeDevtoolsDriver(BrowserInstanceId instanceId, Map<String, ? extends Object> capabilities) {
        BrowserInstance browserInstance = this.createBrowserInstance(instanceId, capabilities);
        return new ChromeDevtoolsDriver(this.driverSettings, (ChromeDevtoolsBrowserInstance)browserInstance);
    }

    private final PlaywrightDriver createPlaywrightDriver(BrowserInstanceId instanceId, Map<String, ? extends Object> capabilities) {
        BrowserInstance browserInstance = this.createBrowserInstance(instanceId, capabilities);
        return new PlaywrightDriver(this.driverSettings, (PlaywrightBrowserInstance)browserInstance);
    }

    private final MockWebDriver createMockChromeDevtoolsDriver(BrowserInstanceId instanceId, Map<String, ? extends Object> capabilities) {
        Function0 backupDriverCreator2 = (Function0)new Function0<ChromeDevtoolsDriver>(this, instanceId, capabilities){
            final /* synthetic */ WebDriverFactory this$0;
            final /* synthetic */ BrowserInstanceId $instanceId;
            final /* synthetic */ Map<String, Object> $capabilities;
            {
                this.this$0 = $receiver;
                this.$instanceId = $instanceId;
                this.$capabilities = $capabilities;
                super(0);
            }

            @NotNull
            public final ChromeDevtoolsDriver invoke() {
                return WebDriverFactory.access$createChromeDevtoolsDriver(this.this$0, this.$instanceId, this.$capabilities);
            }
        };
        return new MockWebDriver(instanceId, (Function0<ChromeDevtoolsDriver>)backupDriverCreator2);
    }

    private final void setProxy(Map<String, Object> capabilities, String proxyServer) {
        Map<String, Object> map = capabilities;
        String string = "proxy";
        boolean bl = false;
        map.put(string, proxyServer);
    }

    public static final /* synthetic */ ChromeDevtoolsDriver access$createChromeDevtoolsDriver(WebDriverFactory $this, BrowserInstanceId instanceId, Map capabilities) {
        return $this.createChromeDevtoolsDriver(instanceId, capabilities);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BrowserType.values().length];
            nArray[BrowserType.CHROME.ordinal()] = 1;
            nArray[BrowserType.PLAYWRIGHT_CHROME.ordinal()] = 2;
            nArray[BrowserType.MOCK_CHROME.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

