/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.concurrent.ScheduledMonitor;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.protocol.browser.driver.WebDriverPoolManager;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolMonitor;", "Lai/platon/pulsar/common/concurrent/ScheduledMonitor;", "driverPoolManager", "Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "getDriverPoolManager", "()Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;", "isActive", "", "()Z", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "watch", "", "pulsar-protocol"})
public class WebDriverPoolMonitor
extends ScheduledMonitor {
    @NotNull
    private final WebDriverPoolManager driverPoolManager;
    @NotNull
    private final ImmutableConfig conf;
    private final Logger log;

    public WebDriverPoolMonitor(@NotNull WebDriverPoolManager driverPoolManager, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)driverPoolManager, (String)"driverPoolManager");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Duration duration = Duration.ofMinutes(20L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(20)");
        Duration duration2 = duration;
        duration = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(30)");
        super(duration2, duration, null, false, 12, null);
        this.driverPoolManager = driverPoolManager;
        this.conf = conf;
        this.log = LoggerFactory.getLogger(WebDriverPoolMonitor.class);
    }

    @NotNull
    public final WebDriverPoolManager getDriverPoolManager() {
        return this.driverPoolManager;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    public final boolean isActive() {
        return AppContext.INSTANCE.isActive();
    }

    public void watch() {
        if (!AppContext.INSTANCE.isActive()) {
            this.close();
            return;
        }
        if (this.driverPoolManager.isIdle()) {
            if (this.driverPoolManager.getHasEvent()) {
                this.log.info("[Idle] {}", (Object)this.driverPoolManager.toString());
            }
            if (this.driverPoolManager.isPreempted()) {
                this.driverPoolManager.releaseLocks();
            }
        }
    }
}

