/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver.cdt;

import ai.platon.pulsar.browser.driver.chrome.ChromeLauncher;
import ai.platon.pulsar.browser.driver.chrome.ChromeTab;
import ai.platon.pulsar.browser.driver.chrome.DevToolsConfig;
import ai.platon.pulsar.browser.driver.chrome.RemoteChrome;
import ai.platon.pulsar.browser.driver.chrome.RemoteDevTools;
import ai.platon.pulsar.browser.driver.chrome.common.ChromeOptions;
import ai.platon.pulsar.browser.driver.chrome.common.LauncherOptions;
import ai.platon.pulsar.crawl.fetch.privacy.BrowserInstanceId;
import ai.platon.pulsar.protocol.browser.driver.BrowserInstance;
import ai.platon.pulsar.protocol.browser.driver.cdt.ChromeDevtoolsDriver;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%2\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020%J\b\u0010*\u001a\u00020\"H\u0016J\u0011\u0010+\u001a\b\u0012\u0004\u0012\u00020%0,\u00a2\u0006\u0002\u0010-R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lai/platon/pulsar/protocol/browser/driver/cdt/ChromeDevtoolsBrowserInstance;", "Lai/platon/pulsar/protocol/browser/driver/BrowserInstance;", "id", "Lai/platon/pulsar/crawl/fetch/privacy/BrowserInstanceId;", "launcherOptions", "Lai/platon/pulsar/browser/driver/chrome/common/LauncherOptions;", "launchOptions", "Lai/platon/pulsar/browser/driver/chrome/common/ChromeOptions;", "(Lai/platon/pulsar/crawl/fetch/privacy/BrowserInstanceId;Lai/platon/pulsar/browser/driver/chrome/common/LauncherOptions;Lai/platon/pulsar/browser/driver/chrome/common/ChromeOptions;)V", "chrome", "Lai/platon/pulsar/browser/driver/chrome/RemoteChrome;", "getChrome", "()Lai/platon/pulsar/browser/driver/chrome/RemoteChrome;", "setChrome", "(Lai/platon/pulsar/browser/driver/chrome/RemoteChrome;)V", "devToolsCount", "", "getDevToolsCount", "()I", "devToolsList", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lai/platon/pulsar/browser/driver/chrome/RemoteDevTools;", "getDevToolsList", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "launcher", "Lai/platon/pulsar/browser/driver/chrome/ChromeLauncher;", "getLauncher", "()Lai/platon/pulsar/browser/driver/chrome/ChromeLauncher;", "setLauncher", "(Lai/platon/pulsar/browser/driver/chrome/ChromeLauncher;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "close", "", "closeTab", "tab", "Lai/platon/pulsar/browser/driver/chrome/ChromeTab;", "createDevTools", "config", "Lai/platon/pulsar/browser/driver/chrome/DevToolsConfig;", "createTab", "launch", "listTab", "", "()[Lai/platon/pulsar/browser/driver/chrome/ChromeTab;", "pulsar-protocol"})
public final class ChromeDevtoolsBrowserInstance
extends BrowserInstance {
    private final Logger logger;
    public ChromeLauncher launcher;
    public RemoteChrome chrome;
    @NotNull
    private final ConcurrentLinkedQueue<RemoteDevTools> devToolsList;

    public ChromeDevtoolsBrowserInstance(@NotNull BrowserInstanceId id, @NotNull LauncherOptions launcherOptions, @NotNull ChromeOptions launchOptions) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)launcherOptions, (String)"launcherOptions");
        Intrinsics.checkNotNullParameter((Object)launchOptions, (String)"launchOptions");
        super(id, launcherOptions, launchOptions);
        this.logger = LoggerFactory.getLogger(ChromeDevtoolsBrowserInstance.class);
        this.devToolsList = new ConcurrentLinkedQueue();
    }

    @NotNull
    public final ChromeLauncher getLauncher() {
        ChromeLauncher chromeLauncher = this.launcher;
        if (chromeLauncher != null) {
            return chromeLauncher;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"launcher");
        return null;
    }

    public final void setLauncher(@NotNull ChromeLauncher chromeLauncher) {
        Intrinsics.checkNotNullParameter((Object)chromeLauncher, (String)"<set-?>");
        this.launcher = chromeLauncher;
    }

    @NotNull
    public final RemoteChrome getChrome() {
        RemoteChrome remoteChrome = this.chrome;
        if (remoteChrome != null) {
            return remoteChrome;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"chrome");
        return null;
    }

    public final void setChrome(@NotNull RemoteChrome remoteChrome) {
        Intrinsics.checkNotNullParameter((Object)remoteChrome, (String)"<set-?>");
        this.chrome = remoteChrome;
    }

    @NotNull
    public final ConcurrentLinkedQueue<RemoteDevTools> getDevToolsList() {
        return this.devToolsList;
    }

    public final int getDevToolsCount() {
        return this.devToolsList.size();
    }

    @Override
    public synchronized void launch() throws Exception {
        if (this.getLaunched().compareAndSet(false, true)) {
            ChromeDevtoolsDriver.ShutdownHookRegistry shutdownHookRegistry = new ChromeDevtoolsDriver.ShutdownHookRegistry();
            LauncherOptions launcherOptions = this.getLauncherOptions();
            this.setLauncher(new ChromeLauncher(null, (ChromeLauncher.ShutdownHookRegistry)shutdownHookRegistry, launcherOptions, 1, null));
            this.setChrome(this.getLauncher().launch(this.getLaunchOptions()));
        }
    }

    @NotNull
    public final synchronized ChromeTab createTab() throws Exception {
        this.setActiveTime(Instant.now());
        this.getTabCount().incrementAndGet();
        return this.getChrome().createTab("about:blank");
    }

    public final synchronized void closeTab(@NotNull ChromeTab tab) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        this.getTabCount().decrementAndGet();
        this.getChrome().closeTab(tab);
    }

    @NotNull
    public final synchronized ChromeTab[] listTab() {
        return this.getChrome().getTabs();
    }

    @NotNull
    public final synchronized RemoteDevTools createDevTools(@NotNull ChromeTab tab, @NotNull DevToolsConfig config) throws Exception {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        RemoteDevTools devTools = this.getChrome().createDevTools(tab, config);
        this.devToolsList.add(devTools);
        return devTools;
    }

    @Override
    public void close() {
        if (this.getLaunched().get() && this.getClosed().compareAndSet(false, true)) {
            this.logger.info("Closing {} devtools ... | {}", (Object)this.devToolsList.size(), (Object)this.getId().getDisplay());
            List list = CollectionsKt.toList((Iterable)this.devToolsList);
            boolean bl = false;
            boolean bl2 = false;
            List it = list;
            boolean bl3 = false;
            this.getDevToolsList().clear();
            List nonSynchronized = list;
            nonSynchronized.parallelStream().forEach(arg_0 -> ChromeDevtoolsBrowserInstance.close$lambda-1(this, arg_0));
            this.getChrome().close();
            this.getLauncher().close();
            this.logger.info("Browser instance is closed | {}", (Object)this.getId().getDisplay());
        }
    }

    private static final void close$lambda-1(ChromeDevtoolsBrowserInstance this$0, RemoteDevTools it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            it.close();
            it.waitUntilClosed();
        }
        catch (Exception e) {
            this$0.logger.warn("Failed to close the dev tool", (Throwable)e);
        }
    }
}

