/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver.playwright;

import ai.platon.pulsar.browser.common.BlockRules;
import ai.platon.pulsar.browser.common.BrowserSettings;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.crawl.fetch.driver.AbstractWebDriver;
import ai.platon.pulsar.persist.jackson.ExtensionsKt;
import ai.platon.pulsar.persist.metadata.BrowserType;
import ai.platon.pulsar.protocol.browser.driver.NavigateEntry;
import ai.platon.pulsar.protocol.browser.driver.WebDriverSettings;
import ai.platon.pulsar.protocol.browser.driver.playwright.PlaywrightBrowserInstance;
import ai.platon.pulsar.protocol.browser.hotfix.sites.amazon.AmazonBlockRules;
import ai.platon.pulsar.protocol.browser.hotfix.sites.jd.JdBlockRules;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.playwright.Locator;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.options.BoundingBox;
import com.microsoft.playwright.options.Cookie;
import com.microsoft.playwright.options.Position;
import com.microsoft.playwright.options.WaitUntilState;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010$\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 Y2\u00020\u0001:\u0001YB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010/\u001a\u000200H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101J!\u00102\u001a\u0002002\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020&H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J\b\u00106\u001a\u000200H\u0016J\u0011\u00107\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101J\u001b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J\u0019\u0010<\u001a\u00020\u00102\u0006\u00103\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J#\u0010=\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0?0>H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101J\u0010\u0010@\u001a\u0002002\u0006\u0010A\u001a\u00020\bH\u0002J\u0010\u0010B\u001a\u0002002\u0006\u0010A\u001a\u00020\bH\u0002J\u0010\u0010C\u001a\u0002002\u0006\u0010A\u001a\u00020\bH\u0002J\u0019\u0010D\u001a\u0002002\u0006\u0010A\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J\u0013\u0010E\u001a\u0004\u0018\u00010\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101J\b\u0010F\u001a\u000200H\u0016J\u000e\u0010G\u001a\u0002002\u0006\u0010H\u001a\u00020IJ\u0019\u0010J\u001a\u0002002\u0006\u00103\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J\u0019\u0010K\u001a\u0002002\u0006\u0010L\u001a\u00020MH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010NJ\u0010\u0010O\u001a\u0002002\u0006\u0010A\u001a\u00020\bH\u0002J\u0011\u0010P\u001a\u000200H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101J\b\u0010Q\u001a\u00020\bH\u0016J!\u0010R\u001a\u0002002\u0006\u00103\u001a\u00020\b2\u0006\u0010S\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010TJ!\u0010U\u001a\u00020V2\u0006\u00103\u001a\u00020\b2\u0006\u0010W\u001a\u00020VH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010XR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R\"\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006Z"}, d2={"Lai/platon/pulsar/protocol/browser/driver/playwright/PlaywrightDriver;", "Lai/platon/pulsar/crawl/fetch/driver/AbstractWebDriver;", "browserSettings", "Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;", "browserInstance", "Lai/platon/pulsar/protocol/browser/driver/playwright/PlaywrightBrowserInstance;", "(Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;Lai/platon/pulsar/protocol/browser/driver/playwright/PlaywrightBrowserInstance;)V", "_sessionId", "", "browserType", "Lai/platon/pulsar/persist/metadata/BrowserType;", "getBrowserType", "()Lai/platon/pulsar/persist/metadata/BrowserType;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "enableBlockingReport", "", "enableUrlBlocking", "getEnableUrlBlocking", "()Z", "isActive", "isFirstLaunch", "isGone", "lastActiveTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "getLastActiveTime", "()Ljava/time/Instant;", "setLastActiveTime", "(Ljava/time/Instant;)V", "logger", "Lorg/slf4j/Logger;", "navigateUrl", "numSessionLost", "Ljava/util/concurrent/atomic/AtomicInteger;", "getNumSessionLost", "()Ljava/util/concurrent/atomic/AtomicInteger;", "openSequence", "", "getOpenSequence", "()I", "page", "Lcom/microsoft/playwright/Page;", "pageInitialized", "sessionId", "getSessionId", "()Ljava/lang/String;", "bringToFront", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "click", "selector", "count", "(Ljava/lang/String;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "currentUrl", "evaluate", "", "expression", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "exists", "getCookies", "", "", "getInvaded", "url", "getNoInvaded", "initSpecialSiteBeforeVisit", "navigateTo", "pageSource", "quit", "screenshot", "path", "Ljava/nio/file/Path;", "scrollTo", "setTimeouts", "driverConfig", "Lai/platon/pulsar/browser/common/BrowserSettings;", "(Lai/platon/pulsar/browser/common/BrowserSettings;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setupUrlBlocking", "stop", "toString", "type", "text", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "waitFor", "", "timeoutMillis", "(Ljava/lang/String;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "pulsar-protocol"})
public final class PlaywrightDriver
extends AbstractWebDriver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebDriverSettings browserSettings;
    @NotNull
    private final PlaywrightBrowserInstance browserInstance;
    @NotNull
    private final Logger logger;
    @NotNull
    private final BrowserType browserType;
    private final int openSequence;
    private boolean isFirstLaunch;
    @NotNull
    private final String _sessionId;
    @NotNull
    private String navigateUrl;
    @NotNull
    private final AtomicBoolean pageInitialized;
    private Page page;
    private final boolean enableBlockingReport;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final AtomicInteger numSessionLost;
    private Instant lastActiveTime;
    @NotNull
    private static final AtomicInteger sessionIdGenerator = new AtomicInteger();

    public PlaywrightDriver(@NotNull WebDriverSettings browserSettings, @NotNull PlaywrightBrowserInstance browserInstance) {
        Intrinsics.checkNotNullParameter((Object)((Object)browserSettings), (String)"browserSettings");
        Intrinsics.checkNotNullParameter((Object)browserInstance, (String)"browserInstance");
        super(browserInstance.getId(), 0, 2, null);
        this.browserSettings = browserSettings;
        this.browserInstance = browserInstance;
        Logger logger = LoggerFactory.getLogger(PlaywrightDriver.class);
        Intrinsics.checkNotNull((Object)logger);
        this.logger = logger;
        this.browserType = BrowserType.PLAYWRIGHT_CHROME;
        this.openSequence = 1 + this.browserInstance.getTabCount().get();
        this.isFirstLaunch = this.openSequence == 1;
        this._sessionId = "playwright-" + sessionIdGenerator.incrementAndGet();
        this.navigateUrl = "";
        this.pageInitialized = new AtomicBoolean();
        this.closed = new AtomicBoolean();
        this.numSessionLost = new AtomicInteger();
        this.lastActiveTime = Instant.now();
    }

    @NotNull
    public BrowserType getBrowserType() {
        return this.browserType;
    }

    public final int getOpenSequence() {
        return this.openSequence;
    }

    public final boolean getEnableUrlBlocking() {
        return this.browserSettings.getEnableUrlBlocking();
    }

    @NotNull
    public final AtomicInteger getNumSessionLost() {
        return this.numSessionLost;
    }

    public Instant getLastActiveTime() {
        return this.lastActiveTime;
    }

    public void setLastActiveTime(Instant instant) {
        this.lastActiveTime = instant;
    }

    public final boolean isGone() {
        return this.closed.get() || this.numSessionLost.get() > 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isActive() {
        Page page;
        if (this.isGone()) return false;
        Page page2 = this.page;
        if (page2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"page");
            page = null;
        } else {
            page = page2;
        }
        if (page.isClosed()) return false;
        return true;
    }

    @Nullable
    public Object setTimeouts(@NotNull BrowserSettings driverConfig, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Nullable
    public Object navigateTo(@NotNull String url, @NotNull Continuation<? super Unit> $completion) {
        PlaywrightDriver playwrightDriver;
        if (this.pageInitialized.compareAndSet(false, true)) {
            this.page = this.browserInstance.createTab();
        }
        this.initSpecialSiteBeforeVisit(url);
        this.browserInstance.getNavigateHistory().add(new NavigateEntry(url, false, null, null, 14, null));
        this.setLastActiveTime(Instant.now());
        PlaywrightDriver playwrightDriver2 = this;
        boolean bl = false;
        boolean bl2 = false;
        PlaywrightDriver it = playwrightDriver2;
        boolean bl3 = false;
        PlaywrightDriver playwrightDriver3 = playwrightDriver = this.browserSettings.getJsInvadingEnabled() ? playwrightDriver2 : null;
        if (playwrightDriver == null) {
            this.getNoInvaded(url);
        } else {
            playwrightDriver.getInvaded(url);
        }
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void initSpecialSiteBeforeVisit(String url) {
        NavigateEntry it;
        if (!this.isFirstLaunch) return;
        if (!StringsKt.contains$default((CharSequence)url, (CharSequence)"jd.com", (boolean)false, (int)2, null)) return;
        Iterable $this$none$iv = this.browserInstance.getNavigateHistory();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return;
            Object element$iv = iterator.next();
            it = (NavigateEntry)element$iv;
            boolean bl = false;
        } while (!StringsKt.contains$default((CharSequence)it.getUrl(), (CharSequence)"jd.com", (boolean)false, (int)2, null));
    }

    @Nullable
    public Object stop(@NotNull Continuation<? super Unit> $completion) {
        if (!this.isActive()) {
            return Unit.INSTANCE;
        }
        try {
            Page page;
            Page page2 = this.page;
            if (page2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"page");
                page = null;
            } else {
                page = page2;
            }
            page.pause();
        }
        catch (Exception e) {
            this.getNumSessionLost().incrementAndGet();
            this.logger.warn("Failed to call stop loading | {}", (Object)e.getMessage());
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object evaluate(@NotNull String expression, @NotNull Continuation<Object> $completion) {
        String string;
        if (!this.isActive()) {
            return null;
        }
        try {
            Object evaluate2;
            Page page;
            Object object = this.page;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"page");
                page = null;
            } else {
                page = object;
            }
            object = evaluate2 = page.evaluate(expression);
            string = object == null ? null : object.toString();
        }
        catch (Exception e) {
            String stackTrace = ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null);
            if (!StringsKt.contains$default((CharSequence)stackTrace, (CharSequence)"Error: Target closed", (boolean)false, (int)2, null)) {
                this.logger.warn("Failed to evaluate | {}", (Object)e.getMessage());
            }
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object getCookies(@NotNull Continuation<? super List<? extends Map<String, String>>> $completion) {
        void $this$mapTo$iv$iv;
        Page page;
        ObjectMapper mapper = ExtensionsKt.pulsarObjectMapper();
        Page page2 = this.page;
        if (page2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"page");
            page = null;
        } else {
            page = page2;
        }
        List list = page.context().cookies();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"page.context().cookies()");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            void $this$readValue$iv;
            Map map;
            void it;
            Cookie cookie = (Cookie)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String json = mapper.writeValueAsString((Object)it);
            ObjectMapper objectMapper = mapper;
            Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
            String content$iv = json;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef22 = false;
            Map $this$filterValues$iv = map = (Map)$this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<Map<String, ? extends String>>(){});
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            Map $i$f$jacksonTypeRef22 = $this$filterValues$iv;
            boolean bl2 = false;
            for (Map.Entry entry$iv : $i$f$jacksonTypeRef22.entrySet()) {
                String it2 = (String)entry$iv.getValue();
                boolean bl3 = false;
                if (!(it2 != null)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterValues$iv = result$iv;
            boolean $i$f$mapValues = false;
            result$iv = $this$mapValues$iv;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it3;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv2;
                boolean bl4 = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                Map map3 = map2;
                boolean bl5 = false;
                String string = it3.toString();
                map3.put(k2, string);
            }
            Map map4 = destination$iv$iv2;
            collection.add(map4);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public String getSessionId() {
        return this._sessionId;
    }

    @Nullable
    public Object currentUrl(@NotNull Continuation<? super String> $completion) {
        try {
            String string;
            if (!this.isActive()) {
                string = this.navigateUrl;
            } else {
                Page page;
                Page page2 = this.page;
                if (page2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"page");
                    page = null;
                } else {
                    page = page2;
                }
                String string2 = page.url();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"page.url()");
                string = string2;
            }
            this.navigateUrl = string;
        }
        catch (Exception e) {
            this.logger.warn("Failed to query url | {}", (Object)e.getMessage());
        }
        return this.navigateUrl;
    }

    @Nullable
    public Object exists(@NotNull String selector, @NotNull Continuation<? super Boolean> $completion) {
        try {
            Page page;
            Page page2 = this.page;
            if (page2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"page");
                page = null;
            } else {
                page = page2;
            }
            Locator locator = page.locator(selector);
            return Boxing.boxBoolean((locator.count() > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            this.logger.warn("Failed to locate | {}", (Object)e.getMessage());
            return Boxing.boxBoolean((boolean)false);
        }
    }

    @Nullable
    public Object waitFor(@NotNull String selector, long timeoutMillis, @NotNull Continuation<? super Long> $completion) {
        try {
            Page page;
            long startTime = System.currentTimeMillis();
            Page page2 = this.page;
            if (page2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"page");
                page = null;
            } else {
                page = page2;
            }
            page.waitForSelector(selector);
            return Boxing.boxLong((long)(timeoutMillis - (System.currentTimeMillis() - startTime)));
        }
        catch (Exception e) {
            this.logger.warn("Failed to wait | {}", (Object)e.getMessage());
            return Boxing.boxLong((long)0L);
        }
    }

    @Nullable
    public Object type(@NotNull String selector, @NotNull String text, @NotNull Continuation<? super Unit> $completion) {
        try {
            Page page;
            Page page2 = this.page;
            if (page2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"page");
                page = null;
            } else {
                page = page2;
            }
            Locator locator = page.locator(selector);
            locator.scrollIntoViewIfNeeded();
            locator.type(text);
        }
        catch (Exception e) {
            this.logger.warn("Failed to type | {}", (Object)e.getMessage());
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object click(@NotNull String selector, int count, @NotNull Continuation<? super Unit> $completion) {
        try {
            Page page;
            Page page2 = this.page;
            if (page2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"page");
                page = null;
            } else {
                page = page2;
            }
            Locator locator = page.locator(selector);
            locator.scrollIntoViewIfNeeded();
            BoundingBox box = locator.boundingBox();
            double x = box.width / (double)3;
            double y = box.height / (double)3;
            x += (double)Random.Default.nextInt((int)x);
            y += (double)Random.Default.nextInt((int)y);
            Position position = new Position(x, y);
            double delayMillis = 500.0 + (double)Random.Default.nextInt(1500);
            Locator.ClickOptions options = new Locator.ClickOptions().setDelay(delayMillis).setNoWaitAfter(true).setPosition(position).setClickCount(count);
            locator.click(options);
        }
        catch (Exception e) {
            this.logger.warn("Failed to click | {}", (Object)e.getMessage());
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object scrollTo(@NotNull String selector, @NotNull Continuation<? super Unit> $completion) {
        try {
            Page page;
            Page page2 = this.page;
            if (page2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"page");
                page = null;
            } else {
                page = page2;
            }
            Locator locator = page.locator(selector);
            locator.scrollIntoViewIfNeeded();
        }
        catch (Exception e) {
            this.logger.warn("Failed to click | {}", (Object)e.getMessage());
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object pageSource(@NotNull Continuation<? super String> $completion) {
        boolean bl;
        Object object;
        boolean bl2 = false;
        try {
            Page page;
            object = Result.Companion;
            boolean bl3 = false;
            Page page2 = this.page;
            if (page2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"page");
                page = null;
            } else {
                page = page2;
            }
            String string = page.content();
            boolean bl4 = false;
            object = Result.constructor-impl((Object)string);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Result.Companion companion = object;
        boolean bl5 = false;
        boolean bl6 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)companion);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl7 = false;
            bl = false;
            Throwable throwable3 = throwable2;
            boolean bl8 = false;
            Throwable it = throwable3;
            boolean bl9 = false;
            this.logger.warn("Failed to get page source | {}", (Object)it.getMessage());
        }
        bl5 = false;
        return Result.isFailure-impl((Object)companion) ? null : companion;
    }

    @Nullable
    public Object bringToFront(@NotNull Continuation<? super Unit> $completion) {
        Page page;
        Page page2 = this.page;
        if (page2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"page");
            page = null;
        } else {
            page = page2;
        }
        page.bringToFront();
        return Unit.INSTANCE;
    }

    public final void screenshot(@NotNull Path path) {
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean bl2 = false;
        try {
            Page page;
            object = Result.Companion;
            boolean bl3 = false;
            Page page2 = this.page;
            if (page2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"page");
                page = null;
            } else {
                page = page2;
            }
            byte[] byArray = page.screenshot(new Page.ScreenshotOptions().setPath(path));
            boolean bl4 = false;
            object = Result.constructor-impl((Object)byArray);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object2 = object;
        boolean bl5 = false;
        boolean bl6 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl7 = false;
            bl = false;
            Throwable throwable3 = throwable2;
            boolean bl8 = false;
            Throwable it = throwable3;
            boolean bl9 = false;
            this.logger.warn("Failed to screenshot | {}", (Object)it.getMessage());
        }
        bl5 = false;
        if (Result.isFailure-impl((Object)object2)) {
            // empty if block
        }
    }

    @NotNull
    public String toString() {
        return this.getSessionId();
    }

    public void quit() {
        this.close();
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Page page;
            Page page2 = this.page;
            if (page2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"page");
                page = null;
            } else {
                page = page2;
            }
            page.close();
        }
    }

    private final void getInvaded(String url) {
        if (!this.isActive()) {
            return;
        }
        try {
            Page page;
            if (this.getEnableUrlBlocking()) {
                this.setupUrlBlocking(url);
            }
            this.navigateUrl = url;
            Page.NavigateOptions options = new Page.NavigateOptions().setWaitUntil(WaitUntilState.COMMIT);
            Page page2 = this.page;
            if (page2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"page");
                page = null;
            } else {
                page = page2;
            }
            page.navigate(url, options);
        }
        catch (Exception e) {
            this.numSessionLost.incrementAndGet();
            this.logger.warn("Failed to navigate | {}", (Object)e.getMessage());
        }
    }

    private final void getNoInvaded(String url) {
        if (!this.isActive()) {
            return;
        }
        try {
            Page page;
            this.navigateUrl = url;
            Page page2 = this.page;
            if (page2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"page");
                page = null;
            } else {
                page = page2;
            }
            page.navigate(url);
        }
        catch (Exception e) {
            this.numSessionLost.incrementAndGet();
            this.logger.warn("Failed to navigate | {}", (Object)e.getMessage());
        }
    }

    private final void setupUrlBlocking(String url) {
        BlockRules blockRules = StringsKt.contains$default((CharSequence)url, (CharSequence)"amazon.com", (boolean)false, (int)2, null) ? (BlockRules)new AmazonBlockRules() : (StringsKt.contains$default((CharSequence)url, (CharSequence)"jd.com", (boolean)false, (int)2, null) ? (BlockRules)new JdBlockRules() : new BlockRules());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/pulsar/protocol/browser/driver/playwright/PlaywrightDriver$Companion;", "", "()V", "sessionIdGenerator", "Ljava/util/concurrent/atomic/AtomicInteger;", "getSessionIdGenerator", "()Ljava/util/concurrent/atomic/AtomicInteger;", "pulsar-protocol"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicInteger getSessionIdGenerator() {
            return sessionIdGenerator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

