/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.emulator;

import ai.platon.pulsar.browser.common.EmulateSettings;
import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.HtmlsKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Parameterized;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.crawl.fetch.FetchTask;
import ai.platon.pulsar.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.protocol.browser.driver.WebDriverSettings;
import ai.platon.pulsar.protocol.browser.emulator.EventHandler;
import ai.platon.pulsar.protocol.browser.emulator.NavigateTaskCancellationException;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u00108\u001a\u000209H\u0004J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0004J\u0010\u00108\u001a\u0002092\u0006\u0010<\u001a\u00020=H\u0004J\b\u0010>\u001a\u000209H\u0016J\b\u0010?\u001a\u00020@H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0018\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0017\u001a\u0004\b\u0019\u0010\u0015R\u001b\u0010\u001b\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0017\u001a\u0004\b\u001c\u0010\u0015R\u001b\u0010\u001e\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0017\u001a\u0004\b\u001f\u0010\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010-R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u00100\u001a\u0002018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u0017\u001a\u0004\b2\u00103R\u0011\u00105\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010-R\u0010\u00107\u001a\u0004\u0018\u00010/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lai/platon/pulsar/protocol/browser/emulator/BrowserEmulatorBase;", "Lai/platon/pulsar/common/config/Parameterized;", "Ljava/lang/AutoCloseable;", "driverSettings", "Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;", "eventHandler", "Lai/platon/pulsar/protocol/browser/emulator/EventHandler;", "immutableConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;Lai/platon/pulsar/protocol/browser/emulator/EventHandler;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "charsetPattern", "Ljava/util/regex/Pattern;", "getCharsetPattern", "()Ljava/util/regex/Pattern;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getClosed", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "counterCancels", "Lcom/codahale/metrics/Counter;", "getCounterCancels", "()Lcom/codahale/metrics/Counter;", "counterCancels$delegate", "Lkotlin/Lazy;", "counterJsEvaluates", "getCounterJsEvaluates", "counterJsEvaluates$delegate", "counterJsWaits", "getCounterJsWaits", "counterJsWaits$delegate", "counterRequests", "getCounterRequests", "counterRequests$delegate", "getDriverSettings", "()Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;", "emulateSettings", "Lai/platon/pulsar/browser/common/EmulateSettings;", "getEmulateSettings", "()Lai/platon/pulsar/browser/common/EmulateSettings;", "getEventHandler", "()Lai/platon/pulsar/protocol/browser/emulator/EventHandler;", "getImmutableConfig", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "isActive", "", "()Z", "log", "Lorg/slf4j/Logger;", "meterNavigates", "Lcom/codahale/metrics/Meter;", "getMeterNavigates", "()Lcom/codahale/metrics/Meter;", "meterNavigates$delegate", "supportAllCharsets", "getSupportAllCharsets", "tracer", "checkState", "", "task", "Lai/platon/pulsar/crawl/fetch/FetchTask;", "driver", "Lai/platon/pulsar/crawl/fetch/driver/WebDriver;", "close", "getParams", "Lai/platon/pulsar/common/config/Params;", "pulsar-protocol"})
public abstract class BrowserEmulatorBase
implements Parameterized,
AutoCloseable {
    @NotNull
    private final WebDriverSettings driverSettings;
    @NotNull
    private final EventHandler eventHandler;
    @NotNull
    private final ImmutableConfig immutableConfig;
    @NotNull
    private final Logger log;
    @Nullable
    private final Logger tracer;
    @NotNull
    private final Pattern charsetPattern;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final Lazy meterNavigates$delegate;
    @NotNull
    private final Lazy counterRequests$delegate;
    @NotNull
    private final Lazy counterJsEvaluates$delegate;
    @NotNull
    private final Lazy counterJsWaits$delegate;
    @NotNull
    private final Lazy counterCancels$delegate;

    /*
     * WARNING - void declaration
     */
    public BrowserEmulatorBase(@NotNull WebDriverSettings driverSettings, @NotNull EventHandler eventHandler2, @NotNull ImmutableConfig immutableConfig) {
        void it;
        Intrinsics.checkNotNullParameter((Object)((Object)driverSettings), (String)"driverSettings");
        Intrinsics.checkNotNullParameter((Object)eventHandler2, (String)"eventHandler");
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"immutableConfig");
        this.driverSettings = driverSettings;
        this.eventHandler = eventHandler2;
        this.immutableConfig = immutableConfig;
        Logger logger = LoggerFactory.getLogger(BrowserEmulatorBase.class);
        Intrinsics.checkNotNull((Object)logger);
        Logger logger2 = this.log = logger;
        boolean bl = false;
        boolean bl2 = false;
        Logger logger3 = logger2;
        BrowserEmulatorBase browserEmulatorBase = this;
        boolean bl3 = false;
        boolean bl4 = it.isTraceEnabled();
        browserEmulatorBase.tracer = bl4 ? logger2 : null;
        this.charsetPattern = this.getSupportAllCharsets() ? HtmlsKt.getSYSTEM_AVAILABLE_CHARSET_PATTERN() : HtmlsKt.getDEFAULT_CHARSET_PATTERN();
        this.closed = new AtomicBoolean(false);
        this.meterNavigates$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Meter>(this){
            final /* synthetic */ BrowserEmulatorBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Meter invoke() {
                return AppMetrics.Companion.getReg().meter((Object)this.this$0, "navigates");
            }
        }));
        this.counterRequests$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Counter>(this){
            final /* synthetic */ BrowserEmulatorBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Counter invoke() {
                return AppMetrics.Companion.getReg().counter((Object)this.this$0, "requests");
            }
        }));
        this.counterJsEvaluates$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Counter>(this){
            final /* synthetic */ BrowserEmulatorBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Counter invoke() {
                return AppMetrics.Companion.getReg().counter((Object)this.this$0, "jsEvaluates");
            }
        }));
        this.counterJsWaits$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Counter>(this){
            final /* synthetic */ BrowserEmulatorBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Counter invoke() {
                return AppMetrics.Companion.getReg().counter((Object)this.this$0, "jsWaits");
            }
        }));
        this.counterCancels$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Counter>(this){
            final /* synthetic */ BrowserEmulatorBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Counter invoke() {
                return AppMetrics.Companion.getReg().counter((Object)this.this$0, "cancels");
            }
        }));
    }

    @NotNull
    public final WebDriverSettings getDriverSettings() {
        return this.driverSettings;
    }

    @NotNull
    public final EventHandler getEventHandler() {
        return this.eventHandler;
    }

    @NotNull
    public final ImmutableConfig getImmutableConfig() {
        return this.immutableConfig;
    }

    @NotNull
    public final EmulateSettings getEmulateSettings() {
        return new EmulateSettings(this.immutableConfig);
    }

    public final boolean getSupportAllCharsets() {
        return this.immutableConfig.getBoolean("parser.support.all.charsets", true);
    }

    @NotNull
    public final Pattern getCharsetPattern() {
        return this.charsetPattern;
    }

    @NotNull
    public final AtomicBoolean getClosed() {
        return this.closed;
    }

    public final boolean isActive() {
        return !this.closed.get() && AppContext.INSTANCE.isActive();
    }

    @NotNull
    public final Meter getMeterNavigates() {
        Lazy lazy = this.meterNavigates$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Meter)lazy.getValue();
    }

    @NotNull
    public final Counter getCounterRequests() {
        Lazy lazy = this.counterRequests$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Counter)lazy.getValue();
    }

    @NotNull
    public final Counter getCounterJsEvaluates() {
        Lazy lazy = this.counterJsEvaluates$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Counter)lazy.getValue();
    }

    @NotNull
    public final Counter getCounterJsWaits() {
        Lazy lazy = this.counterJsWaits$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Counter)lazy.getValue();
    }

    @NotNull
    public final Counter getCounterCancels() {
        Lazy lazy = this.counterCancels$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Counter)lazy.getValue();
    }

    @NotNull
    public Params getParams() {
        Object[] objectArray = new Object[]{"scriptTimeout", this.getEmulateSettings().getScriptTimeout(), "scrollDownCount", this.getEmulateSettings().getScrollCount(), "scrollInterval", this.getEmulateSettings().getScrollInterval(), "jsInvadingEnabled", this.driverSettings.getJsInvadingEnabled(), "emulatorEventHandler", this.immutableConfig.get("browser.emulate.event.handler")};
        Params params = Params.of((String)"pageLoadTimeout", (Object)this.getEmulateSettings().getPageLoadTimeout(), (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n                \"pag\u2026_EVENT_HANDLER)\n        )");
        return params;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            // empty if block
        }
    }

    protected final void checkState() throws NavigateTaskCancellationException {
        if (!this.isActive()) {
            AppContext.INSTANCE.shouldTerminate();
            throw new NavigateTaskCancellationException("Emulator is closed");
        }
    }

    protected final void checkState(@NotNull WebDriver driver) throws NavigateTaskCancellationException {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        this.checkState();
        if (driver.isCanceled()) {
            throw new NavigateTaskCancellationException("Task with driver #" + driver.getId() + " is canceled | " + driver.getUrl());
        }
    }

    protected final void checkState(@NotNull FetchTask task) throws NavigateTaskCancellationException {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.checkState();
        if (task.isCanceled()) {
            throw new NavigateTaskCancellationException("Task #" + task.getBatchTaskId() + "/" + task.getBatchId() + " is canceled | " + task.getUrl());
        }
    }
}

