/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.emulator;

import ai.platon.pulsar.browser.common.BrowserSettings;
import ai.platon.pulsar.browser.common.EmulateSettings;
import ai.platon.pulsar.common.AppFiles;
import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.HtmlIntegrity;
import ai.platon.pulsar.common.HtmlsKt;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.files.ext.AppFilesExtKt;
import ai.platon.pulsar.common.message.MiscMessageWriter;
import ai.platon.pulsar.common.metrics.AppMetricRegistry;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.common.persist.ext.WebPageExKt;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import ai.platon.pulsar.crawl.fetch.FetchTask;
import ai.platon.pulsar.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.crawl.protocol.ForwardingResponse;
import ai.platon.pulsar.crawl.protocol.Response;
import ai.platon.pulsar.persist.PageDatum;
import ai.platon.pulsar.persist.ProtocolStatus;
import ai.platon.pulsar.persist.RetryScope;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.metadata.MultiMetadata;
import ai.platon.pulsar.persist.metadata.OpenPageCategory;
import ai.platon.pulsar.persist.metadata.PageCategory;
import ai.platon.pulsar.persist.model.ActiveDomMessage;
import ai.platon.pulsar.persist.model.ActiveDomMultiStatus;
import ai.platon.pulsar.persist.model.ActiveDomStatus;
import ai.platon.pulsar.persist.model.ActiveDomUrls;
import ai.platon.pulsar.protocol.browser.driver.WebDriverAdapter;
import ai.platon.pulsar.protocol.browser.driver.WebDriverPoolManager;
import ai.platon.pulsar.protocol.browser.emulator.BrowserError;
import ai.platon.pulsar.protocol.browser.emulator.NavigateTask;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020@H\u0016J\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0016J(\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020@2\u0006\u0010H\u001a\u00020IH\u0016J\u0018\u0010J\u001a\u00020K2\u0006\u0010H\u001a\u00020I2\u0006\u0010L\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020O2\u0006\u0010H\u001a\u00020IH\u0002J \u0010N\u001a\u00020O2\u0006\u0010F\u001a\u00020G2\u0006\u0010C\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u0016\u0010P\u001a\u00020@2\u0006\u0010H\u001a\u00020Q2\u0006\u0010R\u001a\u00020EJ\u0010\u0010S\u001a\u00020O2\u0006\u0010H\u001a\u00020IH\u0016J\u000e\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020GJ\u0016\u0010W\u001a\u00020O2\u0006\u0010H\u001a\u00020Q2\u0006\u0010X\u001a\u00020YJ \u0010Z\u001a\u00020O2\u0006\u0010H\u001a\u00020Q2\u0006\u0010F\u001a\u00020G2\u0006\u0010[\u001a\u00020EH\u0002J\u001c\u0010\\\u001a\u00060]j\u0002`^2\u0006\u0010_\u001a\u00020G2\u0006\u0010F\u001a\u00020GH\u0016J\u000e\u0010`\u001a\u00020a2\u0006\u0010H\u001a\u00020IJ\u0010\u0010b\u001a\u00020c2\u0006\u0010A\u001a\u00020BH\u0016J \u0010;\u001a\u00020O2\u0006\u0010d\u001a\u0002002\u0006\u0010A\u001a\u00020B2\u0006\u0010e\u001a\u00020fH\u0002J\u0010\u0010g\u001a\u00020O2\u0006\u0010H\u001a\u00020IH\u0002R\u001b\u0010\t\u001a\u00020\n8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\n8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000e\u001a\u0004\b\u0014\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001e\u001a\u00020\n8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u000e\u001a\u0004\b\u001f\u0010\fR\u0014\u0010!\u001a\u00020\"X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001b\u0010%\u001a\u00020&8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u000e\u001a\u0004\b'\u0010(R\u001b\u0010*\u001a\u00020\n8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u000e\u001a\u0004\b+\u0010\fR\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u0002008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u001b\u00103\u001a\u00020&8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\u000e\u001a\u0004\b4\u0010(R\u001b\u00106\u001a\u00020\n8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010\u000e\u001a\u0004\b7\u0010\fR\u0014\u00109\u001a\u00020\u00178DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0019R\u0014\u0010;\u001a\u00020\u00178DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0019R\u0016\u0010=\u001a\u0004\u0018\u00010\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u001d\u00a8\u0006h"}, d2={"Lai/platon/pulsar/protocol/browser/emulator/EventHandler;", "", "driverPoolManager", "Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;", "messageWriter", "Lai/platon/pulsar/common/message/MiscMessageWriter;", "immutableConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;Lai/platon/pulsar/common/message/MiscMessageWriter;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "bannedPages", "Lcom/codahale/metrics/Meter;", "getBannedPages", "()Lcom/codahale/metrics/Meter;", "bannedPages$delegate", "Lkotlin/Lazy;", "charsetPattern", "Ljava/util/regex/Pattern;", "getCharsetPattern", "()Ljava/util/regex/Pattern;", "emptyPages", "getEmptyPages", "emptyPages$delegate", "jsInvadingEnabled", "", "getJsInvadingEnabled", "()Z", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "notFoundPages", "getNotFoundPages", "notFoundPages$delegate", "numNavigates", "Ljava/util/concurrent/atomic/AtomicInteger;", "getNumNavigates", "()Ljava/util/concurrent/atomic/AtomicInteger;", "pageSourceByteHistogram", "Lcom/codahale/metrics/Histogram;", "getPageSourceByteHistogram", "()Lcom/codahale/metrics/Histogram;", "pageSourceByteHistogram$delegate", "pageSourceBytes", "getPageSourceBytes", "pageSourceBytes$delegate", "registry", "Lai/platon/pulsar/common/metrics/AppMetricRegistry;", "smallPageRate", "", "getSmallPageRate", "()J", "smallPageRateHistogram", "getSmallPageRateHistogram", "smallPageRateHistogram$delegate", "smallPages", "getSmallPages", "smallPages$delegate", "supportAllCharsets", "getSupportAllCharsets", "takeScreenshot", "getTakeScreenshot", "tracer", "getTracer", "checkErrorPage", "Lai/platon/pulsar/persist/ProtocolStatus;", "page", "Lai/platon/pulsar/persist/WebPage;", "status", "checkHtmlIntegrity", "Lai/platon/pulsar/common/HtmlIntegrity;", "pageSource", "", "task", "Lai/platon/pulsar/protocol/browser/emulator/NavigateTask;", "createResponse", "Lai/platon/pulsar/crawl/protocol/ForwardingResponse;", "pageDatum", "Lai/platon/pulsar/persist/PageDatum;", "exportIfNecessary", "", "handleBrokenPageSource", "Lai/platon/pulsar/crawl/fetch/FetchTask;", "htmlIntegrity", "handleBrowseTimeout", "handleChromeErrorPage", "Lai/platon/pulsar/protocol/browser/emulator/BrowserError;", "message", "logBeforeNavigate", "driverSettings", "Lai/platon/pulsar/browser/common/BrowserSettings;", "logBrokenPage", "integrity", "normalizePageSource", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "url", "onAfterNavigate", "Lai/platon/pulsar/crawl/protocol/Response;", "sniffPageCategory", "Lai/platon/pulsar/persist/metadata/OpenPageCategory;", "contentLength", "driver", "Lai/platon/pulsar/crawl/fetch/driver/WebDriver;", "takeScreenshotIfNecessary", "pulsar-protocol"})
public class EventHandler {
    @NotNull
    private final WebDriverPoolManager driverPoolManager;
    @Nullable
    private final MiscMessageWriter messageWriter;
    @NotNull
    private final ImmutableConfig immutableConfig;
    @NotNull
    private final Logger logger;
    @Nullable
    private final Logger tracer;
    @NotNull
    private final Pattern charsetPattern;
    @NotNull
    private final AtomicInteger numNavigates;
    private final boolean jsInvadingEnabled;
    @NotNull
    private final AppMetricRegistry registry;
    @NotNull
    private final Lazy pageSourceBytes$delegate;
    @NotNull
    private final Lazy pageSourceByteHistogram$delegate;
    @NotNull
    private final Lazy bannedPages$delegate;
    @NotNull
    private final Lazy notFoundPages$delegate;
    @NotNull
    private final Lazy smallPages$delegate;
    @NotNull
    private final Lazy smallPageRateHistogram$delegate;
    @NotNull
    private final Lazy emptyPages$delegate;

    /*
     * WARNING - void declaration
     */
    public EventHandler(@NotNull WebDriverPoolManager driverPoolManager, @Nullable MiscMessageWriter messageWriter, @NotNull ImmutableConfig immutableConfig) {
        void it;
        Intrinsics.checkNotNullParameter((Object)driverPoolManager, (String)"driverPoolManager");
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"immutableConfig");
        this.driverPoolManager = driverPoolManager;
        this.messageWriter = messageWriter;
        this.immutableConfig = immutableConfig;
        Logger logger = LoggerFactory.getLogger(EventHandler.class);
        Intrinsics.checkNotNull((Object)logger);
        Logger logger2 = this.logger = logger;
        boolean bl = false;
        boolean bl2 = false;
        Logger logger3 = logger2;
        EventHandler eventHandler2 = this;
        boolean bl3 = false;
        boolean bl4 = it.isTraceEnabled();
        eventHandler2.tracer = bl4 ? logger2 : null;
        this.charsetPattern = this.getSupportAllCharsets() ? HtmlsKt.getSYSTEM_AVAILABLE_CHARSET_PATTERN() : HtmlsKt.getDEFAULT_CHARSET_PATTERN();
        this.numNavigates = new AtomicInteger();
        this.jsInvadingEnabled = this.driverPoolManager.getDriverFactory().getDriverSettings().getJsInvadingEnabled();
        this.registry = AppMetrics.Companion.getDefaultMetricRegistry();
        this.pageSourceBytes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Meter>(this){
            final /* synthetic */ EventHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Meter invoke() {
                return EventHandler.access$getRegistry$p(this.this$0).meter((Object)this.this$0, "pageSourceBytes");
            }
        }));
        this.pageSourceByteHistogram$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Histogram>(this){
            final /* synthetic */ EventHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Histogram invoke() {
                return EventHandler.access$getRegistry$p(this.this$0).histogram((Object)this.this$0, "hPageSourceBytes");
            }
        }));
        this.bannedPages$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Meter>(this){
            final /* synthetic */ EventHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Meter invoke() {
                return EventHandler.access$getRegistry$p(this.this$0).meter((Object)this.this$0, "bannedPages");
            }
        }));
        this.notFoundPages$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Meter>(this){
            final /* synthetic */ EventHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Meter invoke() {
                return EventHandler.access$getRegistry$p(this.this$0).meter((Object)this.this$0, "notFoundPages");
            }
        }));
        this.smallPages$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Meter>(this){
            final /* synthetic */ EventHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Meter invoke() {
                return EventHandler.access$getRegistry$p(this.this$0).meter((Object)this.this$0, "smallPages");
            }
        }));
        this.smallPageRateHistogram$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Histogram>(this){
            final /* synthetic */ EventHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Histogram invoke() {
                return EventHandler.access$getRegistry$p(this.this$0).histogram((Object)this.this$0, "smallPageRate");
            }
        }));
        this.emptyPages$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Meter>(this){
            final /* synthetic */ EventHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Meter invoke() {
                return EventHandler.access$getRegistry$p(this.this$0).meter((Object)this.this$0, "emptyPages");
            }
        }));
    }

    public /* synthetic */ EventHandler(WebDriverPoolManager webDriverPoolManager, MiscMessageWriter miscMessageWriter, ImmutableConfig immutableConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            miscMessageWriter = null;
        }
        this(webDriverPoolManager, miscMessageWriter, immutableConfig);
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @Nullable
    protected final Logger getTracer() {
        return this.tracer;
    }

    protected final boolean getSupportAllCharsets() {
        return this.immutableConfig.getBoolean("parser.support.all.charsets", true);
    }

    protected final boolean getTakeScreenshot() {
        return this.immutableConfig.getBoolean("browser.take.screenshot", false);
    }

    @NotNull
    protected final Pattern getCharsetPattern() {
        return this.charsetPattern;
    }

    @NotNull
    protected final AtomicInteger getNumNavigates() {
        return this.numNavigates;
    }

    protected final boolean getJsInvadingEnabled() {
        return this.jsInvadingEnabled;
    }

    @NotNull
    protected final Meter getPageSourceBytes() {
        Lazy lazy = this.pageSourceBytes$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Meter)lazy.getValue();
    }

    @NotNull
    protected final Histogram getPageSourceByteHistogram() {
        Lazy lazy = this.pageSourceByteHistogram$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Histogram)lazy.getValue();
    }

    @NotNull
    protected final Meter getBannedPages() {
        Lazy lazy = this.bannedPages$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Meter)lazy.getValue();
    }

    @NotNull
    protected final Meter getNotFoundPages() {
        Lazy lazy = this.notFoundPages$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Meter)lazy.getValue();
    }

    @NotNull
    protected final Meter getSmallPages() {
        Lazy lazy = this.smallPages$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Meter)lazy.getValue();
    }

    protected final long getSmallPageRate() {
        return (long)100 * this.getSmallPages().getCount() / (long)this.numNavigates.get();
    }

    @NotNull
    protected final Histogram getSmallPageRateHistogram() {
        Lazy lazy = this.smallPageRateHistogram$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Histogram)lazy.getValue();
    }

    @NotNull
    protected final Meter getEmptyPages() {
        Lazy lazy = this.emptyPages$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Meter)lazy.getValue();
    }

    public final void logBeforeNavigate(@NotNull FetchTask task, @NotNull BrowserSettings driverSettings) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)driverSettings, (String)"driverSettings");
        if (this.logger.isTraceEnabled()) {
            EmulateSettings emulateSettings = new EmulateSettings((ImmutableConfig)task.getVolatileConfig());
            Object[] objectArray = new Object[]{task.getBatchTaskId(), task.getBatchSize(), task.getId(), Thread.currentThread().getId(), task.getNRetries() <= 1 ? "" : "(" + task.getNRetries() + ")", task.getPage().getConfiguredUrl(), emulateSettings.getPageLoadTimeout(), emulateSettings.getScriptTimeout(), emulateSettings.getScrollInterval()};
            this.logger.trace("Navigate {}/{}/{} in [t{}]{} | {} | timeouts: {}/{}/{}", objectArray);
        }
    }

    @NotNull
    public final Response onAfterNavigate(@NotNull NavigateTask task) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.numNavigates.incrementAndGet();
        PageDatum pageDatum = task.getPageDatum();
        int length = task.getPageSource().length();
        this.getPageSourceByteHistogram().update(length);
        this.getPageSourceBytes().mark((long)length);
        pageDatum.setPageCategory(this.sniffPageCategory(task.getPage()));
        pageDatum.setProtocolStatus(this.checkErrorPage(task.getPage(), pageDatum.getProtocolStatus()));
        if (!pageDatum.getProtocolStatus().isSuccess()) {
            task.setPageSource("");
            pageDatum.setLastBrowser(task.getDriver().getBrowserType());
            return (Response)this.createResponse(task, pageDatum);
        }
        HtmlIntegrity integrity = this.checkHtmlIntegrity(task.getPageSource(), task.getPage(), pageDatum.getProtocolStatus(), task);
        if (pageDatum.getProtocolStatus().isTimeout()) {
            if (integrity.isOK()) {
                object = ProtocolStatus.STATUS_SUCCESS;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"STATUS_SUCCESS");
                pageDatum.setProtocolStatus(object);
            }
            this.handleBrowseTimeout(task);
        }
        pageDatum.getHeaders().put("Content-Length", String.valueOf(task.getPageSource().length()));
        if (integrity.isOK()) {
            object = this.normalizePageSource(task.getUrl(), task.getPageSource()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"normalizePageSource(task\u2026sk.pageSource).toString()");
            task.setPageSource((String)object);
        } else {
            pageDatum.setProtocolStatus(this.handleBrokenPageSource(task.getTask(), integrity));
            this.logBrokenPage(task.getTask(), task.getPageSource(), integrity);
        }
        object = pageDatum;
        boolean bl = false;
        boolean bl2 = false;
        Object $this$onAfterNavigate_u24lambda_u2d1 = object;
        boolean bl3 = false;
        $this$onAfterNavigate_u24lambda_u2d1.setLastBrowser(task.getDriver().getBrowserType());
        $this$onAfterNavigate_u24lambda_u2d1.setHtmlIntegrity(integrity);
        String string = task.getPageSource();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        boolean bl4 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        $this$onAfterNavigate_u24lambda_u2d1.setContent(byArray);
        return (Response)this.createResponse(task, pageDatum);
    }

    @NotNull
    public OpenPageCategory sniffPageCategory(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        return new OpenPageCategory(PageCategory.UNKNOWN);
    }

    @NotNull
    public ProtocolStatus checkErrorPage(@NotNull WebPage page, @NotNull ProtocolStatus status) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        return status;
    }

    @NotNull
    public HtmlIntegrity checkHtmlIntegrity(@NotNull String pageSource2, @NotNull WebPage page, @NotNull ProtocolStatus status, @NotNull NavigateTask task) {
        Intrinsics.checkNotNullParameter((Object)pageSource2, (String)"pageSource");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        long length = pageSource2.length();
        return length == 0L ? HtmlIntegrity.EMPTY_0B : (length == 39L ? HtmlIntegrity.EMPTY_39B : (HtmlsKt.isBlankBody((String)pageSource2) ? HtmlIntegrity.BLANK_BODY : this.checkHtmlIntegrity(pageSource2)));
    }

    @NotNull
    public StringBuilder normalizePageSource(@NotNull String url, @NotNull String pageSource2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)pageSource2, (String)"pageSource");
        return HtmlsKt.replaceHTMLCharset((String)pageSource2, (Pattern)this.charsetPattern, (String)"UTF-8");
    }

    @NotNull
    public HtmlIntegrity checkHtmlIntegrity(@NotNull String pageSource2) {
        Intrinsics.checkNotNullParameter((Object)pageSource2, (String)"pageSource");
        int p0 = StringsKt.indexOf$default((CharSequence)pageSource2, (String)"</head>", (int)0, (boolean)false, (int)6, null);
        int p1 = StringsKt.indexOf$default((CharSequence)pageSource2, (String)"<body", (int)p0, (boolean)false, (int)4, null);
        if (p1 <= 0) {
            return HtmlIntegrity.OTHER;
        }
        int p2 = StringsKt.indexOf$default((CharSequence)pageSource2, (String)">", (int)p1, (boolean)false, (int)4, null);
        if (p2 < p1) {
            return HtmlIntegrity.OTHER;
        }
        int p3 = StringsKt.indexOf$default((CharSequence)pageSource2, (String)"<a", (int)p2, (boolean)false, (int)4, null);
        if (p3 < p2) {
            return HtmlIntegrity.NO_ANCHOR;
        }
        if (this.jsInvadingEnabled) {
            String string = pageSource2;
            boolean bl = false;
            String string2 = string.substring(p1, p2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String bodyTag = string2;
            string = this.tracer;
            if (string != null) {
                string.trace("Body tag: " + bodyTag);
            }
            boolean r = StringsKt.contains$default((CharSequence)bodyTag, (CharSequence)"data-error=\"0\"", (boolean)false, (int)2, null);
            if (!r) {
                return HtmlIntegrity.NO_JS_OK_FLAG;
            }
        }
        return HtmlIntegrity.OK;
    }

    public void handleBrowseTimeout(@NotNull NavigateTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (this.logger.isInfoEnabled()) {
            Duration elapsed = Duration.between(task.getStartTime(), Instant.now());
            int length = task.getPageSource().length();
            String string = task.getPage().getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.page.url");
            Path link = AppPaths.uniqueSymbolicLinkForUri$default((AppPaths)AppPaths.INSTANCE, (String)string, null, (int)2, null);
            EmulateSettings emulateSettings = new EmulateSettings((ImmutableConfig)task.getTask().getVolatileConfig());
            Object[] objectArray = new Object[]{task.getPageDatum().getProtocolStatus().getMinorName(), elapsed, Strings.readableBytes((int)length), emulateSettings.getPageLoadTimeout(), emulateSettings.getScriptTimeout(), emulateSettings.getScrollInterval(), link};
            this.logger.info("Timeout ({}) after {} with {} timeouts: {}/{}/{} | file://{}", objectArray);
        }
    }

    @NotNull
    public ForwardingResponse createResponse(@NotNull NavigateTask task, @NotNull PageDatum pageDatum) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)pageDatum, (String)"pageDatum");
        MultiMetadata headers = pageDatum.getHeaders();
        String utf8 = StandardCharsets.UTF_8.name();
        boolean bl = Intrinsics.areEqual((Object)utf8, (Object)"UTF-8");
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        headers.put("Content-Encoding", utf8);
        headers.put("Q-Trusted-Content-Encoding", utf8);
        headers.put("Q-Response-Time", String.valueOf(System.currentTimeMillis()));
        ActiveDomUrls urls = pageDatum.getActiveDomUrls();
        if (urls != null) {
            MiscMessageWriter miscMessageWriter;
            pageDatum.setLocation(urls.getLocation());
            if (!Intrinsics.areEqual((Object)pageDatum.getUrl(), (Object)pageDatum.getLocation()) && (miscMessageWriter = this.messageWriter) != null) {
                miscMessageWriter.debugRedirects(pageDatum.getUrl(), urls);
            }
        }
        if (!task.getDriver().isMockedPageSource()) {
            this.exportIfNecessary(task);
            this.takeScreenshotIfNecessary(task);
        }
        return new ForwardingResponse(task.getPage(), pageDatum);
    }

    @NotNull
    public final BrowserError handleChromeErrorPage(@NotNull String message) {
        ActiveDomStatus activeDomStatus;
        String ec;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ActiveDomMessage activeDomMessage = ActiveDomMessage.Companion.fromJson(message);
        ActiveDomMultiStatus activeDomMultiStatus = activeDomMessage.getMultiStatus();
        String string = ec = activeDomMultiStatus == null ? null : ((activeDomStatus = activeDomMultiStatus.getStatus()) == null ? null : activeDomStatus.getEc());
        activeDomStatus = Intrinsics.areEqual((Object)string, (Object)"ERR_CONNECTION_TIMED_OUT") ? ProtocolStatus.retry((RetryScope)RetryScope.PRIVACY, (Object)ec) : (Intrinsics.areEqual((Object)string, (Object)"ERR_EMPTY_RESPONSE") ? ProtocolStatus.retry((RetryScope)RetryScope.PRIVACY, (Object)ec) : ProtocolStatus.retry((RetryScope)RetryScope.CRAWL, (Object)ec));
        Intrinsics.checkNotNullExpressionValue((Object)activeDomStatus, (String)"when (ec) {\n            \u2026)\n            }\n        }");
        ActiveDomStatus status = activeDomStatus;
        return new BrowserError((ProtocolStatus)status, activeDomMessage);
    }

    @NotNull
    public final ProtocolStatus handleBrokenPageSource(@NotNull FetchTask task, @NotNull HtmlIntegrity htmlIntegrity) {
        ProtocolStatus protocolStatus;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)htmlIntegrity, (String)"htmlIntegrity");
        if (htmlIntegrity.isBanned()) {
            ProtocolStatus protocolStatus2 = ProtocolStatus.retry((RetryScope)RetryScope.PRIVACY, (Object)htmlIntegrity);
            boolean bl = false;
            boolean bl2 = false;
            ProtocolStatus it = protocolStatus2;
            boolean bl3 = false;
            this.getBannedPages().mark();
            ProtocolStatus protocolStatus3 = protocolStatus2;
            Intrinsics.checkNotNullExpressionValue((Object)protocolStatus3, (String)"retry(RetryScope.PRIVACY\u2026so { bannedPages.mark() }");
            protocolStatus = protocolStatus3;
        } else if (htmlIntegrity.isNotFound()) {
            ProtocolStatus protocolStatus4 = ProtocolStatus.failed((int)404);
            boolean bl = false;
            boolean bl4 = false;
            ProtocolStatus it = protocolStatus4;
            boolean bl5 = false;
            this.getNotFoundPages().mark();
            ProtocolStatus protocolStatus5 = protocolStatus4;
            Intrinsics.checkNotNullExpressionValue((Object)protocolStatus5, (String)"failed(ProtocolStatus.NO\u2026 { notFoundPages.mark() }");
            protocolStatus = protocolStatus5;
        } else if (htmlIntegrity.isEmpty()) {
            ProtocolStatus protocolStatus6 = ProtocolStatus.retry((RetryScope)RetryScope.PRIVACY, (Object)htmlIntegrity);
            boolean bl = false;
            boolean bl6 = false;
            ProtocolStatus it = protocolStatus6;
            boolean bl7 = false;
            this.getEmptyPages().mark();
            ProtocolStatus protocolStatus7 = protocolStatus6;
            Intrinsics.checkNotNullExpressionValue((Object)protocolStatus7, (String)"retry(RetryScope.PRIVACY\u2026lso { emptyPages.mark() }");
            protocolStatus = protocolStatus7;
        } else if (htmlIntegrity.isSmall()) {
            ProtocolStatus protocolStatus8 = ProtocolStatus.retry((RetryScope)RetryScope.CRAWL, (Object)htmlIntegrity);
            boolean bl = false;
            boolean bl8 = false;
            ProtocolStatus it = protocolStatus8;
            boolean bl9 = false;
            this.getSmallPages().mark();
            this.getSmallPageRateHistogram().update(this.getSmallPageRate());
            ProtocolStatus protocolStatus9 = protocolStatus8;
            Intrinsics.checkNotNullExpressionValue((Object)protocolStatus9, (String)"retry(RetryScope.CRAWL, \u2026llPageRate)\n            }");
            protocolStatus = protocolStatus9;
        } else {
            ProtocolStatus protocolStatus10 = ProtocolStatus.retry((RetryScope)RetryScope.CRAWL, (Object)htmlIntegrity);
            Intrinsics.checkNotNullExpressionValue((Object)protocolStatus10, (String)"retry(RetryScope.CRAWL, htmlIntegrity)");
            protocolStatus = protocolStatus10;
        }
        return protocolStatus;
    }

    private final void exportIfNecessary(NavigateTask task) {
        this.exportIfNecessary(task.getPageSource(), task.getPageDatum().getProtocolStatus(), task.getPage());
    }

    private final void exportIfNecessary(String pageSource2, ProtocolStatus status, WebPage page) {
        boolean shouldExport;
        CharSequence charSequence = pageSource2;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        int test = WebPageExKt.getOptions((WebPage)page).getTest();
        boolean bl2 = shouldExport = this.logger.isDebugEnabled() || test > 0 || this.logger.isInfoEnabled() && !status.isSuccess();
        if (shouldExport) {
            Path path = AppFilesExtKt.export((AppFiles)AppFiles.INSTANCE, (ProtocolStatus)status, (String)pageSource2, (WebPage)page);
            String string = page.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
            Path link = AppPaths.uniqueSymbolicLinkForUri$default((AppPaths)AppPaths.INSTANCE, (String)string, null, (int)2, null);
            try {
                Files.deleteIfExists(link);
                Files.createSymbolicLink(link, path, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.logger.warn(e.toString());
            }
        }
    }

    private final void takeScreenshotIfNecessary(NavigateTask task) {
        WebDriver driver;
        if (!this.getTakeScreenshot() || !task.getPageDatum().getProtocolStatus().isSuccess() || (driver = task.getDriver()) instanceof WebDriverAdapter) {
            // empty if block
        }
    }

    private final void takeScreenshot(long contentLength, WebPage page, WebDriver driver) {
    }

    private final void logBrokenPage(FetchTask task, String pageSource2, HtmlIntegrity integrity) {
        ProxyEntry proxyEntry = task.getProxyEntry();
        String domain = task.getDomain();
        Path link = AppPaths.uniqueSymbolicLinkForUri$default((AppPaths)AppPaths.INSTANCE, (String)task.getUrl(), null, (int)2, null);
        String readableLength = Strings.readableBytes((int)pageSource2.length());
        if (proxyEntry != null) {
            int count = proxyEntry.getServedDomains().count((Object)domain);
            Object[] objectArray = new Object[]{task.getPage().getId(), integrity.name(), readableLength, proxyEntry.getDisplay(), domain, count, link, task.getUrl()};
            this.logger.warn("{}. Page is {}({}) with {} in {}({}) | file://{}", objectArray);
        } else {
            Object[] objectArray = new Object[]{task.getPage().getId(), integrity.name(), readableLength, link, task.getUrl()};
            this.logger.warn("{}. Page is {}({}) | file://{} | {}", objectArray);
        }
    }

    public static final /* synthetic */ AppMetricRegistry access$getRegistry$p(EventHandler $this) {
        return $this.registry;
    }
}

