/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.emulator.context;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.crawl.fetch.FetchResult;
import ai.platon.pulsar.crawl.fetch.FetchTask;
import ai.platon.pulsar.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.crawl.fetch.privacy.BrowserInstanceId;
import ai.platon.pulsar.protocol.browser.driver.WebDriverPoolManager;
import ai.platon.pulsar.protocol.browser.emulator.context.WebDriverContext;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 &2\u00020\u0001:\u0001&B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0002JC\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152(\u0010\u001e\u001a$\b\u0001\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170!\u0012\u0006\u0012\u0004\u0018\u00010\"0\u001fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#J\u0006\u0010$\u001a\u00020\u001aJ\b\u0010%\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006'"}, d2={"Lai/platon/pulsar/protocol/browser/emulator/context/WebDriverContext;", "Ljava/lang/AutoCloseable;", "browserId", "Lai/platon/pulsar/crawl/fetch/privacy/BrowserInstanceId;", "driverPoolManager", "Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/crawl/fetch/privacy/BrowserInstanceId;Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getBrowserId", "()Lai/platon/pulsar/crawl/fetch/privacy/BrowserInstanceId;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isActive", "", "()Z", "isShutdown", "log", "Lorg/slf4j/Logger;", "runningTasks", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lai/platon/pulsar/crawl/fetch/FetchTask;", "checkAbnormalResult", "Lai/platon/pulsar/crawl/fetch/FetchResult;", "task", "close", "", "closeUnderlyingLayer", "doClose", "run", "browseFun", "Lkotlin/Function3;", "Lai/platon/pulsar/crawl/fetch/driver/WebDriver;", "Lkotlin/coroutines/Continuation;", "", "(Lai/platon/pulsar/crawl/fetch/FetchTask;Lkotlin/jvm/functions/Function3;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shutdown", "waitUntilNoRunningTasks", "Companion", "pulsar-protocol"})
public final class WebDriverContext
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BrowserInstanceId browserId;
    @NotNull
    private final WebDriverPoolManager driverPoolManager;
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final Logger log;
    @NotNull
    private final ConcurrentLinkedDeque<FetchTask> runningTasks;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final AtomicBoolean isShutdown;
    @NotNull
    private static final AtomicInteger numGlobalRunningTasks = new AtomicInteger();
    @NotNull
    private static final Meter globalTasks = AppMetrics.Companion.getReg().meter((Object)Companion, "globalTasks");
    @NotNull
    private static final Meter globalFinishedTasks = AppMetrics.Companion.getReg().meter((Object)Companion, "globalFinishedTasks");
    @NotNull
    private static final ReentrantLock lock = new ReentrantLock();
    private static final Condition notBusy = lock.newCondition();

    public WebDriverContext(@NotNull BrowserInstanceId browserId, @NotNull WebDriverPoolManager driverPoolManager, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        Intrinsics.checkNotNullParameter((Object)driverPoolManager, (String)"driverPoolManager");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.browserId = browserId;
        this.driverPoolManager = driverPoolManager;
        this.conf = conf;
        Logger logger = LoggerFactory.getLogger(WebDriverContext.class);
        Intrinsics.checkNotNull((Object)logger);
        this.log = logger;
        this.runningTasks = new ConcurrentLinkedDeque();
        this.closed = new AtomicBoolean();
        this.isShutdown = new AtomicBoolean();
    }

    @NotNull
    public final BrowserInstanceId getBrowserId() {
        return this.browserId;
    }

    private final boolean isActive() {
        return !this.closed.get();
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final Object run(@NotNull FetchTask var1_1, @NotNull Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object> var2_2, @NotNull Continuation<? super FetchResult> var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void shutdown() {
        this.isShutdown.set(true);
        this.close();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.doClose();
            }
            catch (Throwable t) {
                this.log.error("Unexpected exception", t);
            }
        }
    }

    private final void doClose() {
        this.closeUnderlyingLayer();
        if (!this.isShutdown.get()) {
            this.waitUntilNoRunningTasks();
        }
        Collection collection = this.runningTasks;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.log.warn("Still {} running tasks after context close | {}", (Object)this.runningTasks.size(), (Object)CollectionsKt.joinToString$default((Iterable)this.runningTasks, null, null, null, (int)0, null, (Function1)doClose.1.INSTANCE, (int)31, null));
        } else {
            this.log.info("Web driver context is closed successfully | {}", (Object)this.browserId);
        }
    }

    private final void closeUnderlyingLayer() {
        Iterable $this$forEach$iv = this.runningTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FetchTask it = (FetchTask)element$iv;
            boolean bl = false;
            it.cancel();
        }
        Duration duration = WebDriverPoolManager.Companion.getDRIVER_CLOSE_TIME_OUT();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"DRIVER_CLOSE_TIME_OUT");
        this.driverPoolManager.closeDriverPool(this.browserId, duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitUntilNoRunningTasks() {
        Lock lock = WebDriverContext.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            bl2 = notBusy.await(20L, TimeUnit.SECONDS);
        }
        finally {
            lock.unlock();
        }
    }

    private final FetchResult checkAbnormalResult(FetchTask task) {
        if (!this.isActive()) {
            return FetchResult.Companion.privacyRetry(task);
        }
        if (this.driverPoolManager.isRetiredPool(this.browserId)) {
            return FetchResult.Companion.privacyRetry(task);
        }
        return null;
    }

    private static final Integer _init_$lambda-3() {
        return numGlobalRunningTasks.get();
    }

    static {
        AppMetrics.Companion.getReg().register((Object)Companion, "globalRunningTasks", (Metric)((Gauge)WebDriverContext::_init_$lambda-3));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lai/platon/pulsar/protocol/browser/emulator/context/WebDriverContext$Companion;", "", "()V", "globalFinishedTasks", "Lcom/codahale/metrics/Meter;", "globalTasks", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "notBusy", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "numGlobalRunningTasks", "Ljava/util/concurrent/atomic/AtomicInteger;", "pulsar-protocol"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

