/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.crowd;

import ai.platon.pulsar.crawl.protocol.Response;
import ai.platon.pulsar.crawl.protocol.http.AbstractHttpProtocol;
import ai.platon.pulsar.persist.WebPage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J#\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0006H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lai/platon/pulsar/protocol/crowd/ForwardingProtocol;", "Lai/platon/pulsar/crawl/protocol/http/AbstractHttpProtocol;", "()V", "cache", "", "", "Lai/platon/pulsar/crawl/protocol/Response;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getResponse", "page", "Lai/platon/pulsar/persist/WebPage;", "followRedirects", "", "getResponseDeferred", "(Lai/platon/pulsar/persist/WebPage;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logAfterPutResponse", "", "logAfterRemoveResponse", "url", "response", "setResponse", "pulsar-protocol"})
public class ForwardingProtocol
extends AbstractHttpProtocol {
    private final Logger log = LoggerFactory.getLogger(ForwardingProtocol.class);
    @NotNull
    private final Map<String, Response> cache = new ConcurrentHashMap();

    public void setResponse(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Map<String, Response> map = this.cache;
        String string = response.getUrl();
        boolean bl = false;
        map.put(string, response);
        this.logAfterPutResponse();
    }

    @Nullable
    public Response getResponse(@NotNull WebPage page, boolean followRedirects) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Response response = this.cache.remove(page.getUrl());
        String string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        this.logAfterRemoveResponse(string, response);
        return response;
    }

    @Nullable
    public Object getResponseDeferred(@NotNull WebPage page, boolean followRedirects, @NotNull Continuation<? super Response> $completion) {
        return ForwardingProtocol.getResponseDeferred$suspendImpl(this, page, followRedirects, $completion);
    }

    static /* synthetic */ Object getResponseDeferred$suspendImpl(ForwardingProtocol this_, WebPage page, boolean followRedirects, Continuation $completion) {
        Response response = this_.cache.remove(page.getUrl());
        String string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        this_.logAfterRemoveResponse(string, response);
        return response;
    }

    private final void logAfterRemoveResponse(String url, Response response) {
        if (response == null && this.log.isTraceEnabled()) {
            this.log.trace("No page in forward cache, total {} | {}", (Object)this.cache.size(), (Object)url);
        }
    }

    private final void logAfterPutResponse() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Putting page to forward cache, total {}", (Object)this.cache.size());
        }
        if (this.cache.size() > 100) {
            this.log.warn("Forwarding cache is too large, there might be a bug");
            if (this.cache.size() > 1000) {
                this.log.warn("!!!WARNING!!! FORWARDING CACHE IS UNEXPECTED TOO LARGE, CLEAR IT TO PREVENT MEMORY EXHAUSTING");
                this.cache.clear();
            }
        }
    }
}

