/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver;

import ai.platon.pulsar.browser.common.BrowserSettings;
import ai.platon.pulsar.browser.driver.chrome.ChromeLauncher;
import ai.platon.pulsar.browser.driver.chrome.RemoteChrome;
import ai.platon.pulsar.browser.driver.chrome.common.ChromeOptions;
import ai.platon.pulsar.browser.driver.chrome.common.LauncherOptions;
import ai.platon.pulsar.browser.driver.chrome.util.ChromeProcessException;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.browser.BrowserType;
import ai.platon.pulsar.common.browser.Fingerprint;
import ai.platon.pulsar.protocol.browser.driver.cdt.ChromeDevtoolsBrowser;
import ai.platon.pulsar.protocol.browser.driver.test.MockBrowser;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.AbstractBrowser;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.Browser;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.BrowserLaunchException;
import ai.platon.pulsar.skeleton.crawl.fetch.privacy.BrowserId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lai/platon/pulsar/protocol/browser/driver/BrowserFactory;", "", "()V", "logger", "Lorg/slf4j/Logger;", "connect", "Lai/platon/pulsar/skeleton/crawl/fetch/driver/Browser;", "port", "", "browserSettings", "Lai/platon/pulsar/browser/common/BrowserSettings;", "createMockBrowser", "Lai/platon/pulsar/protocol/browser/driver/test/MockBrowser;", "browserId", "Lai/platon/pulsar/skeleton/crawl/fetch/privacy/BrowserId;", "launcherOptions", "Lai/platon/pulsar/browser/driver/chrome/common/LauncherOptions;", "browserOptions", "Lai/platon/pulsar/browser/driver/chrome/common/ChromeOptions;", "launch", "launchOptions", "launchChromeDevtoolsBrowser", "Lai/platon/pulsar/protocol/browser/driver/cdt/ChromeDevtoolsBrowser;", "pulsar-protocol"})
public final class BrowserFactory {
    @NotNull
    private final Logger logger = LogsKt.getLogger((Object)this);

    @NotNull
    public final Browser connect(int port, @NotNull BrowserSettings browserSettings) {
        Intrinsics.checkNotNullParameter((Object)browserSettings, (String)"browserSettings");
        return (Browser)new ChromeDevtoolsBrowser(port, browserSettings);
    }

    public static /* synthetic */ Browser connect$default(BrowserFactory browserFactory, int n, BrowserSettings browserSettings, int n2, Object object) {
        if ((n2 & 2) != 0) {
            browserSettings = new BrowserSettings(null, 1, null);
        }
        return browserFactory.connect(n, browserSettings);
    }

    @NotNull
    public final Browser launch(@NotNull BrowserId browserId, @NotNull LauncherOptions launcherOptions, @NotNull ChromeOptions launchOptions) throws BrowserLaunchException {
        AbstractBrowser browser;
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        Intrinsics.checkNotNullParameter((Object)launcherOptions, (String)"launcherOptions");
        Intrinsics.checkNotNullParameter((Object)launchOptions, (String)"launchOptions");
        BrowserSettings browserSettings = launcherOptions.getBrowserSettings();
        AbstractBrowser abstractBrowser = browser = WhenMappings.$EnumSwitchMapping$0[browserId.getBrowserType().ordinal()] == 1 ? (AbstractBrowser)this.createMockBrowser(browserId, launcherOptions, launchOptions) : (AbstractBrowser)this.launchChromeDevtoolsBrowser(browserId, launcherOptions, launchOptions);
        if (!browserSettings.isGUI()) {
            // empty if block
        }
        return (Browser)browser;
    }

    private final MockBrowser createMockBrowser(BrowserId browserId, LauncherOptions launcherOptions, ChromeOptions browserOptions) throws BrowserLaunchException {
        Fingerprint backupFingerprint = new Fingerprint(BrowserType.PULSAR_CHROME, null, null, null, null, 30, null);
        BrowserId backupBrowserId = new BrowserId(browserId.getContextDir(), backupFingerprint);
        BrowserSettings browserSettings = launcherOptions.getBrowserSettings();
        return new MockBrowser(browserId, browserSettings, (Browser)this.launchChromeDevtoolsBrowser(backupBrowserId, launcherOptions, browserOptions));
    }

    private final synchronized ChromeDevtoolsBrowser launchChromeDevtoolsBrowser(BrowserId browserId, LauncherOptions launcherOptions, ChromeOptions browserOptions) throws BrowserLaunchException {
        ChromeLauncher launcher = new ChromeLauncher(browserId.getUserDataDir(), launcherOptions, null, 4, null);
        try {
            RemoteChrome chrome = launcher.launch(browserOptions);
            return new ChromeDevtoolsBrowser(browserId, chrome, launcherOptions.getBrowserSettings(), launcher);
        }
        catch (ChromeProcessException e) {
            this.logger.warn("Failed to launch browser", (Throwable)e);
            throw new BrowserLaunchException("Failed to launch browser | " + browserId);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BrowserType.values().length];
            try {
                nArray[BrowserType.MOCK_CHROME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

