/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver;

import ai.platon.pulsar.browser.common.BrowserSettings;
import ai.platon.pulsar.browser.driver.chrome.common.ChromeOptions;
import ai.platon.pulsar.browser.driver.chrome.common.LauncherOptions;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.protocol.browser.driver.BrowserFactory;
import ai.platon.pulsar.protocol.browser.driver.WebDriverSettings;
import ai.platon.pulsar.skeleton.context.PulsarContexts;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.AbstractBrowser;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.AbstractWebDriver;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.Browser;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.BrowserEvents;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.BrowserLaunchException;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.skeleton.crawl.fetch.privacy.BrowserId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\bJ\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0007J\u000e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\u001aJ\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0007J\u0006\u0010#\u001a\u00020\u001aJ\u0010\u0010$\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001d\u001a\u00020\u0007J\b\u0010%\u001a\u0004\u0018\u00010 J\u0018\u0010%\u001a\u0004\u0018\u00010 2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020 0'H\u0002J*\u0010(\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0\fJ \u0010.\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\u0006\u00103\u001a\u00020\u001aJ\b\u00104\u001a\u00020\u001aH\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lai/platon/pulsar/protocol/browser/driver/BrowserManager;", "Ljava/lang/AutoCloseable;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "_browsers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lai/platon/pulsar/skeleton/crawl/fetch/privacy/BrowserId;", "Lai/platon/pulsar/skeleton/crawl/fetch/driver/Browser;", "browserFactory", "Lai/platon/pulsar/protocol/browser/driver/BrowserFactory;", "browsers", "", "getBrowsers", "()Ljava/util/Map;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "closedBrowsers", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "historicalBrowsers", "logger", "Lorg/slf4j/Logger;", "registered", "close", "", "closeBrowser", "browser", "browserId", "closeDriver", "driver", "Lai/platon/pulsar/skeleton/crawl/fetch/driver/WebDriver;", "closeLeastValuableDriver", "destroyBrowserForcibly", "destroyZombieBrowsersForcibly", "findBrowser", "findLeastValuableDriver", "drivers", "", "launch", "driverSettings", "Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;", "capabilities", "", "", "launchIfAbsent", "launcherOptions", "Lai/platon/pulsar/browser/driver/chrome/common/LauncherOptions;", "launchOptions", "Lai/platon/pulsar/browser/driver/chrome/common/ChromeOptions;", "maintain", "registerAsClosableIfNecessary", "pulsar-protocol"})
@SourceDebugExtension(value={"SMAP\nBrowserManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserManager.kt\nai/platon/pulsar/protocol/browser/driver/BrowserManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1#2:164\n766#3:165\n857#3,2:166\n1855#3,2:168\n1360#3:170\n1446#3,5:171\n1855#3,2:176\n800#3,11:178\n766#3:189\n857#3,2:190\n2333#3,14:192\n1855#3,2:206\n1855#3,2:208\n*S KotlinDebug\n*F\n+ 1 BrowserManager.kt\nai/platon/pulsar/protocol/browser/driver/BrowserManager\n*L\n65#1:165\n65#1:166,2\n65#1:168,2\n83#1:170\n83#1:171,5\n104#1:176,2\n112#1:178,11\n113#1:189\n113#1:190,2\n114#1:192,14\n118#1:206,2\n129#1:208,2\n*E\n"})
public class BrowserManager
implements AutoCloseable {
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final Logger logger;
    @NotNull
    private AtomicBoolean registered;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final BrowserFactory browserFactory;
    @NotNull
    private final ConcurrentHashMap<BrowserId, Browser> _browsers;
    @NotNull
    private final ConcurrentLinkedDeque<Browser> historicalBrowsers;
    @NotNull
    private final ConcurrentLinkedDeque<Browser> closedBrowsers;
    @NotNull
    private final Map<BrowserId, Browser> browsers;

    public BrowserManager(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.logger = LogsKt.getLogger((Object)this);
        this.registered = new AtomicBoolean();
        this.closed = new AtomicBoolean();
        this.browserFactory = new BrowserFactory();
        this._browsers = new ConcurrentHashMap();
        this.historicalBrowsers = new ConcurrentLinkedDeque();
        this.closedBrowsers = new ConcurrentLinkedDeque();
        this.browsers = this._browsers;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @NotNull
    public final Map<BrowserId, Browser> getBrowsers() {
        return this.browsers;
    }

    @NotNull
    public final Browser launch(@NotNull BrowserId browserId, @NotNull WebDriverSettings driverSettings, @NotNull Map<String, ? extends Object> capabilities) throws BrowserLaunchException {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        Intrinsics.checkNotNullParameter((Object)((Object)driverSettings), (String)"driverSettings");
        Intrinsics.checkNotNullParameter(capabilities, (String)"capabilities");
        this.registerAsClosableIfNecessary();
        LauncherOptions launcherOptions = new LauncherOptions((BrowserSettings)driverSettings, null, null, 6, null);
        if (driverSettings.isSupervised()) {
            launcherOptions.setSupervisorProcess(driverSettings.getSupervisorProcess());
            List list = launcherOptions.getSupervisorProcessArgs();
            Collection collection = driverSettings.getSupervisorProcessArgs();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-supervisorProcessArgs>(...)");
            list.addAll(collection);
        }
        ChromeOptions launchOptions = driverSettings.createChromeOptions(capabilities);
        return this.launchIfAbsent(browserId, launcherOptions, launchOptions);
    }

    @Nullable
    public final synchronized Browser findBrowser(@NotNull BrowserId browserId) {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        return this.browsers.get(browserId);
    }

    public final synchronized void closeBrowser(@NotNull BrowserId browserId) {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        Browser browser = this._browsers.remove(browserId);
        if (browser instanceof AbstractBrowser) {
            Object object;
            try {
                boolean bl = false;
                ((AbstractBrowser)browser).close();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl = false;
                LogsKt.warnForClose((Object)this, (Throwable)it);
            }
            this.closedBrowsers.add(browser);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void destroyBrowserForcibly(@NotNull BrowserId browserId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        Iterable $this$filter$iv = this.historicalBrowsers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Browser it = (Browser)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)browserId, (Object)it.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Browser browser = (Browser)element$iv;
            boolean bl = false;
            try {
                boolean bl2 = false;
                browser.destroyForcibly();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.exceptionOrNull-impl((Object)object) != null) {
                Throwable throwable;
                Throwable it = throwable;
                boolean bl3 = false;
                LogsKt.warnInterruptible((Object)this, (Throwable)it);
            }
            this.closedBrowsers.add(browser);
        }
    }

    public final synchronized void closeBrowser(@NotNull Browser browser) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        this.closeBrowser(browser.getId());
    }

    public final synchronized void closeDriver(@NotNull WebDriver driver2) {
        block2: {
            Throwable throwable;
            Object object;
            Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
            try {
                boolean bl = false;
                driver2.close();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
            if (throwable3 == null) break block2;
            Throwable it = throwable = throwable3;
            boolean bl = false;
            LogsKt.warnForClose((Object)this, (Throwable)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final synchronized WebDriver findLeastValuableDriver() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.browsers.values();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Browser it = (Browser)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getDrivers().values();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List drivers = (List)destination$iv$iv;
        return this.findLeastValuableDriver(drivers);
    }

    public final synchronized void closeLeastValuableDriver() {
        WebDriver driver2 = this.findLeastValuableDriver();
        if (driver2 != null) {
            this.closeDriver(driver2);
        }
    }

    public final synchronized void destroyZombieBrowsersForcibly() {
        List zombieBrowsers = CollectionsKt.minus((Iterable)CollectionsKt.minus((Iterable)this.historicalBrowsers, (Iterable)CollectionsKt.toSet((Iterable)this.browsers.values())), (Iterable)this.closedBrowsers);
        if (!((Collection)zombieBrowsers).isEmpty()) {
            this.logger.warn("There are {} zombie browsers, cleaning them ...", (Object)zombieBrowsers.size());
            Iterable $this$forEach$iv = zombieBrowsers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Throwable throwable;
                Object object;
                Browser browser = (Browser)element$iv;
                boolean bl = false;
                this.logger.info("Closing zombie browser | {}", (Object)browser.getId());
                try {
                    boolean bl2 = false;
                    browser.destroyForcibly();
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                if (Result.exceptionOrNull-impl((Object)object) == null) continue;
                Throwable it = throwable;
                boolean bl3 = false;
                LogsKt.warnInterruptible((Object)this, (Throwable)it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final WebDriver findLeastValuableDriver(Iterable<? extends WebDriver> drivers) {
        Object v0;
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable<? extends WebDriver> $this$filterIsInstance$iv = drivers;
        boolean $i$f$filterIsInstance = false;
        Iterable<? extends WebDriver> iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AbstractWebDriver)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AbstractWebDriver it = (AbstractWebDriver)element$iv$iv;
            boolean bl = false;
            if (!(!it.isReady() && !it.isWorking())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                AbstractWebDriver it = (AbstractWebDriver)minElem$iv;
                boolean bl = false;
                Comparable minValue$iv = it.getLastActiveTime();
                do {
                    Object e$iv = iterator$iv.next();
                    AbstractWebDriver it2 = (AbstractWebDriver)e$iv;
                    $i$a$-minByOrNull-BrowserManager$findLeastValuableDriver$2 = false;
                    Comparable v$iv = it2.getLastActiveTime();
                    if (minValue$iv.compareTo(v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    public final void maintain() {
        Iterable $this$forEach$iv = this.browsers.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Browser it = (Browser)element$iv;
            boolean bl = false;
            if (!(it instanceof AbstractBrowser)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            ((AbstractBrowser)it).emit((Object)BrowserEvents.willMaintain);
            ((AbstractBrowser)it).emit((Object)BrowserEvents.maintain);
            ((AbstractBrowser)it).emit((Object)BrowserEvents.didMaintain);
        }
    }

    @Override
    public synchronized void close() {
        if (this.closed.compareAndSet(false, true)) {
            Collection<Browser> collection = this._browsers.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                String string;
                Browser browser = (Browser)element$iv;
                boolean bl = false;
                if (!(browser instanceof AbstractBrowser)) {
                    string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                try {
                    boolean bl2 = false;
                    browser.close();
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                if (Result.exceptionOrNull-impl((Object)object) == null) continue;
                String it = string;
                boolean bl3 = false;
                LogsKt.warnForClose((Object)this, (Throwable)((Object)it));
            }
            this._browsers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Browser launchIfAbsent(BrowserId browserId, LauncherOptions launcherOptions, ChromeOptions launchOptions) throws BrowserLaunchException {
        Browser browser = this._browsers.get(browserId);
        if (browser != null) {
            return browser;
        }
        BrowserFactory browserFactory = this.browserFactory;
        synchronized (browserFactory) {
            boolean bl = false;
            Browser browser1 = this.browserFactory.launch(browserId, launcherOptions, launchOptions);
            ((Map)this._browsers).put(browserId, browser1);
            this.historicalBrowsers.add(browser1);
            Browser browser2 = browser1;
            return browser2;
        }
    }

    private final void registerAsClosableIfNecessary() {
        if (this.registered.compareAndSet(false, true)) {
            PulsarContexts.registerClosable((AutoCloseable)this, (int)-100);
        }
    }
}

