/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.protocol.browser.driver.BrowserManager;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.AbstractWebDriver;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.WebDriver;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\tJ\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\tJ\u0018\u0010#\u001a\u0004\u0018\u00010\t2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020\u001eR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014\u00a8\u0006)"}, d2={"Lai/platon/pulsar/protocol/browser/driver/ConcurrentStatefulDriverPool;", "", "browserManager", "Lai/platon/pulsar/protocol/browser/driver/BrowserManager;", "capacity", "", "(Lai/platon/pulsar/protocol/browser/driver/BrowserManager;I)V", "_closedDrivers", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lai/platon/pulsar/skeleton/crawl/fetch/driver/WebDriver;", "_retiredDrivers", "_standbyDrivers", "Ljava/util/concurrent/ArrayBlockingQueue;", "_workingDrivers", "activeDriverCount", "getActiveDriverCount", "()I", "closedDrivers", "Ljava/util/Queue;", "getClosedDrivers", "()Ljava/util/Queue;", "logger", "Lorg/slf4j/Logger;", "retiredDrivers", "getRetiredDrivers", "standbyDrivers", "getStandbyDrivers", "workingDrivers", "getWorkingDrivers", "cancelAll", "", "clear", "close", "driver", "offer", "poll", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "retire", "pulsar-protocol"})
@SourceDebugExtension(value={"SMAP\nConcurrentStatefulDriverPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcurrentStatefulDriverPool.kt\nai/platon/pulsar/protocol/browser/driver/ConcurrentStatefulDriverPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1#2:127\n1855#3,2:128\n1855#3,2:130\n*S KotlinDebug\n*F\n+ 1 ConcurrentStatefulDriverPool.kt\nai/platon/pulsar/protocol/browser/driver/ConcurrentStatefulDriverPool\n*L\n102#1:128,2\n115#1:130,2\n*E\n"})
public final class ConcurrentStatefulDriverPool {
    @NotNull
    private final BrowserManager browserManager;
    private final int capacity;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ArrayBlockingQueue<WebDriver> _standbyDrivers;
    @NotNull
    private final ConcurrentLinkedQueue<WebDriver> _workingDrivers;
    @NotNull
    private final ConcurrentLinkedQueue<WebDriver> _retiredDrivers;
    @NotNull
    private final ConcurrentLinkedQueue<WebDriver> _closedDrivers;

    public ConcurrentStatefulDriverPool(@NotNull BrowserManager browserManager, int capacity) {
        Intrinsics.checkNotNullParameter((Object)browserManager, (String)"browserManager");
        this.browserManager = browserManager;
        this.capacity = capacity;
        this.logger = LogsKt.getLogger((Object)this);
        this._standbyDrivers = new ArrayBlockingQueue(2 * this.capacity);
        this._workingDrivers = new ConcurrentLinkedQueue();
        this._retiredDrivers = new ConcurrentLinkedQueue();
        this._closedDrivers = new ConcurrentLinkedQueue();
    }

    @NotNull
    public final Queue<WebDriver> getStandbyDrivers() {
        return this._standbyDrivers;
    }

    @NotNull
    public final Queue<WebDriver> getWorkingDrivers() {
        return this._workingDrivers;
    }

    @NotNull
    public final Queue<WebDriver> getRetiredDrivers() {
        return this._retiredDrivers;
    }

    @NotNull
    public final Queue<WebDriver> getClosedDrivers() {
        return this._closedDrivers;
    }

    public final synchronized int getActiveDriverCount() {
        return this.getWorkingDrivers().size() + this.getStandbyDrivers().size();
    }

    @Nullable
    public final synchronized WebDriver poll(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        WebDriver driver2 = this._standbyDrivers.poll(timeout, unit);
        if (driver2 instanceof AbstractWebDriver) {
            ((AbstractWebDriver)driver2).startWork();
            this._workingDrivers.add(driver2);
        }
        return driver2;
    }

    public final synchronized void offer(@NotNull WebDriver driver2) {
        Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
        if (!(driver2 instanceof AbstractWebDriver)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!((AbstractWebDriver)driver2).isRecyclable()) {
            return;
        }
        ((AbstractWebDriver)driver2).free();
        this._workingDrivers.remove(driver2);
        this._standbyDrivers.offer(driver2);
    }

    public final synchronized void close(@NotNull WebDriver driver2) {
        block3: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
            if (!(driver2 instanceof AbstractWebDriver)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            ((AbstractWebDriver)driver2).retire();
            this._standbyDrivers.remove(driver2);
            this._workingDrivers.remove(driver2);
            this._retiredDrivers.remove(driver2);
            this._closedDrivers.add(driver2);
            Object object2 = this;
            try {
                ConcurrentStatefulDriverPool $this$close_u24lambda_u240 = object2;
                boolean bl = false;
                $this$close_u24lambda_u240.browserManager.closeDriver(driver2);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block3;
            Object it = object = throwable;
            boolean bl = false;
            LogsKt.warnInterruptible((Object)this, (Throwable)it);
        }
    }

    public final synchronized void retire() {
        List drivers = CollectionsKt.plus((Collection)this._standbyDrivers, (Iterable)this._workingDrivers);
        this._standbyDrivers.clear();
        this._workingDrivers.clear();
        this._retiredDrivers.addAll(drivers);
        Iterable $this$forEach$iv = drivers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            String string;
            WebDriver driver2 = (WebDriver)element$iv;
            boolean bl = false;
            if (!(driver2 instanceof AbstractWebDriver)) {
                string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            ((AbstractWebDriver)driver2).cancel();
            ((AbstractWebDriver)driver2).retire();
            try {
                boolean bl2 = false;
                BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(driver2, null){
                    int label;
                    final /* synthetic */ WebDriver $driver;
                    {
                        this.$driver = $driver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.$driver.stop((Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.exceptionOrNull-impl((Object)object) == null) continue;
            String it = string;
            boolean bl3 = false;
            LogsKt.warnInterruptible((Object)this, (Throwable)((Object)it));
        }
    }

    public final synchronized void cancelAll() {
        Iterable $this$forEach$iv = this._workingDrivers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebDriver it = (WebDriver)element$iv;
            boolean bl = false;
            AbstractWebDriver abstractWebDriver = it instanceof AbstractWebDriver ? (AbstractWebDriver)it : null;
            if (abstractWebDriver == null) continue;
            abstractWebDriver.cancel();
        }
    }

    public final synchronized void clear() {
        this.getStandbyDrivers().clear();
        this.getWorkingDrivers().clear();
        this.getRetiredDrivers().clear();
        this.getClosedDrivers().clear();
    }
}

