/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.protocol.browser.driver.LoadingWebDriverPool;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.skeleton.crawl.fetch.privacy.BrowserId;
import com.google.common.annotations.Beta;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bJ\"\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00052\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u0005J\u0016\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020!J\u000e\u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bJ\u0010\u0010#\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u0005J\n\u0010$\u001a\u0004\u0018\u00010%H\u0007J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001a\u001a\u00020\u0005H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006&"}, d2={"Lai/platon/pulsar/protocol/browser/driver/ConcurrentStatefulDriverPoolPool;", "", "()V", "_closedDriverPools", "Ljava/util/concurrent/ConcurrentSkipListSet;", "Lai/platon/pulsar/skeleton/crawl/fetch/privacy/BrowserId;", "_retiredDriverPools", "Ljava/util/concurrent/ConcurrentSkipListMap;", "Lai/platon/pulsar/protocol/browser/driver/LoadingWebDriverPool;", "_workingDriverPools", "closedDriverPools", "", "getClosedDriverPools", "()Ljava/util/Set;", "logger", "Lorg/slf4j/Logger;", "retiredDriverPools", "", "getRetiredDriverPools", "()Ljava/util/Map;", "workingDriverPools", "getWorkingDriverPools", "close", "", "driverPool", "computeIfAbsent", "browserId", "mappingFunction", "Lkotlin/Function1;", "isFullCapacity", "", "isRetiredPool", "promisedDriverCount", "", "capacity", "retire", "subscribeDriver", "Lai/platon/pulsar/skeleton/crawl/fetch/driver/WebDriver;", "pulsar-protocol"})
@SourceDebugExtension(value={"SMAP\nConcurrentStatefulDriverPoolPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcurrentStatefulDriverPoolPool.kt\nai/platon/pulsar/protocol/browser/driver/ConcurrentStatefulDriverPoolPool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n288#2,2:142\n1855#2,2:145\n1#3:144\n*S KotlinDebug\n*F\n+ 1 ConcurrentStatefulDriverPoolPool.kt\nai/platon/pulsar/protocol/browser/driver/ConcurrentStatefulDriverPoolPool\n*L\n91#1:142,2\n138#1:145,2\n*E\n"})
public final class ConcurrentStatefulDriverPoolPool {
    @NotNull
    private final Logger logger = LogsKt.getLogger((Object)this);
    @NotNull
    private final ConcurrentSkipListMap<BrowserId, LoadingWebDriverPool> _workingDriverPools = new ConcurrentSkipListMap();
    @NotNull
    private final ConcurrentSkipListMap<BrowserId, LoadingWebDriverPool> _retiredDriverPools = new ConcurrentSkipListMap();
    @NotNull
    private final ConcurrentSkipListSet<BrowserId> _closedDriverPools = new ConcurrentSkipListSet();

    @NotNull
    public final Map<BrowserId, LoadingWebDriverPool> getWorkingDriverPools() {
        return this._workingDriverPools;
    }

    @NotNull
    public final Map<BrowserId, LoadingWebDriverPool> getRetiredDriverPools() {
        return this._retiredDriverPools;
    }

    @NotNull
    public final Set<BrowserId> getClosedDriverPools() {
        return this._closedDriverPools;
    }

    public final synchronized int promisedDriverCount(@NotNull BrowserId browserId, int capacity) {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        if (this.getClosedDriverPools().contains(browserId) || this.getRetiredDriverPools().containsKey(browserId)) {
            return 0;
        }
        LoadingWebDriverPool loadingWebDriverPool = this._workingDriverPools.get(browserId);
        if (loadingWebDriverPool == null) {
            return capacity;
        }
        LoadingWebDriverPool pool = loadingWebDriverPool;
        return pool.getNumAvailable();
    }

    public final synchronized boolean isFullCapacity(@NotNull BrowserId browserId) {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        if (this.getClosedDriverPools().contains(browserId) || this.getRetiredDriverPools().containsKey(browserId)) {
            return false;
        }
        LoadingWebDriverPool loadingWebDriverPool = this._workingDriverPools.get(browserId);
        if (loadingWebDriverPool == null) {
            return false;
        }
        LoadingWebDriverPool pool = loadingWebDriverPool;
        return pool.getNumWorking() + pool.getNumWaiting() >= pool.getCapacity();
    }

    public final synchronized boolean isRetiredPool(@NotNull BrowserId browserId) {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        return this.getRetiredDriverPools().containsKey(browserId);
    }

    @Beta
    @Nullable
    public final synchronized WebDriver subscribeDriver(@NotNull BrowserId browserId) {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        if (this.getClosedDriverPools().contains(browserId) || this.getRetiredDriverPools().containsKey(browserId)) {
            return null;
        }
        LoadingWebDriverPool loadingWebDriverPool = this._workingDriverPools.get(browserId);
        if (loadingWebDriverPool == null) {
            return null;
        }
        LoadingWebDriverPool pool = loadingWebDriverPool;
        WebDriver driver2 = pool.poll();
        return driver2;
    }

    @Beta
    @Nullable
    public final synchronized WebDriver subscribeDriver() {
        Object v1;
        block2: {
            Collection<LoadingWebDriverPool> collection = this._workingDriverPools.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LoadingWebDriverPool it = (LoadingWebDriverPool)element$iv;
                boolean bl = false;
                if (!(it.getNumAvailable() > 0)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        LoadingWebDriverPool loadingWebDriverPool = v1;
        if (loadingWebDriverPool == null) {
            return null;
        }
        LoadingWebDriverPool driverPool2 = loadingWebDriverPool;
        WebDriver driver2 = driverPool2.poll();
        return driver2;
    }

    @NotNull
    public final synchronized LoadingWebDriverPool computeIfAbsent(@NotNull BrowserId browserId, @NotNull Function1<? super BrowserId, LoadingWebDriverPool> mappingFunction) {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        Intrinsics.checkNotNullParameter(mappingFunction, (String)"mappingFunction");
        LoadingWebDriverPool loadingWebDriverPool = this._workingDriverPools.computeIfAbsent(browserId, arg_0 -> ConcurrentStatefulDriverPoolPool.computeIfAbsent$lambda$1(mappingFunction, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)loadingWebDriverPool, (String)"computeIfAbsent(...)");
        return loadingWebDriverPool;
    }

    public final synchronized void retire(@NotNull LoadingWebDriverPool driverPool2) {
        Intrinsics.checkNotNullParameter((Object)driverPool2, (String)"driverPool");
        BrowserId browserId = driverPool2.getBrowserId();
        this._workingDriverPools.remove(browserId);
        if (this._closedDriverPools.contains(browserId)) {
            this.logger.warn("Inconsistent driver pool state: retire pool who is already closed | {}", (Object)browserId);
        }
        driverPool2.retire();
        ((Map)this._retiredDriverPools).put(browserId, driverPool2);
    }

    @Nullable
    public final synchronized LoadingWebDriverPool retire(@NotNull BrowserId browserId) {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        LoadingWebDriverPool retiredDriverPool = this._workingDriverPools.remove(browserId);
        if (retiredDriverPool != null) {
            this.retire(retiredDriverPool);
        }
        return retiredDriverPool;
    }

    public final synchronized void close(@NotNull LoadingWebDriverPool driverPool2) {
        block2: {
            Throwable throwable;
            Object object;
            Intrinsics.checkNotNullParameter((Object)driverPool2, (String)"driverPool");
            BrowserId browserId = driverPool2.getBrowserId();
            this._workingDriverPools.remove(browserId);
            this._retiredDriverPools.remove(browserId);
            this._closedDriverPools.add(browserId);
            try {
                boolean bl = false;
                driverPool2.close();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
            if (throwable3 == null) break block2;
            Throwable it = throwable = throwable3;
            boolean bl = false;
            LogsKt.warnForClose((Object)this, (Throwable)it);
        }
    }

    public final synchronized void close() {
        List pools = CollectionsKt.plus(this.getWorkingDriverPools().values(), (Iterable)this.getRetiredDriverPools().values());
        Iterable $this$forEach$iv = pools;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LoadingWebDriverPool it = (LoadingWebDriverPool)element$iv;
            boolean bl = false;
            this.close(it);
        }
    }

    private static final LoadingWebDriverPool computeIfAbsent$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LoadingWebDriverPool)$tmp0.invoke(p0);
    }
}

