/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.IllegalApplicationStateException;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.protocol.browser.driver.ConcurrentStatefulDriverPool;
import ai.platon.pulsar.protocol.browser.driver.LoadingWebDriverPool;
import ai.platon.pulsar.protocol.browser.driver.WebDriverFactory;
import ai.platon.pulsar.protocol.browser.driver.WebDriverPoolManager;
import ai.platon.pulsar.protocol.browser.driver.WebDriverSettings;
import ai.platon.pulsar.protocol.browser.emulator.WebDriverPoolExhaustedException;
import ai.platon.pulsar.skeleton.common.AppSystemInfo;
import ai.platon.pulsar.skeleton.common.metrics.AppMetricRegistry;
import ai.platon.pulsar.skeleton.common.metrics.MetricsSystem;
import ai.platon.pulsar.skeleton.crawl.BrowseEventHandlers;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.AbstractWebDriver;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.Browser;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.BrowserLaunchException;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.IllegalWebDriverStateException;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.WebDriverCancellationException;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.WebDriverException;
import ai.platon.pulsar.skeleton.crawl.fetch.privacy.BrowserId;
import com.codahale.metrics.Meter;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u0085\u00012\u00020\u0001:\u0004\u0085\u0001\u0086\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\J\u0010\u0010]\u001a\u0004\u0018\u00010\u00142\u0006\u0010^\u001a\u00020_J\u0006\u0010`\u001a\u00020ZJ\b\u0010a\u001a\u00020ZH\u0016J\u0018\u0010b\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010[\u001a\u00020\\H\u0002J\u0010\u0010c\u001a\u00020\u00142\u0006\u0010[\u001a\u00020\\H\u0002J4\u0010d\u001a\u00020Z2\u0006\u0010e\u001a\u00020_2\u001c\u0010f\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020Z0h\u0012\u0006\u0012\u0004\u0018\u00010i0gH\u0082@\u00a2\u0006\u0002\u0010jJ\u001c\u0010k\u001a\u0004\u0018\u00010\u00142\u0012\u0010l\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020.0gJ\u001a\u0010m\u001a\u00020Z2\u0012\u0010f\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020Z0gJ\u0010\u0010n\u001a\u00020Z2\u0006\u0010o\u001a\u00020\u0014H\u0002J\u0010\u0010p\u001a\u00020Z2\u0006\u0010o\u001a\u00020\u0014H\u0002J\u0006\u0010q\u001a\u00020\u0014J\u000e\u0010q\u001a\u00020\u00142\u0006\u0010[\u001a\u00020\\J\u001e\u0010q\u001a\u00020\u00142\u0006\u0010[\u001a\u00020\\2\u0006\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020uJ0\u0010q\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010[\u001a\u00020\\2\b\u0010v\u001a\u0004\u0018\u00010w2\u0006\u0010x\u001a\u00020yH\u0086@\u00a2\u0006\u0002\u0010zJ\u001e\u0010q\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010[\u001a\u00020\\2\u0006\u0010r\u001a\u00020%J&\u0010q\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010[\u001a\u00020\\2\u0006\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020uJ*\u0010{\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010[\u001a\u00020\\2\u0006\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020uH\u0002J8\u0010|\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010[\u001a\u00020\\2\b\u0010v\u001a\u0004\u0018\u00010w2\u0006\u0010x\u001a\u00020y2\u0006\u0010r\u001a\u00020%H\u0082@\u00a2\u0006\u0002\u0010}J\u000e\u0010~\u001a\u00020Z2\u0006\u0010o\u001a\u00020\u0014J\u0018\u0010\u007f\u001a\u00020Z2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010[\u001a\u00020\\H\u0002J\u0007\u0010\u0080\u0001\u001a\u00020ZJ\t\u0010\u0081\u0001\u001a\u00020.H\u0002J\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001J\t\u0010\u0084\u0001\u001a\u00020_H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001bR\u0019\u0010$\u001a\n &*\u0004\u0018\u00010%0%8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0019\u0010)\u001a\n &*\u0004\u0018\u00010%0%8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010/R\u0011\u00100\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010/R\u0011\u00101\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010/R\u0011\u00102\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010/R\u000e\u00103\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00106\u001a\u0002052\u0006\u00104\u001a\u000205@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u000e\u00109\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010:\u001a\n &*\u0004\u0018\u00010;0;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010<\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0011\u0010@\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010?R\u0011\u0010B\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u001bR\u0011\u0010D\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bE\u0010\u001bR\u0011\u0010F\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bG\u0010\u001bR\u0011\u0010H\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bI\u0010\u001bR\u0011\u0010J\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bK\u0010\u001bR\u0011\u0010L\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bM\u0010\u001bR\u0011\u0010N\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bO\u0010\u001bR\u0011\u0010P\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010\u001bR\u0011\u0010R\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bS\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010\u001bR\u000e\u0010U\u001a\u00020VX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010W\u001a\u00020XX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0087\u0001"}, d2={"Lai/platon/pulsar/protocol/browser/driver/LoadingWebDriverPool;", "Ljava/lang/AutoCloseable;", "browserId", "Lai/platon/pulsar/skeleton/crawl/fetch/privacy/BrowserId;", "priority", "", "driverPoolManager", "Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;", "driverFactory", "Lai/platon/pulsar/protocol/browser/driver/WebDriverFactory;", "immutableConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/skeleton/crawl/fetch/privacy/BrowserId;ILai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;Lai/platon/pulsar/protocol/browser/driver/WebDriverFactory;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "_browser", "Lai/platon/pulsar/skeleton/crawl/fetch/driver/Browser;", "_numCreatedDrivers", "Ljava/util/concurrent/atomic/AtomicInteger;", "_numWaitingTasks", "activeDrivers", "", "Lai/platon/pulsar/skeleton/crawl/fetch/driver/WebDriver;", "getActiveDrivers", "()Ljava/util/Collection;", "getBrowserId", "()Lai/platon/pulsar/skeleton/crawl/fetch/privacy/BrowserId;", "capacity", "getCapacity", "()I", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getDriverFactory", "()Lai/platon/pulsar/protocol/browser/driver/WebDriverFactory;", "getDriverPoolManager", "()Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;", "id", "getId", "idleTime", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getIdleTime", "()Ljava/time/Duration;", "idleTimeout", "getIdleTimeout", "getImmutableConfig", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "isActive", "", "()Z", "isClosed", "isIdle", "isPermanent", "isRetired", "<set-?>", "Ljava/time/Instant;", "lastActiveTime", "getLastActiveTime", "()Ljava/time/Instant;", "launchEventsEmitted", "logger", "Lorg/slf4j/Logger;", "meterClosed", "Lcom/codahale/metrics/Meter;", "getMeterClosed", "()Lcom/codahale/metrics/Meter;", "meterOffer", "getMeterOffer", "numActive", "getNumActive", "numAvailable", "getNumAvailable", "numClosed", "getNumClosed", "numCreated", "getNumCreated", "numDriverSlots", "getNumDriverSlots", "numRetired", "getNumRetired", "numStandby", "getNumStandby", "numWaiting", "getNumWaiting", "numWorking", "getNumWorking", "getPriority", "registry", "Lai/platon/pulsar/skeleton/common/metrics/AppMetricRegistry;", "statefulDriverPool", "Lai/platon/pulsar/protocol/browser/driver/ConcurrentStatefulDriverPool;", "allocate", "", "conf", "Lai/platon/pulsar/common/config/VolatileConfig;", "cancel", "url", "", "cancelAll", "close", "computeBrowserAndDriver", "computeBrowserAndDriver0", "dispatchEvent", "name", "action", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "firstOrNull", "predicate", "forEach", "logDriverOnline", "driver", "offerOrDismiss", "poll", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "event", "Lai/platon/pulsar/skeleton/crawl/BrowseEventHandlers;", "page", "Lai/platon/pulsar/persist/WebPage;", "(ILai/platon/pulsar/common/config/VolatileConfig;Lai/platon/pulsar/skeleton/crawl/BrowseEventHandlers;Lai/platon/pulsar/persist/WebPage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pollWebDriver", "pollWithEvents", "(ILai/platon/pulsar/common/config/VolatileConfig;Lai/platon/pulsar/skeleton/crawl/BrowseEventHandlers;Lai/platon/pulsar/persist/WebPage;Ljava/time/Duration;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "put", "resourceSafeCreateDriverIfNecessary", "retire", "shouldCreateWebDriver", "takeSnapshot", "Lai/platon/pulsar/protocol/browser/driver/LoadingWebDriverPool$Snapshot;", "toString", "Companion", "Snapshot", "pulsar-protocol"})
@SourceDebugExtension(value={"SMAP\nLoadingWebDriverPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoadingWebDriverPool.kt\nai/platon/pulsar/protocol/browser/driver/LoadingWebDriverPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,466:1\n1#2:467\n1855#3,2:468\n288#3,2:470\n518#3,7:472\n800#3,11:479\n1774#3,4:490\n*S KotlinDebug\n*F\n+ 1 LoadingWebDriverPool.kt\nai/platon/pulsar/protocol/browser/driver/LoadingWebDriverPool\n*L\n283#1:468,2\n285#1:470,2\n288#1:472,7\n392#1:479,11\n393#1:490,4\n*E\n"})
public final class LoadingWebDriverPool
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BrowserId browserId;
    private final int priority;
    @NotNull
    private final WebDriverPoolManager driverPoolManager;
    @NotNull
    private final WebDriverFactory driverFactory;
    @NotNull
    private final ImmutableConfig immutableConfig;
    private final Logger logger;
    private final int id;
    @NotNull
    private final AppMetricRegistry registry;
    @Nullable
    private Browser _browser;
    @NotNull
    private final ConcurrentStatefulDriverPool statefulDriverPool;
    @NotNull
    private final Meter meterClosed;
    @NotNull
    private final Meter meterOffer;
    private boolean isRetired;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final AtomicBoolean launchEventsEmitted;
    @NotNull
    private final AtomicInteger _numCreatedDrivers;
    @NotNull
    private final AtomicInteger _numWaitingTasks;
    @NotNull
    private Instant lastActiveTime;
    private static Duration CLOSE_ALL_TIMEOUT = Duration.ofSeconds(60L);
    private static Duration POLLING_TIMEOUT = Duration.ofSeconds(60L);
    @NotNull
    private static final AtomicInteger instanceSequencer = new AtomicInteger();

    public LoadingWebDriverPool(@NotNull BrowserId browserId, int priority, @NotNull WebDriverPoolManager driverPoolManager, @NotNull WebDriverFactory driverFactory, @NotNull ImmutableConfig immutableConfig) {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        Intrinsics.checkNotNullParameter((Object)driverPoolManager, (String)"driverPoolManager");
        Intrinsics.checkNotNullParameter((Object)driverFactory, (String)"driverFactory");
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"immutableConfig");
        this.browserId = browserId;
        this.priority = priority;
        this.driverPoolManager = driverPoolManager;
        this.driverFactory = driverFactory;
        this.immutableConfig = immutableConfig;
        this.logger = LoggerFactory.getLogger(LoadingWebDriverPool.class);
        this.id = instanceSequencer.incrementAndGet();
        this.registry = MetricsSystem.Companion.getDefaultMetricRegistry();
        this.statefulDriverPool = new ConcurrentStatefulDriverPool(this.driverPoolManager.getBrowserManager(), this.getCapacity());
        this.meterClosed = this.registry.meter((Object)this, "closed");
        this.meterOffer = this.registry.meter((Object)this, "offer");
        this.closed = new AtomicBoolean();
        this.launchEventsEmitted = new AtomicBoolean();
        this._numCreatedDrivers = new AtomicInteger();
        this._numWaitingTasks = new AtomicInteger();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.lastActiveTime = instant;
    }

    public /* synthetic */ LoadingWebDriverPool(BrowserId browserId, int n, WebDriverPoolManager webDriverPoolManager, WebDriverFactory webDriverFactory, ImmutableConfig immutableConfig, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(browserId, n, webDriverPoolManager, webDriverFactory, immutableConfig);
    }

    @NotNull
    public final BrowserId getBrowserId() {
        return this.browserId;
    }

    public final int getPriority() {
        return this.priority;
    }

    @NotNull
    public final WebDriverPoolManager getDriverPoolManager() {
        return this.driverPoolManager;
    }

    @NotNull
    public final WebDriverFactory getDriverFactory() {
        return this.driverFactory;
    }

    @NotNull
    public final ImmutableConfig getImmutableConfig() {
        return this.immutableConfig;
    }

    public final int getId() {
        return this.id;
    }

    public final int getCapacity() {
        return this.immutableConfig.getInt("browser.max.active.tabs", 8);
    }

    private final Collection<WebDriver> getActiveDrivers() {
        return CollectionsKt.plus((Collection)this.statefulDriverPool.getStandbyDrivers(), (Iterable)this.statefulDriverPool.getWorkingDrivers());
    }

    @NotNull
    public final Meter getMeterClosed() {
        return this.meterClosed;
    }

    @NotNull
    public final Meter getMeterOffer() {
        return this.meterOffer;
    }

    public final boolean isClosed() {
        return this.closed.get();
    }

    public final boolean isActive() {
        return !this.isClosed() && !this.isRetired && AppContext.INSTANCE.isActive();
    }

    public final int getNumCreated() {
        return this._numCreatedDrivers.get();
    }

    public final int getNumWaiting() {
        return this._numWaitingTasks.get();
    }

    public final int getNumStandby() {
        return this.statefulDriverPool.getStandbyDrivers().size();
    }

    public final int getNumAvailable() {
        return this.getNumStandby() + this.getNumDriverSlots();
    }

    public final int getNumWorking() {
        return this.statefulDriverPool.getWorkingDrivers().size();
    }

    public final int getNumRetired() {
        return this.statefulDriverPool.getRetiredDrivers().size();
    }

    public final int getNumClosed() {
        return this.statefulDriverPool.getClosedDrivers().size();
    }

    public final int getNumActive() {
        return this.getNumWorking() + this.getNumStandby();
    }

    public final int getNumDriverSlots() {
        return this.getCapacity() - this.getNumActive();
    }

    @NotNull
    public final Instant getLastActiveTime() {
        return this.lastActiveTime;
    }

    public final Duration getIdleTimeout() {
        Duration duration = Duration.ofMinutes(20L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        return this.immutableConfig.getDuration("browser.driver.pool.idle.timeout", duration);
    }

    public final Duration getIdleTime() {
        return Duration.between(this.lastActiveTime, Instant.now());
    }

    public final boolean isIdle() {
        return this.getNumWorking() == 0 && this.getIdleTime().compareTo(this.getIdleTimeout()) > 0;
    }

    public final boolean isPermanent() {
        return this.browserId.getPrivacyAgent().isPermanent();
    }

    public final void allocate(@NotNull VolatileConfig conf) throws BrowserLaunchException, WebDriverPoolExhaustedException, InterruptedException {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        int n = this.getCapacity();
        for (int i = 0; i < n; ++i) {
            Object object;
            int it = i;
            boolean bl = false;
            Object object2 = this;
            try {
                LoadingWebDriverPool $this$allocate_u24lambda_u242_u24lambda_u240 = object2;
                boolean bl2 = false;
                $this$allocate_u24lambda_u242_u24lambda_u240.put($this$allocate_u24lambda_u242_u24lambda_u240.poll($this$allocate_u24lambda_u242_u24lambda_u240.priority, conf, POLLING_TIMEOUT.getSeconds(), TimeUnit.SECONDS));
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) continue;
            Object it2 = object = throwable;
            boolean bl3 = false;
            LogsKt.warnInterruptible((Object)this, (Throwable)it2);
        }
    }

    @NotNull
    public final WebDriver poll() throws BrowserLaunchException, WebDriverPoolExhaustedException, InterruptedException {
        return this.poll(VolatileConfig.Companion.getUNSAFE());
    }

    @NotNull
    public final WebDriver poll(@NotNull VolatileConfig conf) throws BrowserLaunchException, WebDriverPoolExhaustedException, InterruptedException {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        return this.poll(0, conf, POLLING_TIMEOUT.getSeconds(), TimeUnit.SECONDS);
    }

    @NotNull
    public final WebDriver poll(@NotNull VolatileConfig conf, long timeout, @NotNull TimeUnit unit) throws BrowserLaunchException, WebDriverPoolExhaustedException, InterruptedException {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.poll(0, conf, timeout, unit);
    }

    @NotNull
    public final WebDriver poll(int priority, @NotNull VolatileConfig conf, @NotNull Duration timeout) throws BrowserLaunchException, WebDriverPoolExhaustedException, InterruptedException {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        return this.poll(priority, conf, timeout.getSeconds(), TimeUnit.SECONDS);
    }

    @NotNull
    public final WebDriver poll(int priority, @NotNull VolatileConfig conf, long timeout, @NotNull TimeUnit unit) throws BrowserLaunchException, WebDriverPoolExhaustedException, InterruptedException {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        WebDriver driver2 = this.pollWebDriver(priority, conf, timeout, unit);
        if (driver2 == null) {
            Snapshot snapshot = this.takeSnapshot();
            String string = "Driver pool is exhausted | %s";
            Object[] objectArray = new Object[]{snapshot.format(true)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String message = string2;
            this.logger.warn(message);
            throw new WebDriverPoolExhaustedException("Driver pool is exhausted (" + snapshot + ")");
        }
        return driver2;
    }

    @Nullable
    public final Object poll(int priority, @NotNull VolatileConfig conf, @Nullable BrowseEventHandlers event, @NotNull WebPage page, @NotNull Continuation<? super WebDriver> $completion) throws BrowserLaunchException, WebDriverPoolExhaustedException {
        Duration timeout = this.driverFactory.getDriverSettings().getPollingDriverTimeout();
        boolean notEmitted = this.launchEventsEmitted.compareAndSet(false, true);
        if (notEmitted) {
            Intrinsics.checkNotNull((Object)timeout);
            return this.pollWithEvents(priority, conf, event, page, timeout, $completion);
        }
        Intrinsics.checkNotNull((Object)timeout);
        return this.poll(priority, conf, timeout);
    }

    public final void put(@NotNull WebDriver driver2) {
        Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.lastActiveTime = instant;
        this.offerOrDismiss(driver2);
    }

    private final void offerOrDismiss(WebDriver driver2) {
        if (!(driver2 instanceof AbstractWebDriver)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (((AbstractWebDriver)driver2).isWorking()) {
            this.statefulDriverPool.offer(driver2);
            this.meterOffer.mark();
        } else {
            if (this.isActive()) {
                this.logger.warn("The driver is not working unexpectedly, mark it as retired and close it");
            }
            this.statefulDriverPool.close(driver2);
            this.meterClosed.mark();
        }
    }

    public final void retire() {
        this.isRetired = true;
        this.statefulDriverPool.retire();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.statefulDriverPool.clear();
        }
    }

    public final void forEach(@NotNull Function1<? super WebDriver, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Iterable $this$forEach$iv = this.getActiveDrivers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            action.invoke(element$iv);
        }
    }

    @Nullable
    public final WebDriver firstOrNull(@NotNull Function1<? super WebDriver, Boolean> predicate) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Iterable $this$firstOrNull$iv = this.getActiveDrivers();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                if (!((Boolean)predicate.invoke(element$iv)).booleanValue()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final WebDriver cancel(@NotNull String url) {
        WebDriver webDriver;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Iterable $this$lastOrNull$iv = this.getActiveDrivers();
        boolean $i$f$lastOrNull = false;
        Object last$iv = null;
        for (Object element$iv : $this$lastOrNull$iv) {
            WebDriver it = (WebDriver)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getNavigateEntry().getPageUrl(), (Object)url)) continue;
            last$iv = element$iv;
        }
        WebDriver webDriver2 = last$iv;
        if (webDriver2 != null) {
            WebDriver webDriver3;
            WebDriver it = webDriver3 = webDriver2;
            boolean bl = false;
            if (!(it instanceof AbstractWebDriver)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            ((AbstractWebDriver)it).cancel();
            webDriver = webDriver3;
        } else {
            webDriver = null;
        }
        return webDriver;
    }

    public final void cancelAll() {
        this.statefulDriverPool.cancelAll();
    }

    @NotNull
    public String toString() {
        return this.takeSnapshot().format(false);
    }

    @NotNull
    public final Snapshot takeSnapshot() {
        int n = this.getNumActive();
        int n2 = this.getNumStandby();
        int n3 = this.getNumWaiting();
        int n4 = this.getNumWorking();
        int n5 = this.getNumDriverSlots();
        int n6 = this.getNumRetired();
        int n7 = this.getNumClosed();
        boolean bl = this.isIdle();
        Duration duration = this.getIdleTime();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"<get-idleTime>(...)");
        return new Snapshot(n, n2, n3, n4, n5, n6, n7, this.isRetired, bl, duration, false, 1024, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object pollWithEvents(int var1_1, VolatileConfig var2_2, BrowseEventHandlers var3_3, WebPage var4_4, Duration var5_5, Continuation<? super WebDriver> var6_6) throws BrowserLaunchException, WebDriverPoolExhaustedException {
        if (!(var6_6 instanceof pollWithEvents.1)) ** GOTO lbl-1000
        var11_7 = var6_6;
        if ((var11_7.label & -2147483648) != 0) {
            var11_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var6_6){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ LoadingWebDriverPool this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LoadingWebDriverPool.access$pollWithEvents(this.this$0, 0, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = conf;
                $continuation.L$2 = event;
                $continuation.L$3 = page;
                $continuation.L$4 = timeout;
                $continuation.I$0 = priority;
                $continuation.label = 1;
                v0 = this.dispatchEvent("onWillLaunchBrowser", (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(event, page, null){
                    int label;
                    final /* synthetic */ BrowseEventHandlers $event;
                    final /* synthetic */ WebPage $page;
                    {
                        this.$event = $event;
                        this.$page = $page;
                        super(1, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                BrowseEventHandlers browseEventHandlers = this.$event;
                                if (browseEventHandlers != null && (browseEventHandlers = browseEventHandlers.getOnWillLaunchBrowser()) != null) {
                                    browseEventHandlers.invoke((Object)this.$page);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super Unit>)$continuation);
                if (v0 == var12_9) {
                    return var12_9;
                }
                ** GOTO lbl32
            }
            case 1: {
                priority = $continuation.I$0;
                timeout = (Duration)$continuation.L$4;
                page = (WebPage)$continuation.L$3;
                event = (BrowseEventHandlers)$continuation.L$2;
                conf = (VolatileConfig)$continuation.L$1;
                this = (LoadingWebDriverPool)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                driver = var7_10 = this.poll(priority, conf, timeout);
                $i$a$-also-LoadingWebDriverPool$pollWithEvents$3 = false;
                $continuation.L$0 = var7_10;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.label = 2;
                v1 = this.dispatchEvent("onBrowserLaunched", (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(event, page, driver, null){
                    int label;
                    final /* synthetic */ BrowseEventHandlers $event;
                    final /* synthetic */ WebPage $page;
                    final /* synthetic */ WebDriver $driver;
                    {
                        this.$event = $event;
                        this.$page = $page;
                        this.$driver = $driver;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        block5: {
                            Object object2;
                            Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    BrowseEventHandlers browseEventHandlers = this.$event;
                                    if (browseEventHandlers == null || (browseEventHandlers = browseEventHandlers.getOnBrowserLaunched()) == null) break;
                                    this.label = 1;
                                    object2 = browseEventHandlers.invoke((Object)this.$page, (Object)this.$driver, (Continuation)this);
                                    if (object2 == object3) {
                                        return object3;
                                    }
                                    break block5;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    object2 = $result;
                                    break block5;
                                }
                            }
                            object2 = null;
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super Unit>)$continuation);
                if (v1 == var12_9) {
                    return var12_9;
                }
                ** GOTO lbl49
            }
            case 2: {
                $i$a$-also-LoadingWebDriverPool$pollWithEvents$3 = false;
                var7_10 = (WebDriver)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl49:
                // 2 sources

                return var7_10;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final WebDriver pollWebDriver(int priority, VolatileConfig conf, long timeout, TimeUnit unit) throws BrowserLaunchException, InterruptedException {
        WebDriver webDriver;
        this._numWaitingTasks.incrementAndGet();
        try {
            this.resourceSafeCreateDriverIfNecessary(priority, conf);
            webDriver = this.statefulDriverPool.poll(timeout, unit);
        }
        finally {
            this._numWaitingTasks.decrementAndGet();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            this.lastActiveTime = instant;
        }
        WebDriver driver2 = webDriver;
        return driver2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resourceSafeCreateDriverIfNecessary(int priority, VolatileConfig conf) throws BrowserLaunchException {
        WebDriverFactory webDriverFactory = this.driverFactory;
        synchronized (webDriverFactory) {
            boolean bl = false;
            if (!this.isActive()) {
                return;
            }
            if (!this.shouldCreateWebDriver()) {
                return;
            }
            WebDriver driver2 = this.computeBrowserAndDriver(priority, conf);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final WebDriver computeBrowserAndDriver(int priority, VolatileConfig conf) throws BrowserLaunchException {
        try {
            return this.computeBrowserAndDriver0(conf);
        }
        catch (IllegalWebDriverStateException e) {
            this.logger.debug("[Unexpected]", (Throwable)e);
            if (this.isActive()) {
                throw new BrowserLaunchException("Failed launch browser", (Throwable)e);
            }
            throw new IllegalApplicationStateException("Process is shutting down, do not create new drivers", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldCreateWebDriver() {
        int n;
        Object[] objectArray;
        Object[] objectArray2;
        Browser browser = this._browser;
        if (browser != null && (objectArray2 = browser.getDrivers()) != null && (objectArray = objectArray2.values()) != null) {
            void $this$count$iv;
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            Iterable iterable = (Iterable)objectArray;
            boolean $i$f$filterIsInstance22 = false;
            void var7_9 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof AbstractWebDriver)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filterIsInstance22 = (List)destination$iv$iv;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    AbstractWebDriver it = (AbstractWebDriver)element$iv;
                    boolean bl = false;
                    if (!(!it.isQuit()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
        } else {
            n = 0;
        }
        int resourceConsumingDriversInBrowser = n;
        int resourceConsumingDriversInPool = this.statefulDriverPool.getActiveDriverCount();
        if (resourceConsumingDriversInBrowser != resourceConsumingDriversInPool) {
            objectArray2 = new Object[]{this.getNumDriverSlots(), resourceConsumingDriversInPool, resourceConsumingDriversInBrowser};
            this.logger.warn("Inconsistent online driver status, resource consuming drivers: {}/{}/{} (slots/pool/browser)", objectArray2);
        }
        boolean isCriticalResources = AppSystemInfo.Companion.isCriticalResources();
        if (resourceConsumingDriversInPool >= this.getCapacity()) {
            objectArray = new Object[]{this.getNumDriverSlots(), resourceConsumingDriversInPool, resourceConsumingDriversInBrowser};
            this.logger.debug("Enough online drivers, will not create new one. Resource consuming drivers: {}/{}/{} (slots/pool/browser)", objectArray);
        } else if (AppSystemInfo.Companion.isCriticalMemory()) {
            objectArray = new Object[]{AppSystemInfo.Companion.formatAvailableMemory(), this.getNumDriverSlots(), resourceConsumingDriversInPool, resourceConsumingDriversInBrowser};
            this.logger.info("Critical memory: {}, resource consuming drivers: {}/{}/{} (slots/pool/browser), will not create new driver", objectArray);
        }
        return this.isActive() && !isCriticalResources && resourceConsumingDriversInPool < this.getCapacity();
    }

    private final WebDriver computeBrowserAndDriver0(VolatileConfig conf) throws WebDriverException {
        Browser browser = this.driverFactory.launchBrowser(this.browserId, conf);
        WebDriver driver2 = browser.newDriver();
        this._browser = browser;
        this._numCreatedDrivers.incrementAndGet();
        this.statefulDriverPool.offer(driver2);
        if (this.logger.isDebugEnabled()) {
            this.logDriverOnline(driver2);
        }
        return driver2;
    }

    /*
     * Unable to fully structure code
     */
    private final Object dispatchEvent(String var1_1, Function1<? super Continuation<? super Unit>, ? extends Object> var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof dispatchEvent.1)) ** GOTO lbl-1000
        var6_4 = var3_3;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ LoadingWebDriverPool this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LoadingWebDriverPool.access$dispatchEvent(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.isActive()) {
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = name;
                $continuation.label = 1;
                v0 = action.invoke((Object)$continuation);
                ** if (v0 != var7_6) goto lbl22
lbl21:
                // 1 sources

                return var7_6;
lbl22:
                // 1 sources

                ** GOTO lbl42
            }
            case 1: {
                name = (String)$continuation.L$1;
                this = (LoadingWebDriverPool)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (WebDriverCancellationException var4_7) {
                    this.logger.info("Web driver is cancelled");
                }
                catch (WebDriverException e) {
                    this.logger.warn(ExceptionsKt.brief$default((Throwable)e, (String)("[Ignored][" + name + "] "), null, (int)2, null));
                }
                catch (Exception e) {
                    this.logger.warn(ExceptionsKt.stringify$default((Throwable)e, (String)("[Ignored][" + name + "] "), null, (int)2, null));
                }
                catch (Throwable e) {
                    this.logger.error(ExceptionsKt.stringify$default((Throwable)e, (String)("[Unexpected][" + name + "] "), null, (int)2, null));
                }
lbl42:
                // 6 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void logDriverOnline(WebDriver driver2) {
        if (!(driver2 instanceof AbstractWebDriver)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        WebDriverSettings driverSettings = this.driverFactory.getDriverSettings();
        Object[] objectArray = new Object[]{this.getNumActive(), ((AbstractWebDriver)driver2).getName(), driverSettings.getPageLoadStrategy(), this.getCapacity()};
        this.logger.trace("The {}th web driver is active, browser: {} pageLoadStrategy: {} capacity: {}", objectArray);
    }

    public static final /* synthetic */ Object access$pollWithEvents(LoadingWebDriverPool $this, int priority, VolatileConfig conf, BrowseEventHandlers event, WebPage page, Duration timeout, Continuation $completion) {
        return $this.pollWithEvents(priority, conf, event, page, timeout, (Continuation<? super WebDriver>)$completion);
    }

    public static final /* synthetic */ Object access$dispatchEvent(LoadingWebDriverPool $this, String name, Function1 action, Continuation $completion) {
        return $this.dispatchEvent(name, (Function1<? super Continuation<? super Unit>, ? extends Object>)action, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\"\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lai/platon/pulsar/protocol/browser/driver/LoadingWebDriverPool$Companion;", "", "()V", "CLOSE_ALL_TIMEOUT", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getCLOSE_ALL_TIMEOUT", "()Ljava/time/Duration;", "setCLOSE_ALL_TIMEOUT", "(Ljava/time/Duration;)V", "POLLING_TIMEOUT", "getPOLLING_TIMEOUT", "setPOLLING_TIMEOUT", "instanceSequencer", "Ljava/util/concurrent/atomic/AtomicInteger;", "getInstanceSequencer", "()Ljava/util/concurrent/atomic/AtomicInteger;", "pulsar-protocol"})
    public static final class Companion {
        private Companion() {
        }

        public final Duration getCLOSE_ALL_TIMEOUT() {
            return CLOSE_ALL_TIMEOUT;
        }

        public final void setCLOSE_ALL_TIMEOUT(Duration duration) {
            CLOSE_ALL_TIMEOUT = duration;
        }

        public final Duration getPOLLING_TIMEOUT() {
            return POLLING_TIMEOUT;
        }

        public final void setPOLLING_TIMEOUT(Duration duration) {
            POLLING_TIMEOUT = duration;
        }

        @NotNull
        public final AtomicInteger getInstanceSequencer() {
            return instanceSequencer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000bJ\b\u0010 \u001a\u00020\u001eH\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0013R\u0011\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016\u00a8\u0006!"}, d2={"Lai/platon/pulsar/protocol/browser/driver/LoadingWebDriverPool$Snapshot;", "", "numActive", "", "numStandby", "numWaiting", "numWorking", "numDriverSlots", "numRetired", "numClosed", "isRetired", "", "isIdle", "idleTime", "Ljava/time/Duration;", "lackOfResources", "(IIIIIIIZZLjava/time/Duration;Z)V", "getIdleTime", "()Ljava/time/Duration;", "()Z", "getLackOfResources", "getNumActive", "()I", "getNumClosed", "getNumDriverSlots", "getNumRetired", "getNumStandby", "getNumWaiting", "getNumWorking", "format", "", "verbose", "toString", "pulsar-protocol"})
    public static final class Snapshot {
        private final int numActive;
        private final int numStandby;
        private final int numWaiting;
        private final int numWorking;
        private final int numDriverSlots;
        private final int numRetired;
        private final int numClosed;
        private final boolean isRetired;
        private final boolean isIdle;
        @NotNull
        private final Duration idleTime;
        private final boolean lackOfResources;

        public Snapshot(int numActive, int numStandby, int numWaiting, int numWorking, int numDriverSlots, int numRetired, int numClosed, boolean isRetired, boolean isIdle2, @NotNull Duration idleTime, boolean lackOfResources) {
            Intrinsics.checkNotNullParameter((Object)idleTime, (String)"idleTime");
            this.numActive = numActive;
            this.numStandby = numStandby;
            this.numWaiting = numWaiting;
            this.numWorking = numWorking;
            this.numDriverSlots = numDriverSlots;
            this.numRetired = numRetired;
            this.numClosed = numClosed;
            this.isRetired = isRetired;
            this.isIdle = isIdle2;
            this.idleTime = idleTime;
            this.lackOfResources = lackOfResources;
        }

        public /* synthetic */ Snapshot(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2, Duration duration, boolean bl3, int n8, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n8 & 0x400) != 0) {
                bl3 = AppSystemInfo.Companion.isCriticalResources();
            }
            this(n, n2, n3, n4, n5, n6, n7, bl, bl2, duration, bl3);
        }

        public final int getNumActive() {
            return this.numActive;
        }

        public final int getNumStandby() {
            return this.numStandby;
        }

        public final int getNumWaiting() {
            return this.numWaiting;
        }

        public final int getNumWorking() {
            return this.numWorking;
        }

        public final int getNumDriverSlots() {
            return this.numDriverSlots;
        }

        public final int getNumRetired() {
            return this.numRetired;
        }

        public final int getNumClosed() {
            return this.numClosed;
        }

        public final boolean isRetired() {
            return this.isRetired;
        }

        public final boolean isIdle() {
            return this.isIdle;
        }

        @NotNull
        public final Duration getIdleTime() {
            return this.idleTime;
        }

        public final boolean getLackOfResources() {
            return this.lackOfResources;
        }

        @NotNull
        public final String format(boolean verbose) {
            String string;
            if (verbose) {
                var4_2 = "active: %d, standby: %d, waiting: %d, working: %d, slots: %d, retired: %d, closed: %d";
                var5_3 = new Object[]{this.numActive, this.numStandby, this.numWaiting, this.numWorking, this.numDriverSlots, this.numRetired, this.numClosed};
                String string2 = String.format(var4_2, Arrays.copyOf(var5_3, var5_3.length));
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            } else {
                var4_2 = "%d/%d/%d/%d/%d/%d/%d (active/standby/waiting/working/slots/retired/closed)";
                var5_3 = new Object[]{this.numActive, this.numStandby, this.numWaiting, this.numWorking, this.numDriverSlots, this.numRetired, this.numClosed};
                String string3 = String.format(var4_2, Arrays.copyOf(var5_3, var5_3.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            }
            String status = string;
            String time = DateTimesKt.readable((Duration)this.idleTime);
            return this.lackOfResources ? "[Lack of resource] | " + status : (this.isIdle ? "[Idle] " + time + " | " + status : (this.isRetired ? "[Retired] | " + status : status));
        }

        @NotNull
        public String toString() {
            return this.format(false);
        }
    }
}

