/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver;

import ai.platon.pulsar.common.browser.BrowserType;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.protocol.browser.UnsupportedWebDriverException;
import ai.platon.pulsar.protocol.browser.driver.BrowserManager;
import ai.platon.pulsar.protocol.browser.driver.WebDriverSettings;
import ai.platon.pulsar.protocol.browser.driver.cdt.ChromeDevtoolsBrowser;
import ai.platon.pulsar.protocol.browser.driver.test.MockBrowser;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.AbstractBrowser;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.AbstractWebDriver;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.Browser;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.BrowserLaunchException;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.skeleton.crawl.fetch.privacy.BrowserId;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019J,\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u0016\u001a\u00020\u0017J6\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00150!2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u00010%J$\u0010'\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u00010%H\u0002J\u0006\u0010)\u001a\u00020\u001fJ&\u0010*\u001a\u00020+2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u00010,2\b\u0010-\u001a\u0004\u0018\u00010.H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lai/platon/pulsar/protocol/browser/driver/WebDriverFactory;", "", "driverSettings", "Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;", "browserManager", "Lai/platon/pulsar/protocol/browser/driver/BrowserManager;", "immutableConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;Lai/platon/pulsar/protocol/browser/driver/BrowserManager;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getBrowserManager", "()Lai/platon/pulsar/protocol/browser/driver/BrowserManager;", "getDriverSettings", "()Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;", "getImmutableConfig", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "numDrivers", "Ljava/util/concurrent/atomic/AtomicInteger;", "create", "Lai/platon/pulsar/skeleton/crawl/fetch/driver/WebDriver;", "conf", "Lai/platon/pulsar/common/config/VolatileConfig;", "start", "", "browserId", "Lai/platon/pulsar/skeleton/crawl/fetch/privacy/BrowserId;", "priority", "", "launchBrowser", "Lai/platon/pulsar/skeleton/crawl/fetch/driver/Browser;", "launchBrowserAndDriver", "Lkotlin/Pair;", "launchChrome", "Lai/platon/pulsar/protocol/browser/driver/cdt/ChromeDevtoolsBrowser;", "capabilities", "", "", "launchMockChrome", "Lai/platon/pulsar/protocol/browser/driver/test/MockBrowser;", "launchTempBrowser", "setProxy", "", "", "proxyURI", "Ljava/net/URI;", "pulsar-protocol"})
public class WebDriverFactory {
    @NotNull
    private final WebDriverSettings driverSettings;
    @NotNull
    private final BrowserManager browserManager;
    @NotNull
    private final ImmutableConfig immutableConfig;
    private final Logger logger;
    @NotNull
    private final AtomicInteger numDrivers;

    public WebDriverFactory(@NotNull WebDriverSettings driverSettings, @NotNull BrowserManager browserManager, @NotNull ImmutableConfig immutableConfig) {
        Intrinsics.checkNotNullParameter((Object)((Object)driverSettings), (String)"driverSettings");
        Intrinsics.checkNotNullParameter((Object)browserManager, (String)"browserManager");
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"immutableConfig");
        this.driverSettings = driverSettings;
        this.browserManager = browserManager;
        this.immutableConfig = immutableConfig;
        this.logger = LoggerFactory.getLogger(WebDriverFactory.class);
        this.numDrivers = new AtomicInteger();
    }

    @NotNull
    public final WebDriverSettings getDriverSettings() {
        return this.driverSettings;
    }

    @NotNull
    public final BrowserManager getBrowserManager() {
        return this.browserManager;
    }

    @NotNull
    public final ImmutableConfig getImmutableConfig() {
        return this.immutableConfig;
    }

    @NotNull
    public final WebDriver create(boolean start) throws BrowserLaunchException {
        return this.create(this.immutableConfig.toVolatileConfig(), start);
    }

    public static /* synthetic */ WebDriver create$default(WebDriverFactory webDriverFactory, boolean bl, int n, Object object) throws BrowserLaunchException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return webDriverFactory.create(bl);
    }

    @NotNull
    public final WebDriver create(@NotNull VolatileConfig conf, boolean start) throws BrowserLaunchException {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        return this.create(BrowserId.Companion.getRANDOM(), 0, conf, start);
    }

    public static /* synthetic */ WebDriver create$default(WebDriverFactory webDriverFactory, VolatileConfig volatileConfig, boolean bl, int n, Object object) throws BrowserLaunchException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return webDriverFactory.create(volatileConfig, bl);
    }

    @NotNull
    public final WebDriver create(@NotNull BrowserId browserId, int priority, @NotNull VolatileConfig conf, boolean start) throws BrowserLaunchException {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        return (WebDriver)this.launchBrowserAndDriver(browserId, priority, conf, start).getSecond();
    }

    public static /* synthetic */ WebDriver create$default(WebDriverFactory webDriverFactory, BrowserId browserId, int n, VolatileConfig volatileConfig, boolean bl, int n2, Object object) throws BrowserLaunchException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            volatileConfig = VolatileConfig.Companion.getUNSAFE();
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return webDriverFactory.create(browserId, n, volatileConfig, bl);
    }

    @NotNull
    public final Browser launchBrowser() throws BrowserLaunchException {
        return WebDriverFactory.launchBrowser$default(this, BrowserId.Companion.getDEFAULT(), null, 2, null);
    }

    @NotNull
    public final Browser launchTempBrowser() throws BrowserLaunchException {
        return WebDriverFactory.launchBrowser$default(this, BrowserId.Companion.getRANDOM(), null, 2, null);
    }

    @NotNull
    public final Browser launchBrowser(@NotNull BrowserId browserId, @NotNull VolatileConfig conf) throws BrowserLaunchException {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.numDrivers.incrementAndGet();
        this.logger.debug("Creating browser #{} | {}", (Object)this.numDrivers, (Object)browserId);
        BrowserType browserType = browserId.getBrowserType();
        Map<String, Object> capabilities = this.driverSettings.createGeneralOptions();
        this.setProxy(capabilities, browserId.getFingerprint().getProxyURI());
        try {
            AbstractBrowser browser = switch (WhenMappings.$EnumSwitchMapping$0[browserType.ordinal()]) {
                case 1 -> this.launchChrome(browserId, capabilities);
                case 2 -> this.launchMockChrome(browserId, capabilities);
                default -> throw new UnsupportedWebDriverException("Unsupported browser type: " + browserType);
            };
            return (Browser)browser;
        }
        catch (BrowserLaunchException e) {
            this.logger.error("Failed to launch browser {} | {}", (Object)browserType, (Object)e.getMessage());
            throw e;
        }
    }

    public static /* synthetic */ Browser launchBrowser$default(WebDriverFactory webDriverFactory, BrowserId browserId, VolatileConfig volatileConfig, int n, Object object) throws BrowserLaunchException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: launchBrowser");
        }
        if ((n & 2) != 0) {
            volatileConfig = VolatileConfig.Companion.getUNSAFE();
        }
        return webDriverFactory.launchBrowser(browserId, volatileConfig);
    }

    private final Pair<Browser, WebDriver> launchBrowserAndDriver(BrowserId browserId, int priority, VolatileConfig conf, boolean start) throws BrowserLaunchException {
        try {
            Browser browser = this.launchBrowser(browserId, conf);
            WebDriver webDriver = browser.newDriver();
            Intrinsics.checkNotNull((Object)webDriver, (String)"null cannot be cast to non-null type ai.platon.pulsar.skeleton.crawl.fetch.driver.AbstractWebDriver");
            AbstractWebDriver driver2 = (AbstractWebDriver)webDriver;
            if (start) {
                driver2.startWork();
            }
            return TuplesKt.to((Object)browser, (Object)driver2);
        }
        catch (BrowserLaunchException e) {
            this.logger.error("Can not launch browser | {}", (Object)e.getMessage());
            throw e;
        }
    }

    static /* synthetic */ Pair launchBrowserAndDriver$default(WebDriverFactory webDriverFactory, BrowserId browserId, int n, VolatileConfig volatileConfig, boolean bl, int n2, Object object) throws BrowserLaunchException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: launchBrowserAndDriver");
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return webDriverFactory.launchBrowserAndDriver(browserId, n, volatileConfig, bl);
    }

    @NotNull
    public final ChromeDevtoolsBrowser launchChrome(@NotNull BrowserId browserId, @NotNull Map<String, ? extends Object> capabilities) throws BrowserLaunchException {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        Intrinsics.checkNotNullParameter(capabilities, (String)"capabilities");
        if (!(browserId.getBrowserType() == BrowserType.PULSAR_CHROME)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Browser browser = this.browserManager.launch(browserId, this.driverSettings, capabilities);
        Intrinsics.checkNotNull((Object)browser, (String)"null cannot be cast to non-null type ai.platon.pulsar.protocol.browser.driver.cdt.ChromeDevtoolsBrowser");
        return (ChromeDevtoolsBrowser)browser;
    }

    private final MockBrowser launchMockChrome(BrowserId browserId, Map<String, ? extends Object> capabilities) throws BrowserLaunchException {
        if (!(browserId.getBrowserType() == BrowserType.MOCK_CHROME)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Browser browser = this.browserManager.launch(browserId, this.driverSettings, capabilities);
        Intrinsics.checkNotNull((Object)browser, (String)"null cannot be cast to non-null type ai.platon.pulsar.protocol.browser.driver.test.MockBrowser");
        return (MockBrowser)browser;
    }

    private final void setProxy(Map<String, Object> capabilities, URI proxyURI) {
        if (proxyURI == null) {
            return;
        }
        capabilities.put("proxy", proxyURI);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BrowserType.values().length];
            try {
                nArray[BrowserType.PULSAR_CHROME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BrowserType.MOCK_CHROME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

