/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver;

import ai.platon.pulsar.browser.common.BrowserSettings;
import ai.platon.pulsar.browser.driver.chrome.common.ChromeOptions;
import ai.platon.pulsar.common.config.AppConstants;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import java.net.URI;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00102\b\b\u0002\u0010\u0015\u001a\u00020\u0010H\u0016R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;", "Lai/platon/pulsar/browser/common/BrowserSettings;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "fetchTaskTimeout", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getFetchTaskTimeout", "()Ljava/time/Duration;", "pollingDriverTimeout", "getPollingDriverTimeout", "createChromeOptions", "Lai/platon/pulsar/browser/driver/chrome/common/ChromeOptions;", "generalOptions", "", "", "", "createGeneralOptions", "", "formatViewPort", "delimiter", "Companion", "pulsar-protocol"})
public class WebDriverSettings
extends BrowserSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String POLLING_DRIVER_TIMEOUT = "polling.driver.timeout";
    private static final Duration POLLING_DRIVER_TIMEOUT_DEFAULT = Duration.ofSeconds(60L);

    public WebDriverSettings(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(conf);
    }

    public final Duration getFetchTaskTimeout() {
        ImmutableConfig immutableConfig = this.getConf();
        Duration duration = AppConstants.FETCH_TASK_TIMEOUT_DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"FETCH_TASK_TIMEOUT_DEFAULT");
        return immutableConfig.getDuration("fetch.task.timeout", duration);
    }

    public final Duration getPollingDriverTimeout() {
        ImmutableConfig immutableConfig = this.getConf();
        Duration duration = POLLING_DRIVER_TIMEOUT_DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"POLLING_DRIVER_TIMEOUT_DEFAULT");
        return immutableConfig.getDuration(POLLING_DRIVER_TIMEOUT, duration);
    }

    @NotNull
    public String formatViewPort(@NotNull String delimiter) {
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        return BrowserSettings.Companion.getSCREEN_VIEWPORT().width + delimiter + BrowserSettings.Companion.getSCREEN_VIEWPORT().height;
    }

    public static /* synthetic */ String formatViewPort$default(WebDriverSettings webDriverSettings, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: formatViewPort");
        }
        if ((n & 1) != 0) {
            string = ",";
        }
        return webDriverSettings.formatViewPort(string);
    }

    @NotNull
    public Map<String, Object> createGeneralOptions() {
        Map generalOptions = new LinkedHashMap();
        return generalOptions;
    }

    @NotNull
    public ChromeOptions createChromeOptions(@NotNull Map<String, ? extends Object> generalOptions) {
        Intrinsics.checkNotNullParameter(generalOptions, (String)"generalOptions");
        ChromeOptions chromeOptions = new ChromeOptions(null, false, false, false, false, 0, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, null, false, false, false, false, null, 0x7FFFFFF, null);
        chromeOptions.merge(generalOptions);
        chromeOptions.removeArgument("proxy");
        Object proxy = generalOptions.get("proxy");
        if (proxy instanceof String) {
            chromeOptions.setProxyServer((String)proxy);
        } else if (proxy instanceof URI) {
            chromeOptions.setProxyServer(((URI)proxy).getHost() + ":" + ((URI)proxy).getPort());
        } else if (proxy instanceof ProxyEntry) {
            chromeOptions.setProxyServer(((ProxyEntry)proxy).getHostPort());
        }
        chromeOptions.setHeadless(this.isHeadless());
        chromeOptions.setNoSandbox(this.getNoSandbox());
        chromeOptions.addArgument("window-position", "0,0").addArgument("window-size", WebDriverSettings.formatViewPort$default(this, null, 1, null)).addArgument("pageLoadStrategy", this.getPageLoadStrategy()).addArgument("throwExceptionOnScriptError", "true");
        return chromeOptions;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings$Companion;", "", "()V", "POLLING_DRIVER_TIMEOUT", "", "getPOLLING_DRIVER_TIMEOUT", "()Ljava/lang/String;", "POLLING_DRIVER_TIMEOUT_DEFAULT", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getPOLLING_DRIVER_TIMEOUT_DEFAULT", "()Ljava/time/Duration;", "pulsar-protocol"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getPOLLING_DRIVER_TIMEOUT() {
            return POLLING_DRIVER_TIMEOUT;
        }

        public final Duration getPOLLING_DRIVER_TIMEOUT_DEFAULT() {
            return POLLING_DRIVER_TIMEOUT_DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

