/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver.cdt;

import ai.platon.pulsar.browser.common.BrowserSettings;
import ai.platon.pulsar.browser.driver.chrome.ChromeLauncher;
import ai.platon.pulsar.browser.driver.chrome.ChromeTab;
import ai.platon.pulsar.browser.driver.chrome.DevToolsConfig;
import ai.platon.pulsar.browser.driver.chrome.RemoteChrome;
import ai.platon.pulsar.browser.driver.chrome.RemoteDevTools;
import ai.platon.pulsar.browser.driver.chrome.impl.ChromeImpl;
import ai.platon.pulsar.browser.driver.chrome.util.ChromeDriverException;
import ai.platon.pulsar.browser.driver.chrome.util.ChromeIOException;
import ai.platon.pulsar.browser.driver.chrome.util.ChromeServiceException;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.urls.UrlUtils;
import ai.platon.pulsar.protocol.browser.driver.cdt.ChromeDevtoolsBrowser;
import ai.platon.pulsar.protocol.browser.driver.cdt.ChromeDevtoolsDriver;
import ai.platon.pulsar.skeleton.common.AppSystemInfo;
import ai.platon.pulsar.skeleton.context.PulsarContexts;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.AbstractBrowser;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.AbstractWebDriver;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.IllegalWebDriverStateException;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.WebDriverException;
import ai.platon.pulsar.skeleton.crawl.fetch.privacy.BrowserId;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B'\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020%H\u0002J\b\u0010)\u001a\u00020%H\u0016J\b\u0010*\u001a\u00020%H\u0002J\b\u0010+\u001a\u00020%H\u0002J\u000e\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020.J\u0018\u0010/\u001a\u0002002\u0006\u0010-\u001a\u00020.2\u0006\u00101\u001a\u00020\u001fH\u0002J\u0006\u00102\u001a\u00020.J\u000e\u00102\u001a\u00020.2\u0006\u00103\u001a\u00020!J\u0016\u00104\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0082@\u00a2\u0006\u0002\u00105J\u0010\u00106\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u00107\u001a\u00020%H\u0016J\b\u00108\u001a\u00020%H\u0002J\u0018\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020.2\u0006\u0010<\u001a\u00020\u0017H\u0002J\u0018\u0010=\u001a\u0004\u0018\u00010:2\u0006\u00103\u001a\u00020!H\u0096@\u00a2\u0006\u0002\u0010>J\u0018\u0010=\u001a\u0004\u0018\u00010'2\u0006\u0010?\u001a\u00020@H\u0096@\u00a2\u0006\u0002\u0010AJ\u001c\u0010B\u001a\b\u0012\u0004\u0012\u00020'0C2\u0006\u0010?\u001a\u00020@H\u0096@\u00a2\u0006\u0002\u0010AJ\u0014\u0010D\u001a\b\u0012\u0004\u0012\u00020'0CH\u0096@\u00a2\u0006\u0002\u0010EJ\u0011\u0010F\u001a\b\u0012\u0004\u0012\u00020.0G\u00a2\u0006\u0002\u0010HJ\b\u0010I\u001a\u00020%H\u0016J\b\u0010J\u001a\u00020:H\u0016J\u0010\u0010J\u001a\u00020:2\u0006\u00103\u001a\u00020!H\u0016J\u0018\u0010K\u001a\u00020:2\u0006\u0010;\u001a\u00020.2\u0006\u0010<\u001a\u00020\u0017H\u0002J\b\u0010L\u001a\u00020%H\u0002J\b\u0010M\u001a\u00020%H\u0002J\u0018\u0010N\u001a\u00020%2\u0006\u0010-\u001a\u00020.2\u0006\u0010&\u001a\u00020'H\u0002R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0018R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006O"}, d2={"Lai/platon/pulsar/protocol/browser/driver/cdt/ChromeDevtoolsBrowser;", "Lai/platon/pulsar/skeleton/crawl/fetch/driver/AbstractBrowser;", "port", "", "browserSettings", "Lai/platon/pulsar/browser/common/BrowserSettings;", "(ILai/platon/pulsar/browser/common/BrowserSettings;)V", "id", "Lai/platon/pulsar/skeleton/crawl/fetch/privacy/BrowserId;", "chrome", "Lai/platon/pulsar/browser/driver/chrome/RemoteChrome;", "launcher", "Lai/platon/pulsar/browser/driver/chrome/ChromeLauncher;", "(Lai/platon/pulsar/skeleton/crawl/fetch/privacy/BrowserId;Lai/platon/pulsar/browser/driver/chrome/RemoteChrome;Lai/platon/pulsar/browser/common/BrowserSettings;Lai/platon/pulsar/browser/driver/chrome/ChromeLauncher;)V", "getChrome", "()Lai/platon/pulsar/browser/driver/chrome/RemoteChrome;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "isActive", "", "()Z", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "reuseRecoveredDriver", "getReuseRecoveredDriver", "toolsConfig", "Lai/platon/pulsar/browser/driver/chrome/DevToolsConfig;", "userAgent", "", "getUserAgent", "()Ljava/lang/String;", "addToDriverTree", "", "driver", "Lai/platon/pulsar/skeleton/crawl/fetch/driver/WebDriver;", "buildDriverTree", "close", "closeDrivers", "closeRecoveredIdleDrivers", "closeTab", "tab", "Lai/platon/pulsar/browser/driver/chrome/ChromeTab;", "createDevTools", "Lai/platon/pulsar/browser/driver/chrome/RemoteDevTools;", "config", "createTab", "url", "currentUrl", "(Lai/platon/pulsar/skeleton/crawl/fetch/driver/WebDriver;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "destroyDriver", "destroyForcibly", "doClose", "doNewDriver", "Lai/platon/pulsar/protocol/browser/driver/cdt/ChromeDevtoolsDriver;", "chromeTab", "recovered", "findDriver", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "urlRegex", "Lkotlin/text/Regex;", "(Lkotlin/text/Regex;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findDrivers", "", "listDrivers", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "listTabs", "", "()[Lai/platon/pulsar/browser/driver/chrome/ChromeTab;", "maintain", "newDriver", "newDriverIfAbsent", "recoverUnmanagedPages", "recoverUnmanagedPages0", "reportNewDriver", "pulsar-protocol"})
@SourceDebugExtension(value={"SMAP\nChromeDevtoolsBrowser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromeDevtoolsBrowser.kt\nai/platon/pulsar/protocol/browser/driver/cdt/ChromeDevtoolsBrowser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,361:1\n1#2:362\n800#3,11:363\n288#3,2:374\n800#3,11:376\n288#3,2:387\n800#3,11:389\n766#3:400\n857#3,2:401\n288#3,2:403\n1855#3,2:405\n766#3:410\n857#3,2:411\n766#3:413\n857#3,2:414\n1855#3,2:416\n800#3,11:418\n766#3:429\n857#3,2:430\n1747#3,3:432\n1855#3,2:435\n1855#3,2:437\n3792#4:407\n4307#4,2:408\n*S KotlinDebug\n*F\n+ 1 ChromeDevtoolsBrowser.kt\nai/platon/pulsar/protocol/browser/driver/cdt/ChromeDevtoolsBrowser\n*L\n134#1:363,11\n134#1:374,2\n139#1:376,11\n139#1:387,2\n144#1:389,11\n144#1:400\n144#1:401,2\n218#1:403,2\n240#1:405,2\n281#1:410\n281#1:411,2\n282#1:413\n282#1:414,2\n283#1:416,2\n304#1:418,11\n311#1:429\n311#1:430,2\n314#1:432,3\n321#1:435,2\n349#1:437,2\n280#1:407\n280#1:408,2\n*E\n"})
public final class ChromeDevtoolsBrowser
extends AbstractBrowser {
    @NotNull
    private final RemoteChrome chrome;
    @Nullable
    private final ChromeLauncher launcher;
    private final Logger logger;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final DevToolsConfig toolsConfig;

    public ChromeDevtoolsBrowser(@NotNull BrowserId id, @NotNull RemoteChrome chrome, @NotNull BrowserSettings browserSettings, @Nullable ChromeLauncher launcher) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)chrome, (String)"chrome");
            Intrinsics.checkNotNullParameter((Object)browserSettings, (String)"browserSettings");
            super(id, browserSettings);
            this.chrome = chrome;
            this.launcher = launcher;
            this.logger = LoggerFactory.getLogger(ChromeDevtoolsBrowser.class);
            this.closed = new AtomicBoolean();
            this.toolsConfig = new DevToolsConfig(null, 1, null);
            ChromeLauncher chromeLauncher = this.launcher;
            if (chromeLauncher == null) break block0;
            ChromeLauncher it = chromeLauncher;
            boolean bl = false;
            PulsarContexts.registerClosable((AutoCloseable)((AutoCloseable)it), (int)Integer.MIN_VALUE);
        }
    }

    @NotNull
    public final RemoteChrome getChrome() {
        return this.chrome;
    }

    private final ImmutableConfig getConf() {
        return this.getBrowserSettings().getConf();
    }

    private final boolean getReuseRecoveredDriver() {
        return this.getConf().getBoolean("browser.reuse.recovered.drivers", false);
    }

    public boolean isActive() {
        return super.isActive() && this.chrome.isActive();
    }

    @NotNull
    public String getUserAgent() {
        String string = this.chrome.getVersion().getUserAgent();
        if (string == null) {
            string = AbstractBrowser.Companion.getDEFAULT_USER_AGENT();
        }
        return string;
    }

    public ChromeDevtoolsBrowser(int port, @NotNull BrowserSettings browserSettings) {
        Intrinsics.checkNotNullParameter((Object)browserSettings, (String)"browserSettings");
        this(BrowserId.Companion.getRANDOM(), (RemoteChrome)new ChromeImpl(port), browserSettings, null);
    }

    public /* synthetic */ ChromeDevtoolsBrowser(int n, BrowserSettings browserSettings, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            browserSettings = new BrowserSettings(null, 1, null);
        }
        this(n, browserSettings);
    }

    @NotNull
    public final synchronized ChromeTab createTab() throws WebDriverException {
        return this.createTab("about:blank");
    }

    @NotNull
    public final synchronized ChromeTab createTab(@NotNull String url) throws WebDriverException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.setLastActiveTime(Instant.now());
        try {
            return this.chrome.createTab(url);
        }
        catch (ChromeIOException e) {
            throw new IllegalWebDriverStateException("createTab", (Throwable)e);
        }
        catch (ChromeServiceException e) {
            throw new WebDriverException("createTab", (Throwable)e);
        }
    }

    @NotNull
    public final synchronized ChromeTab[] listTabs() throws WebDriverException {
        try {
            return this.chrome.listTabs();
        }
        catch (ChromeIOException e) {
            throw new IllegalWebDriverStateException("listTabs", (Throwable)e);
        }
        catch (ChromeServiceException e) {
            if (!this.isActive()) {
                return new ChromeTab[0];
            }
            throw new WebDriverException("listTabs", (Throwable)e);
        }
    }

    public final synchronized void closeTab(@NotNull ChromeTab tab) throws WebDriverException {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        this.logger.debug("Closing tab | {}", (Object)tab.getUrl());
        try {
            if (!this.isActive()) {
                return;
            }
            this.chrome.closeTab(tab);
        }
        catch (ChromeIOException e) {
            throw new IllegalWebDriverStateException("closeTab", (Throwable)e);
        }
        catch (ChromeServiceException e) {
            throw new WebDriverException("closeTab", (Throwable)e);
        }
    }

    @NotNull
    public synchronized ChromeDevtoolsDriver newDriver() throws WebDriverException {
        return this.newDriver("about:blank");
    }

    @NotNull
    public synchronized ChromeDevtoolsDriver newDriver(@NotNull String url) throws WebDriverException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            ChromeTab chromeTab = this.createTab(url);
            return this.newDriverIfAbsent(chromeTab, false);
        }
        catch (ChromeIOException e) {
            throw new IllegalWebDriverStateException("newDriver", (Throwable)e);
        }
        catch (ChromeDriverException e) {
            this.logger.warn(ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
            throw new WebDriverException("Failed to create chrome devtools driver | " + e.getMessage(), null, null, 6, null);
        }
        catch (Exception e) {
            this.logger.warn(ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
            throw new WebDriverException("[Unexpected] Failed to create chrome devtools driver", (Throwable)e);
        }
    }

    @Nullable
    public Object listDrivers(@NotNull Continuation<? super List<? extends WebDriver>> $completion) throws WebDriverException {
        this.recoverUnmanagedPages();
        return CollectionsKt.toList((Iterable)this.getDrivers().values());
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object findDriver(@NotNull String var1_1, @NotNull Continuation<? super ChromeDevtoolsDriver> var2_2) throws WebDriverException {
        block9: {
            if (!(var2_2 instanceof findDriver.1)) ** GOTO lbl-1000
            var11_3 = var2_2;
            if ((var11_3.label & -2147483648) != 0) {
                var11_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    /* synthetic */ Object result;
                    final /* synthetic */ ChromeDevtoolsBrowser this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.findDriver((String)null, (Continuation<? super ChromeDevtoolsDriver>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    this.recoverUnmanagedPages();
                    $this$filterIsInstance$iv = this.getDrivers().values();
                    $i$f$filterIsInstance = false;
                    var5_8 = $this$filterIsInstance$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof ChromeDevtoolsDriver)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$firstOrNull$iv = (List)destination$iv$iv;
                    $i$f$firstOrNull = false;
                    var5_8 = $this$firstOrNull$iv.iterator();
lbl26:
                    // 2 sources

                    while (var5_8.hasNext()) {
                        element$iv = var5_8.next();
                        it = (ChromeDevtoolsDriver)element$iv;
                        $i$a$-firstOrNull-ChromeDevtoolsBrowser$findDriver$2 = false;
                        $continuation.L$0 = this;
                        $continuation.L$1 = url;
                        $continuation.L$2 = var5_8;
                        $continuation.L$3 = element$iv;
                        $continuation.label = 1;
                        v0 = this.currentUrl((WebDriver)it, (Continuation<? super String>)$continuation);
                        if (v0 == var12_5) {
                            return var12_5;
                        }
                        ** GOTO lbl49
                    }
                    break;
                }
                case 1: {
                    $i$f$firstOrNull = false;
                    $i$a$-firstOrNull-ChromeDevtoolsBrowser$findDriver$2 = false;
                    element$iv = $continuation.L$3;
                    var5_8 = (Iterator)$continuation.L$2;
                    url = (String)$continuation.L$1;
                    this = (ChromeDevtoolsBrowser)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl49:
                    // 2 sources

                    if (!Intrinsics.areEqual((Object)v0, (Object)url)) ** GOTO lbl26
                    v1 = element$iv;
                    break block9;
                }
            }
            v1 = null;
        }
        return v1;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object findDriver(@NotNull Regex var1_1, @NotNull Continuation<? super WebDriver> var2_2) {
        block9: {
            if (!(var2_2 instanceof findDriver.3)) ** GOTO lbl-1000
            var11_3 = var2_2;
            if ((var11_3.label & -2147483648) != 0) {
                var11_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    /* synthetic */ Object result;
                    final /* synthetic */ ChromeDevtoolsBrowser this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.findDriver((Regex)null, (Continuation<? super WebDriver>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    this.recoverUnmanagedPages();
                    $this$filterIsInstance$iv = this.getDrivers().values();
                    $i$f$filterIsInstance = false;
                    var5_8 = $this$filterIsInstance$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof ChromeDevtoolsDriver)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$firstOrNull$iv = (List)destination$iv$iv;
                    $i$f$firstOrNull = false;
                    var5_8 = $this$firstOrNull$iv.iterator();
lbl26:
                    // 2 sources

                    while (var5_8.hasNext()) {
                        element$iv = var5_8.next();
                        it = (ChromeDevtoolsDriver)element$iv;
                        $i$a$-firstOrNull-ChromeDevtoolsBrowser$findDriver$4 = false;
                        $continuation.L$0 = this;
                        $continuation.L$1 = urlRegex;
                        $continuation.L$2 = var5_8;
                        $continuation.L$3 = element$iv;
                        $continuation.label = 1;
                        v0 = this.currentUrl((WebDriver)it, (Continuation<? super String>)$continuation);
                        if (v0 == var12_5) {
                            return var12_5;
                        }
                        ** GOTO lbl50
                    }
                    break;
                }
                case 1: {
                    $i$f$firstOrNull = false;
                    $i$a$-firstOrNull-ChromeDevtoolsBrowser$findDriver$4 = false;
                    element$iv = $continuation.L$3;
                    var5_8 = (Iterator)$continuation.L$2;
                    urlRegex = (Regex)$continuation.L$1;
                    this = (ChromeDevtoolsBrowser)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl50:
                    // 2 sources

                    if (!urlRegex.matches((CharSequence)v0)) ** GOTO lbl26
                    v1 = element$iv;
                    break block9;
                }
            }
            v1 = null;
        }
        return v1;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object findDrivers(@NotNull Regex var1_1, @NotNull Continuation<? super List<? extends WebDriver>> var2_2) {
        if (!(var2_2 instanceof findDrivers.1)) ** GOTO lbl-1000
        var13_3 = var2_2;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ ChromeDevtoolsBrowser this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.findDrivers(null, (Continuation<? super List<? extends WebDriver>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.recoverUnmanagedPages();
                $this$filterIsInstance$iv = this.getDrivers().values();
                $i$f$filterIsInstance = false;
                var5_8 = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ChromeDevtoolsDriver)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                var8_11 = $this$filterTo$iv$iv.iterator();
lbl29:
                // 3 sources

                while (var8_11.hasNext()) {
                    element$iv$iv = var8_11.next();
                    it = (ChromeDevtoolsDriver)element$iv$iv;
                    $i$a$-filter-ChromeDevtoolsBrowser$findDrivers$2 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = urlRegex;
                    $continuation.L$2 = destination$iv$iv;
                    $continuation.L$3 = var8_11;
                    $continuation.L$4 = element$iv$iv;
                    $continuation.label = 1;
                    v0 = this.currentUrl((WebDriver)it, (Continuation<? super String>)$continuation);
                    if (v0 == var14_5) {
                        return var14_5;
                    }
                    ** GOTO lbl56
                }
                break;
            }
            case 1: {
                $i$f$filter = false;
                $i$f$filterTo = false;
                $i$a$-filter-ChromeDevtoolsBrowser$findDrivers$2 = false;
                element$iv$iv = $continuation.L$4;
                var8_11 = (Iterator<T>)$continuation.L$3;
                destination$iv$iv = (Collection)$continuation.L$2;
                urlRegex = (Regex)$continuation.L$1;
                this = (ChromeDevtoolsBrowser)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl56:
                // 2 sources

                if (!urlRegex.matches((CharSequence)v0)) ** GOTO lbl29
                destination$iv$iv.add(element$iv$iv);
                ** GOTO lbl29
            }
        }
        return (List)destination$iv$iv;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public void destroyDriver(@NotNull WebDriver driver2) {
        Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
        if (driver2 instanceof ChromeDevtoolsDriver) {
            Object object;
            ChromeTab chromeTab = ((ChromeDevtoolsDriver)driver2).getChromeTab();
            String chromeTabId = chromeTab.getId();
            this.get_recoveredDrivers().remove(chromeTabId);
            this.get_reusedDrivers().remove(chromeTabId);
            this.get_drivers().remove(chromeTabId);
            Object object2 = this;
            try {
                ChromeDevtoolsBrowser $this$destroyDriver_u24lambda_u244 = object2;
                boolean bl = false;
                ((ChromeDevtoolsDriver)driver2).doClose();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl = false;
                LogsKt.warnForClose((Object)((Object)this), (Throwable)it);
            }
            try {
                this.closeTab(((ChromeDevtoolsDriver)driver2).getChromeTab());
            }
            catch (WebDriverException e) {
                if (this.isActive()) {
                    throw e;
                }
            }
            catch (Exception e) {
                LogsKt.warnInterruptible((Object)((Object)this), (Throwable)e, (String)"Failed to close tab", (Object[])new Object[0]);
            }
        }
    }

    public void maintain() {
        this.recoverUnmanagedPages();
        this.closeRecoveredIdleDrivers();
    }

    public synchronized void destroyForcibly() {
        block4: {
            Object object;
            Object object2 = this;
            try {
                Unit unit;
                ChromeDevtoolsBrowser $this$destroyForcibly_u24lambda_u246 = object2;
                boolean bl = false;
                $this$destroyForcibly_u24lambda_u246.close();
                ChromeLauncher chromeLauncher = $this$destroyForcibly_u24lambda_u246.launcher;
                if (chromeLauncher != null) {
                    chromeLauncher.destroyForcibly();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block4;
            Object it = object = throwable;
            boolean bl = false;
            LogsKt.warnForClose((Object)((Object)this), (Throwable)it);
        }
    }

    public void close() {
        block3: {
            Object object;
            if (!this.closed.compareAndSet(false, true)) break block3;
            try {
                boolean bl = false;
                this.doClose();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl = false;
                LogsKt.warnForClose((Object)((Object)this), (Throwable)it);
            }
        }
    }

    private final Object currentUrl(WebDriver driver2, Continuation<? super String> $completion) {
        return driver2.currentUrl($completion);
    }

    private final ChromeDevtoolsDriver newDriverIfAbsent(ChromeTab chromeTab, boolean recovered) {
        WebDriver driver2 = (WebDriver)this.get_drivers().get(chromeTab.getId());
        if (driver2 != null) {
            return (ChromeDevtoolsDriver)driver2;
        }
        driver2 = (WebDriver)this.doNewDriver(chromeTab, recovered);
        this.addToDriverTree(driver2);
        return (ChromeDevtoolsDriver)driver2;
    }

    private final ChromeDevtoolsDriver doNewDriver(ChromeTab chromeTab, boolean recovered) {
        if (!recovered && this.getReuseRecoveredDriver()) {
            Object v1;
            block4: {
                Collection collection = this.get_recoveredDrivers().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$firstOrNull$iv = collection;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    WebDriver it = (WebDriver)element$iv;
                    boolean bl = false;
                    if (!(it instanceof ChromeDevtoolsDriver && !((ChromeDevtoolsDriver)it).isReused())) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            WebDriver driver2 = v1;
            if (driver2 instanceof ChromeDevtoolsDriver) {
                ((ChromeDevtoolsDriver)driver2).setReused(true);
                ((Map)this.get_reusedDrivers()).put(((ChromeDevtoolsDriver)driver2).getChromeTab().getId(), driver2);
                this.logger.info("Reuse recovered driver | {}", (Object)chromeTab.getUrl());
                return (ChromeDevtoolsDriver)driver2;
            }
        }
        RemoteDevTools devTools = this.createDevTools(chromeTab, this.toolsConfig);
        ChromeDevtoolsDriver driver3 = new ChromeDevtoolsDriver(chromeTab, devTools, this.getBrowserSettings(), this);
        ((Map)this.get_drivers()).put(chromeTab.getId(), driver3);
        if (recovered) {
            driver3.setRecovered(true);
            ((Map)this.get_recoveredDrivers()).put(chromeTab.getId(), driver3);
        }
        return driver3;
    }

    private final void buildDriverTree() {
        Iterable $this$forEach$iv = this.getDrivers().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebDriver it = (WebDriver)element$iv;
            boolean bl = false;
            this.addToDriverTree(it);
        }
    }

    private final void addToDriverTree(WebDriver driver2) {
        WebDriver parent;
        String parentId;
        if (driver2 instanceof ChromeDevtoolsDriver && (parentId = ((ChromeDevtoolsDriver)driver2).getChromeTab().getParentId()) != null && (parent = (WebDriver)this.getDrivers().get(parentId)) instanceof ChromeDevtoolsDriver) {
            ((ChromeDevtoolsDriver)driver2).setOpener(parent);
            ((ChromeDevtoolsDriver)parent).getOutgoingPages().add(driver2);
            Object[] objectArray = new Object[]{((ChromeDevtoolsDriver)parent).getChromeTab().getUrl(), ((ChromeDevtoolsDriver)driver2).getChromeTab().getUrl(), ((ChromeDevtoolsDriver)driver2).getChromeTab().getId()};
            this.logger.info("Add driver to tree | parent: {}, child: {} | {}", objectArray);
        }
    }

    private final void recoverUnmanagedPages() {
        try {
            this.recoverUnmanagedPages0();
        }
        catch (WebDriverException e) {
            if (this.isActive()) {
                this.logger.warn("Failed to recover unmanaged pages | {}", (Object)e.getMessage());
            }
            this.logger.info("No page recovering, browser is closed.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void recoverUnmanagedPages0() throws WebDriverException {
        ChromeTab it;
        Object $this$filterTo$iv$iv;
        ChromeTab[] tabs = this.listTabs();
        Object $this$filter$iv = tabs;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it2 = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(!this.getDrivers().keySet().contains(it2.getId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            it = (ChromeTab)element$iv$iv;
            boolean bl = false;
            if (!it.isPageType()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            it = (ChromeTab)element$iv$iv;
            boolean bl = false;
            if (!UrlUtils.isStandard((String)it.getUrl())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChromeTab tab = (ChromeTab)element$iv;
            boolean bl = false;
            ChromeDevtoolsDriver driver2 = this.newDriverIfAbsent(tab, true);
            this.reportNewDriver(tab, (WebDriver)driver2);
        }
    }

    private final void reportNewDriver(ChromeTab tab, WebDriver driver2) {
        String parentId = tab.getParentId();
        if (parentId != null) {
            Object[] objectArray = new Object[6];
            objectArray[0] = tab.getId();
            objectArray[1] = tab.getParentId();
            objectArray[2] = driver2.getId();
            WebDriver webDriver = driver2.getOpener();
            objectArray[3] = webDriver != null ? Integer.valueOf(webDriver.getId()) : null;
            Object object = driver2.getOpener();
            objectArray[4] = object != null && (object = object.getOutgoingPages()) != null ? object.size() : 0;
            objectArray[5] = tab.getUrl();
            this.logger.info("Recover tab {} with parent: {} | driver: {}, opener: {}, siblings: {} | {}", objectArray);
        } else {
            Object[] objectArray = new Object[]{tab.getId(), driver2.getId(), tab.getUrl()};
            this.logger.info("Recover tab {} with no parent | driver: {} | {}", objectArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void closeRecoveredIdleDrivers() {
        void $this$filterTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.getDrivers().values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ChromeDevtoolsDriver)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List chromeDrivers = (List)destination$iv$iv;
        Duration pageLoadTimeout = this.getBrowserSettings().getInteractSettings().getPageLoadTimeout();
        long seconds = AppSystemInfo.Companion.isCriticalResources() ? 15L : pageLoadTimeout.getSeconds();
        Duration unmanagedTabTimeout = Duration.ofSeconds(seconds);
        Function1 isIdle2 = (Function1)new Function1<AbstractWebDriver, Boolean>(unmanagedTabTimeout){
            final /* synthetic */ Duration $unmanagedTabTimeout;
            {
                this.$unmanagedTabTimeout = $unmanagedTabTimeout;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull AbstractWebDriver driver2) {
                Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
                return Duration.between(driver2.getLastActiveTime(), Instant.now()).compareTo(this.$unmanagedTabTimeout) > 0;
            }
        };
        Iterable $this$filter$iv = chromeDrivers;
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChromeDevtoolsDriver it = (ChromeDevtoolsDriver)((Object)element$iv$iv);
            boolean bl = false;
            if (!(it.isRecovered() && !it.isReused() && (Boolean)isIdle2.invoke((Object)it) != false)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List unmanagedTimeoutDrivers = (List)destination$iv$iv2;
        if (!((Collection)unmanagedTimeoutDrivers).isEmpty()) {
            boolean hasHistory;
            ChromeDevtoolsDriver it;
            block8: {
                this.logger.debug("Closing {} unmanaged drivers", (Object)unmanagedTimeoutDrivers.size());
                Iterable $this$any$iv = unmanagedTimeoutDrivers;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (ChromeDevtoolsDriver)((Object)element$iv);
                        boolean bl = false;
                        if (!it.getNavigateHistory().isEmpty()) continue;
                        v0 = true;
                        break block8;
                    }
                    v0 = hasHistory = false;
                }
            }
            if (hasHistory) {
                this.logger.warn("Unmanaged driver should has no history, this indicates a bug");
            }
            Iterable $this$forEach$iv = unmanagedTimeoutDrivers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ChromeDevtoolsDriver)((Object)element$iv);
                boolean bl = false;
                this.destroyDriver((WebDriver)it);
            }
        }
    }

    private final void doClose() {
        this.closeDrivers();
        this.chrome.close();
        ChromeLauncher chromeLauncher = this.launcher;
        if (chromeLauncher != null) {
            chromeLauncher.close();
        }
        this.logger.info("Browser is closed successfully | #{}", (Object)this.getId().getDisplay());
    }

    private final void closeDrivers() {
        Collection collection = MapsKt.toList((Map)this.getDrivers());
        if (collection.isEmpty()) {
            boolean bl = false;
            return;
        }
        List dyingDrivers = (List)collection;
        this.get_recoveredDrivers().clear();
        this.get_reusedDrivers().clear();
        this.get_drivers().clear();
        this.logger.info("Closing browser with {} drivers/devtools ... | #{}", (Object)dyingDrivers.size(), (Object)this.getId());
        Iterable $this$forEach$iv = dyingDrivers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Throwable throwable;
            Object object;
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            String id = (String)pair.component1();
            WebDriver driver2 = (WebDriver)pair.component2();
            try {
                boolean bl2 = false;
                driver2.close();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            if (Result.exceptionOrNull-impl((Object)object) == null) continue;
            Throwable it = throwable;
            boolean bl3 = false;
            LogsKt.warnForClose((Object)((Object)this), (Throwable)it);
        }
    }

    private final synchronized RemoteDevTools createDevTools(ChromeTab tab, DevToolsConfig config) throws WebDriverException {
        Object object;
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)this.chrome.createDevTools(tab, config));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new WebDriverException("createDevTools", it);
        }
        return (RemoteDevTools)object;
    }

    public static final /* synthetic */ Object access$currentUrl(ChromeDevtoolsBrowser $this, WebDriver driver2, Continuation $completion) {
        return $this.currentUrl(driver2, (Continuation<? super String>)$completion);
    }
}

