/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver.cdt.detail;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.NavigateEntry;
import com.github.kklisura.cdt.protocol.v2023.events.network.RequestWillBeSent;
import com.github.kklisura.cdt.protocol.v2023.events.network.ResponseReceived;
import com.github.kklisura.cdt.protocol.v2023.types.network.ResourceType;
import com.github.kklisura.cdt.protocol.v2023.types.network.Response;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\rJ\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\rH\u0002J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lai/platon/pulsar/protocol/browser/driver/cdt/detail/ChromeNavigateEntry;", "", "navigateEntry", "Lai/platon/pulsar/skeleton/crawl/fetch/driver/NavigateEntry;", "(Lai/platon/pulsar/skeleton/crawl/fetch/driver/NavigateEntry;)V", "logger", "Lorg/slf4j/Logger;", "tracer", "isMajorRequestWillBeSent", "", "event", "Lcom/github/kklisura/cdt/protocol/v2023/events/network/RequestWillBeSent;", "isMajorResponseReceived", "Lcom/github/kklisura/cdt/protocol/v2023/events/network/ResponseReceived;", "isMinorResource", "type", "Lcom/github/kklisura/cdt/protocol/v2023/types/network/ResourceType;", "updateStateAfterResponseReceived", "", "updateStateAfterResponseReceived0", "updateStateBeforeRequestSent", "updateStateBeforeRequestSent0", "pulsar-protocol"})
@SourceDebugExtension(value={"SMAP\nChromeNavigateEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromeNavigateEntry.kt\nai/platon/pulsar/protocol/browser/driver/cdt/detail/ChromeNavigateEntry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public final class ChromeNavigateEntry {
    @NotNull
    private final NavigateEntry navigateEntry;
    @NotNull
    private final Logger logger;
    @Nullable
    private final Logger tracer;

    /*
     * WARNING - void declaration
     */
    public ChromeNavigateEntry(@NotNull NavigateEntry navigateEntry) {
        void it;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)navigateEntry, (String)"navigateEntry");
        this.navigateEntry = navigateEntry;
        Logger logger2 = logger = (this.logger = LogsKt.getLogger((Object)this));
        ChromeNavigateEntry chromeNavigateEntry = this;
        boolean bl = false;
        boolean bl2 = it.isTraceEnabled();
        chromeNavigateEntry.tracer = bl2 ? logger : null;
    }

    public final void updateStateBeforeRequestSent(@NotNull RequestWillBeSent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.updateStateBeforeRequestSent0(event);
    }

    public final void updateStateAfterResponseReceived(@NotNull ResponseReceived event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.updateStateAfterResponseReceived0(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMinorResource(@NotNull RequestWillBeSent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.navigateEntry.getDocumentTransferred()) return false;
        ResourceType resourceType = event.getType();
        Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"getType(...)");
        if (!this.isMinorResource(resourceType)) return false;
        return true;
    }

    private final void updateStateBeforeRequestSent0(RequestWillBeSent event) {
        int count2 = this.navigateEntry.getNetworkRequestCount().incrementAndGet();
        if (this.logger.isDebugEnabled() && count2 == 1 && event.getType() != ResourceType.DOCUMENT) {
            Object[] url;
            Object[] objectArray = url = event.getRequest().getUrl();
            Intrinsics.checkNotNull((Object)objectArray);
            if (StringsKt.startsWith$default((String)objectArray, (String)"data:", (boolean)false, (int)2, null)) {
                url = "data:xxx(...ignored)";
            }
            objectArray = new Object[]{event.getType(), this.navigateEntry.getNetworkRequestCount(), url};
            this.logger.debug("The resource type of the first request is {}, requests: {} | {}", objectArray);
        }
        if (this.isMajorRequestWillBeSent(event)) {
            String string = event.getRequestId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestId(...)");
            Map map = event.getRequest().getHeaders();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getHeaders(...)");
            this.navigateEntry.updateMainRequest(string, map);
        }
    }

    private final void updateStateAfterResponseReceived0(ResponseReceived event) {
        int count2 = this.navigateEntry.getNetworkResponseCount().incrementAndGet();
        Response response2 = event.getResponse();
        if (this.logger.isDebugEnabled() && count2 == 1 && event.getType() != ResourceType.DOCUMENT) {
            Object[] url;
            Object[] objectArray = url = response2.getUrl();
            Intrinsics.checkNotNull((Object)objectArray);
            if (StringsKt.startsWith$default((String)objectArray, (String)"data:", (boolean)false, (int)2, null)) {
                url = "data:xxx(...ignored)";
            }
            objectArray = new Object[]{event.getType(), this.navigateEntry.getNetworkResponseCount(), url};
            this.logger.debug("The resource type of the first response is {}, responses: {} | {}", objectArray);
        }
        if (this.isMajorResponseReceived(event)) {
            Logger logger = this.tracer;
            if (logger != null) {
                logger.trace("onResponseReceived | driver, document | {}", (Object)event.getRequestId());
            }
            Integer n = response2.getStatus();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getStatus(...)");
            int n2 = ((Number)n).intValue();
            String string = response2.getStatusText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatusText(...)");
            Map map = response2.getHeaders();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getHeaders(...)");
            this.navigateEntry.updateMainResponse(n2, string, map);
        }
    }

    private final boolean isMajorRequestWillBeSent(RequestWillBeSent event) {
        return !this.navigateEntry.getDocumentTransferred() && event.getType() == ResourceType.DOCUMENT;
    }

    private final boolean isMajorResponseReceived(ResponseReceived event) {
        return !this.navigateEntry.getDocumentTransferred() && event.getType() == ResourceType.DOCUMENT;
    }

    private final boolean isMinorResource(ResourceType type2) {
        Object[] objectArray = new ResourceType[]{ResourceType.FONT, ResourceType.MEDIA, ResourceType.IMAGE};
        return CollectionsKt.listOf((Object[])objectArray).contains(type2);
    }
}

