/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver.cdt.detail;

import ai.platon.pulsar.browser.driver.chrome.util.ChromeDriverException;
import ai.platon.pulsar.browser.driver.chrome.util.ChromeRPCException;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.event.AbstractEventEmitter;
import ai.platon.pulsar.protocol.browser.driver.cdt.ChromeDevtoolsDriver;
import ai.platon.pulsar.protocol.browser.driver.cdt.Credentials;
import ai.platon.pulsar.protocol.browser.driver.cdt.detail.CDPRequest;
import ai.platon.pulsar.protocol.browser.driver.cdt.detail.CDPResponse;
import ai.platon.pulsar.protocol.browser.driver.cdt.detail.NetworkEventManager;
import ai.platon.pulsar.protocol.browser.driver.cdt.detail.NetworkEvents;
import ai.platon.pulsar.protocol.browser.driver.cdt.detail.QueuedEventGroup;
import ai.platon.pulsar.protocol.browser.driver.cdt.detail.RedirectInfo;
import ai.platon.pulsar.protocol.browser.driver.cdt.detail.RobustRPC;
import com.github.kklisura.cdt.protocol.v2023.commands.Fetch;
import com.github.kklisura.cdt.protocol.v2023.commands.Network;
import com.github.kklisura.cdt.protocol.v2023.commands.Security;
import com.github.kklisura.cdt.protocol.v2023.events.fetch.AuthRequired;
import com.github.kklisura.cdt.protocol.v2023.events.fetch.RequestPaused;
import com.github.kklisura.cdt.protocol.v2023.events.network.LoadingFailed;
import com.github.kklisura.cdt.protocol.v2023.events.network.LoadingFinished;
import com.github.kklisura.cdt.protocol.v2023.events.network.RequestServedFromCache;
import com.github.kklisura.cdt.protocol.v2023.events.network.RequestWillBeSent;
import com.github.kklisura.cdt.protocol.v2023.events.network.RequestWillBeSentExtraInfo;
import com.github.kklisura.cdt.protocol.v2023.events.network.ResponseReceived;
import com.github.kklisura.cdt.protocol.v2023.events.network.ResponseReceivedExtraInfo;
import com.github.kklisura.cdt.protocol.v2023.types.fetch.AuthChallengeResponse;
import com.github.kklisura.cdt.protocol.v2023.types.fetch.AuthChallengeResponseResponse;
import com.github.kklisura.cdt.protocol.v2023.types.fetch.RequestPattern;
import com.github.kklisura.cdt.protocol.v2023.types.network.Request;
import com.github.kklisura.cdt.protocol.v2023.types.network.Response;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010;\u001a\u00020<2\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u00020\n2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020<2\u0006\u0010@\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u00020<2\u0006\u0010@\u001a\u00020EH\u0002J\u001a\u0010F\u001a\u00020<2\u0006\u0010@\u001a\u00020G2\b\u0010H\u001a\u0004\u0018\u00010IH\u0002J\u0018\u0010J\u001a\u00020<2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\u001dH\u0002J\"\u0010N\u001a\u00020<2\u0006\u0010K\u001a\u00020L2\u0006\u0010O\u001a\u00020P2\b\u0010H\u001a\u0004\u0018\u00010IH\u0002J\u0010\u0010Q\u001a\u00020<2\u0006\u0010@\u001a\u00020RH\u0002J\u0010\u0010S\u001a\u00020<2\u0006\u0010@\u001a\u00020CH\u0002J\u0010\u0010T\u001a\u00020<2\u0006\u0010@\u001a\u00020EH\u0002J\u001a\u0010U\u001a\u00020<2\u0006\u0010@\u001a\u00020>2\b\u0010V\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010W\u001a\u00020<2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010X\u001a\u00020<2\u0006\u0010@\u001a\u00020YH\u0002J\u0010\u0010Z\u001a\u00020<2\u0006\u0010@\u001a\u00020>H\u0002J\u0010\u0010[\u001a\u00020<2\u0006\u0010@\u001a\u00020\\H\u0002J\u0010\u0010]\u001a\u00020<2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010^\u001a\u00020<2\u0006\u0010@\u001a\u00020GH\u0002J\u0010\u0010_\u001a\u00020<2\u0006\u0010@\u001a\u00020IH\u0002J\u0018\u0010`\u001a\u00020<2\u0006\u0010a\u001a\u00020>2\u0006\u0010b\u001a\u00020AH\u0002J\u000e\u0010c\u001a\u00020<2\u0006\u0010d\u001a\u00020\u001dJ\u001a\u0010e\u001a\u00020<2\u0012\u0010f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0gJ\u000e\u0010h\u001a\u00020<2\u0006\u0010i\u001a\u00020\u001dJ\b\u0010j\u001a\u00020<H\u0002J\b\u0010k\u001a\u00020<H\u0002R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001fR\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\u0004\u0018\u00010&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u001f\"\u0004\b-\u0010!R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\u0004\u0018\u00010/8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0016\u00102\u001a\u0004\u0018\u00010$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u001a\u00105\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u001f\"\u0004\b7\u0010!R\u001a\u00108\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u001f\"\u0004\b:\u0010!\u00a8\u0006l"}, d2={"Lai/platon/pulsar/protocol/browser/driver/cdt/detail/NetworkManager;", "Lai/platon/pulsar/common/event/AbstractEventEmitter;", "Lai/platon/pulsar/protocol/browser/driver/cdt/detail/NetworkEvents;", "driver", "Lai/platon/pulsar/protocol/browser/driver/cdt/ChromeDevtoolsDriver;", "rpc", "Lai/platon/pulsar/protocol/browser/driver/cdt/detail/RobustRPC;", "(Lai/platon/pulsar/protocol/browser/driver/cdt/ChromeDevtoolsDriver;Lai/platon/pulsar/protocol/browser/driver/cdt/detail/RobustRPC;)V", "attemptedAuthentications", "", "", "getAttemptedAuthentications", "()Ljava/util/Set;", "credentials", "Lai/platon/pulsar/protocol/browser/driver/cdt/Credentials;", "getCredentials", "()Lai/platon/pulsar/protocol/browser/driver/cdt/Credentials;", "setCredentials", "(Lai/platon/pulsar/protocol/browser/driver/cdt/Credentials;)V", "extraHTTPHeaders", "", "", "getExtraHTTPHeaders", "()Ljava/util/Map;", "fetchAPI", "Lcom/github/kklisura/cdt/protocol/v2023/commands/Fetch;", "getFetchAPI", "()Lcom/github/kklisura/cdt/protocol/v2023/commands/Fetch;", "ignoreHTTPSErrors", "", "getIgnoreHTTPSErrors", "()Z", "setIgnoreHTTPSErrors", "(Z)V", "isActive", "logger", "Lorg/slf4j/Logger;", "networkAPI", "Lcom/github/kklisura/cdt/protocol/v2023/commands/Network;", "getNetworkAPI", "()Lcom/github/kklisura/cdt/protocol/v2023/commands/Network;", "networkEventManager", "Lai/platon/pulsar/protocol/browser/driver/cdt/detail/NetworkEventManager;", "protocolRequestInterceptionEnabled", "getProtocolRequestInterceptionEnabled", "setProtocolRequestInterceptionEnabled", "securityAPI", "Lcom/github/kklisura/cdt/protocol/v2023/commands/Security;", "getSecurityAPI", "()Lcom/github/kklisura/cdt/protocol/v2023/commands/Security;", "tracer", "getTracer", "()Lorg/slf4j/Logger;", "userCacheDisabled", "getUserCacheDisabled", "setUserCacheDisabled", "userRequestInterceptionEnabled", "getUserRequestInterceptionEnabled", "setUserRequestInterceptionEnabled", "authenticate", "", "computeRequestWillBeSentEvent", "Lcom/github/kklisura/cdt/protocol/v2023/events/network/RequestWillBeSent;", "networkRequestId", "event", "Lcom/github/kklisura/cdt/protocol/v2023/events/fetch/RequestPaused;", "emitLoadingFailed", "Lcom/github/kklisura/cdt/protocol/v2023/events/network/LoadingFailed;", "emitLoadingFinished", "Lcom/github/kklisura/cdt/protocol/v2023/events/network/LoadingFinished;", "emitResponseEvent", "Lcom/github/kklisura/cdt/protocol/v2023/events/network/ResponseReceived;", "extraInfo", "Lcom/github/kklisura/cdt/protocol/v2023/events/network/ResponseReceivedExtraInfo;", "forgetRequest", "request", "Lai/platon/pulsar/protocol/browser/driver/cdt/detail/CDPRequest;", "removeEvents", "handleRequestRedirect", "underlyingResponse", "Lcom/github/kklisura/cdt/protocol/v2023/types/network/Response;", "onAuthRequired", "Lcom/github/kklisura/cdt/protocol/v2023/events/fetch/AuthRequired;", "onLoadingFailed", "onLoadingFinished", "onRequest", "fetchRequestId", "onRequestPaused", "onRequestServedFromCache", "Lcom/github/kklisura/cdt/protocol/v2023/events/network/RequestServedFromCache;", "onRequestWillBeSent", "onRequestWillBeSentExtraInfo", "Lcom/github/kklisura/cdt/protocol/v2023/events/network/RequestWillBeSentExtraInfo;", "onRequestWithoutNetworkInstrumentation", "onResponseReceived", "onResponseReceivedExtraInfo", "patchRequestEventHeaders", "requestWillBeSent", "requestPaused", "setCacheEnabled", "enabled", "setExtraHTTPHeaders", "headers", "", "setRequestInterception", "value", "updateProtocolCacheDisabled", "updateProtocolRequestInterception", "pulsar-protocol"})
@SourceDebugExtension(value={"SMAP\nNetworkManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkManager.kt\nai/platon/pulsar/protocol/browser/driver/cdt/detail/NetworkManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,453:1\n1#2:454\n1253#3,4:455\n*S KotlinDebug\n*F\n+ 1 NetworkManager.kt\nai/platon/pulsar/protocol/browser/driver/cdt/detail/NetworkManager\n*L\n73#1:455,4\n*E\n"})
public final class NetworkManager
extends AbstractEventEmitter<NetworkEvents> {
    @NotNull
    private final ChromeDevtoolsDriver driver;
    @NotNull
    private final RobustRPC rpc;
    @NotNull
    private final Logger logger;
    @NotNull
    private final NetworkEventManager networkEventManager;
    private boolean ignoreHTTPSErrors;
    @NotNull
    private final Map<String, Object> extraHTTPHeaders;
    @Nullable
    private Credentials credentials;
    @NotNull
    private final Set<String> attemptedAuthentications;
    private boolean userRequestInterceptionEnabled;
    private boolean protocolRequestInterceptionEnabled;
    private boolean userCacheDisabled;

    public NetworkManager(@NotNull ChromeDevtoolsDriver driver2, @NotNull RobustRPC rpc) {
        Intrinsics.checkNotNullParameter((Object)((Object)driver2), (String)"driver");
        Intrinsics.checkNotNullParameter((Object)rpc, (String)"rpc");
        this.driver = driver2;
        this.rpc = rpc;
        this.logger = LogsKt.getLogger((Object)((Object)this));
        this.networkEventManager = new NetworkEventManager();
        this.ignoreHTTPSErrors = true;
        this.extraHTTPHeaders = new LinkedHashMap();
        this.attemptedAuthentications = new LinkedHashSet();
        Fetch fetch = this.getFetchAPI();
        if (fetch != null) {
            fetch.onRequestPaused(this::onRequestPaused);
        }
        Fetch fetch2 = this.getFetchAPI();
        if (fetch2 != null) {
            fetch2.onAuthRequired(this::onAuthRequired);
        }
        Network network = this.getNetworkAPI();
        if (network != null) {
            network.onRequestWillBeSent(this::onRequestWillBeSent);
        }
        Network network2 = this.getNetworkAPI();
        if (network2 != null) {
            network2.onRequestWillBeSentExtraInfo(this::onRequestWillBeSentExtraInfo);
        }
        Network network3 = this.getNetworkAPI();
        if (network3 != null) {
            network3.onRequestServedFromCache(this::onRequestServedFromCache);
        }
        Network network4 = this.getNetworkAPI();
        if (network4 != null) {
            network4.onResponseReceived(this::onResponseReceived);
        }
        Network network5 = this.getNetworkAPI();
        if (network5 != null) {
            network5.onLoadingFinished(this::onLoadingFinished);
        }
        Network network6 = this.getNetworkAPI();
        if (network6 != null) {
            network6.onLoadingFailed(this::onLoadingFailed);
        }
        Network network7 = this.getNetworkAPI();
        if (network7 != null) {
            network7.onResponseReceivedExtraInfo(this::onResponseReceivedExtraInfo);
        }
        if (this.ignoreHTTPSErrors) {
            RobustRPC.invokeSilently$default(this.rpc, "setIgnoreCertificateErrors", null, (Function0)new Function0<Unit>(){

                @Nullable
                public final Unit invoke() {
                    Unit unit;
                    Security security = this.getSecurityAPI();
                    if (security != null) {
                        security.enable();
                    }
                    Security security2 = this.getSecurityAPI();
                    if (security2 != null) {
                        security2.setIgnoreCertificateErrors(Boolean.valueOf(this.getIgnoreHTTPSErrors()));
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    return unit;
                }
            }, 2, null);
        }
        RobustRPC.invokeSilently$default(this.rpc, "enable", null, (Function0)new Function0<Unit>(){

            @Nullable
            public final Unit invoke() {
                Unit unit;
                Network network = this.getNetworkAPI();
                if (network != null) {
                    network.enable();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
        }, 2, null);
    }

    private final Logger getTracer() {
        Logger logger;
        Logger it = logger = this.logger;
        boolean bl = false;
        return it.isTraceEnabled() ? logger : null;
    }

    public final boolean isActive() {
        return this.driver.isActive();
    }

    private final Network getNetworkAPI() {
        Network network;
        Network it = network = this.driver.getDevTools().getNetwork();
        boolean bl = false;
        return this.isActive() ? network : null;
    }

    private final Fetch getFetchAPI() {
        Fetch fetch;
        Fetch it = fetch = this.driver.getDevTools().getFetch();
        boolean bl = false;
        return this.isActive() ? fetch : null;
    }

    private final Security getSecurityAPI() {
        Security security;
        Security it = security = this.driver.getDevTools().getSecurity();
        boolean bl = false;
        return this.isActive() ? security : null;
    }

    public final boolean getIgnoreHTTPSErrors() {
        return this.ignoreHTTPSErrors;
    }

    public final void setIgnoreHTTPSErrors(boolean bl) {
        this.ignoreHTTPSErrors = bl;
    }

    @NotNull
    public final Map<String, Object> getExtraHTTPHeaders() {
        return this.extraHTTPHeaders;
    }

    @Nullable
    public final Credentials getCredentials() {
        return this.credentials;
    }

    public final void setCredentials(@Nullable Credentials credentials) {
        this.credentials = credentials;
    }

    @NotNull
    public final Set<String> getAttemptedAuthentications() {
        return this.attemptedAuthentications;
    }

    public final boolean getUserRequestInterceptionEnabled() {
        return this.userRequestInterceptionEnabled;
    }

    public final void setUserRequestInterceptionEnabled(boolean bl) {
        this.userRequestInterceptionEnabled = bl;
    }

    public final boolean getProtocolRequestInterceptionEnabled() {
        return this.protocolRequestInterceptionEnabled;
    }

    public final void setProtocolRequestInterceptionEnabled(boolean bl) {
        this.protocolRequestInterceptionEnabled = bl;
    }

    public final boolean getUserCacheDisabled() {
        return this.userCacheDisabled;
    }

    public final void setUserCacheDisabled(boolean bl) {
        this.userCacheDisabled = bl;
    }

    public final void authenticate(@NotNull Credentials credentials) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        this.credentials = credentials;
        this.updateProtocolRequestInterception();
    }

    /*
     * WARNING - void declaration
     */
    public final void setExtraHTTPHeaders(@NotNull Map<String, String> headers) {
        void $this$associateTo$iv;
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.extraHTTPHeaders.clear();
        Iterable iterable = headers.entrySet();
        Map<String, Object> destination$iv = this.extraHTTPHeaders;
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            Map<String, Object> map = destination$iv;
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            String string = ((String)it.getKey()).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Pair pair = TuplesKt.to((Object)string, it.getValue());
            map.put((String)pair.getFirst(), pair.getSecond());
        }
        this.rpc.invoke("setExtraHTTPHeaders", (Function0)new Function0<Unit>(this){
            final /* synthetic */ NetworkManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Unit invoke() {
                Unit unit;
                Network network = NetworkManager.access$getNetworkAPI(this.this$0);
                if (network != null) {
                    network.setExtraHTTPHeaders(this.this$0.getExtraHTTPHeaders());
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
        });
    }

    public final void setCacheEnabled(boolean enabled) {
        this.userCacheDisabled = !enabled;
        this.updateProtocolCacheDisabled();
    }

    public final void setRequestInterception(boolean value) {
        this.userRequestInterceptionEnabled = value;
        this.updateProtocolRequestInterception();
    }

    private final void onAuthRequired(AuthRequired event) {
        AuthChallengeResponse authChallengeResponse;
        Logger logger = this.getTracer();
        if (logger != null) {
            logger.trace("onAuthRequired | {}", (Object)event.getRequestId());
        }
        AuthChallengeResponseResponse response2 = this.attemptedAuthentications.contains(event.getRequestId()) ? AuthChallengeResponseResponse.CANCEL_AUTH : (this.credentials != null ? AuthChallengeResponseResponse.PROVIDE_CREDENTIALS : AuthChallengeResponseResponse.DEFAULT);
        AuthChallengeResponse it = authChallengeResponse = new AuthChallengeResponse();
        boolean bl = false;
        it.setResponse(response2);
        Credentials credentials = this.credentials;
        it.setUsername(credentials != null ? credentials.getUsername() : null);
        Credentials credentials2 = this.credentials;
        it.setPassword(credentials2 != null ? credentials2.getPassword() : null);
        AuthChallengeResponse authChallengeResponse2 = authChallengeResponse;
        this.rpc.invokeSilently("continueWithAuth", event.getRequestId(), (Function0)new Function0<Unit>(this, event, authChallengeResponse2){
            final /* synthetic */ NetworkManager this$0;
            final /* synthetic */ AuthRequired $event;
            final /* synthetic */ AuthChallengeResponse $authChallengeResponse;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                this.$authChallengeResponse = $authChallengeResponse;
                super(0);
            }

            @Nullable
            public final Unit invoke() {
                Unit unit;
                Fetch fetch = NetworkManager.access$getFetchAPI(this.this$0);
                if (fetch != null) {
                    fetch.continueWithAuth(this.$event.getRequestId(), this.$authChallengeResponse);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
        });
    }

    private final void onRequestPaused(RequestPaused event) {
        Logger logger = this.getTracer();
        if (logger != null) {
            logger.trace("onRequestPaused | {}", (Object)event.getRequestId());
        }
        if (this.credentials != null && !this.protocolRequestInterceptionEnabled) {
            this.logger.warn("protocolRequestInterceptionEnabled should be true since credentials is set");
        }
        if (!this.userRequestInterceptionEnabled && this.protocolRequestInterceptionEnabled) {
            this.rpc.invokeSilently("continueRequest", event.getRequestId(), (Function0)new Function0<Unit>(this, event){
                final /* synthetic */ NetworkManager this$0;
                final /* synthetic */ RequestPaused $event;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    super(0);
                }

                @Nullable
                public final Unit invoke() {
                    Unit unit;
                    Fetch fetch = NetworkManager.access$getFetchAPI(this.this$0);
                    if (fetch != null) {
                        fetch.continueRequest(this.$event.getRequestId());
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    return unit;
                }
            });
        }
        String networkRequestId = event.getNetworkId();
        String fetchRequestId = event.getRequestId();
        if (networkRequestId == null) {
            this.onRequestWithoutNetworkInstrumentation(event);
            return;
        }
        RequestWillBeSent requestWillBeSentEvent = this.computeRequestWillBeSentEvent(networkRequestId, event);
        if (requestWillBeSentEvent != null) {
            this.patchRequestEventHeaders(requestWillBeSentEvent, event);
            this.onRequest(requestWillBeSentEvent, fetchRequestId);
        } else {
            this.networkEventManager.addRequestPausedEvent(networkRequestId, event);
        }
    }

    private final RequestWillBeSent computeRequestWillBeSentEvent(String networkRequestId, RequestPaused event) {
        boolean different;
        RequestWillBeSent willSentEvent = this.networkEventManager.getRequestWillBeSentEvent(networkRequestId);
        boolean bl = different = willSentEvent != null && (!Intrinsics.areEqual((Object)willSentEvent.getRequest().getUrl(), (Object)event.getRequest().getUrl()) || !Intrinsics.areEqual((Object)willSentEvent.getRequest().getMethod(), (Object)event.getRequest().getMethod()));
        if (different) {
            this.networkEventManager.removeRequestWillBeSentEvent(networkRequestId);
        }
        return !different ? willSentEvent : null;
    }

    /*
     * Unable to fully structure code
     */
    private final void onRequestWillBeSent(RequestWillBeSent event) {
        v0 = this.getTracer();
        if (v0 != null) {
            v0.trace("onRequestWillBeSent | {}", (Object)event.getRequestId());
        }
        this.emit((Object)NetworkEvents.RequestWillBeSent, event);
        url = event.getRequest().getUrl();
        if (!this.userRequestInterceptionEnabled) ** GOTO lbl-1000
        Intrinsics.checkNotNull((Object)url);
        if (!StringsKt.startsWith$default((String)url, (String)"data:", (boolean)false, (int)2, null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = intercept = false;
        }
        if (!intercept) {
            this.onRequest(event, null);
            return;
        }
        networkRequestId = event.getRequestId();
        Intrinsics.checkNotNull((Object)networkRequestId);
        this.networkEventManager.addRequestWillBeSentEvent(networkRequestId, event);
        requestPausedEvent = this.networkEventManager.getRequestPausedEvent(networkRequestId);
        if (requestPausedEvent != null) {
            fetchRequestId = requestPausedEvent.getRequestId();
            this.patchRequestEventHeaders(event, requestPausedEvent);
            this.onRequest(event, fetchRequestId);
            this.networkEventManager.removeRequestPausedEvent(networkRequestId);
        }
    }

    private final void onRequestWillBeSentExtraInfo(RequestWillBeSentExtraInfo event) {
        this.networkEventManager.addRequestWillBeSentExtraInfoEvent(event);
    }

    private final void onRequest(RequestWillBeSent event, String fetchRequestId) {
        CDPRequest request;
        CDPRequest cDPRequest;
        String requestId = event.getRequestId();
        Logger logger = this.getTracer();
        if (logger != null) {
            logger.trace("onRequest | {}", (Object)requestId);
        }
        Queue<WeakReference<CDPRequest>> redirectChain = new LinkedList();
        if (event.getRedirectResponse() != null) {
            ResponseReceivedExtraInfo redirectResponseExtraInfo = null;
            Boolean bl = event.getRedirectHasExtraInfo();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getRedirectHasExtraInfo(...)");
            if (bl.booleanValue()) {
                Intrinsics.checkNotNull((Object)requestId);
                redirectResponseExtraInfo = this.networkEventManager.takeFirstResponseExtraInfo(requestId);
                if (redirectResponseExtraInfo == null) {
                    this.networkEventManager.queueRedirectInfoEvent(requestId, new RedirectInfo(event, fetchRequestId));
                    return;
                }
            }
            Intrinsics.checkNotNull((Object)requestId);
            CDPRequest request2 = this.networkEventManager.getCDPRequest(requestId);
            if (request2 != null) {
                Response response2 = event.getRedirectResponse();
                Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"getRedirectResponse(...)");
                this.handleRequestRedirect(request2, response2, redirectResponseExtraInfo);
                redirectChain = request2.getRedirectChain();
            }
        }
        String frame = event.getFrameId();
        if (!Intrinsics.areEqual((Object)requestId, (Object)event.getRequestId())) {
            boolean $i$a$-require-NetworkManager$onRequest$22 = false;
            String $i$a$-require-NetworkManager$onRequest$22 = "Inconsistent request id: <" + event.getRequestId() + "> <- <" + requestId + ">";
            throw new IllegalArgumentException($i$a$-require-NetworkManager$onRequest$22.toString());
        }
        boolean allowInterception = this.userRequestInterceptionEnabled;
        Intrinsics.checkNotNull((Object)requestId);
        Request request3 = event.getRequest();
        Intrinsics.checkNotNullExpressionValue((Object)request3, (String)"getRequest(...)");
        CDPRequest it = cDPRequest = (request = new CDPRequest(this.driver, requestId, request3, fetchRequestId, allowInterception, redirectChain));
        boolean bl = false;
        it.setLoaderId(event.getLoaderId());
        it.setDocumentURL(event.getDocumentURL());
        it.setInitiator(event.getInitiator());
        it.setType(event.getType());
        this.networkEventManager.addRequest(requestId, request);
        this.emit((Object)NetworkEvents.Request, request);
        request.finalizeInterceptions();
    }

    private final void onRequestServedFromCache(RequestServedFromCache event) {
        CDPRequest request;
        Logger logger = this.getTracer();
        if (logger != null) {
            logger.trace("onRequestServedFromCache | {}", (Object)event.getRequestId());
        }
        String string = event.getRequestId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestId(...)");
        CDPRequest cDPRequest = request = this.networkEventManager.getCDPRequest(string);
        if (cDPRequest != null) {
            cDPRequest.setFromMemoryCache(true);
        }
        this.emit((Object)NetworkEvents.RequestServedFromCache, request);
    }

    private final void onResponseReceived(ResponseReceived event) {
        String requestId = event.getRequestId();
        Logger logger = this.getTracer();
        if (logger != null) {
            logger.trace("onResponseReceived | {}", (Object)requestId);
        }
        ResponseReceivedExtraInfo extraInfo = null;
        Intrinsics.checkNotNull((Object)requestId);
        CDPRequest request = this.networkEventManager.getCDPRequest(requestId);
        if (request != null && !request.getFromMemoryCache()) {
            Boolean bl = event.getHasExtraInfo();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getHasExtraInfo(...)");
            if (bl.booleanValue() && (extraInfo = this.networkEventManager.takeFirstResponseExtraInfo(requestId)) == null) {
                this.networkEventManager.addQueuedEventGroup(requestId, new QueuedEventGroup(event, null, null, 6, null));
                return;
            }
        }
        this.emit((Object)NetworkEvents.ResponseReceived, event);
        this.emitResponseEvent(event, extraInfo);
    }

    private final void onResponseReceivedExtraInfo(ResponseReceivedExtraInfo event) {
        String requestId = event.getRequestId();
        Logger logger = this.getTracer();
        if (logger != null) {
            logger.trace("onResponseReceivedExtraInfo | {}", (Object)event.getRequestId());
        }
        Intrinsics.checkNotNull((Object)requestId);
        RedirectInfo redirectInfo = this.networkEventManager.takeFirstRedirectInfoEvent(requestId);
        if (redirectInfo != null) {
            this.networkEventManager.addResponseExtraInfoEvent(requestId, event);
            this.onRequest(redirectInfo.getEvent(), redirectInfo.getFetchRequestId());
            return;
        }
        QueuedEventGroup queuedEvents = this.networkEventManager.getQueuedEventGroup(requestId);
        if (queuedEvents != null) {
            LoadingFinished it;
            this.networkEventManager.deleteQueuedEventGroup(requestId);
            this.emitResponseEvent(queuedEvents.getResponseReceivedEvent(), event);
            LoadingFinished loadingFinished = queuedEvents.getLoadingFinishedEvent();
            if (loadingFinished != null) {
                it = loadingFinished;
                boolean bl = false;
                this.emitLoadingFinished(it);
            }
            LoadingFailed loadingFailed = queuedEvents.getLoadingFailedEvent();
            if (loadingFailed != null) {
                it = loadingFailed;
                boolean bl = false;
                this.emitLoadingFailed((LoadingFailed)it);
            }
            return;
        }
        this.networkEventManager.addResponseExtraInfoEvent(requestId, event);
    }

    private final void patchRequestEventHeaders(RequestWillBeSent requestWillBeSent, RequestPaused requestPaused) {
        Map map = requestWillBeSent.getRequest().getHeaders();
        Map map2 = requestPaused.getRequest().getHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getHeaders(...)");
        map.putAll(map2);
    }

    private final void onRequestWithoutNetworkInstrumentation(RequestPaused event) {
        CDPRequest request;
        CDPRequest cDPRequest;
        String frame = event.getFrameId();
        String interceptionId = event.getRequestId();
        String string = event.getRequestId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestId(...)");
        Request request2 = event.getRequest();
        Intrinsics.checkNotNullExpressionValue((Object)request2, (String)"getRequest(...)");
        CDPRequest it = cDPRequest = (request = new CDPRequest(this.driver, string, request2, interceptionId, this.userRequestInterceptionEnabled, null, 32, null));
        boolean bl = false;
        this.emit((Object)NetworkEvents.Request, request);
        request.finalizeInterceptions();
    }

    private final void emitResponseEvent(ResponseReceived event, ResponseReceivedExtraInfo extraInfo) {
        String requestId = event.getRequestId();
        Intrinsics.checkNotNull((Object)requestId);
        CDPRequest cDPRequest = this.networkEventManager.getCDPRequest(requestId);
        if (cDPRequest == null) {
            return;
        }
        CDPRequest request = cDPRequest;
        List<ResponseReceivedExtraInfo> extraInfos = this.networkEventManager.computeResponseExtraInfoList(requestId);
        if (!((Collection)extraInfos).isEmpty()) {
            this.logger.debug("Unexpected extraInfo events for request | {} events | {}", (Object)extraInfos.size(), (Object)requestId);
        }
        ResponseReceivedExtraInfo extraInfo0 = extraInfo;
        Boolean bl = event.getResponse().getFromDiskCache();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getFromDiskCache(...)");
        if (bl.booleanValue()) {
            extraInfo0 = null;
        }
        Response response2 = event.getResponse();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"getResponse(...)");
        CDPResponse response3 = new CDPResponse(this.driver, request, response2, extraInfo0);
        request.setResponse(response3);
        this.emit((Object)NetworkEvents.Response, response3);
    }

    private final void handleRequestRedirect(CDPRequest request, Response underlyingResponse, ResponseReceivedExtraInfo extraInfo) {
        CDPResponse response2 = new CDPResponse(this.driver, request, underlyingResponse, extraInfo);
        request.setResponse(response2);
        request.getRedirectChain().add(new WeakReference<CDPRequest>(request));
        this.forgetRequest(request, false);
        this.emit((Object)NetworkEvents.Response, response2);
        this.emit((Object)NetworkEvents.RequestFinished, request);
    }

    private final void updateProtocolRequestInterception() {
        boolean enabled;
        boolean bl = enabled = this.userRequestInterceptionEnabled || this.credentials != null;
        if (enabled == this.protocolRequestInterceptionEnabled) {
            return;
        }
        this.protocolRequestInterceptionEnabled = enabled;
        this.updateProtocolCacheDisabled();
        if (enabled) {
            RequestPattern requestPattern;
            RequestPattern it = requestPattern = new RequestPattern();
            boolean bl2 = false;
            it.setUrlPattern("*");
            RequestPattern pattern = requestPattern;
            RobustRPC.invokeSilently$default(this.rpc, "enable", null, (Function0)new Function0<Unit>(this, pattern){
                final /* synthetic */ NetworkManager this$0;
                final /* synthetic */ RequestPattern $pattern;
                {
                    this.this$0 = $receiver;
                    this.$pattern = $pattern;
                    super(0);
                }

                @Nullable
                public final Unit invoke() {
                    Unit unit;
                    Fetch fetch = NetworkManager.access$getFetchAPI(this.this$0);
                    if (fetch != null) {
                        fetch.enable(CollectionsKt.listOf((Object)this.$pattern), Boolean.valueOf(true));
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    return unit;
                }
            }, 2, null);
        }
    }

    private final void forgetRequest(CDPRequest request, boolean removeEvents) {
        String requestId = request.getRequestId();
        String interceptionId = request.getInterceptionId();
        this.networkEventManager.removeRequest(requestId);
        if (interceptionId != null) {
            this.attemptedAuthentications.remove(interceptionId);
        }
        if (removeEvents) {
            this.networkEventManager.removeAll(requestId);
        }
    }

    private final void updateProtocolCacheDisabled() {
        try {
            this.rpc.invoke("setCacheDisabled", (Function0)new Function0<Unit>(this){
                final /* synthetic */ NetworkManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Unit invoke() {
                    Unit unit;
                    Network network = NetworkManager.access$getNetworkAPI(this.this$0);
                    if (network != null) {
                        network.setCacheDisabled(Boolean.valueOf(this.this$0.getUserCacheDisabled()));
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    return unit;
                }
            });
        }
        catch (ChromeRPCException e) {
            RobustRPC.handleChromeException$default(this.rpc, (ChromeDriverException)((Object)e), "setCacheDisabled", null, 4, null);
        }
    }

    private final void onLoadingFinished(LoadingFinished event) {
        String requestId = event.getRequestId();
        Logger logger = this.getTracer();
        if (logger != null) {
            logger.trace("onLoadingFinished | {}", (Object)event.getRequestId());
        }
        Intrinsics.checkNotNull((Object)requestId);
        QueuedEventGroup queuedEventGroup = this.networkEventManager.getQueuedEventGroup(requestId);
        if (queuedEventGroup != null) {
            queuedEventGroup.setLoadingFinishedEvent(event);
        } else {
            this.emitLoadingFinished(event);
        }
    }

    private final void emitLoadingFinished(LoadingFinished event) {
        String string = event.getRequestId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestId(...)");
        CDPRequest cDPRequest = this.networkEventManager.getCDPRequest(string);
        if (cDPRequest == null) {
            return;
        }
        CDPRequest request = cDPRequest;
        CDPResponse cDPResponse = request.getResponse();
        if (cDPResponse != null) {
            cDPResponse.resolveBody(null);
        }
        this.forgetRequest(request, true);
        this.emit((Object)NetworkEvents.RequestFinished, request);
    }

    private final void onLoadingFailed(LoadingFailed event) {
        String requestId = event.getRequestId();
        Logger logger = this.getTracer();
        if (logger != null) {
            logger.trace("onLoadingFailed | {}", (Object)event.getRequestId());
        }
        Intrinsics.checkNotNull((Object)requestId);
        QueuedEventGroup queuedEventGroup = this.networkEventManager.getQueuedEventGroup(requestId);
        if (queuedEventGroup != null) {
            queuedEventGroup.setLoadingFailedEvent(event);
        } else {
            this.emitLoadingFailed(event);
        }
    }

    private final void emitLoadingFailed(LoadingFailed event) {
        String requestId = event.getRequestId();
        Intrinsics.checkNotNull((Object)requestId);
        CDPRequest cDPRequest = this.networkEventManager.getCDPRequest(requestId);
        if (cDPRequest == null) {
            return;
        }
        CDPRequest request = cDPRequest;
        request.setFailureText$pulsar_protocol(event.getErrorText());
        CDPResponse cDPResponse = request.getResponse();
        if (cDPResponse != null) {
            cDPResponse.resolveBody(null);
        }
        this.forgetRequest(request, true);
        this.emit((Object)NetworkEvents.RequestFailed, request);
    }

    public static final /* synthetic */ Fetch access$getFetchAPI(NetworkManager $this) {
        return $this.getFetchAPI();
    }
}

