/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.emulator;

import ai.platon.pulsar.browser.common.BrowserSettings;
import ai.platon.pulsar.browser.common.InteractSettings;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.protocol.browser.emulator.NavigateTask;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.WebDriver;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\"\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006#"}, d2={"Lai/platon/pulsar/protocol/browser/emulator/InteractTask;", "", "navigateTask", "Lai/platon/pulsar/protocol/browser/emulator/NavigateTask;", "browserSettings", "Lai/platon/pulsar/browser/common/BrowserSettings;", "driver", "Lai/platon/pulsar/skeleton/crawl/fetch/driver/WebDriver;", "(Lai/platon/pulsar/protocol/browser/emulator/NavigateTask;Lai/platon/pulsar/browser/common/BrowserSettings;Lai/platon/pulsar/skeleton/crawl/fetch/driver/WebDriver;)V", "getBrowserSettings", "()Lai/platon/pulsar/browser/common/BrowserSettings;", "getDriver", "()Lai/platon/pulsar/skeleton/crawl/fetch/driver/WebDriver;", "interactSettings", "Lai/platon/pulsar/browser/common/InteractSettings;", "getInteractSettings", "()Lai/platon/pulsar/browser/common/InteractSettings;", "isCanceled", "", "()Z", "getNavigateTask", "()Lai/platon/pulsar/protocol/browser/emulator/NavigateTask;", "page", "Lai/platon/pulsar/persist/WebPage;", "getPage", "()Lai/platon/pulsar/persist/WebPage;", "pageConf", "Lai/platon/pulsar/common/config/VolatileConfig;", "getPageConf", "()Lai/platon/pulsar/common/config/VolatileConfig;", "url", "", "getUrl", "()Ljava/lang/String;", "supportDOM", "pulsar-protocol"})
public final class InteractTask {
    @NotNull
    private final NavigateTask navigateTask;
    @NotNull
    private final BrowserSettings browserSettings;
    @NotNull
    private final WebDriver driver;

    public InteractTask(@NotNull NavigateTask navigateTask, @NotNull BrowserSettings browserSettings, @NotNull WebDriver driver2) {
        Intrinsics.checkNotNullParameter((Object)navigateTask, (String)"navigateTask");
        Intrinsics.checkNotNullParameter((Object)browserSettings, (String)"browserSettings");
        Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
        this.navigateTask = navigateTask;
        this.browserSettings = browserSettings;
        this.driver = driver2;
    }

    @NotNull
    public final NavigateTask getNavigateTask() {
        return this.navigateTask;
    }

    @NotNull
    public final BrowserSettings getBrowserSettings() {
        return this.browserSettings;
    }

    @NotNull
    public final WebDriver getDriver() {
        return this.driver;
    }

    @NotNull
    public final String getUrl() {
        return this.navigateTask.getUrl();
    }

    @NotNull
    public final WebPage getPage() {
        return this.navigateTask.getPage();
    }

    public final boolean isCanceled() {
        return this.navigateTask.getFetchTask().getPage().isCanceled();
    }

    @NotNull
    public final VolatileConfig getPageConf() {
        VolatileConfig volatileConfig = this.navigateTask.getFetchTask().getPage().getConf();
        Intrinsics.checkNotNullExpressionValue((Object)volatileConfig, (String)"getConf(...)");
        return volatileConfig;
    }

    @NotNull
    public final InteractSettings getInteractSettings() {
        return this.navigateTask.getInteractSettings();
    }

    public final boolean supportDOM() {
        String string;
        String string2 = this.navigateTask.getPageDatum().getHeaders().get("Content-Type");
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String contentType = string;
        Object[] objectArray = new String[]{"text/html", "application/xhtml+xml", "text/xml", "application/xml"};
        List domMineTypes = CollectionsKt.listOf((Object[])objectArray);
        return contentType != null && domMineTypes.contains(contentType);
    }
}

