/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.emulator;

import ai.platon.pulsar.browser.common.BrowserSettings;
import ai.platon.pulsar.browser.common.InteractSettings;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.persist.PageDatum;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.skeleton.crawl.fetch.FetchTask;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.WebDriver;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0019\u0010+\u001a\n -*\u0004\u0018\u00010,0,\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010(\u00a8\u00062"}, d2={"Lai/platon/pulsar/protocol/browser/emulator/NavigateTask;", "", "fetchTask", "Lai/platon/pulsar/skeleton/crawl/fetch/FetchTask;", "driver", "Lai/platon/pulsar/skeleton/crawl/fetch/driver/WebDriver;", "browserSettings", "Lai/platon/pulsar/browser/common/BrowserSettings;", "(Lai/platon/pulsar/skeleton/crawl/fetch/FetchTask;Lai/platon/pulsar/skeleton/crawl/fetch/driver/WebDriver;Lai/platon/pulsar/browser/common/BrowserSettings;)V", "getBrowserSettings", "()Lai/platon/pulsar/browser/common/BrowserSettings;", "getDriver", "()Lai/platon/pulsar/skeleton/crawl/fetch/driver/WebDriver;", "getFetchTask", "()Lai/platon/pulsar/skeleton/crawl/fetch/FetchTask;", "interactSettings", "Lai/platon/pulsar/browser/common/InteractSettings;", "getInteractSettings", "()Lai/platon/pulsar/browser/common/InteractSettings;", "originalContentLength", "", "getOriginalContentLength", "()I", "setOriginalContentLength", "(I)V", "page", "Lai/platon/pulsar/persist/WebPage;", "getPage", "()Lai/platon/pulsar/persist/WebPage;", "pageConf", "Lai/platon/pulsar/common/config/VolatileConfig;", "getPageConf", "()Lai/platon/pulsar/common/config/VolatileConfig;", "pageDatum", "Lai/platon/pulsar/persist/PageDatum;", "getPageDatum", "()Lai/platon/pulsar/persist/PageDatum;", "pageSource", "", "getPageSource", "()Ljava/lang/String;", "setPageSource", "(Ljava/lang/String;)V", "startTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "getStartTime", "()Ljava/time/Instant;", "url", "getUrl", "pulsar-protocol"})
public final class NavigateTask {
    @NotNull
    private final FetchTask fetchTask;
    @NotNull
    private final WebDriver driver;
    @NotNull
    private final BrowserSettings browserSettings;
    private final Instant startTime;
    @NotNull
    private final PageDatum pageDatum;
    private int originalContentLength;
    @NotNull
    private String pageSource;

    public NavigateTask(@NotNull FetchTask fetchTask, @NotNull WebDriver driver2, @NotNull BrowserSettings browserSettings) {
        Intrinsics.checkNotNullParameter((Object)fetchTask, (String)"fetchTask");
        Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)browserSettings, (String)"browserSettings");
        this.fetchTask = fetchTask;
        this.driver = driver2;
        this.browserSettings = browserSettings;
        this.startTime = Instant.now();
        this.pageDatum = new PageDatum(this.getPage());
        this.originalContentLength = -1;
        this.pageSource = "";
        this.pageDatum.getHeaders().set("Q-Request-Time", String.valueOf(this.startTime.toEpochMilli()));
    }

    @NotNull
    public final FetchTask getFetchTask() {
        return this.fetchTask;
    }

    @NotNull
    public final WebDriver getDriver() {
        return this.driver;
    }

    @NotNull
    public final BrowserSettings getBrowserSettings() {
        return this.browserSettings;
    }

    public final Instant getStartTime() {
        return this.startTime;
    }

    @NotNull
    public final String getUrl() {
        return this.fetchTask.getUrl();
    }

    @NotNull
    public final WebPage getPage() {
        return this.fetchTask.getPage();
    }

    @NotNull
    public final VolatileConfig getPageConf() {
        VolatileConfig volatileConfig = this.fetchTask.getPage().getConf();
        Intrinsics.checkNotNullExpressionValue((Object)volatileConfig, (String)"getConf(...)");
        return volatileConfig;
    }

    @NotNull
    public final PageDatum getPageDatum() {
        return this.pageDatum;
    }

    public final int getOriginalContentLength() {
        return this.originalContentLength;
    }

    public final void setOriginalContentLength(int n) {
        this.originalContentLength = n;
    }

    @NotNull
    public final String getPageSource() {
        return this.pageSource;
    }

    public final void setPageSource(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.pageSource = string;
    }

    @NotNull
    public final InteractSettings getInteractSettings() {
        Object object = this.getPage().getVar("InteractSettings");
        InteractSettings interactSettings = object instanceof InteractSettings ? (InteractSettings)object : null;
        if (interactSettings == null) {
            interactSettings = InteractSettings.Companion.fromJson(this.getPageConf().get("browser.interact.settings"), this.browserSettings.getInteractSettings());
        }
        return interactSettings;
    }
}

