/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.emulator.context;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.proxy.ProxyException;
import ai.platon.pulsar.common.proxy.ProxyPoolManager;
import ai.platon.pulsar.protocol.browser.driver.WebDriverPoolManager;
import ai.platon.pulsar.protocol.browser.emulator.context.BrowserPrivacyContext;
import ai.platon.pulsar.skeleton.crawl.CoreMetrics;
import ai.platon.pulsar.skeleton.crawl.fetch.privacy.PrivacyAgent;
import ai.platon.pulsar.skeleton.crawl.fetch.privacy.PrivacyContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000fJ\u0006\u00104\u001a\u000202J\u000e\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u00020\u0012J\u000e\u00107\u001a\u0002082\u0006\u00106\u001a\u00020\u0012R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u00198F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001d\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u00198F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001bR\u0017\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000f0\"8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010$\u00a8\u00069"}, d2={"Lai/platon/pulsar/protocol/browser/emulator/context/ConcurrentStatefulPrivacyContextPool;", "", "proxyPoolManager", "Lai/platon/pulsar/common/proxy/ProxyPoolManager;", "driverPoolManager", "Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;", "coreMetrics", "Lai/platon/pulsar/skeleton/crawl/CoreMetrics;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "allowedPrivacyContextCount", "", "(Lai/platon/pulsar/common/proxy/ProxyPoolManager;Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;Lai/platon/pulsar/skeleton/crawl/CoreMetrics;Lai/platon/pulsar/common/config/ImmutableConfig;I)V", "_deadContexts", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lai/platon/pulsar/skeleton/crawl/fetch/privacy/PrivacyContext;", "_permanentContexts", "Ljava/util/concurrent/ConcurrentHashMap;", "Lai/platon/pulsar/skeleton/crawl/fetch/privacy/PrivacyAgent;", "_temporaryContexts", "_zombieContexts", "activeContextCount", "getActiveContextCount", "()I", "activeContexts", "", "getActiveContexts", "()Ljava/util/Map;", "getAllowedPrivacyContextCount", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "getCoreMetrics", "()Lai/platon/pulsar/skeleton/crawl/CoreMetrics;", "deadContexts", "Ljava/util/Deque;", "getDeadContexts", "()Ljava/util/Deque;", "getDriverPoolManager", "()Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;", "logger", "Lorg/slf4j/Logger;", "permanentContexts", "getPermanentContexts", "getProxyPoolManager", "()Lai/platon/pulsar/common/proxy/ProxyPoolManager;", "temporaryContexts", "getTemporaryContexts", "zombieContexts", "getZombieContexts", "close", "", "privacyContext", "closeDyingContexts", "computeIfAbsent", "privacyAgent", "createUnmanagedContext", "Lai/platon/pulsar/protocol/browser/emulator/context/BrowserPrivacyContext;", "pulsar-protocol"})
@SourceDebugExtension(value={"SMAP\nConcurrentStatefulPrivacyContextPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcurrentStatefulPrivacyContextPool.kt\nai/platon/pulsar/protocol/browser/emulator/context/ConcurrentStatefulPrivacyContextPool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n766#2:153\n857#2,2:154\n1855#2:156\n1856#2:158\n1#3:157\n*S KotlinDebug\n*F\n+ 1 ConcurrentStatefulPrivacyContextPool.kt\nai/platon/pulsar/protocol/browser/emulator/context/ConcurrentStatefulPrivacyContextPool\n*L\n121#1:153\n121#1:154,2\n128#1:156\n128#1:158\n*E\n"})
public final class ConcurrentStatefulPrivacyContextPool {
    @NotNull
    private final ProxyPoolManager proxyPoolManager;
    @NotNull
    private final WebDriverPoolManager driverPoolManager;
    @NotNull
    private final CoreMetrics coreMetrics;
    @NotNull
    private final ImmutableConfig conf;
    private final int allowedPrivacyContextCount;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<PrivacyAgent, PrivacyContext> _permanentContexts;
    @NotNull
    private final ConcurrentHashMap<PrivacyAgent, PrivacyContext> _temporaryContexts;
    @NotNull
    private final ConcurrentLinkedDeque<PrivacyContext> _zombieContexts;
    @NotNull
    private final ConcurrentLinkedDeque<PrivacyContext> _deadContexts;

    public ConcurrentStatefulPrivacyContextPool(@NotNull ProxyPoolManager proxyPoolManager, @NotNull WebDriverPoolManager driverPoolManager, @NotNull CoreMetrics coreMetrics, @NotNull ImmutableConfig conf, int allowedPrivacyContextCount) {
        Intrinsics.checkNotNullParameter((Object)proxyPoolManager, (String)"proxyPoolManager");
        Intrinsics.checkNotNullParameter((Object)driverPoolManager, (String)"driverPoolManager");
        Intrinsics.checkNotNullParameter((Object)coreMetrics, (String)"coreMetrics");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.proxyPoolManager = proxyPoolManager;
        this.driverPoolManager = driverPoolManager;
        this.coreMetrics = coreMetrics;
        this.conf = conf;
        this.allowedPrivacyContextCount = allowedPrivacyContextCount;
        this.logger = LogsKt.getLogger((Object)this);
        this._permanentContexts = new ConcurrentHashMap();
        this._temporaryContexts = new ConcurrentHashMap();
        this._zombieContexts = new ConcurrentLinkedDeque();
        this._deadContexts = new ConcurrentLinkedDeque();
    }

    @NotNull
    public final ProxyPoolManager getProxyPoolManager() {
        return this.proxyPoolManager;
    }

    @NotNull
    public final WebDriverPoolManager getDriverPoolManager() {
        return this.driverPoolManager;
    }

    @NotNull
    public final CoreMetrics getCoreMetrics() {
        return this.coreMetrics;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    public final int getAllowedPrivacyContextCount() {
        return this.allowedPrivacyContextCount;
    }

    @NotNull
    public final Map<PrivacyAgent, PrivacyContext> getPermanentContexts() {
        return this._permanentContexts;
    }

    @NotNull
    public final Map<PrivacyAgent, PrivacyContext> getTemporaryContexts() {
        return this._temporaryContexts;
    }

    @NotNull
    public final Deque<PrivacyContext> getZombieContexts() {
        return this._zombieContexts;
    }

    @NotNull
    public final Deque<PrivacyContext> getDeadContexts() {
        return this._deadContexts;
    }

    @NotNull
    public final synchronized Map<PrivacyAgent, PrivacyContext> getActiveContexts() {
        return MapsKt.plus(this.getPermanentContexts(), this.getTemporaryContexts());
    }

    public final synchronized int getActiveContextCount() {
        return this.getPermanentContexts().size() + this.getTemporaryContexts().size();
    }

    @NotNull
    public final PrivacyContext computeIfAbsent(@NotNull PrivacyAgent privacyAgent) throws ProxyException {
        PrivacyContext privacyContext;
        Intrinsics.checkNotNullParameter((Object)privacyAgent, (String)"privacyAgent");
        if (privacyAgent.isPermanent()) {
            PrivacyContext privacyContext2 = this._permanentContexts.computeIfAbsent(privacyAgent, arg_0 -> ConcurrentStatefulPrivacyContextPool.computeIfAbsent$lambda$0((Function1)new Function1<PrivacyAgent, PrivacyContext>(this, privacyAgent){
                final /* synthetic */ ConcurrentStatefulPrivacyContextPool this$0;
                final /* synthetic */ PrivacyAgent $privacyAgent;
                {
                    this.this$0 = $receiver;
                    this.$privacyAgent = $privacyAgent;
                    super(1);
                }

                @NotNull
                public final PrivacyContext invoke(@NotNull PrivacyAgent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (PrivacyContext)this.this$0.createUnmanagedContext(this.$privacyAgent);
                }
            }, arg_0));
            Intrinsics.checkNotNull((Object)privacyContext2);
            privacyContext = privacyContext2;
        } else {
            PrivacyContext privacyContext3 = this._temporaryContexts.computeIfAbsent(privacyAgent, arg_0 -> ConcurrentStatefulPrivacyContextPool.computeIfAbsent$lambda$1((Function1)new Function1<PrivacyAgent, PrivacyContext>(this, privacyAgent){
                final /* synthetic */ ConcurrentStatefulPrivacyContextPool this$0;
                final /* synthetic */ PrivacyAgent $privacyAgent;
                {
                    this.this$0 = $receiver;
                    this.$privacyAgent = $privacyAgent;
                    super(1);
                }

                @NotNull
                public final PrivacyContext invoke(@NotNull PrivacyAgent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (PrivacyContext)this.this$0.createUnmanagedContext(this.$privacyAgent);
                }
            }, arg_0));
            Intrinsics.checkNotNull((Object)privacyContext3);
            privacyContext = privacyContext3;
        }
        return privacyContext;
    }

    @NotNull
    public final BrowserPrivacyContext createUnmanagedContext(@NotNull PrivacyAgent privacyAgent) throws ProxyException {
        Intrinsics.checkNotNullParameter((Object)privacyAgent, (String)"privacyAgent");
        BrowserPrivacyContext context = new BrowserPrivacyContext(this.proxyPoolManager, this.driverPoolManager, this.coreMetrics, this.conf, privacyAgent);
        if (privacyAgent.isPermanent()) {
            this.logger.info("Permanent privacy context is created #{} | {}", (Object)context.getDisplay(), (Object)context.getBaseDir());
        } else if (privacyAgent.isTemporary()) {
            Object[] objectArray = new Object[]{context.getDisplay(), this.getTemporaryContexts().size(), this.allowedPrivacyContextCount, context.getBaseDir()};
            this.logger.info("Temporary privacy context is created #{}, active: {}, allowed: {} | {}", objectArray);
        } else if (privacyAgent.isGroup()) {
            Object[] objectArray = new Object[]{context.getDisplay(), this.getTemporaryContexts().size(), this.allowedPrivacyContextCount, context.getBaseDir()};
            this.logger.info("Sequential privacy context in group is created #{}, active: {}, allowed: {} | {}", objectArray);
        } else {
            this.logger.warn("Unexpected privacy context is created #{} | {}", (Object)context.getDisplay(), (Object)context.getBaseDir());
        }
        return context;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void closeDyingContexts() {
        void $this$filterTo$iv$iv;
        this.logger.debug("Closing zombie contexts ...");
        Iterable $this$filter$iv = this.getZombieContexts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PrivacyContext it = (PrivacyContext)element$iv$iv;
            boolean bl = false;
            if (!(!it.isClosed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List dyingContexts = (List)destination$iv$iv;
        if (dyingContexts.isEmpty()) {
            return;
        }
        this.logger.debug("Closing {} zombie contexts ...", (Object)dyingContexts.size());
        Iterable $this$forEach$iv = dyingContexts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            PrivacyContext privacyContext = (PrivacyContext)element$iv;
            boolean bl = false;
            Object object2 = privacyContext;
            try {
                PrivacyContext $this$closeDyingContexts_u24lambda_u245_u24lambda_u243 = object2;
                boolean bl2 = false;
                $this$closeDyingContexts_u24lambda_u245_u24lambda_u243.close();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl3 = false;
                LogsKt.warnForClose((Object)this, (Throwable)it);
            }
            this.getZombieContexts().remove(privacyContext);
            this.getDeadContexts().add(privacyContext);
        }
    }

    public final synchronized void close(@NotNull PrivacyContext privacyContext) {
        Intrinsics.checkNotNullParameter((Object)privacyContext, (String)"privacyContext");
        PrivacyAgent privacyAgent = privacyContext.getPrivacyAgent();
        this._permanentContexts.remove(privacyAgent);
        this._temporaryContexts.remove(privacyAgent);
        if (!this._zombieContexts.contains(privacyContext)) {
            this._zombieContexts.addFirst(privacyContext);
        }
        this.closeDyingContexts();
    }

    private static final PrivacyContext computeIfAbsent$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PrivacyContext)$tmp0.invoke(p0);
    }

    private static final PrivacyContext computeIfAbsent$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PrivacyContext)$tmp0.invoke(p0);
    }
}

