/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.emulator.context;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.IllegalApplicationStateException;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.MultiSinkWriter;
import ai.platon.pulsar.common.browser.Fingerprint;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.emoji.PopularEmoji;
import ai.platon.pulsar.common.proxy.ProxyException;
import ai.platon.pulsar.common.proxy.ProxyPoolManager;
import ai.platon.pulsar.persist.ProtocolStatus;
import ai.platon.pulsar.persist.RetryScope;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.protocol.browser.DefaultWebDriverPoolManager;
import ai.platon.pulsar.protocol.browser.driver.WebDriverPoolManager;
import ai.platon.pulsar.protocol.browser.emulator.context.AbstractBrowserPrivacyManager;
import ai.platon.pulsar.protocol.browser.emulator.context.BrowserPrivacyContext;
import ai.platon.pulsar.protocol.browser.emulator.context.MultiPrivacyContextManager;
import ai.platon.pulsar.skeleton.common.AppSystemInfo;
import ai.platon.pulsar.skeleton.common.metrics.AppMetricRegistry;
import ai.platon.pulsar.skeleton.common.metrics.MetricsSystem;
import ai.platon.pulsar.skeleton.common.metrics.MultiMetric;
import ai.platon.pulsar.skeleton.crawl.CoreMetrics;
import ai.platon.pulsar.skeleton.crawl.fetch.FetchResult;
import ai.platon.pulsar.skeleton.crawl.fetch.FetchTask;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.skeleton.crawl.fetch.privacy.AbstractPrivacyContext;
import ai.platon.pulsar.skeleton.crawl.fetch.privacy.PrivacyAgent;
import ai.platon.pulsar.skeleton.crawl.fetch.privacy.PrivacyAgentGenerator;
import ai.platon.pulsar.skeleton.crawl.fetch.privacy.PrivacyContext;
import ai.platon.pulsar.skeleton.crawl.fetch.privacy.PrivacyManager;
import com.codahale.metrics.Meter;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010)\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0016\u0018\u0000 h2\u00020\u0001:\u0002hiB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\rJ\b\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020BH\u0016J \u0010@\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020D2\u0006\u0010A\u001a\u00020B2\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020BH\u0016J \u0010G\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020D2\u0006\u0010A\u001a\u00020B2\u0006\u0010E\u001a\u00020FH\u0016J\u0018\u0010H\u001a\u00020?2\u0006\u0010C\u001a\u00020D2\u0006\u0010A\u001a\u00020BH\u0002J\u0010\u0010I\u001a\u00020J2\u0006\u0010>\u001a\u00020?H\u0016J\b\u0010K\u001a\u00020<H\u0002JH\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\u001b2\u0006\u0010E\u001a\u00020F2(\u0010O\u001a$\b\u0001\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020Q\u0012\n\u0012\b\u0012\u0004\u0012\u00020M0R\u0012\u0006\u0012\u0004\u0018\u00010S0PH\u0082@\u00a2\u0006\u0002\u0010TJ\b\u0010U\u001a\u00020<H\u0002J\b\u0010V\u001a\u00020<H\u0002J\u0010\u0010W\u001a\u00020X2\u0006\u0010N\u001a\u00020YH\u0002J\u0018\u0010Z\u001a\u00020<2\u0006\u0010[\u001a\u00020X2\u0006\u0010E\u001a\u00020FH\u0002J\u0018\u0010\\\u001a\u00020<2\u0006\u0010N\u001a\u00020Y2\u0006\u0010]\u001a\u00020MH\u0002J\u0010\u0010^\u001a\u00020<2\u0006\u0010_\u001a\u000207H\u0016J\b\u0010`\u001a\u00020<H\u0002J@\u0010a\u001a\u00020M2\u0006\u0010E\u001a\u00020F2(\u0010O\u001a$\b\u0001\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020Q\u0012\n\u0012\b\u0012\u0004\u0012\u00020M0R\u0012\u0006\u0012\u0004\u0018\u00010S0PH\u0096@\u00a2\u0006\u0002\u0010bJH\u0010c\u001a\u00020M2\u0006\u0010N\u001a\u00020\u001b2\u0006\u0010E\u001a\u00020F2(\u0010O\u001a$\b\u0001\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020Q\u0012\n\u0012\b\u0012\u0004\u0012\u00020M0R\u0012\u0006\u0012\u0004\u0018\u00010S0PH\u0082@\u00a2\u0006\u0002\u0010TJH\u0010d\u001a\u00020M2\u0006\u0010N\u001a\u00020\u001b2\u0006\u0010E\u001a\u00020F2(\u0010O\u001a$\b\u0001\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020Q\u0012\n\u0012\b\u0012\u0004\u0012\u00020M0R\u0012\u0006\u0012\u0004\u0018\u00010S0PH\u0082@\u00a2\u0006\u0002\u0010TJ\u0018\u0010e\u001a\u00020<2\u0006\u0010N\u001a\u00020Y2\u0006\u0010]\u001a\u00020MH\u0002J\b\u0010f\u001a\u00020\u001bH\u0002J\u0018\u0010g\u001a\u00020<2\u0006\u0010N\u001a\u00020Y2\u0006\u0010]\u001a\u00020MH\u0002R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u000fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0011R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0016\u0010,\u001a\n \u0018*\u0004\u0018\u00010-0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u00101\u001a\n \u0018*\u0004\u0018\u00010-0-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0014\u00106\u001a\u0002078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0010\u0010:\u001a\u0004\u0018\u00010\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lai/platon/pulsar/protocol/browser/emulator/context/MultiPrivacyContextManager;", "Lai/platon/pulsar/protocol/browser/emulator/context/AbstractBrowserPrivacyManager;", "driverPoolManager", "Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;", "(Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;)V", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "proxyPoolManager", "Lai/platon/pulsar/common/proxy/ProxyPoolManager;", "coreMetrics", "Lai/platon/pulsar/skeleton/crawl/CoreMetrics;", "(Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;Lai/platon/pulsar/common/proxy/ProxyPoolManager;Lai/platon/pulsar/skeleton/crawl/CoreMetrics;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "activeContextCount", "", "getActiveContextCount", "()I", "allowedPrivacyContextCount", "getAllowedPrivacyContextCount", "getCoreMetrics", "()Lai/platon/pulsar/skeleton/crawl/CoreMetrics;", "driverAbsenceReportTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "iterator", "", "Lai/platon/pulsar/skeleton/crawl/fetch/privacy/PrivacyContext;", "lastDumpTime", "lastMaintainTime", "logger", "Lorg/slf4j/Logger;", "maintainCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "getMaintainCount$pulsar_protocol", "()Ljava/util/concurrent/atomic/AtomicInteger;", "maxAllowedBadContexts", "getMaxAllowedBadContexts", "messageWriter", "Lai/platon/pulsar/common/MultiSinkWriter;", "metrics", "Lai/platon/pulsar/protocol/browser/emulator/context/MultiPrivacyContextManager$Metrics;", "getMetrics", "()Lai/platon/pulsar/protocol/browser/emulator/context/MultiPrivacyContextManager$Metrics;", "minMaintainInterval", "Ljava/time/Duration;", "numTasksAtLastReportTime", "", "snapshotDumpCount", "snapshotDumpInterval", "getSnapshotDumpInterval", "()Ljava/time/Duration;", "setSnapshotDumpInterval", "(Ljava/time/Duration;)V", "tooFrequentMaintenance", "", "getTooFrequentMaintenance", "()Z", "tracer", "closeDyingContexts", "", "computeIfAbsent", "privacyAgent", "Lai/platon/pulsar/skeleton/crawl/fetch/privacy/PrivacyAgent;", "computeIfNecessary", "fingerprint", "Lai/platon/pulsar/common/browser/Fingerprint;", "page", "Lai/platon/pulsar/persist/WebPage;", "task", "Lai/platon/pulsar/skeleton/crawl/fetch/FetchTask;", "computeNextContext", "createPrivacyAgent", "createUnmanagedContext", "Lai/platon/pulsar/protocol/browser/emulator/context/BrowserPrivacyContext;", "doMaintain", "doRun", "Lai/platon/pulsar/skeleton/crawl/fetch/FetchResult;", "privacyContext", "fetchFun", "Lkotlin/Function3;", "Lai/platon/pulsar/skeleton/crawl/fetch/driver/WebDriver;", "Lkotlin/coroutines/Continuation;", "", "(Lai/platon/pulsar/skeleton/crawl/fetch/privacy/PrivacyContext;Lai/platon/pulsar/skeleton/crawl/fetch/FetchTask;Lkotlin/jvm/functions/Function3;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dump", "dumpIfNecessary", "formatPrivacyContext", "", "Lai/platon/pulsar/skeleton/crawl/fetch/privacy/AbstractPrivacyContext;", "handleTooManyDriverAbsence", "errorMessage", "logPrivacyLeakWarning", "result", "maintain", "force", "reserveResourceForcefully", "run", "(Lai/platon/pulsar/skeleton/crawl/fetch/FetchTask;Lkotlin/jvm/functions/Function3;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runAndUpdate", "runIfPrivacyContextActive", "tracePrivacyContextInactive", "tryNextUnderLoadedPrivacyContext", "updatePrivacyContext", "Companion", "Metrics", "pulsar-protocol"})
@SourceDebugExtension(value={"SMAP\nMultiPrivacyContextManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiPrivacyContextManager.kt\nai/platon/pulsar/protocol/browser/emulator/context/MultiPrivacyContextManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,600:1\n1#2:601\n1855#3,2:602\n1855#3,2:611\n1855#3,2:620\n1855#3,2:629\n1855#3,2:638\n1855#3,2:640\n494#4,7:604\n494#4,7:613\n494#4,7:622\n494#4,7:631\n*S KotlinDebug\n*F\n+ 1 MultiPrivacyContextManager.kt\nai/platon/pulsar/protocol/browser/emulator/context/MultiPrivacyContextManager\n*L\n312#1:602,2\n373#1:611,2\n382#1:620,2\n389#1:629,2\n396#1:638,2\n588#1:640,2\n373#1:604,7\n382#1:613,7\n389#1:622,7\n396#1:631,7\n*E\n"})
public class MultiPrivacyContextManager
extends AbstractBrowserPrivacyManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final CoreMetrics coreMetrics;
    @NotNull
    private final Logger logger;
    @Nullable
    private final Logger tracer;
    private long numTasksAtLastReportTime;
    private final int maxAllowedBadContexts;
    @NotNull
    private final AtomicInteger maintainCount;
    private Instant lastMaintainTime;
    private final Duration minMaintainInterval;
    private Instant lastDumpTime;
    @NotNull
    private final AtomicInteger snapshotDumpCount;
    private Duration snapshotDumpInterval;
    @NotNull
    private final MultiSinkWriter messageWriter;
    private Instant driverAbsenceReportTime;
    @NotNull
    private final Iterator<PrivacyContext> iterator;
    @NotNull
    private final Metrics metrics;
    @NotNull
    private static final String VAR_CONTEXT_INFO = "CONTEXT_INFO";
    @NotNull
    private static final String SNAPSHOT_FILE_NAME = "privacy.context.snapshot.txt";
    private static final Path SNAPSHOT_PATH = AppPaths.INSTANCE.getTMP_DIR().resolve(SNAPSHOT_FILE_NAME);
    private static Duration SNAPSHOT_DUMP_INTERVAL = Duration.ofMinutes(1L);

    /*
     * WARNING - void declaration
     */
    public MultiPrivacyContextManager(@NotNull WebDriverPoolManager driverPoolManager, @Nullable ProxyPoolManager proxyPoolManager, @Nullable CoreMetrics coreMetrics, @NotNull ImmutableConfig conf) {
        void it;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)driverPoolManager, (String)"driverPoolManager");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(driverPoolManager, proxyPoolManager, conf);
        this.coreMetrics = coreMetrics;
        Logger logger2 = logger = (this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(MultiPrivacyContextManager.class)));
        MultiPrivacyContextManager multiPrivacyContextManager = this;
        boolean bl = false;
        boolean bl2 = it.isTraceEnabled();
        multiPrivacyContextManager.tracer = bl2 ? logger : null;
        this.maxAllowedBadContexts = 10;
        this.maintainCount = new AtomicInteger();
        this.lastMaintainTime = Instant.now();
        this.minMaintainInterval = Duration.ofSeconds(15L);
        this.lastDumpTime = Instant.now();
        this.snapshotDumpCount = new AtomicInteger();
        this.snapshotDumpInterval = SNAPSHOT_DUMP_INTERVAL;
        this.messageWriter = new MultiSinkWriter();
        this.driverAbsenceReportTime = Instant.EPOCH;
        this.iterator = Iterables.cycle((Iterable)this.getTemporaryContexts().values()).iterator();
        this.metrics = new Metrics();
    }

    public /* synthetic */ MultiPrivacyContextManager(WebDriverPoolManager webDriverPoolManager, ProxyPoolManager proxyPoolManager, CoreMetrics coreMetrics, ImmutableConfig immutableConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            proxyPoolManager = null;
        }
        if ((n & 4) != 0) {
            coreMetrics = null;
        }
        this(webDriverPoolManager, proxyPoolManager, coreMetrics, immutableConfig);
    }

    @Nullable
    public final CoreMetrics getCoreMetrics() {
        return this.coreMetrics;
    }

    private final int getAllowedPrivacyContextCount() {
        return this.getConf().getInt("privacy.context.number", 2);
    }

    public final int getMaxAllowedBadContexts() {
        return this.maxAllowedBadContexts;
    }

    @NotNull
    public final AtomicInteger getMaintainCount$pulsar_protocol() {
        return this.maintainCount;
    }

    private final boolean getTooFrequentMaintenance() {
        Instant instant = this.lastMaintainTime;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"lastMaintainTime");
        Duration duration = this.minMaintainInterval;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"minMaintainInterval");
        return DateTimes.INSTANCE.isNotExpired(instant, duration);
    }

    public final Duration getSnapshotDumpInterval() {
        return this.snapshotDumpInterval;
    }

    public final void setSnapshotDumpInterval(Duration duration) {
        this.snapshotDumpInterval = duration;
    }

    private final int getActiveContextCount() {
        return this.getPermanentContexts().size() + this.getTemporaryContexts().size();
    }

    @NotNull
    public final Metrics getMetrics() {
        return this.metrics;
    }

    public MultiPrivacyContextManager(@NotNull WebDriverPoolManager driverPoolManager) {
        Intrinsics.checkNotNullParameter((Object)driverPoolManager, (String)"driverPoolManager");
        this(driverPoolManager, null, null, driverPoolManager.getImmutableConfig());
    }

    public MultiPrivacyContextManager(@NotNull WebDriverPoolManager driverPoolManager, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)driverPoolManager, (String)"driverPoolManager");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(driverPoolManager, null, null, conf);
    }

    public MultiPrivacyContextManager(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(new DefaultWebDriverPoolManager(conf), conf);
    }

    @Nullable
    public Object run(@NotNull FetchTask task, @NotNull Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object> fetchFun, @NotNull Continuation<? super FetchResult> $completion) throws Exception {
        return MultiPrivacyContextManager.run$suspendImpl(this, task, fetchFun, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object run$suspendImpl(MultiPrivacyContextManager var0, FetchTask var1_1, Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object> var2_2, Continuation<? super FetchResult> var3_3) throws Exception {
        if (!(var3_3 instanceof run.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ MultiPrivacyContextManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MultiPrivacyContextManager.run$suspendImpl(this.this$0, null, null, (Continuation<? super FetchResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this.metrics.getTasks().mark();
                if (!$this.isActive()) {
                    return FetchResult.Companion.canceled((FetchTask)task, "Inactive privacy context manager");
                }
                privacyContext = $this.computeNextContext(task.getPage(), task.getFingerprint(), (FetchTask)task);
                $continuation.L$0 = $this;
                $continuation.label = 1;
                v0 = $this.runIfPrivacyContextActive(privacyContext, (FetchTask)task, (Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object>)fetchFun, (Continuation<? super FetchResult>)$continuation);
                if (v0 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                $this = (MultiPrivacyContextManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                var6_8 = v0;
                (FetchResult)var6_8;
                $i$a$-also-MultiPrivacyContextManager$run$result$1 = false;
                $this.metrics.getFinishes().mark();
                result = (FetchResult)var6_8;
                PrivacyManager.DefaultImpls.maintain$default((PrivacyManager)$this, (boolean)false, (int)1, null);
                return result;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public BrowserPrivacyContext createUnmanagedContext(@NotNull PrivacyAgent privacyAgent) throws ProxyException {
        Intrinsics.checkNotNullParameter((Object)privacyAgent, (String)"privacyAgent");
        BrowserPrivacyContext context = new BrowserPrivacyContext(this.getProxyPoolManager(), this.getDriverPoolManager(), this.coreMetrics, this.getConf(), privacyAgent);
        if (privacyAgent.isPermanent()) {
            this.logger.info("Permanent privacy context is created #{} | {}", (Object)context.getDisplay(), (Object)context.getBaseDir());
        } else if (privacyAgent.isTemporary()) {
            Object[] objectArray = new Object[]{context.getDisplay(), this.getTemporaryContexts().size(), this.getAllowedPrivacyContextCount(), context.getBaseDir()};
            this.logger.info("Temporary privacy context is created #{}, active: {}, allowed: {} | {}", objectArray);
        } else if (privacyAgent.isGroup()) {
            Object[] objectArray = new Object[]{context.getDisplay(), this.getTemporaryContexts().size(), this.getAllowedPrivacyContextCount(), context.getBaseDir()};
            this.logger.info("Sequential privacy context in group is created #{}, active: {}, allowed: {} | {}", objectArray);
        } else {
            this.logger.warn("Unexpected privacy context is created #{} | {}", (Object)context.getDisplay(), (Object)context.getBaseDir());
        }
        return context;
    }

    @NotNull
    public PrivacyContext computeNextContext(@NotNull WebPage page, @NotNull Fingerprint fingerprint, @NotNull FetchTask task) throws ProxyException {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        PrivacyContext context = this.computeIfNecessary(page, fingerprint, task);
        if (context.isActive()) {
            return context;
        }
        boolean bl2 = bl = !context.isActive();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.close(context);
        return this.computeIfAbsent(this.createPrivacyAgent(task.getPage(), fingerprint));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PrivacyContext computeIfNecessary(@NotNull WebPage page, @NotNull Fingerprint fingerprint, @NotNull FetchTask task) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Object object = this.getContextLifeCycleMonitor();
        synchronized (object) {
            PrivacyAgent privacyAgent;
            block6: {
                boolean bl = false;
                if (!this.isActive()) {
                    throw new IllegalApplicationStateException("Inactive privacy context manager");
                }
                privacyAgent = this.createPrivacyAgent(page, fingerprint);
                if (!privacyAgent.isPermanent()) break block6;
                this.reserveResourceForcefully();
                PrivacyContext privacyContext = this.computeIfAbsent(privacyAgent);
                return privacyContext;
            }
            if (this.getActiveContextCount() < this.getAllowedPrivacyContextCount()) {
                this.computeIfAbsent(privacyAgent);
            }
            PrivacyContext privacyContext = this.tryNextUnderLoadedPrivacyContext();
            return privacyContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PrivacyContext computeIfAbsent(@NotNull PrivacyAgent privacyAgent) throws ProxyException {
        Intrinsics.checkNotNullParameter((Object)privacyAgent, (String)"privacyAgent");
        Object object = this.getContextLifeCycleMonitor();
        synchronized (object) {
            PrivacyContext privacyContext;
            boolean bl = false;
            if (!this.isActive()) {
                throw new IllegalApplicationStateException("Inactive privacy context manager");
            }
            if (privacyAgent.isPermanent()) {
                var4_5 = this.getPermanentContexts().computeIfAbsent(privacyAgent, arg_0 -> MultiPrivacyContextManager.computeIfAbsent$lambda$5$lambda$3((Function1)new Function1<PrivacyAgent, PrivacyContext>(this, privacyAgent){
                    final /* synthetic */ MultiPrivacyContextManager this$0;
                    final /* synthetic */ PrivacyAgent $privacyAgent;
                    {
                        this.this$0 = $receiver;
                        this.$privacyAgent = $privacyAgent;
                        super(1);
                    }

                    @NotNull
                    public final PrivacyContext invoke(@NotNull PrivacyAgent it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return (PrivacyContext)this.this$0.createUnmanagedContext(this.$privacyAgent);
                    }
                }, arg_0));
                Intrinsics.checkNotNull((Object)var4_5);
                privacyContext = var4_5;
            } else {
                var4_5 = this.getTemporaryContexts().computeIfAbsent(privacyAgent, arg_0 -> MultiPrivacyContextManager.computeIfAbsent$lambda$5$lambda$4((Function1)new Function1<PrivacyAgent, PrivacyContext>(this, privacyAgent){
                    final /* synthetic */ MultiPrivacyContextManager this$0;
                    final /* synthetic */ PrivacyAgent $privacyAgent;
                    {
                        this.this$0 = $receiver;
                        this.$privacyAgent = $privacyAgent;
                        super(1);
                    }

                    @NotNull
                    public final PrivacyContext invoke(@NotNull PrivacyAgent it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return (PrivacyContext)this.this$0.createUnmanagedContext(this.$privacyAgent);
                    }
                }, arg_0));
                Intrinsics.checkNotNull((Object)var4_5);
                privacyContext = var4_5;
            }
            PrivacyContext privacyContext2 = privacyContext;
            return privacyContext2;
        }
    }

    @NotNull
    public PrivacyContext computeNextContext(@NotNull Fingerprint fingerprint) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        PrivacyContext context = this.computeIfNecessary(fingerprint);
        if (context.isActive()) {
            return context;
        }
        boolean bl2 = bl = !context.isActive();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.close(context);
        return this.computeIfAbsent(this.getPrivacyAgentGenerator().invoke(fingerprint));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PrivacyContext computeIfNecessary(@NotNull Fingerprint fingerprint) {
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Object object = this.getContextLifeCycleMonitor();
        synchronized (object) {
            boolean bl = false;
            if (!this.isActive()) {
                throw new IllegalApplicationStateException("Inactive privacy context manager");
            }
            if (this.getTemporaryContexts().size() < this.getAllowedPrivacyContextCount()) {
                PrivacyAgentGenerator generator = this.getPrivacyAgentGeneratorFactory().getGenerator();
                this.computeIfAbsent(generator.invoke(fingerprint));
            }
            PrivacyContext privacyContext = this.tryNextUnderLoadedPrivacyContext();
            return privacyContext;
        }
    }

    public void maintain(boolean force) {
        if (!force && this.getTooFrequentMaintenance()) {
            return;
        }
        this.lastMaintainTime = Instant.now();
        if (this.maintainCount.getAndIncrement() == 0) {
            this.logger.info("Maintaining service is started, minimal maintain interval: {}", (Object)this.minMaintainInterval);
        }
        this.doMaintain();
        this.lastMaintainTime = Instant.now();
    }

    private final void doMaintain() {
        this.closeDyingContexts();
        Iterable $this$forEach$iv = this.getActiveContexts().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PrivacyContext context = (PrivacyContext)element$iv;
            boolean bl = false;
            context.maintain();
        }
        this.dumpIfNecessary();
    }

    private final PrivacyAgent createPrivacyAgent(WebPage page, Fingerprint fingerprint) {
        Object specifiedPrivacyAgent = page.getVar(PrivacyAgent.class);
        if (specifiedPrivacyAgent instanceof PrivacyAgent) {
            return (PrivacyAgent)specifiedPrivacyAgent;
        }
        specifiedPrivacyAgent = page.getVar("VAR_PRIVACY_AGENT");
        if (specifiedPrivacyAgent instanceof PrivacyAgent) {
            return (PrivacyAgent)specifiedPrivacyAgent;
        }
        return this.getPrivacyAgentGeneratorFactory().getGenerator().invoke(fingerprint);
    }

    private final PrivacyContext tryNextUnderLoadedPrivacyContext() {
        int n = this.getTemporaryContexts().size();
        PrivacyContext privacyContext = this.iterator.next();
        Intrinsics.checkNotNullExpressionValue((Object)privacyContext, (String)"next(...)");
        PrivacyContext pc = privacyContext;
        while (n-- > 0 && pc.isFullCapacity()) {
            Intrinsics.checkNotNullExpressionValue((Object)this.iterator.next(), (String)"next(...)");
        }
        return pc;
    }

    private final void reserveResourceForcefully() {
        block1: {
            this.doMaintain();
            if (!AppSystemInfo.Companion.isCriticalResources()) break block1;
            Object[] objectArray = new Object[]{AppSystemInfo.Companion.formatAvailableMemory(), AppSystemInfo.Companion.formatMemoryToReserve(), AppSystemInfo.Companion.formatMemoryShortage()};
            this.logger.info("Critical resource, closing a temporary context | availableMem: {}, memToReserve: {}, shortage: {}", objectArray);
            Set set = this.getTemporaryContexts().entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            Map.Entry entry = (Map.Entry)CollectionsKt.firstOrNull((Iterable)set);
            if (entry != null) {
                Map.Entry it = entry;
                boolean bl = false;
                Object v = it.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                this.close((PrivacyContext)v);
            }
        }
    }

    private final void closeDyingContexts() {
        Map $this$filterValues$iv = this.getActiveContexts();
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            PrivacyContext it2 = (PrivacyContext)entry.getValue();
            boolean bl2 = false;
            if (!(!it2.isActive())) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Iterable $this$forEach$iv = ((Map)result$iv).values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PrivacyContext privacyContext = (PrivacyContext)element$iv;
            boolean bl = false;
            this.getPermanentContexts().remove(privacyContext.getPrivacyAgent());
            this.getTemporaryContexts().remove(privacyContext.getPrivacyAgent());
            Object[] bl2 = new Object[]{DateTimesKt.readable((Duration)privacyContext.getElapsedTime()), privacyContext.getDisplay(), privacyContext.getReadableState()};
            this.logger.info("Privacy context is inactive, closing it | {} | {} | {}", bl2);
            this.close(privacyContext);
        }
        $this$filterValues$iv = this.getTemporaryContexts();
        $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            PrivacyContext it3 = (PrivacyContext)entry.getValue();
            boolean bl3 = false;
            if (!it3.isIdle()) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        $this$forEach$iv = ((Map)result$iv).values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PrivacyContext privacyContext = (PrivacyContext)element$iv;
            boolean bl = false;
            this.getTemporaryContexts().remove(privacyContext.getPrivacyAgent());
            Object[] bl3 = new Object[]{DateTimesKt.readable((Duration)privacyContext.getIdleTime()), DateTimesKt.readable((Duration)privacyContext.getElapsedTime()), privacyContext.getDisplay(), privacyContext.getReadableState()};
            this.logger.warn("Privacy context hangs unexpectedly, closing it | {}/{} | {} | {}", bl3);
            this.close(privacyContext);
        }
        $this$filterValues$iv = this.getPermanentContexts();
        $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            PrivacyContext it4 = (PrivacyContext)entry.getValue();
            boolean bl4 = false;
            if (!it4.isIdle()) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        $this$forEach$iv = ((Map)result$iv).values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PrivacyContext privacyContext = (PrivacyContext)element$iv;
            boolean bl = false;
            this.getPermanentContexts().remove(privacyContext.getPrivacyAgent());
            Object[] bl4 = new Object[]{DateTimesKt.readable((Duration)privacyContext.getIdleTime()), DateTimesKt.readable((Duration)privacyContext.getElapsedTime()), privacyContext.getDisplay(), privacyContext.getReadableState()};
            this.logger.warn("Permanent privacy context is idle, closing it | {}/{} | {} | {}", bl4);
            this.close(privacyContext);
        }
        $this$filterValues$iv = this.getActiveContexts();
        $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            PrivacyContext it5 = (PrivacyContext)entry.getValue();
            boolean bl = false;
            if (!it5.isHighFailureRate()) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        $this$forEach$iv = ((Map)result$iv).values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PrivacyContext privacyContext = (PrivacyContext)element$iv;
            boolean bl = false;
            this.getPermanentContexts().remove(privacyContext.getPrivacyAgent());
            this.getTemporaryContexts().remove(privacyContext.getPrivacyAgent());
            Object[] objectArray = new Object[]{Float.valueOf(privacyContext.getFailureRate()), DateTimesKt.readable((Duration)privacyContext.getElapsedTime()), privacyContext.getDisplay(), privacyContext.getReadableState()};
            this.logger.warn("Privacy context has too high failure rate: {}, closing it | {} | {} | {}", objectArray);
            this.close(privacyContext);
        }
    }

    private final Object runIfPrivacyContextActive(PrivacyContext privacyContext, FetchTask task, Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object> fetchFun, Continuation<? super FetchResult> $completion) throws ProxyException, Exception {
        String errorMessage;
        if (!(privacyContext instanceof BrowserPrivacyContext)) {
            throw new ClassCastException("The privacy context should be a BrowserPrivacyContext | " + privacyContext.getClass());
        }
        if (privacyContext.isIdle()) {
            this.logger.warn("[Unexpected] Privacy is idle and can not perform tasks, closing it now");
            this.close(privacyContext);
            v0 = "PRIVACY CX IDLE";
        } else if (!privacyContext.isActive()) {
            this.logger.warn("[Unexpected] Privacy is inactive and can not perform tasks, closing it now");
            this.close(privacyContext);
            v0 = "PRIVACY CX NOT INACTIVE";
        } else {
            v0 = errorMessage = null;
        }
        if (errorMessage != null) {
            this.metrics.getIllegalDrivers().mark();
            if (this.metrics.getIllegalDrivers().getOneMinuteRate() > 5.0) {
                this.handleTooManyDriverAbsence(errorMessage, task);
            }
            return FetchResult.Companion.crawlRetry(task, errorMessage);
        }
        if (!privacyContext.hasWebDriverPromise()) {
            Duration duration = Duration.ofSeconds(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
            return FetchResult.Companion.crawlRetry(task, duration, "No driver available");
        }
        return this.runAndUpdate(privacyContext, task, fetchFun, $completion);
    }

    private final void handleTooManyDriverAbsence(String errorMessage, FetchTask task) {
        Instant now = Instant.now();
        if (Duration.between(this.driverAbsenceReportTime, now).getSeconds() > 10L) {
            this.driverAbsenceReportTime = now;
            Collection collection = this.getTemporaryContexts().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            String promisedDrivers2 = CollectionsKt.joinToString$default((Iterable)collection, null, null, null, (int)0, null, (Function1)handleTooManyDriverAbsence.promisedDrivers.1.INSTANCE, (int)31, null);
            Collection collection2 = this.getTemporaryContexts().values();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
            String states2 = CollectionsKt.joinToString$default((Iterable)collection2, null, null, null, (int)0, null, (Function1)handleTooManyDriverAbsence.states.1.INSTANCE, (int)31, null);
            Collection collection3 = this.getTemporaryContexts().values();
            Intrinsics.checkNotNullExpressionValue(collection3, (String)"<get-values>(...)");
            String idleTimes2 = CollectionsKt.joinToString$default((Iterable)collection3, null, null, null, (int)0, null, (Function1)handleTooManyDriverAbsence.idleTimes.1.INSTANCE, (int)31, null);
            Object[] objectArray = new Object[]{promisedDrivers2, errorMessage, states2, idleTimes2, task.getUrl()};
            this.logger.warn("Too many driver absence, promised drivers: {} | {} | {} | {} | {}", objectArray);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object runAndUpdate(PrivacyContext var1_1, FetchTask var2_2, Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object> var3_3, Continuation<? super FetchResult> var4_4) throws ProxyException, Exception {
        if (!(var4_4 instanceof runAndUpdate.1)) ** GOTO lbl-1000
        var7_5 = var4_4;
        if ((var7_5.label & -2147483648) != 0) {
            var7_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ MultiPrivacyContextManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MultiPrivacyContextManager.access$runAndUpdate(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = privacyContext;
                $continuation.label = 1;
                v0 = this.doRun(privacyContext, (FetchTask)task, (Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object>)fetchFun, (Continuation<? super FetchResult>)$continuation);
                if (v0 == var8_7) {
                    return var8_7;
                }
                ** GOTO lbl24
            }
            case 1: {
                privacyContext = (PrivacyContext)$continuation.L$1;
                this = (MultiPrivacyContextManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                result = (FetchResult)v0;
                Intrinsics.checkNotNull((Object)privacyContext, (String)"null cannot be cast to non-null type ai.platon.pulsar.skeleton.crawl.fetch.privacy.AbstractPrivacyContext");
                this.updatePrivacyContext((AbstractPrivacyContext)privacyContext, result);
                if (result.isPrivacyRetry()) {
                    result.getStatus().upgradeRetry(RetryScope.CRAWL);
                }
                return result;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object doRun(PrivacyContext var1_1, FetchTask var2_2, Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object> var3_3, Continuation<? super FetchResult> var4_4) throws ProxyException, Exception {
        if (!(var4_4 instanceof doRun.1)) ** GOTO lbl-1000
        var9_5 = var4_4;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ MultiPrivacyContextManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MultiPrivacyContextManager.access$doRun(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!(task.isCanceled() == false)) {
                    var7_8 = "Failed requirement.";
                    throw new IllegalArgumentException(var7_8.toString());
                }
                if (!(task.getState().get() == FetchTask.State.NOT_READY)) {
                    var7_9 = "Failed requirement.";
                    throw new IllegalArgumentException(var7_9.toString());
                }
                if (!(task.getProxyEntry() == null)) {
                    var7_10 = "Failed requirement.";
                    throw new IllegalArgumentException(var7_10.toString());
                }
                task.markReady();
                $continuation.L$0 = this;
                $continuation.L$1 = privacyContext;
                $continuation.L$2 = task;
                $continuation.label = 1;
                v0 = privacyContext.run(task, (Function3)new Function3<FetchTask, WebDriver, Continuation<? super FetchResult>, Object>(task, (Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object>)fetchFun, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ FetchTask $task;
                    final /* synthetic */ Function3<FetchTask, WebDriver, Continuation<? super FetchResult>, Object> $fetchFun;
                    {
                        this.$task = $task;
                        this.$fetchFun = $fetchFun;
                        super(3, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                WebDriver driver2 = (WebDriver)this.L$0;
                                this.$task.startWork();
                                this.label = 1;
                                Object object3 = this.$fetchFun.invoke((Object)this.$task, (Object)driver2, (Object)((Object)this));
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Nullable
                    public final Object invoke(@NotNull FetchTask p1, @NotNull WebDriver p2, @Nullable Continuation<? super FetchResult> p3) {
                        var var4_4 = new /* invalid duplicate definition of identical inner class */;
                        var4_4.L$0 = p2;
                        return var4_4.invokeSuspend(Unit.INSTANCE);
                    }
                }, (Continuation)$continuation);
                ** if (v0 != var10_7) goto lbl31
lbl30:
                // 1 sources

                return var10_7;
lbl31:
                // 1 sources

                ** GOTO lbl40
            }
            case 1: {
                task = (FetchTask)$continuation.L$2;
                privacyContext = (PrivacyContext)$continuation.L$1;
                this = (MultiPrivacyContextManager)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl40:
                    // 2 sources

                    var6_12 = (FetchResult)v0;
                }
                catch (Throwable var7_11) {
                    throw var7_11;
                }
                finally {
                    task.done();
                    v1 = task.getPage().getVariables();
                    Intrinsics.checkNotNull((Object)privacyContext, (String)"null cannot be cast to non-null type ai.platon.pulsar.skeleton.crawl.fetch.privacy.AbstractPrivacyContext");
                    v1.set(MultiPrivacyContextManager.VAR_CONTEXT_INFO, (Object)this.formatPrivacyContext((AbstractPrivacyContext)privacyContext));
                }
                result = var6_12;
                return result;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String formatPrivacyContext(AbstractPrivacyContext privacyContext) {
        String string = "%s(%.2f)";
        Object[] objectArray = new Object[]{privacyContext.getPrivacyAgent().getDisplay(), privacyContext.getMeterSuccesses().getMeanRate()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private final void updatePrivacyContext(AbstractPrivacyContext privacyContext, FetchResult result2) {
        if (!privacyContext.isActive()) {
            this.tracePrivacyContextInactive(privacyContext, result2);
            return;
        }
        long numTasks = privacyContext.getMeterTasks().getCount();
        if (numTasks > this.numTasksAtLastReportTime && numTasks % (long)30 == 0L) {
            this.numTasksAtLastReportTime = numTasks;
            privacyContext.report();
        }
        ProtocolStatus status = result2.getResponse().getProtocolStatus();
        if (status.isRetry()) {
            this.logPrivacyLeakWarning(privacyContext, result2);
        } else if (status.isSuccess()) {
            this.metrics.getSuccesses().mark();
        }
    }

    private final void logPrivacyLeakWarning(AbstractPrivacyContext privacyContext, FetchResult result2) {
        int warnings = privacyContext.getPrivacyLeakWarnings().get();
        ProtocolStatus status = result2.getStatus();
        if (warnings > 0) {
            String string;
            PopularEmoji symbol = PopularEmoji.WARNING;
            if (privacyContext.getPrivacyAgent().isPermanent()) {
                var8_6 = "%s/%s";
                var9_7 = new Object[]{warnings, privacyContext.getMaximumWarnings()};
                String string2 = String.format(var8_6, Arrays.copyOf(var9_7, var9_7.length));
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            } else {
                var8_6 = "%s";
                var9_7 = new Object[]{warnings};
                String string3 = String.format(var8_6, Arrays.copyOf(var9_7, var9_7.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            }
            String warningMessage = string;
            Object[] objectArray = new Object[]{warningMessage, privacyContext.getSeq(), privacyContext.getDisplay(), result2.getTask().getPage().getId(), status};
            this.logger.info(symbol + " Privacy leak warning {} | {}#{} | {}. {}", objectArray);
        }
        if (privacyContext.getPrivacyLeakWarnings().get() == 6) {
            privacyContext.report();
        }
    }

    private final void tracePrivacyContextInactive(AbstractPrivacyContext privacyContext, FetchResult result2) {
        block0: {
            Logger logger = this.tracer;
            if (logger == null) break block0;
            Object[] objectArray = new Object[]{result2.getTask().getId(), privacyContext.getSeq(), privacyContext.getPrivacyLeakWarnings(), result2.getStatus(), result2.getTask().getUrl()};
            logger.trace("{}. Context {}/#{} is not active | {} | {}", objectArray);
        }
    }

    private final void dumpIfNecessary() {
        Instant instant = this.lastDumpTime;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"lastDumpTime");
        Duration duration = this.snapshotDumpInterval;
        Intrinsics.checkNotNull((Object)duration);
        if (DateTimes.INSTANCE.isExpired(instant, duration)) {
            this.lastDumpTime = Instant.now();
            this.dump();
        }
    }

    private final void dump() {
        try {
            if (this.getActiveContexts().isEmpty()) {
                return;
            }
            int count2 = this.snapshotDumpCount.incrementAndGet();
            StringBuilder sb = new StringBuilder();
            sb.append("\n\n\n" + count2 + ". Privacy contexts snapshot \n");
            StringBuilder stringBuilder = sb.append(LocalDateTime.now());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
            sb.append("------------------------------");
            String[] stringArray = new String[]{"\n", this.buildStatusString()};
            StringsKt.append((StringBuilder)sb, (String[])stringArray);
            sb.append("\n");
            sb.append("\n");
            Iterable $this$forEach$iv = this.getActiveContexts().values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PrivacyContext it = (PrivacyContext)element$iv;
                boolean bl = false;
                sb.append(it.buildReport());
            }
            sb.append("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Path path = SNAPSHOT_PATH;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"SNAPSHOT_PATH");
            this.messageWriter.writeTo(string, path);
        }
        catch (IOException e) {
            this.logger.warn(ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
        }
    }

    private static final PrivacyContext computeIfAbsent$lambda$5$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PrivacyContext)$tmp0.invoke(p0);
    }

    private static final PrivacyContext computeIfAbsent$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PrivacyContext)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Object access$runIfPrivacyContextActive(MultiPrivacyContextManager $this, PrivacyContext privacyContext, FetchTask task, Function3 fetchFun, Continuation $completion) {
        return $this.runIfPrivacyContextActive(privacyContext, task, (Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object>)fetchFun, (Continuation<? super FetchResult>)$completion);
    }

    public static final /* synthetic */ Object access$runAndUpdate(MultiPrivacyContextManager $this, PrivacyContext privacyContext, FetchTask task, Function3 fetchFun, Continuation $completion) {
        return $this.runAndUpdate(privacyContext, task, (Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object>)fetchFun, (Continuation<? super FetchResult>)$completion);
    }

    public static final /* synthetic */ Object access$doRun(MultiPrivacyContextManager $this, PrivacyContext privacyContext, FetchTask task, Function3 fetchFun, Continuation $completion) {
        return $this.doRun(privacyContext, task, (Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object>)fetchFun, (Continuation<? super FetchResult>)$completion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\n \u0005*\u0004\u0018\u00010\u000f0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u0006\u0014"}, d2={"Lai/platon/pulsar/protocol/browser/emulator/context/MultiPrivacyContextManager$Companion;", "", "()V", "SNAPSHOT_DUMP_INTERVAL", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getSNAPSHOT_DUMP_INTERVAL", "()Ljava/time/Duration;", "setSNAPSHOT_DUMP_INTERVAL", "(Ljava/time/Duration;)V", "SNAPSHOT_FILE_NAME", "", "getSNAPSHOT_FILE_NAME", "()Ljava/lang/String;", "SNAPSHOT_PATH", "Ljava/nio/file/Path;", "getSNAPSHOT_PATH", "()Ljava/nio/file/Path;", "VAR_CONTEXT_INFO", "getVAR_CONTEXT_INFO", "pulsar-protocol"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getVAR_CONTEXT_INFO() {
            return VAR_CONTEXT_INFO;
        }

        @NotNull
        public final String getSNAPSHOT_FILE_NAME() {
            return SNAPSHOT_FILE_NAME;
        }

        public final Path getSNAPSHOT_PATH() {
            return SNAPSHOT_PATH;
        }

        public final Duration getSNAPSHOT_DUMP_INTERVAL() {
            return SNAPSHOT_DUMP_INTERVAL;
        }

        public final void setSNAPSHOT_DUMP_INTERVAL(Duration duration) {
            SNAPSHOT_DUMP_INTERVAL = duration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lai/platon/pulsar/protocol/browser/emulator/context/MultiPrivacyContextManager$Metrics;", "", "()V", "finishes", "Lai/platon/pulsar/skeleton/common/metrics/MultiMetric;", "getFinishes", "()Lai/platon/pulsar/skeleton/common/metrics/MultiMetric;", "illegalDrivers", "Lcom/codahale/metrics/Meter;", "getIllegalDrivers", "()Lcom/codahale/metrics/Meter;", "registry", "Lai/platon/pulsar/skeleton/common/metrics/AppMetricRegistry;", "successes", "getSuccesses", "tasks", "getTasks", "pulsar-protocol"})
    public static final class Metrics {
        @NotNull
        private final AppMetricRegistry registry = MetricsSystem.Companion.getReg();
        @NotNull
        private final MultiMetric tasks = this.registry.multiMetric((Object)this, "tasks");
        @NotNull
        private final MultiMetric successes = this.registry.multiMetric((Object)this, "successes");
        @NotNull
        private final MultiMetric finishes = this.registry.multiMetric((Object)this, "finishes");
        @NotNull
        private final Meter illegalDrivers = this.registry.meter((Object)this, "illegalDrivers");

        @NotNull
        public final MultiMetric getTasks() {
            return this.tasks;
        }

        @NotNull
        public final MultiMetric getSuccesses() {
            return this.successes;
        }

        @NotNull
        public final MultiMetric getFinishes() {
            return this.finishes;
        }

        @NotNull
        public final Meter getIllegalDrivers() {
            return this.illegalDrivers;
        }
    }
}

