/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.emulator.context;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.protocol.browser.driver.WebDriverPoolManager;
import ai.platon.pulsar.protocol.browser.emulator.context.WebDriverContext;
import ai.platon.pulsar.skeleton.common.AppSystemInfo;
import ai.platon.pulsar.skeleton.common.metrics.MetricsSystem;
import ai.platon.pulsar.skeleton.crawl.fetch.FetchResult;
import ai.platon.pulsar.skeleton.crawl.fetch.FetchTask;
import ai.platon.pulsar.skeleton.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.skeleton.crawl.fetch.privacy.BrowserId;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 52\u00020\u0001:\u00015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u001fH\u0002J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0002J\b\u0010&\u001a\u00020$H\u0002J\b\u0010'\u001a\u00020$H\u0016J@\u0010(\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001f2(\u0010)\u001a$\b\u0001\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020+\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0,\u0012\u0006\u0012\u0004\u0018\u00010-0*H\u0086@\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020$H\u0002J\u0010\u00100\u001a\u00020$2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020$2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00104\u001a\u00020$2\u0006\u00101\u001a\u000202H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lai/platon/pulsar/protocol/browser/emulator/context/WebDriverContext;", "Ljava/lang/AutoCloseable;", "browserId", "Lai/platon/pulsar/skeleton/crawl/fetch/privacy/BrowserId;", "driverPoolManager", "Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/skeleton/crawl/fetch/privacy/BrowserId;Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getBrowserId", "()Lai/platon/pulsar/skeleton/crawl/fetch/privacy/BrowserId;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "getDriverPoolManager", "()Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;", "isActive", "", "()Z", "isReady", "isRetired", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "logger", "Lorg/slf4j/Logger;", "notBusy", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "runningTasks", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lai/platon/pulsar/skeleton/crawl/fetch/FetchTask;", "checkAbnormalResult", "Lai/platon/pulsar/skeleton/crawl/fetch/FetchResult;", "task", "close", "", "closeContext", "closeUnderlyingLayerGracefully", "maintain", "run", "browseFun", "Lkotlin/Function3;", "Lai/platon/pulsar/skeleton/crawl/fetch/driver/WebDriver;", "Lkotlin/coroutines/Continuation;", "", "(Lai/platon/pulsar/skeleton/crawl/fetch/FetchTask;Lkotlin/jvm/functions/Function3;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shutdownUnderlyingLayerImmediately", "waitUntilAllDoneNormally", "timeout", "Ljava/time/Duration;", "waitUntilIdle", "waitUntilNoRunningTasks", "Companion", "pulsar-protocol"})
@SourceDebugExtension(value={"SMAP\nWebDriverContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebDriverContext.kt\nai/platon/pulsar/protocol/browser/emulator/context/WebDriverContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1#2:252\n1855#3,2:253\n1855#3,2:255\n*S KotlinDebug\n*F\n+ 1 WebDriverContext.kt\nai/platon/pulsar/protocol/browser/emulator/context/WebDriverContext\n*L\n183#1:253,2\n193#1:255,2\n*E\n"})
public class WebDriverContext
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BrowserId browserId;
    @NotNull
    private final WebDriverPoolManager driverPoolManager;
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConcurrentLinkedDeque<FetchTask> runningTasks;
    @NotNull
    private final ReentrantLock lock;
    private final Condition notBusy;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private static final AtomicInteger numGlobalRunningTasks = new AtomicInteger();
    @NotNull
    private static final Meter globalTasks = MetricsSystem.Companion.getReg().meter((Object)Companion, "globalTasks");
    @NotNull
    private static final Meter globalFinishedTasks = MetricsSystem.Companion.getReg().meter((Object)Companion, "globalFinishedTasks");

    public WebDriverContext(@NotNull BrowserId browserId, @NotNull WebDriverPoolManager driverPoolManager, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        Intrinsics.checkNotNullParameter((Object)driverPoolManager, (String)"driverPoolManager");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.browserId = browserId;
        this.driverPoolManager = driverPoolManager;
        this.conf = conf;
        Logger logger = LoggerFactory.getLogger(WebDriverContext.class);
        Intrinsics.checkNotNull((Object)logger);
        this.logger = logger;
        this.runningTasks = new ConcurrentLinkedDeque();
        this.lock = new ReentrantLock();
        this.notBusy = this.lock.newCondition();
        this.closed = new AtomicBoolean();
    }

    @NotNull
    public final BrowserId getBrowserId() {
        return this.browserId;
    }

    @NotNull
    public final WebDriverPoolManager getDriverPoolManager() {
        return this.driverPoolManager;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    public boolean isActive() {
        return !this.closed.get() && AppContext.INSTANCE.isActive();
    }

    public boolean isRetired() {
        return this.driverPoolManager.isRetiredPool(this.browserId);
    }

    public boolean isReady() {
        boolean isDriverPoolReady = this.driverPoolManager.isReady() && this.driverPoolManager.hasDriverPromise(this.browserId);
        return this.isActive() && isDriverPoolReady;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final Object run(@NotNull FetchTask var1_1, @NotNull Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object> var2_2, @NotNull Continuation<? super FetchResult> var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void maintain() throws Exception {
    }

    @Override
    public void close() {
        block4: {
            Object object;
            block5: {
                Object $this$close_u24lambda_u241;
                if (!this.closed.compareAndSet(false, true)) break block4;
                if (AppContext.INSTANCE.isActive()) break block5;
                Object object2 = this;
                try {
                    $this$close_u24lambda_u241 = object2;
                    boolean bl = false;
                    super.shutdownUnderlyingLayerImmediately();
                    $this$close_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    $this$close_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object2 = $this$close_u24lambda_u241;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) break block4;
                Object it = $this$close_u24lambda_u241 = throwable;
                boolean bl = false;
                LogsKt.warnForClose((Object)this, (Throwable)it);
                break block4;
            }
            Object object3 = this;
            try {
                WebDriverContext $this$close_u24lambda_u243 = object3;
                boolean bl = false;
                $this$close_u24lambda_u243.closeContext();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object3 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
            if (throwable == null) break block4;
            Object it = object = throwable;
            boolean bl = false;
            LogsKt.warnForClose((Object)this, (Throwable)it);
        }
    }

    private final void closeContext() {
        boolean asap = !AppContext.INSTANCE.isActive() || AppSystemInfo.Companion.isCriticalResources();
        this.logger.debug("Closing web driver context, asap: " + asap);
        if (asap) {
            this.closeUnderlyingLayerGracefully();
        } else {
            this.closeUnderlyingLayerGracefully();
        }
        String isShutdown = AppContext.INSTANCE.isActive() ? "" : " (shutdown)";
        String display = this.browserId.getDisplay();
        if (!((Collection)this.runningTasks).isEmpty()) {
            Object[] objectArray = new Object[]{this.runningTasks.size(), CollectionsKt.joinToString$default((Iterable)this.runningTasks, null, null, null, (int)0, null, (Function1)closeContext.1.INSTANCE, (int)31, null), display};
            this.logger.info("Still {} running tasks after context close" + isShutdown + " | {} | {}", objectArray);
        } else {
            this.logger.info("Web driver context is closed successfully" + isShutdown + " | {} | {}", (Object)display, (Object)this.browserId);
        }
    }

    private final void closeUnderlyingLayerGracefully() {
        Iterable $this$forEach$iv = this.runningTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FetchTask it = (FetchTask)element$iv;
            boolean bl = false;
            it.cancel();
        }
        this.driverPoolManager.cancelAll(this.browserId);
        Duration duration = WebDriverPoolManager.Companion.getDRIVER_SAFE_CLOSE_TIME_OUT();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"<get-DRIVER_SAFE_CLOSE_TIME_OUT>(...)");
        this.driverPoolManager.closeBrowserAccompaniedDriverPoolGracefully(this.browserId, duration);
    }

    private final void shutdownUnderlyingLayerImmediately() {
        this.logger.info("Shutdown the underlying layer immediately");
        Iterable $this$forEach$iv = this.runningTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FetchTask it = (FetchTask)element$iv;
            boolean bl = false;
            it.cancel();
        }
        this.driverPoolManager.cancelAll();
        this.driverPoolManager.close();
    }

    private final void waitUntilAllDoneNormally(Duration timeout) {
        this.waitUntilIdle(timeout);
    }

    private final void waitUntilNoRunningTasks(Duration timeout) {
        this.waitUntilIdle(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitUntilIdle(Duration timeout) throws InterruptedException {
        String message;
        long n = timeout.getSeconds();
        this.lock.lockInterruptibly();
        try {
            while (!((Collection)this.runningTasks).isEmpty() && !AppSystemInfo.Companion.isCriticalResources()) {
                long l = n;
                n = l + -1L;
                if (l > 0L) {
                    this.notBusy.await(1L, TimeUnit.SECONDS);
                    continue;
                }
                break;
            }
        }
        finally {
            this.lock.unlock();
        }
        String isShutdown = AppContext.INSTANCE.isActive() ? "" : " (shutdown)";
        String display = this.browserId.getDisplay();
        if (AppSystemInfo.Companion.isCriticalMemory()) {
            var7_7 = "Low memory (%s), close %d retired browsers immediately" + isShutdown + " | " + display;
            var8_8 = new Object[]{AppSystemInfo.Companion.formatAvailableMemory(), this.runningTasks.size()};
            String string = String.format(var7_7, Arrays.copyOf(var8_8, var8_8.length));
            v1 = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        } else if (n <= 0L) {
            var7_7 = "Timeout (still %d running tasks)" + isShutdown + " | " + display;
            var8_8 = new Object[]{this.runningTasks.size()};
            String string = String.format(var7_7, Arrays.copyOf(var8_8, var8_8.length));
            v1 = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        } else if (n > 0L) {
            var7_7 = "All tasks return in %d seconds" + isShutdown + " | " + display;
            var8_8 = new Object[]{timeout.getSeconds() - n};
            String string = String.format(var7_7, Arrays.copyOf(var8_8, var8_8.length));
            v1 = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        } else {
            v1 = message = "";
        }
        if (!StringsKt.isBlank((CharSequence)message)) {
            this.logger.info(message);
        }
    }

    private final FetchResult checkAbnormalResult(FetchTask task) {
        if (!this.isActive()) {
            return FetchResult.Companion.canceled(task, "Inactive web driver context");
        }
        if (this.driverPoolManager.isRetiredPool(this.browserId)) {
            return FetchResult.Companion.canceled(task, "Retired driver pool");
        }
        return null;
    }

    private static final Integer _init_$lambda$7() {
        return numGlobalRunningTasks.get();
    }

    static {
        MetricsSystem.Companion.getReg().register((Object)Companion, "globalRunningTasks", (Metric)((Gauge)WebDriverContext::_init_$lambda$7));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lai/platon/pulsar/protocol/browser/emulator/context/WebDriverContext$Companion;", "", "()V", "globalFinishedTasks", "Lcom/codahale/metrics/Meter;", "globalTasks", "numGlobalRunningTasks", "Ljava/util/concurrent/atomic/AtomicInteger;", "pulsar-protocol"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

