/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.emulator.util;

import ai.platon.pulsar.common.HtmlIntegrity;
import ai.platon.pulsar.common.HtmlUtils;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.persist.PageDatum;
import ai.platon.pulsar.protocol.browser.emulator.util.AbstractHtmlIntegrityChecker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0019\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lai/platon/pulsar/protocol/browser/emulator/util/DefaultHtmlIntegrityChecker;", "Lai/platon/pulsar/protocol/browser/emulator/util/AbstractHtmlIntegrityChecker;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "jsEnabled", "", "tracer", "Lorg/slf4j/Logger;", "checkHtmlIntegrity", "Lai/platon/pulsar/common/HtmlIntegrity;", "pageSource", "", "checkHtmlIntegrity0", "invoke", "pageDatum", "Lai/platon/pulsar/persist/PageDatum;", "pulsar-protocol"})
@SourceDebugExtension(value={"SMAP\nHtmlIntegrityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlIntegrityChecker.kt\nai/platon/pulsar/protocol/browser/emulator/util/DefaultHtmlIntegrityChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public class DefaultHtmlIntegrityChecker
extends AbstractHtmlIntegrityChecker {
    @NotNull
    private final ImmutableConfig conf;
    @Nullable
    private final Logger tracer;
    private final boolean jsEnabled;

    /*
     * WARNING - void declaration
     */
    public DefaultHtmlIntegrityChecker(@NotNull ImmutableConfig conf) {
        void it;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        Logger logger2 = logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(DefaultHtmlIntegrityChecker.class));
        DefaultHtmlIntegrityChecker defaultHtmlIntegrityChecker = this;
        boolean bl = false;
        boolean bl2 = it.isTraceEnabled();
        defaultHtmlIntegrityChecker.tracer = bl2 ? logger : null;
        this.jsEnabled = this.conf.getBoolean("browser.js.invading.enabled", true);
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @Override
    @NotNull
    public HtmlIntegrity invoke(@NotNull String pageSource2, @NotNull PageDatum pageDatum) {
        Intrinsics.checkNotNullParameter((Object)pageSource2, (String)"pageSource");
        Intrinsics.checkNotNullParameter((Object)pageDatum, (String)"pageDatum");
        return this.checkHtmlIntegrity(pageSource2);
    }

    private final HtmlIntegrity checkHtmlIntegrity(String pageSource2) {
        long length = pageSource2.length();
        return length == 0L ? HtmlIntegrity.EMPTY_0B : (length == 39L ? HtmlIntegrity.EMPTY_39B : (HtmlUtils.INSTANCE.isBlankBody(pageSource2) ? HtmlIntegrity.BLANK_BODY : this.checkHtmlIntegrity0(pageSource2)));
    }

    private final HtmlIntegrity checkHtmlIntegrity0(String pageSource2) {
        int p0 = StringsKt.indexOf$default((CharSequence)pageSource2, (String)"</head>", (int)0, (boolean)false, (int)6, null);
        int p1 = StringsKt.indexOf$default((CharSequence)pageSource2, (String)"<body", (int)p0, (boolean)false, (int)4, null);
        if (p1 <= 0) {
            return HtmlIntegrity.OTHER;
        }
        int p2 = StringsKt.indexOf$default((CharSequence)pageSource2, (String)">", (int)p1, (boolean)false, (int)4, null);
        if (p2 < p1) {
            return HtmlIntegrity.OTHER;
        }
        int p3 = StringsKt.indexOf$default((CharSequence)pageSource2, (String)"<a", (int)p2, (boolean)false, (int)4, null);
        if (p3 < p2) {
            return HtmlIntegrity.NO_ANCHOR;
        }
        if (this.jsEnabled) {
            String string = pageSource2.substring(p1, p2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String bodyTag = string;
            Logger logger = this.tracer;
            if (logger != null) {
                logger.trace("Body tag: " + bodyTag);
            }
            boolean r = StringsKt.contains$default((CharSequence)bodyTag, (CharSequence)"data-error=\"0\"", (boolean)false, (int)2, null);
            if (!r) {
                return HtmlIntegrity.NO_JS_OK_FLAG;
            }
        }
        return HtmlIntegrity.OK;
    }
}

