/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.crowd;

import ai.platon.pulsar.common.concurrent.ConcurrentExpiringLRUCache;
import ai.platon.pulsar.common.concurrent.ExpiringItem;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.skeleton.crawl.protocol.Response;
import ai.platon.pulsar.skeleton.crawl.protocol.http.AbstractHttpProtocol;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0006H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lai/platon/pulsar/protocol/crowd/ForwardingProtocol;", "Lai/platon/pulsar/skeleton/crawl/protocol/http/AbstractHttpProtocol;", "()V", "cache", "Lai/platon/pulsar/common/concurrent/ConcurrentExpiringLRUCache;", "", "Lai/platon/pulsar/skeleton/crawl/protocol/Response;", "cacheCapacity", "", "cacheTTL", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "getResponse", "page", "Lai/platon/pulsar/persist/WebPage;", "followRedirects", "", "getResponseDeferred", "(Lai/platon/pulsar/persist/WebPage;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logAfterPutResponse", "", "logAfterRemoveResponse", "url", "response", "setResponse", "pulsar-protocol"})
public class ForwardingProtocol
extends AbstractHttpProtocol {
    private final Logger logger = LoggerFactory.getLogger(ForwardingProtocol.class);
    private final Duration cacheTTL = Duration.ofMinutes(5L);
    private final int cacheCapacity;
    @NotNull
    private final ConcurrentExpiringLRUCache<String, Response> cache;

    public ForwardingProtocol() {
        this.cacheCapacity = 200;
        Duration duration = this.cacheTTL;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"cacheTTL");
        this.cache = new ConcurrentExpiringLRUCache(duration, this.cacheCapacity);
    }

    public void setResponse(@NotNull Response response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        ConcurrentExpiringLRUCache.putDatum$default(this.cache, (Object)response2.getUrl(), (Object)response2, (long)0L, (int)4, null);
        this.logAfterPutResponse();
    }

    @Nullable
    public Response getResponse(@NotNull WebPage page, boolean followRedirects) throws Exception {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        String string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        ExpiringItem expiringItem = this.cache.remove((Object)string);
        if (expiringItem == null || (expiringItem = (Response)expiringItem.getDatum()) == null) {
            return null;
        }
        ExpiringItem response2 = expiringItem;
        String string2 = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrl(...)");
        this.logAfterRemoveResponse(string2, (Response)response2);
        return response2;
    }

    @Nullable
    public Object getResponseDeferred(@NotNull WebPage page, boolean followRedirects, @NotNull Continuation<? super Response> $completion) throws Exception {
        return ForwardingProtocol.getResponseDeferred$suspendImpl(this, page, followRedirects, $completion);
    }

    static /* synthetic */ Object getResponseDeferred$suspendImpl(ForwardingProtocol $this, WebPage page, boolean followRedirects, Continuation<? super Response> $completion) throws Exception {
        ConcurrentExpiringLRUCache<String, Response> concurrentExpiringLRUCache = $this.cache;
        String string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        ExpiringItem expiringItem = concurrentExpiringLRUCache.remove((Object)string);
        if (expiringItem == null || (expiringItem = (Response)expiringItem.getDatum()) == null) {
            return null;
        }
        ExpiringItem response2 = expiringItem;
        String string2 = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrl(...)");
        $this.logAfterRemoveResponse(string2, (Response)response2);
        return response2;
    }

    private final void logAfterRemoveResponse(String url, Response response2) {
        if (response2 == null && this.logger.isTraceEnabled()) {
            this.logger.trace("No page in forward cache, total {} | {}", (Object)this.cache.getSize(), (Object)url);
        }
    }

    private final void logAfterPutResponse() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Putting page to forward cache, total {}", (Object)this.cache.getSize());
        }
        if (this.cache.getSize() > 100) {
            this.logger.warn("Forwarding cache is too large, there might be a bug");
            if (this.cache.getSize() > 1000) {
                this.logger.warn("!!!WARNING!!! FORWARDING CACHE IS UNEXPECTED TOO LARGE, CLEAR IT TO PREVENT MEMORY EXHAUSTING");
                this.cache.clear();
            }
        }
    }
}

