/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom;

import java.util.Random;
import javax.validation.constraints.NotNull;

public class SleepScheduler {
    private final Random random;
    private final long from;
    private final long to;

    public SleepScheduler(long sleepTime) {
        this(sleepTime, sleepTime, null);
    }

    public SleepScheduler(long from, long to) {
        this(from, to, new Random(System.currentTimeMillis() * 13L));
    }

    private SleepScheduler(long from, long to, @NotNull Random random) {
        if (from < 0L) {
            throw new IllegalArgumentException("Sleep time cannot be less than 0.");
        }
        this.from = from;
        if (from > to) {
            throw new IllegalArgumentException("Sleep time in \"from\" cannot be greater less than \"to\".");
        }
        this.to = to;
        this.random = random;
    }

    public long getSleepTime() {
        if (this.from == this.to) {
            return this.from;
        }
        return (long)this.random.nextInt((int)(this.to - this.from)) + this.from;
    }
}

