/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.job;

import ai.preferred.venom.Handleable;
import ai.preferred.venom.job.Job;
import ai.preferred.venom.job.Priority;
import ai.preferred.venom.job.Scheduler;
import ai.preferred.venom.request.Request;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public abstract class AbstractQueueScheduler
extends AbstractQueue<Job>
implements Scheduler,
BlockingQueue<Job>,
AutoCloseable {
    abstract BlockingQueue<Job> getQueue();

    @Override
    public void add(Request r, Handleable h, Priority p) {
        this.add(r, h, p, Priority.FLOOR);
    }

    @Override
    public void add(Request r, Handleable h) {
        this.add(r, h, Priority.DEFAULT);
    }

    @Override
    public void add(Request r, Priority p, Priority pf) {
        this.add(r, null, p, pf);
    }

    @Override
    public void add(Request r, Priority p) {
        this.add(r, null, p, Priority.FLOOR);
    }

    @Override
    public void add(Request r) {
        this.add(r, null, Priority.DEFAULT, Priority.FLOOR);
    }

    @Override
    @Nonnull
    public Iterator<Job> iterator() {
        return this.getQueue().iterator();
    }

    @Override
    public int size() {
        return this.getQueue().size();
    }

    @Override
    @Nonnull
    public Job take() throws InterruptedException {
        return this.getQueue().take();
    }

    @Override
    public Job poll(long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        return this.getQueue().poll(timeout, unit);
    }

    @Override
    public int remainingCapacity() {
        return this.getQueue().remainingCapacity();
    }

    @Override
    public int drainTo(@Nonnull Collection<? super Job> c) {
        return this.getQueue().drainTo(c);
    }

    @Override
    public int drainTo(@Nonnull Collection<? super Job> c, int maxElements) {
        return this.getQueue().drainTo(c, maxElements);
    }

    @Override
    public boolean offer(@Nonnull Job job) {
        return this.getQueue().offer(job);
    }

    @Override
    public Job poll() {
        return (Job)this.getQueue().poll();
    }

    @Override
    public Job peek() {
        return (Job)this.getQueue().peek();
    }

    @Override
    public void close() {
        this.getQueue().iterator().forEachRemaining(job -> job.cancel(true));
    }
}

