/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.job;

import ai.preferred.venom.Handleable;
import ai.preferred.venom.job.Job;
import ai.preferred.venom.job.Priority;
import ai.preferred.venom.request.Request;
import java.util.Queue;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicJob.class);
    private final Request request;
    private final Handleable handler;
    private final Priority priorityFloor;
    private final Queue<Job> queue;
    private boolean cancelled = false;
    private boolean done = false;
    private Priority priority;
    private int tryCount = 1;

    public BasicJob(Request request, Handleable handler, Priority priority, Priority priorityFloor, Queue<Job> queue) {
        this.request = request;
        this.handler = handler;
        this.priority = priority;
        this.priorityFloor = priorityFloor;
        this.queue = queue;
    }

    private synchronized void interrupt() {
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public Handleable getHandler() {
        return this.handler;
    }

    @Override
    public Priority getPriority() {
        return this.priority;
    }

    @Override
    public void reQueue() {
        if (this.cancelled) {
            LOGGER.debug("Job {} - {} is cancelled, will not be re-queued.", (Object)this.toString(), (Object)this.request.getUrl());
            return;
        }
        if (this.done) {
            LOGGER.debug("Job {} - {} is done, will not be re-queued.", (Object)this.toString(), (Object)this.request.getUrl());
            return;
        }
        this.queue.remove(this);
        this.priority = this.priority.downgrade(this.priorityFloor);
        ++this.tryCount;
        this.queue.add(this);
        LOGGER.debug("Job {} - {} re-queued.", (Object)this.toString(), (Object)this.request.getUrl());
    }

    @Override
    public int getTryCount() {
        return this.tryCount;
    }

    @Override
    public int compareTo(@Nonnull Job o) {
        return this.priority.compareTo(o.getPriority());
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelled) {
            LOGGER.debug("Job {} - {} cannot be cancelled, already cancelled.", (Object)this.toString(), (Object)this.request.getUrl());
            return false;
        }
        if (this.done) {
            LOGGER.debug("Job {} - {} cannot be cancelled, already done.", (Object)this.toString(), (Object)this.getRequest().getUrl());
            return false;
        }
        if (!this.queue.remove(this) && mayInterruptIfRunning) {
            this.interrupt();
        }
        LOGGER.debug("Job {} - {} cancelled.", (Object)this.toString(), (Object)this.getRequest().getUrl());
        this.done = true;
        this.cancelled = true;
        return true;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void done() {
        this.done = true;
        this.interrupt();
    }
}

