/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.utils;

import java.util.Locale;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.DecompressingEntity;
import org.apache.http.client.entity.DeflateInputStream;
import org.apache.http.client.entity.InputStreamFactory;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;

public class ResponseDecompressor {
    private static final InputStreamFactory DEFLATE = DeflateInputStream::new;
    private static final InputStreamFactory GZIP = GZIPInputStream::new;
    private final Lookup<InputStreamFactory> decoderRegistry = RegistryBuilder.create().register("gzip", (Object)GZIP).register("x-gzip", (Object)GZIP).register("deflate", (Object)DEFLATE).build();

    public void decompress(HttpResponse response) {
        Header ceheader;
        HttpEntity entity = response.getEntity();
        if (entity != null && entity.getContentLength() != 0L && (ceheader = entity.getContentEncoding()) != null) {
            HeaderElement[] codecs;
            for (HeaderElement codec : codecs = ceheader.getElements()) {
                String codecName = codec.getName().toLowerCase(Locale.ROOT);
                InputStreamFactory decoderFactory = (InputStreamFactory)this.decoderRegistry.lookup(codecName);
                if (decoderFactory == null) continue;
                response.setEntity((HttpEntity)new DecompressingEntity(response.getEntity(), decoderFactory));
                response.removeHeaders("Content-Length");
                response.removeHeaders("Content-Encoding");
                response.removeHeaders("Content-MD5");
            }
        }
    }
}

