/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom;

import ai.preferred.venom.Handleable;
import ai.preferred.venom.HandlerRouter;
import ai.preferred.venom.Interruptible;
import ai.preferred.venom.Session;
import ai.preferred.venom.SleepScheduler;
import ai.preferred.venom.ThreadedWorkerManager;
import ai.preferred.venom.WorkerManager;
import ai.preferred.venom.fetcher.AsyncFetcher;
import ai.preferred.venom.fetcher.Fetcher;
import ai.preferred.venom.fetcher.StopCodeException;
import ai.preferred.venom.job.AbstractQueueScheduler;
import ai.preferred.venom.job.Job;
import ai.preferred.venom.job.PriorityQueueScheduler;
import ai.preferred.venom.job.Scheduler;
import ai.preferred.venom.request.CrawlerRequest;
import ai.preferred.venom.request.Request;
import ai.preferred.venom.response.Response;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.http.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Crawler
implements Interruptible,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Crawler.class);
    @NotNull
    private final Thread crawlerThread;
    @NotNull
    private final AtomicBoolean exitWhenDone;
    @NotNull
    private final Fetcher fetcher;
    private final int maxTries;
    private final double propRetainProxy;
    @Nullable
    private final HandlerRouter router;
    @NotNull
    private final AbstractQueueScheduler scheduler;
    @NotNull
    private final Semaphore connections;
    @NotNull
    private final Session session;
    @NotNull
    private final SleepScheduler sleepScheduler;
    @NotNull
    private final ExecutorService threadPool;
    @NotNull
    private final WorkerManager workerManager;
    @NotNull
    private final Map<Job, Future> uncompletedFutures;

    private Crawler(Builder builder) {
        this.crawlerThread = new Thread(this::run, builder.name);
        this.exitWhenDone = new AtomicBoolean(false);
        this.fetcher = builder.fetcher;
        this.maxTries = builder.maxTries;
        this.propRetainProxy = builder.propRetainProxy;
        this.router = builder.router;
        this.scheduler = builder.scheduler;
        this.connections = new Semaphore(builder.maxConnections);
        this.session = builder.session;
        this.sleepScheduler = builder.sleepScheduler;
        this.threadPool = new ForkJoinPool(builder.parallelism, pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName(builder.name + " " + worker.getPoolIndex());
            return worker;
        }, null, true);
        this.workerManager = builder.workerManager == null ? new ThreadedWorkerManager(this.threadPool) : builder.workerManager;
        this.uncompletedFutures = new ConcurrentHashMap<Job, Future>();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Crawler buildDefault() {
        return Crawler.builder().build();
    }

    private void sleep(Job job, long lastRequestTime) throws InterruptedException {
        long timeElapsed;
        long timeElapsedMillis;
        long sleepTime = job.getRequest().getSleepScheduler() == null ? this.sleepScheduler.getSleepTime() : (job.getRequest().getSleepScheduler() != null ? job.getRequest().getSleepScheduler().getSleepTime() : 0L);
        if (sleepTime > (timeElapsedMillis = TimeUnit.NANOSECONDS.toMillis(timeElapsed = System.nanoTime() - lastRequestTime))) {
            Thread.sleep(sleepTime - timeElapsedMillis);
        }
    }

    private CrawlerRequest normalizeRequest(Request request) {
        if (request instanceof CrawlerRequest) {
            return (CrawlerRequest)request;
        }
        return new CrawlerRequest(request);
    }

    private CrawlerRequest prepareRequest(Request request, int tryCount) {
        CrawlerRequest crawlerRequest = this.normalizeRequest(request);
        if (request.getProxy() != null && (double)tryCount / (double)this.maxTries > this.propRetainProxy) {
            crawlerRequest.removeProxy();
        }
        return crawlerRequest;
    }

    private void run() {
        this.fetcher.start();
        long lastRequestTime = 0L;
        while (!Thread.currentThread().isInterrupted() && !this.threadPool.isShutdown()) {
            try {
                Job job = this.scheduler.poll(3L, TimeUnit.SECONDS);
                if (job == null) {
                    if (this.uncompletedFutures.size() != 0 || !this.exitWhenDone.get()) continue;
                    break;
                }
                this.sleep(job, lastRequestTime);
                lastRequestTime = System.nanoTime();
                this.connections.acquire();
                this.threadPool.execute(() -> {
                    LOGGER.debug("Preparing to fetch {}", (Object)job.getRequest().getUrl());
                    CrawlerRequest crawlerRequest = this.prepareRequest(job.getRequest(), job.getTryCount());
                    Future<Response> responseFuture = this.fetcher.fetch(crawlerRequest, new AsyncCrawlerCallbackProcessor(this, job));
                    this.uncompletedFutures.put(job, responseFuture);
                });
            }
            catch (InterruptedException e) {
                LOGGER.debug("({}) producer thread interrupted.", (Object)this.crawlerThread.getName(), (Object)e);
                break;
            }
        }
        LOGGER.debug("({}) will stop producing requests.", (Object)this.crawlerThread.getName());
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public synchronized Crawler start() {
        this.crawlerThread.start();
        LOGGER.info("{} thread started.", (Object)this.crawlerThread.getName());
        return this;
    }

    public synchronized Crawler startAndClose() throws Exception {
        this.start();
        this.close();
        return this;
    }

    @Override
    public void interruptAndClose() throws Exception {
        this.crawlerThread.interrupt();
        this.uncompletedFutures.values().forEach(future -> future.cancel(true));
        this.threadPool.shutdownNow();
        if (this.workerManager instanceof Interruptible) {
            ((Interruptible)((Object)this.workerManager)).interruptAndClose();
        }
        this.close();
    }

    @Override
    public void close() throws Exception {
        if (this.exitWhenDone.compareAndSet(false, true)) {
            LOGGER.debug("Initialising \"{}\" shutdown, waiting for threads to join...", (Object)this.crawlerThread.getName());
            this.crawlerThread.join();
            LOGGER.debug("{} producer thread joined.", (Object)this.crawlerThread.getName());
            this.threadPool.shutdown();
            this.scheduler.close();
            this.threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
            LOGGER.debug("{} thread pool joined.", (Object)this.crawlerThread.getName());
            LOGGER.debug("{} shutdown completed.", (Object)this.crawlerThread.getName());
            this.workerManager.close();
            this.fetcher.close();
        }
    }

    public static final class AsyncCrawlerCallbackProcessor
    implements FutureCallback<Response> {
        private final Crawler crawler;
        private final Job job;

        private AsyncCrawlerCallbackProcessor(Crawler crawler, Job job) {
            this.crawler = crawler;
            this.job = job;
        }

        public void completed(Response response) {
            this.cancelled();
            this.crawler.threadPool.execute(() -> {
                Handleable routedHandler;
                if (this.job.getHandler() != null) {
                    this.job.getHandler().handle(this.job.getRequest(), response, this.crawler.scheduler, this.crawler.session, this.crawler.workerManager.getWorker());
                    return;
                }
                if (this.crawler.router != null && (routedHandler = this.crawler.router.getHandler(this.job.getRequest())) != null) {
                    routedHandler.handle(this.job.getRequest(), response, this.crawler.scheduler, this.crawler.session, this.crawler.workerManager.getWorker());
                    return;
                }
                LOGGER.error("No handler to handle request {}.", (Object)this.job.getRequest().getUrl());
            });
        }

        public void failed(Exception ex) {
            this.cancelled();
            if (ex instanceof StopCodeException) {
                this.job.cancel(true);
            } else if (this.job.getTryCount() < this.crawler.maxTries) {
                this.job.reQueue();
            }
        }

        public void cancelled() {
            this.crawler.connections.release();
            this.crawler.uncompletedFutures.remove(this.job);
        }
    }

    public static final class Builder {
        private Fetcher fetcher = AsyncFetcher.buildDefault();
        private int maxConnections = Runtime.getRuntime().availableProcessors() * 10;
        private int maxTries = 50;
        private String name = "Crawler";
        private int parallelism = Runtime.getRuntime().availableProcessors();
        private WorkerManager workerManager = null;
        private double propRetainProxy = 0.05;
        private HandlerRouter router = null;
        private AbstractQueueScheduler scheduler = new PriorityQueueScheduler();
        private SleepScheduler sleepScheduler = new SleepScheduler(250L, 2000L);
        private Session session = Session.EMPTY_SESSION;

        private Builder() {
        }

        public Builder name(@NotNull String name) {
            this.name = name;
            return this;
        }

        public Builder fetcher(@NotNull Fetcher fetcher) {
            this.fetcher = fetcher;
            return this;
        }

        public Builder parallism(int parallelism) {
            if (parallelism <= 0) {
                LOGGER.warn("Attribute 'numThreads' not within range, defaulting to system default.");
            } else {
                this.parallelism = parallelism;
            }
            return this;
        }

        public Builder workerManager(@NotNull WorkerManager workerManager) {
            this.workerManager = workerManager;
            return this;
        }

        public Builder scheduler(@NotNull AbstractQueueScheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        public Builder router(@NotNull HandlerRouter router) {
            this.router = router;
            return this;
        }

        public Builder maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder maxTries(int maxTries) {
            this.maxTries = maxTries;
            return this;
        }

        public Builder propRetainProxy(double propRetainProxy) {
            if (propRetainProxy > 1.0 || propRetainProxy < 0.0) {
                LOGGER.warn("Attribute 'propRetainProxy' not within range, defaulting to 0.05.");
            } else {
                this.propRetainProxy = propRetainProxy;
            }
            return this;
        }

        public Builder sleepScheduler(@NotNull SleepScheduler sleepScheduler) {
            this.sleepScheduler = sleepScheduler;
            return this;
        }

        public Builder session(@NotNull Session session) {
            this.session = session;
            return this;
        }

        public Crawler build() {
            return new Crawler(this);
        }
    }
}

