/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.fetcher;

import ai.preferred.venom.fetcher.StopCodeException;
import ai.preferred.venom.fetcher.ValidationException;
import ai.preferred.venom.request.HttpFetcherRequest;
import ai.preferred.venom.request.Request;
import ai.preferred.venom.request.Unwrappable;
import ai.preferred.venom.response.BaseResponse;
import ai.preferred.venom.response.Response;
import ai.preferred.venom.utils.ResponseDecompressor;
import ai.preferred.venom.validator.Validator;
import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Set;
import org.apache.http.ContentTooLongException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.ContentBufferEntity;
import org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.nio.util.SimpleInputBuffer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Asserts;
import org.apache.http.util.EntityUtils;
import org.apache.tika.Tika;
import org.apache.tika.io.TikaInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncResponseConsumer
extends AbstractAsyncResponseConsumer<Response> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncResponseConsumer.class);
    private static final ResponseDecompressor RESPONSE_DECOMPRESSOR = new ResponseDecompressor();
    private static final ContentType DEFAULT_CONTENT_TYPE = ContentType.APPLICATION_OCTET_STREAM;
    private final Validator validator;
    private final Set<Integer> stopCodes;
    private final boolean compressed;
    private final Request request;
    private volatile HttpResponse httpResponse;
    private volatile SimpleInputBuffer buf;

    AsyncResponseConsumer(Validator validator, Set<Integer> stopCodes, boolean compressed, HttpFetcherRequest request) {
        this.validator = validator;
        this.stopCodes = stopCodes;
        this.compressed = compressed;
        this.request = request;
    }

    private BaseResponse createVenomResponse(boolean compressed) throws IOException {
        if (compressed) {
            RESPONSE_DECOMPRESSOR.decompress(this.httpResponse);
        }
        byte[] content = EntityUtils.toByteArray((HttpEntity)this.httpResponse.getEntity());
        Header[] headers = this.httpResponse.getAllHeaders();
        ContentType contentType = this.parseContentType(content);
        String baseUrl = "";
        try {
            URL url = new URL(this.request.getUrl());
            baseUrl = url.getProtocol() + "://" + url.getHost();
        }
        catch (MalformedURLException e) {
            LOGGER.warn("Could not parse base URL: " + this.request.getUrl());
        }
        return new BaseResponse(this.httpResponse.getStatusLine().getStatusCode(), baseUrl, content, contentType, headers, this.request.getProxy());
    }

    private ContentType parseContentType(byte[] content) {
        try {
            CharsetMatch match;
            ContentType type = ContentType.get((HttpEntity)this.httpResponse.getEntity());
            if (type == null) {
                TikaInputStream stream = TikaInputStream.get((InputStream)new ByteArrayInputStream(content));
                Tika tika = new Tika();
                String fileType = tika.detect((InputStream)stream);
                type = ContentType.create((String)fileType);
            }
            if (type.getCharset() == null && (match = new CharsetDetector().setText((InputStream)new ByteArrayInputStream(content)).detect()) != null && match.getConfidence() > 50) {
                type = type.withCharset(match.getName());
            }
            return type;
        }
        catch (ParseException e) {
            LOGGER.warn("Could not parse content type", (Throwable)e);
        }
        catch (UnsupportedCharsetException e) {
            LOGGER.warn("Charset is not available in this instance of the Java virtual machine", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot get content to determine media type", (Throwable)e);
        }
        return DEFAULT_CONTENT_TYPE;
    }

    protected final void onResponseReceived(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    protected final void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Asserts.notNull((Object)this.buf, (String)"Content buffer");
        this.buf.consumeContent(decoder);
    }

    protected final void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: " + len);
        }
        if (len < 0L) {
            len = 4096L;
        }
        this.buf = new SimpleInputBuffer((int)len, (ByteBufferAllocator)new HeapByteBufferAllocator());
        this.httpResponse.setEntity((HttpEntity)new ContentBufferEntity(entity, (ContentInputBuffer)this.buf));
    }

    protected final BaseResponse buildResult(HttpContext context) throws Exception {
        int statusCode = this.httpResponse.getStatusLine().getStatusCode();
        if (this.stopCodes.contains(statusCode)) {
            EntityUtils.consumeQuietly((HttpEntity)this.httpResponse.getEntity());
            this.releaseResources();
            throw new StopCodeException(statusCode, "Stop code received.");
        }
        BaseResponse response = this.createVenomResponse(this.compressed);
        this.releaseResources();
        try {
            Validator.Status status = this.validator.isValid(Unwrappable.unwrapRequest(this.request), response);
            if (status != Validator.Status.VALID) {
                throw new ValidationException(status, (Response)response, "Invalid response.");
            }
        }
        catch (Exception e) {
            throw new ValidationException(Validator.Status.INVALID_CONTENT, response, "Validator threw an exception, please check your code for bugs.", e);
        }
        return response;
    }

    protected final void releaseResources() {
        this.httpResponse = null;
        this.buf = null;
    }
}

