/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.job;

import ai.preferred.venom.Handleable;
import ai.preferred.venom.Handler;
import ai.preferred.venom.job.AbstractQueueScheduler;
import ai.preferred.venom.job.BasicJob;
import ai.preferred.venom.job.Job;
import ai.preferred.venom.job.Priority;
import ai.preferred.venom.request.Request;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyScheduler
extends AbstractQueueScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LazyScheduler.class);
    private final PriorityBlockingQueue<Job> queue = new PriorityBlockingQueue();
    private final Object lock = new Object();
    private final Iterator<Request> requests;
    private final Handler handler;

    public LazyScheduler(Iterator<Request> requests, Handler handler) {
        this.requests = requests;
        this.handler = handler;
    }

    public LazyScheduler(Iterator<Request> requests) {
        this(requests, null);
    }

    final PriorityBlockingQueue<Job> getQueue() {
        return this.queue;
    }

    @Override
    public final void add(Request r, Handleable h, Priority p, Priority pf) {
        BasicJob job = new BasicJob(r, h, p, pf, this.queue);
        ((PriorityBlockingQueue)this.getQueue()).add(job);
        LOGGER.debug("Job {} - {} added to queue.", (Object)job.toString(), (Object)r.getUrl());
    }

    private Job pollLazyRequest() {
        return new BasicJob(this.requests.next(), this.handler, Priority.DEFAULT, Priority.FLOOR, this.getQueue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Job poll() {
        Object object = this.lock;
        synchronized (object) {
            if (((AbstractCollection)((Object)this.getQueue())).isEmpty() && this.requests.hasNext()) {
                return this.pollLazyRequest();
            }
        }
        return (Job)((PriorityBlockingQueue)this.getQueue()).poll();
    }

    @Override
    public final void put(@Nonnull Job job) {
        ((PriorityBlockingQueue)this.getQueue()).put(job);
    }

    @Override
    public final boolean offer(Job job, long timeout, @Nonnull TimeUnit unit) {
        return ((PriorityBlockingQueue)this.getQueue()).offer(job, timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Job poll(long time, @Nonnull TimeUnit unit) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (((AbstractCollection)((Object)this.getQueue())).isEmpty() && this.requests.hasNext()) {
                return this.pollLazyRequest();
            }
        }
        return (Job)((PriorityBlockingQueue)this.getQueue()).poll(time, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return ((AbstractCollection)((Object)this.getQueue())).isEmpty() && !this.requests.hasNext();
        }
    }
}

