/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.job;

import ai.preferred.venom.Handler;
import ai.preferred.venom.job.Job;
import ai.preferred.venom.job.Priority;
import ai.preferred.venom.request.Request;
import java.util.Queue;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicJob.class);
    private final Request request;
    private final Handler handler;
    private final Priority priorityFloor;
    private final Queue<Job> queue;
    private Priority priority;
    private int tryCount = 1;

    public BasicJob(Request request, Handler handler, Priority priority, Priority priorityFloor, Queue<Job> queue) {
        this.request = request;
        this.handler = handler;
        this.priority = priority;
        this.priorityFloor = priorityFloor;
        this.queue = queue;
    }

    @Override
    public final Request getRequest() {
        return this.request;
    }

    @Override
    public final Handler getHandler() {
        return this.handler;
    }

    @Override
    public final Priority getPriority() {
        return this.priority;
    }

    @Override
    public final void reQueue() {
        this.queue.remove(this);
        this.priority = this.priority.downgrade(this.priorityFloor);
        ++this.tryCount;
        this.queue.add(this);
        LOGGER.debug("Job {} - {} re-queued.", (Object)this.toString(), (Object)this.request.getUrl());
    }

    @Override
    public final int getTryCount() {
        return this.tryCount;
    }

    @Override
    public final int compareTo(@Nonnull Job job) {
        return this.priority.compareTo(job.getPriority());
    }
}

