/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.utils;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;

public class InlineExecutorService
extends AbstractExecutorService
implements ExecutorService {
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final AtomicBoolean terminated = new AtomicBoolean(false);
    private final Lock lock = new ReentrantLock();

    @Override
    public final void shutdown() {
        this.shutdown.compareAndSet(false, true);
    }

    @Override
    @Nonnull
    public final List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    @Override
    public final boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public final boolean isTerminated() {
        return this.terminated.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean awaitTermination(long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        if (this.terminated.get()) {
            return true;
        }
        this.lock.tryLock(timeout, unit);
        try {
            boolean bl = this.terminated.get();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void execute(@Nonnull Runnable command) {
        if (this.shutdown.get()) {
            throw new RejectedExecutionException("Executor has been shutdown.");
        }
        this.lock.lock();
        try {
            command.run();
        }
        finally {
            if (this.shutdown.get()) {
                this.terminated.compareAndSet(false, true);
            }
            this.lock.unlock();
        }
    }
}

