/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom;

import ai.preferred.venom.Worker;
import ai.preferred.venom.WorkerManager;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedWorkerManager
implements WorkerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadedWorkerManager.class);
    @Nullable
    private final ExecutorService executor;
    private final Worker worker;

    public ThreadedWorkerManager() {
        this(null);
    }

    public ThreadedWorkerManager(@Nullable ExecutorService executor) {
        this.executor = executor;
        this.worker = executor instanceof ForkJoinPool || executor == null ? new ForkJoinWorker() : new DefaultWorker(executor);
    }

    @Override
    public final Worker getWorker() {
        return this.worker;
    }

    @Override
    public final void interruptAndClose() {
        if (this.executor == null) {
            return;
        }
        LOGGER.debug("Forcefully shutting down the worker manager");
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            LOGGER.debug("The worker manager has been terminated");
        }
        catch (InterruptedException e) {
            LOGGER.warn("Closing has been interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public final void close() {
        if (this.executor == null) {
            return;
        }
        LOGGER.debug("Shutting down the worker manager");
        this.executor.shutdown();
        try {
            if (this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS)) {
                LOGGER.debug("The worker manager has been terminated");
            } else {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Closing has been interrupted, forcefully shutting down", (Throwable)e);
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static final class ManagedBlockerTask
    implements ForkJoinPool.ManagedBlocker {
        private final Runnable task;
        private boolean done = false;

        private ManagedBlockerTask(Runnable task) {
            this.task = task;
        }

        @Override
        public boolean block() {
            this.task.run();
            this.done = true;
            return true;
        }

        @Override
        public boolean isReleasable() {
            return this.done;
        }
    }

    static final class ForkJoinWorker
    extends AbstractManagedBlockingWorker {
        ForkJoinWorker() {
        }

        @Override
        @NotNull
        public <T> Future<T> submit(@NotNull Callable<T> task) {
            return ForkJoinTask.adapt(task).fork();
        }

        @Override
        @NotNull
        public <T> Future<T> submit(@NotNull Runnable task, T result) {
            return ForkJoinTask.adapt(task, result).fork();
        }

        @Override
        @NotNull
        public Future<?> submit(@NotNull Runnable task) {
            return ForkJoinTask.adapt(task).fork();
        }
    }

    static final class DefaultWorker
    extends AbstractManagedBlockingWorker {
        private final ExecutorService executor;

        DefaultWorker(ExecutorService executor) {
            this.executor = executor;
        }

        @Override
        @NotNull
        public <T> Future<T> submit(@NotNull Callable<T> task) {
            return this.executor.submit(task);
        }

        @Override
        @NotNull
        public <T> Future<T> submit(@NotNull Runnable task, T result) {
            return this.executor.submit(task, result);
        }

        @Override
        @NotNull
        public Future<?> submit(@NotNull Runnable task) {
            return this.executor.submit(task);
        }
    }

    public static abstract class AbstractManagedBlockingWorker
    implements Worker {
        @Override
        public final void executeBlockingIO(@NotNull Runnable task) {
            if (task == null) {
                throw new NullPointerException();
            }
            ManagedBlockerTask managedBlockerTask = new ManagedBlockerTask(task);
            try {
                ForkJoinPool.managedBlock(managedBlockerTask);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new AssertionError("Exception of unknown cause. Please verify codebase.", e);
            }
        }
    }
}

