/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom;

import ai.preferred.venom.Handler;
import ai.preferred.venom.HandlerRouter;
import ai.preferred.venom.ValidatorRouter;
import ai.preferred.venom.request.Request;
import ai.preferred.venom.validator.Validator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;

public class UrlRouter
implements HandlerRouter,
ValidatorRouter {
    private final Handler defaultHandler;
    private final Map<Pattern, Handler> handlerRules = new LinkedHashMap<Pattern, Handler>();
    private final Map<Pattern, Validator> validatorRules = new LinkedHashMap<Pattern, Validator>();
    private final ReentrantReadWriteLock handlerRulesLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock validatorRulesLock = new ReentrantReadWriteLock();

    public UrlRouter() {
        this(null);
    }

    public UrlRouter(Handler defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public final UrlRouter register(Pattern urlPattern, Handler handler) {
        this.handlerRulesLock.writeLock().lock();
        try {
            this.handlerRules.put(urlPattern, handler);
        }
        finally {
            this.handlerRulesLock.writeLock().unlock();
        }
        return this;
    }

    public final UrlRouter register(Pattern urlPattern, Validator validator) {
        this.validatorRulesLock.writeLock().lock();
        try {
            this.validatorRules.put(urlPattern, validator);
        }
        finally {
            this.validatorRulesLock.writeLock().unlock();
        }
        return this;
    }

    public final UrlRouter register(Pattern urlPattern, Handler handler, Validator validator) {
        this.register(urlPattern, handler);
        this.register(urlPattern, validator);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Handler getHandler(Request request) {
        this.handlerRulesLock.readLock().lock();
        try {
            for (Map.Entry<Pattern, Handler> rule : this.handlerRules.entrySet()) {
                if (!rule.getKey().matcher(request.getUrl()).matches()) continue;
                Handler handler = rule.getValue();
                return handler;
            }
        }
        finally {
            this.handlerRulesLock.readLock().unlock();
        }
        if (this.defaultHandler != null) {
            return this.defaultHandler;
        }
        throw new RuntimeException("Default handler is not set");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Validator getValidator(Request request) {
        this.validatorRulesLock.readLock().lock();
        try {
            for (Map.Entry<Pattern, Validator> rule : this.validatorRules.entrySet()) {
                if (!rule.getKey().matcher(request.getUrl()).matches()) continue;
                Validator validator = rule.getValue();
                return validator;
            }
        }
        finally {
            this.validatorRulesLock.readLock().unlock();
        }
        return Validator.ALWAYS_VALID;
    }
}

