/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.fetcher;

import ai.preferred.venom.fetcher.StopCodeException;
import ai.preferred.venom.fetcher.ValidationException;
import ai.preferred.venom.request.HttpFetcherRequest;
import ai.preferred.venom.request.Unwrappable;
import ai.preferred.venom.response.BaseResponse;
import ai.preferred.venom.response.Response;
import ai.preferred.venom.utils.ResponseDecompressor;
import ai.preferred.venom.utils.UrlUtil;
import ai.preferred.venom.validator.Validator;
import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.http.ContentTooLongException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.ContentBufferEntity;
import org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.nio.util.SimpleInputBuffer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Asserts;
import org.apache.http.util.EntityUtils;
import org.apache.tika.Tika;
import org.apache.tika.io.TikaInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncResponseConsumer
extends AbstractAsyncResponseConsumer<Response> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncResponseConsumer.class);
    private static final ResponseDecompressor RESPONSE_DECOMPRESSOR = new ResponseDecompressor();
    private static final ContentType DEFAULT_CONTENT_TYPE = ContentType.APPLICATION_OCTET_STREAM;
    private final Validator validator;
    private final Set<Integer> stopCodes;
    private final boolean compressed;
    private final HttpFetcherRequest request;
    private volatile HttpResponse httpResponse;
    private volatile SimpleInputBuffer buf;
    private byte[] content;

    AsyncResponseConsumer(Validator validator, Set<Integer> stopCodes, boolean compressed, HttpFetcherRequest request) {
        this.validator = validator;
        this.stopCodes = stopCodes;
        this.compressed = compressed;
        this.request = request;
        request.getDiagnostics().setStart();
    }

    private byte[] getContent(HttpEntity entity) throws IOException {
        if (this.content == null) {
            this.content = IOUtils.toByteArray((InputStream)entity.getContent());
        }
        return this.content;
    }

    private BaseResponse createVenomResponse(boolean compressed) throws IOException {
        String tryBaseUrl;
        if (compressed) {
            RESPONSE_DECOMPRESSOR.decompress(this.httpResponse);
        }
        HttpEntity entity = this.httpResponse.getEntity();
        byte[] content = this.getContent(entity);
        this.request.getDiagnostics().setSize(content.length);
        ContentType contentType = this.getContentType(entity);
        Header[] headers = this.httpResponse.getAllHeaders();
        try {
            tryBaseUrl = UrlUtil.getBaseUrl(this.request);
        }
        catch (URISyntaxException e) {
            LOGGER.warn("Could not parse base URL: " + this.request.getUrl());
            tryBaseUrl = this.request.getUrl();
        }
        String baseUrl = tryBaseUrl;
        return new BaseResponse(this.httpResponse.getStatusLine().getStatusCode(), baseUrl, content, contentType, headers, this.request.getProxy());
    }

    protected final synchronized ContentType getContentType(HttpEntity entity) {
        try {
            ContentType contentType = ContentType.get((HttpEntity)entity);
            if (contentType == null || contentType.getCharset() == null) {
                TikaInputStream stream;
                byte[] bytes;
                try {
                    bytes = this.getContent(entity);
                }
                catch (IllegalStateException e) {
                    return contentType;
                }
                if (contentType == null) {
                    stream = TikaInputStream.get((byte[])bytes);
                    try {
                        Tika tika = new Tika();
                        String fileType = tika.detect((InputStream)stream);
                        contentType = ContentType.create((String)fileType);
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                if (contentType.getCharset() == null) {
                    stream = TikaInputStream.get((byte[])bytes);
                    try {
                        CharsetMatch match = new CharsetDetector().setText((InputStream)stream).detect();
                        if (match != null && match.getConfidence() > 50) {
                            contentType = contentType.withCharset(match.getName());
                        }
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
            }
            return contentType;
        }
        catch (ParseException e) {
            LOGGER.warn("Could not parse content type", (Throwable)e);
        }
        catch (UnsupportedCharsetException e) {
            LOGGER.warn("Charset is not available in this instance of the Java virtual machine", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot get content to determine media type", (Throwable)e);
        }
        return DEFAULT_CONTENT_TYPE;
    }

    protected final void onResponseReceived(HttpResponse httpResponse) {
        this.request.getDiagnostics().setAcknowledge();
        this.httpResponse = httpResponse;
    }

    protected final void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Asserts.notNull((Object)this.buf, (String)"Content buffer");
        this.buf.consumeContent(decoder);
    }

    protected final void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: " + len);
        }
        if (len < 0L) {
            len = 4096L;
        }
        this.buf = new SimpleInputBuffer((int)len, (ByteBufferAllocator)new HeapByteBufferAllocator());
        this.httpResponse.setEntity((HttpEntity)new ContentBufferEntity(entity, (ContentInputBuffer)this.buf));
    }

    protected final BaseResponse buildResult(HttpContext context) throws Exception {
        Validator.Status status;
        this.request.getDiagnostics().setComplete();
        int statusCode = this.httpResponse.getStatusLine().getStatusCode();
        if (this.stopCodes.contains(statusCode)) {
            EntityUtils.consumeQuietly((HttpEntity)this.httpResponse.getEntity());
            this.releaseResources();
            throw new StopCodeException(statusCode, "Stop code received.");
        }
        BaseResponse response = this.createVenomResponse(this.compressed);
        this.releaseResources();
        try {
            status = this.validator.isValid(Unwrappable.unwrapRequest(this.request), response);
        }
        catch (Exception e) {
            throw new ValidationException(Validator.Status.INVALID_CONTENT, response, "Validator threw an exception, please check your code for bugs.", e);
        }
        if (status == Validator.Status.STOP) {
            throw new ValidationException(status, (Response)response, "Validator stopped the request.");
        }
        if (status != Validator.Status.VALID) {
            throw new ValidationException(status, (Response)response, "Invalid response.");
        }
        return response;
    }

    protected final void releaseResources() {
        this.httpResponse = null;
        this.buf = null;
    }
}

