/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.request;

import ai.preferred.venom.SleepScheduler;
import ai.preferred.venom.request.Request;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpHost;

public class VRequest
implements Request {
    private final Request.Method method;
    private final String url;
    private final Map<String, String> headers;
    private final String body;
    private final HttpHost proxy;
    private final SleepScheduler sleepScheduler;

    public VRequest(String url) {
        this(url, Collections.emptyMap());
    }

    public VRequest(String url, Map<String, String> headers) {
        this(Request.Method.GET, url, new HashMap<String, String>(headers), null, null, null);
    }

    protected VRequest(Builder<?> builder) {
        this(((Builder)builder).method == null ? Request.Method.GET : ((Builder)builder).method, ((Builder)builder).url, new HashMap<String, String>(((Builder)builder).headers), ((Builder)builder).body, ((Builder)builder).scheduler, ((Builder)builder).proxy);
    }

    private VRequest(Request.Method method, String url, Map<String, String> headers, String body, SleepScheduler sleepScheduler, HttpHost proxy) {
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.body = body;
        this.sleepScheduler = sleepScheduler;
        this.proxy = proxy;
    }

    public static Builder build(Request.Method method, String url) {
        return new Builder(method, url);
    }

    @Override
    public final Request.Method getMethod() {
        return this.method;
    }

    @Override
    public final String getBody() {
        return this.body;
    }

    @Override
    public final String getUrl() {
        return this.url;
    }

    @Override
    public final Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public final HttpHost getProxy() {
        return this.proxy;
    }

    @Override
    public final SleepScheduler getSleepScheduler() {
        return this.sleepScheduler;
    }

    public static class Builder<T extends Builder<T>> {
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Request.Method method;
        private String body;
        private String url;
        private HttpHost proxy;
        private SleepScheduler scheduler;

        protected Builder(Request.Method method, String url) {
            this.method = method;
            this.url = url;
        }

        public static Builder get(String url) {
            return new Builder(Request.Method.GET, url);
        }

        public static Builder post(String url) {
            return new Builder(Request.Method.POST, url);
        }

        public static Builder head(String url) {
            return new Builder(Request.Method.HEAD, url);
        }

        public static Builder put(String url) {
            return new Builder(Request.Method.PUT, url);
        }

        public static Builder delete(String url) {
            return new Builder(Request.Method.DELETE, url);
        }

        public static Builder options(String url) {
            return new Builder(Request.Method.OPTIONS, url);
        }

        public final T setBody(String body) {
            this.body = body;
            return (T)this;
        }

        public final T setSleepScheduler(SleepScheduler scheduler) {
            this.scheduler = scheduler;
            return (T)this;
        }

        public final T setProxy(HttpHost proxy) {
            this.proxy = proxy;
            return (T)this;
        }

        public final T removeHeader(String name) {
            this.headers.remove(name);
            return (T)this;
        }

        public final T removeHeaders() {
            this.headers.clear();
            return (T)this;
        }

        public final T addHeaders(Map<String, String> headers) {
            this.headers.putAll(headers);
            return (T)this;
        }

        public final T addHeader(String name, String value) {
            this.headers.put(name, value);
            return (T)this;
        }

        public final T setUrl(String url) {
            this.url = url;
            return (T)this;
        }

        public VRequest build() {
            return new VRequest(this);
        }
    }
}

