/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.validator;

import ai.preferred.venom.request.Request;
import ai.preferred.venom.response.Response;
import ai.preferred.venom.validator.Validator;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeTypeValidator
implements Validator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeTypeValidator.class);
    private final Pattern regex;

    public MimeTypeValidator(String regex) {
        this(Pattern.compile(regex));
    }

    public MimeTypeValidator(Pattern regex) {
        this.regex = regex;
    }

    @Override
    public final Validator.Status isValid(Request request, Response response) {
        if (this.regex.matcher(response.getContentType().getMimeType()).matches()) {
            return Validator.Status.VALID;
        }
        LOGGER.warn("Invalid ({}) Mime type received for {}", (Object)response.getContentType().getMimeType(), (Object)request.getUrl());
        return Validator.Status.INVALID_CONTENT;
    }
}

