/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.job;

import ai.preferred.venom.Handler;
import ai.preferred.venom.job.Job;
import ai.preferred.venom.job.JobAttribute;
import ai.preferred.venom.job.Priority;
import ai.preferred.venom.job.PriorityJobAttribute;
import ai.preferred.venom.request.Request;
import java.util.concurrent.BlockingQueue;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Scheduler.class);
    private final BlockingQueue<Job> queue;

    public Scheduler(BlockingQueue<Job> queue) {
        this.queue = queue;
    }

    public final void add(@NotNull Request request, Handler handler, JobAttribute ... jobAttributes) {
        Job job = new Job(request, handler, jobAttributes);
        this.queue.add(job);
        LOGGER.debug("Job {} - {} added to queue.", (Object)job.toString(), (Object)request.getUrl());
    }

    public final void add(@NotNull Request request, JobAttribute ... jobAttributes) {
        this.add(request, (Handler)null, jobAttributes);
    }

    public final void add(Request request, @NotNull Handler handler) {
        this.add(request, handler, new JobAttribute[0]);
    }

    public final void add(@NotNull Request request) {
        this.add(request, (Handler)null, new JobAttribute[0]);
    }

    @Deprecated
    public final void add(@NotNull Request r, Handler h, Priority p, Priority pf) {
        this.add(r, h, new PriorityJobAttribute(p, pf));
    }

    @Deprecated
    public final void add(@NotNull Request r, Handler h, Priority p) {
        this.add(r, h, p, Priority.FLOOR);
    }

    @Deprecated
    public final void add(@NotNull Request r, Priority p, Priority pf) {
        this.add(r, null, p, pf);
    }

    @Deprecated
    public final void add(@NotNull Request r, Priority p) {
        this.add(r, (Handler)null, p);
    }
}

