/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.socks;

import ai.preferred.venom.socks.SocksIOSession;
import java.io.IOException;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOSession;

public class SocksIOEventDispatch
implements IOEventDispatch {
    private final IOEventDispatch dispatch;

    public SocksIOEventDispatch(IOEventDispatch dispatch) {
        this.dispatch = dispatch;
    }

    public void connected(IOSession session) {
        this.dispatch.connected(session);
    }

    public void inputReady(IOSession session) {
        try {
            if (this.initializeSocksSession(session)) {
                this.dispatch.inputReady(session);
            }
        }
        catch (RuntimeException e) {
            session.shutdown();
            throw e;
        }
    }

    public void outputReady(IOSession session) {
        try {
            if (this.initializeSocksSession(session)) {
                this.dispatch.outputReady(session);
            }
        }
        catch (RuntimeException e) {
            session.shutdown();
            throw e;
        }
    }

    public void timeout(IOSession session) {
        try {
            this.dispatch.timeout(session);
            SocksIOSession socksIOSession = this.getSocksSession(session);
            if (socksIOSession != null) {
                socksIOSession.shutdown();
            }
        }
        catch (RuntimeException e) {
            session.shutdown();
            throw e;
        }
    }

    public void disconnected(IOSession session) {
        this.dispatch.disconnected(session);
    }

    private boolean initializeSocksSession(IOSession session) {
        SocksIOSession socksSession = this.getSocksSession(session);
        if (socksSession != null) {
            try {
                try {
                    if (!socksSession.isInitialized()) {
                        return socksSession.initialize();
                    }
                }
                catch (IOException e) {
                    this.onException(socksSession, e);
                    throw new RuntimeException(e);
                }
            }
            catch (RuntimeException e) {
                socksSession.shutdown();
                throw e;
            }
        }
        return true;
    }

    private void onException(IOSession session, Exception ex) {
        NHttpClientEventHandler handler;
        NHttpClientConnection conn = this.getConnection(session);
        if (conn != null && (handler = this.getEventHandler((NHttpConnection)conn)) != null) {
            handler.exception(conn, ex);
        }
    }

    private SocksIOSession getSocksSession(IOSession session) {
        return (SocksIOSession)session.getAttribute("http.session.socks");
    }

    private NHttpClientConnection getConnection(IOSession session) {
        return (NHttpClientConnection)session.getAttribute("http.connection");
    }

    private NHttpClientEventHandler getEventHandler(NHttpConnection conn) {
        return (NHttpClientEventHandler)conn.getContext().getAttribute("http.nio.exchange-handler");
    }
}

