/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.socks;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpHost;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionBufferStatus;
import org.apache.http.util.Asserts;

public class SocksIOSession
implements IOSession {
    public static final String SESSION_KEY = "http.session.socks";
    private static final String DEFAULT_USER_ID = "USER";
    private static final byte SOCKS_VERSION = 4;
    private static final byte CONNECT = 1;
    private static final byte NULL = 0;
    private static final byte[] DIST_IP_LOOKUP_REQUEST = new byte[]{0, 0, 0, 1};
    private final IOSession innerSession;
    private final HttpHost targetHost;
    private final String userId;
    private final SocketAddress remoteAddress;
    private final ByteBuffer replyBuf = ByteBuffer.allocate(8);
    private volatile int status = 0;
    private volatile boolean initialized;
    private boolean connectRequested;
    private boolean connectReceived;
    private boolean endOfStream = false;

    public SocksIOSession(IOSession innerSession) {
        this(innerSession, DEFAULT_USER_ID);
    }

    public SocksIOSession(IOSession innerSession, String userId) {
        HttpRoute route = (HttpRoute)innerSession.getAttribute("http.session.attachment");
        this.innerSession = innerSession;
        this.targetHost = route.getTargetHost();
        this.userId = userId;
        this.remoteAddress = this.targetHost.getAddress() != null ? new InetSocketAddress(this.targetHost.getAddress(), this.targetHost.getPort()) : InetSocketAddress.createUnresolved(this.targetHost.getHostName(), this.targetHost.getPort());
        innerSession.setAttribute(SESSION_KEY, (Object)this);
    }

    synchronized boolean initialize() throws IOException {
        Asserts.check((!this.initialized ? 1 : 0) != 0, (String)"Socks I/O session already initialized");
        if (this.innerSession.getStatus() >= 1) {
            return false;
        }
        if (!this.connectRequested) {
            this.sendConnectRequest();
        }
        if (!this.connectReceived) {
            this.initialized = this.receiveConnectReply();
        }
        return this.initialized;
    }

    private void sendConnectRequest() throws IOException {
        Asserts.check((!this.connectRequested ? 1 : 0) != 0, (String)"Socks CONNECT already sent");
        boolean isIPv4 = InetAddressUtils.isIPv4Address((String)this.targetHost.getHostName());
        byte[] userId = this.userId.getBytes(StandardCharsets.ISO_8859_1);
        byte[] host = this.targetHost.getHostName().getBytes(StandardCharsets.ISO_8859_1);
        int size = 9 + userId.length + (isIPv4 ? 0 : host.length + 1);
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put((byte)4);
        buf.put((byte)1);
        buf.put((byte)(this.targetHost.getPort() >> 8 & 0xFF));
        buf.put((byte)(this.targetHost.getPort() & 0xFF));
        buf.put(isIPv4 ? Inet4Address.getByName(this.targetHost.getHostName()).getAddress() : DIST_IP_LOOKUP_REQUEST);
        buf.put(userId);
        buf.put((byte)0);
        if (!isIPv4) {
            buf.put(host);
            buf.put((byte)0);
        }
        buf.flip();
        if (this.innerSession.channel().write(buf) != size) {
            throw new IOException("Could not flush the buffer");
        }
        this.connectRequested = true;
    }

    private boolean receiveConnectReply() throws IOException {
        int read = this.innerSession.channel().read(this.replyBuf);
        if (!this.endOfStream && read == -1) {
            this.endOfStream = true;
            this.close();
            throw new IOException("IO channel closed before connection established");
        }
        if (this.replyBuf.position() < 8) {
            return false;
        }
        this.replyBuf.flip();
        this.processConnectReply();
        return true;
    }

    private void processConnectReply() throws IOException {
        Asserts.check((!this.connectReceived ? 1 : 0) != 0, (String)"CONNECT reply has been already received");
        Asserts.check((this.replyBuf.limit() == 8 ? 1 : 0) != 0, (String)"Response is expected of 8 bytes, but got {}", (Object)this.replyBuf.limit());
        byte vn = this.replyBuf.get();
        Asserts.check((vn == 0 || vn == 4 ? 1 : 0) != 0, (String)"Invalid socks version {}", (Object)vn);
        IOException ex = null;
        byte cd = this.replyBuf.get();
        switch (cd) {
            case 90: {
                break;
            }
            case 91: {
                ex = new IOException("SOCKS request rejected");
                break;
            }
            case 92: {
                ex = new IOException("SOCKS server couldn't reach destination");
                break;
            }
            case 93: {
                ex = new IOException("SOCKS authentication failed");
                break;
            }
            default: {
                ex = new IOException("Reply from SOCKS server contains bad status");
            }
        }
        if (ex != null) {
            this.close();
            throw ex;
        }
        this.connectReceived = true;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    public ByteChannel channel() {
        return this.innerSession.channel();
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.innerSession.getLocalAddress();
    }

    public int getEventMask() {
        return this.innerSession.getEventMask();
    }

    public void setEventMask(int ops) {
        this.innerSession.setEventMask(ops);
    }

    public void setEvent(int op) {
        this.innerSession.setEvent(op);
    }

    public void clearEvent(int op) {
        this.innerSession.clearEvent(op);
    }

    public synchronized void close() {
        if (this.status >= 1) {
            return;
        }
        this.status = Integer.MAX_VALUE;
        this.innerSession.close();
    }

    public synchronized void shutdown() {
        if (this.status >= 1) {
            return;
        }
        this.status = Integer.MAX_VALUE;
        this.innerSession.shutdown();
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isClosed() {
        return this.innerSession.isClosed();
    }

    public int getSocketTimeout() {
        return this.innerSession.getSocketTimeout();
    }

    public void setSocketTimeout(int timeout) {
        this.innerSession.setSocketTimeout(timeout);
    }

    public void setBufferStatus(SessionBufferStatus status) {
        this.innerSession.setBufferStatus(status);
    }

    public boolean hasBufferedInput() {
        return this.innerSession.hasBufferedInput();
    }

    public boolean hasBufferedOutput() {
        return this.innerSession.hasBufferedOutput();
    }

    public void setAttribute(String name, Object obj) {
        this.innerSession.setAttribute(name, obj);
    }

    public Object getAttribute(String name) {
        return this.innerSession.getAttribute(name);
    }

    public Object removeAttribute(String name) {
        return this.innerSession.removeAttribute(name);
    }
}

