/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.socks;

import ai.preferred.venom.socks.SocksIOSession;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLIOSession;

public class SocksIOSessionStrategy
implements SchemeIOSessionStrategy {
    private final SSLIOSessionStrategy sslioSessionStrategy;

    public SocksIOSessionStrategy(SSLIOSessionStrategy sslioSessionStrategy) {
        this.sslioSessionStrategy = sslioSessionStrategy;
    }

    public IOSession upgrade(HttpHost host, IOSession session) throws IOException {
        HttpRoute route = (HttpRoute)session.getAttribute("http.session.attachment");
        SocksIOSession socksSession = new SocksIOSession(session);
        socksSession.initialize();
        if ("https".equals(route.getTargetHost().getSchemeName())) {
            SSLIOSession wrappedSocksSession = this.sslioSessionStrategy.upgrade(route.getTargetHost(), (IOSession)socksSession);
            wrappedSocksSession.setAttribute("http.session.socks", (Object)socksSession);
            return wrappedSocksSession;
        }
        return socksSession;
    }

    public boolean isLayeringRequired() {
        return true;
    }
}

