/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.utils;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;

public class InlineExecutorService
extends AbstractExecutorService
implements ExecutorService {
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final AtomicBoolean terminated = new AtomicBoolean(false);
    private final Lock executing = new ReentrantLock();

    private void setTerminated() {
        if (!this.shutdown.get()) {
            return;
        }
        if (this.executing.tryLock()) {
            try {
                this.terminated.compareAndSet(false, true);
            }
            finally {
                this.executing.unlock();
            }
        }
    }

    @Override
    public final void shutdown() {
        this.shutdown.compareAndSet(false, true);
    }

    @Override
    @Nonnull
    public final List<Runnable> shutdownNow() {
        this.shutdown.compareAndSet(false, true);
        return Collections.emptyList();
    }

    @Override
    public final boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public final boolean isTerminated() {
        if (this.terminated.get()) {
            return true;
        }
        this.setTerminated();
        return this.terminated.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean awaitTermination(long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        if (this.terminated.get()) {
            return true;
        }
        this.executing.tryLock(timeout, unit);
        try {
            this.setTerminated();
        }
        finally {
            this.executing.unlock();
        }
        return this.terminated.get();
    }

    @Override
    public final void execute(@Nonnull Runnable command) {
        if (this.shutdown.get()) {
            throw new RejectedExecutionException("Executor has been shutdown.");
        }
        this.executing.lock();
        try {
            command.run();
        }
        finally {
            this.setTerminated();
            this.executing.unlock();
        }
    }
}

