/*
 * Decompiled with CFR 0.152.
 */
package ai.promoted.delivery.client;

import ai.promoted.delivery.client.Delivery;
import ai.promoted.delivery.client.DeliveryException;
import ai.promoted.delivery.client.DeliveryRequest;
import ai.promoted.delivery.client.DeliveryRequestState;
import ai.promoted.delivery.model.Response;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class ApiDelivery
implements Delivery {
    private static final Logger LOGGER = Logger.getLogger(ApiDelivery.class.getName());
    private final String endpoint;
    private final String apiKey;
    private final HttpClient httpClient;
    private final ObjectMapper mapper;
    private final Duration timeoutDuration;
    private final int maxRequestInsertions;

    public ApiDelivery(String endpoint, String apiKey, long timeoutMillis, boolean warmup, int maxRequestInsertions) {
        this.endpoint = endpoint;
        this.apiKey = apiKey;
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.timeoutDuration = Duration.of(timeoutMillis, ChronoUnit.MILLIS);
        this.maxRequestInsertions = maxRequestInsertions;
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
        if (warmup) {
            this.runWarmup();
        }
    }

    @Override
    public Response runDelivery(DeliveryRequest deliveryRequest) throws DeliveryException {
        Response resp;
        DeliveryRequestState state = new DeliveryRequestState(deliveryRequest);
        try {
            String requestBody = this.mapper.writeValueAsString((Object)state.getRequestToSend(this.maxRequestInsertions));
            HttpRequest httpReq = HttpRequest.newBuilder().uri(URI.create(this.endpoint)).header("Accept-Encoding", "gzip").header("x-api-key", this.apiKey).timeout(this.timeoutDuration).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
            HttpResponse<InputStream> response = this.httpClient.send(httpReq, HttpResponse.BodyHandlers.ofInputStream());
            String encoding = response.headers().firstValue("Content-Encoding").orElse("");
            resp = encoding.equals("gzip") ? this.processCompressedResponse(response) : this.processUncompressedResponse(response);
        }
        catch (Exception ex) {
            throw new DeliveryException("Error running delivery", ex);
        }
        ApiDelivery.validate(resp);
        return state.getResponseToReturn(resp);
    }

    private Response processUncompressedResponse(HttpResponse<InputStream> response) throws IOException, StreamReadException, DatabindException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (InputStream is = response.body();
             ByteArrayOutputStream autoCloseOs = os;){
            is.transferTo(autoCloseOs);
        }
        return (Response)this.mapper.readValue(os.toByteArray(), Response.class);
    }

    private Response processCompressedResponse(HttpResponse<InputStream> response) throws IOException, StreamReadException, DatabindException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (GZIPInputStream is = new GZIPInputStream(response.body());
             ByteArrayOutputStream autoCloseOs = os;){
            is.transferTo(autoCloseOs);
        }
        return (Response)this.mapper.readValue(os.toByteArray(), Response.class);
    }

    static void validate(Response response) throws DeliveryException {
        if (response.getRequestId() == null || response.getRequestId().equals("")) {
            throw new DeliveryException("Delivery Response should contain a requestId");
        }
    }

    private void runWarmup() {
        String warmupEndpoint = ApiDelivery.replaceSuffix(this.endpoint, "/deliver", "/healthz");
        for (int i = 0; i < 20; ++i) {
            try {
                HttpRequest httpReq = HttpRequest.newBuilder().uri(URI.create(warmupEndpoint)).header("x-api-key", this.apiKey).GET().build();
                this.httpClient.send(httpReq, HttpResponse.BodyHandlers.ofString());
                continue;
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Error during warmup", ex);
            }
        }
    }

    static String replaceSuffix(String original, String target, String replacement) {
        if (!original.endsWith(target)) {
            return original;
        }
        return original.substring(0, original.length() - target.length()) + replacement;
    }
}

