/*
 * Decompiled with CFR 0.152.
 */
package ai.promoted.delivery.client;

import ai.promoted.delivery.client.DefaultDeliveryRequestValidator;
import ai.promoted.delivery.client.DeliveryRequestValidator;
import ai.promoted.delivery.model.CohortMembership;
import ai.promoted.delivery.model.Request;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class DeliveryRequest
implements Cloneable {
    private Request request;
    private final boolean onlyLog;
    private final int retrievalInsertionOffset;
    @Nullable
    private final CohortMembership experiment;
    private final DeliveryRequestValidator validator;

    public DeliveryRequest(Request request, CohortMembership experiment, boolean onlyLog, int retrievalInsertionOffset, DeliveryRequestValidator validator) {
        this.request = request;
        this.onlyLog = onlyLog;
        this.experiment = experiment;
        this.retrievalInsertionOffset = retrievalInsertionOffset;
        this.validator = validator;
    }

    public DeliveryRequest(Request request, CohortMembership experiment, boolean onlyLog, int retrievalInsertionOffset) {
        this(request, experiment, onlyLog, retrievalInsertionOffset, DefaultDeliveryRequestValidator.INSTANCE);
    }

    public DeliveryRequest(Request request, CohortMembership experiment) {
        this(request, experiment, false, 0);
    }

    public DeliveryRequest(Request request) {
        this(request, null);
    }

    public Request getRequest() {
        return this.request;
    }

    public boolean isOnlyLog() {
        return this.onlyLog;
    }

    public int getRetrievalInsertionOffset() {
        return this.retrievalInsertionOffset;
    }

    public CohortMembership getExperiment() {
        return this.experiment;
    }

    public DeliveryRequest clone() throws CloneNotSupportedException {
        DeliveryRequest deliveryRequestCopy = (DeliveryRequest)super.clone();
        deliveryRequestCopy.request = this.request.clone();
        return deliveryRequestCopy;
    }

    public List<String> validate(boolean isShadowTraffic) {
        if (this.validator != null) {
            return this.validator.validate(this, isShadowTraffic);
        }
        return new ArrayList<String>();
    }
}

